/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.tasks;

import java.io.File;
import net.i2p.router.RouterContext;
import net.i2p.util.ShellCommand;
import net.i2p.util.SystemVersion;
import net.i2p.util.VersionComparator;

public class BasePerms {
    private static final String FIXED_VER = "0.9.46";
    private static final String PROP_FIXED = "router.fixedBasePerms";

    public static void fix(RouterContext ctx) {
        if (!SystemVersion.isWindows()) {
            return;
        }
        if (ctx.getBooleanProperty(PROP_FIXED)) {
            return;
        }
        if (!ctx.router().getKillVMOnEnd()) {
            return;
        }
        File dir = ctx.getBaseDir();
        File f = new File(dir, "history.txt");
        if (f.exists() && !f.canWrite()) {
            return;
        }
        String first = ctx.getProperty("router.firstVersion");
        if (first == null || VersionComparator.comp(first, FIXED_VER) < 0) {
            File f1 = new File(dir, "Uninstaller");
            File f2 = new File(dir, "fixperms.log");
            if (f1.exists() && f2.exists()) {
                File f3 = new File(dir, "fixperms.bat");
                f3.delete();
                try {
                    BasePerms.fix(dir);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        ctx.router().saveConfig(PROP_FIXED, "true");
    }

    private static void fix(File f) {
        File bat = new File(f, "scripts");
        bat = new File(bat, "fixperms2.bat");
        String[] args = new String[]{bat.getAbsolutePath(), f.getAbsolutePath()};
        new ShellCommand().executeSilentAndWaitTimed(args, 0);
    }
}

