/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.util.Comparing;
import org.jetbrains.kotlin.com.intellij.openapi.util.Couple;
import org.jetbrains.kotlin.com.intellij.openapi.util.Pair;
import org.jetbrains.kotlin.com.intellij.psi.JavaPsiFacade;
import org.jetbrains.kotlin.com.intellij.psi.PsiAnnotation;
import org.jetbrains.kotlin.com.intellij.psi.PsiAnonymousClass;
import org.jetbrains.kotlin.com.intellij.psi.PsiArrayType;
import org.jetbrains.kotlin.com.intellij.psi.PsiCallExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiCapturedWildcardType;
import org.jetbrains.kotlin.com.intellij.psi.PsiClass;
import org.jetbrains.kotlin.com.intellij.psi.PsiClassType;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiElementFactory;
import org.jetbrains.kotlin.com.intellij.psi.PsiEllipsisType;
import org.jetbrains.kotlin.com.intellij.psi.PsiIntersectionType;
import org.jetbrains.kotlin.com.intellij.psi.PsiJavaCodeReferenceElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiManager;
import org.jetbrains.kotlin.com.intellij.psi.PsiPrimitiveType;
import org.jetbrains.kotlin.com.intellij.psi.PsiReferenceParameterList;
import org.jetbrains.kotlin.com.intellij.psi.PsiSubstitutor;
import org.jetbrains.kotlin.com.intellij.psi.PsiType;
import org.jetbrains.kotlin.com.intellij.psi.PsiTypeElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiTypeParameter;
import org.jetbrains.kotlin.com.intellij.psi.PsiTypeVisitor;
import org.jetbrains.kotlin.com.intellij.psi.PsiWildcardType;
import org.jetbrains.kotlin.com.intellij.psi.TypeAnnotationProvider;
import org.jetbrains.kotlin.com.intellij.psi.search.GlobalSearchScope;
import org.jetbrains.kotlin.com.intellij.psi.util.InheritanceUtil;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiTypesUtil;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiUtil;
import org.jetbrains.kotlin.com.intellij.psi.util.TypeConversionUtil;
import org.jetbrains.kotlin.com.intellij.psi.util.TypesDistinctProver;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;

public class GenericsUtil {
    private static final Logger LOG = Logger.getInstance(GenericsUtil.class);

    private GenericsUtil() {
    }

    public static PsiType getGreatestLowerBound(@Nullable PsiType type1, @Nullable PsiType type2) {
        if (type1 == null || type2 == null) {
            return null;
        }
        if (type1.equalsToText("java.lang.Object")) {
            return type2;
        }
        if (type2.equalsToText("java.lang.Object")) {
            return type1;
        }
        return PsiIntersectionType.createIntersection(type1, type2);
    }

    @Nullable
    public static PsiType getLeastUpperBound(PsiType type1, PsiType type2, PsiManager manager) {
        if (TypeConversionUtil.isPrimitiveAndNotNull(type1) || TypeConversionUtil.isPrimitiveAndNotNull(type2)) {
            return null;
        }
        if (TypeConversionUtil.isNullType(type1)) {
            return type2;
        }
        if (TypeConversionUtil.isNullType(type2)) {
            return type1;
        }
        if (Comparing.equal(type1, type2)) {
            return type1;
        }
        return GenericsUtil.getLeastUpperBound(type1, type2, new LinkedHashSet<Couple<PsiType>>(), manager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private static PsiType getLeastUpperBound(PsiType type1, PsiType type2, Set<Couple<PsiType>> compared, PsiManager manager) {
        if (type1 instanceof PsiCapturedWildcardType) {
            return GenericsUtil.getLeastUpperBound(((PsiCapturedWildcardType)type1).getUpperBound(), type2, compared, manager);
        }
        if (type2 instanceof PsiCapturedWildcardType) {
            return GenericsUtil.getLeastUpperBound(type1, ((PsiCapturedWildcardType)type2).getUpperBound(), compared, manager);
        }
        if (type1 instanceof PsiWildcardType) {
            return GenericsUtil.getLeastUpperBound(((PsiWildcardType)type1).getExtendsBound(), type2, compared, manager);
        }
        if (type2 instanceof PsiWildcardType) {
            return GenericsUtil.getLeastUpperBound(type1, ((PsiWildcardType)type2).getExtendsBound(), compared, manager);
        }
        if (type1 instanceof PsiArrayType && type2 instanceof PsiArrayType) {
            PsiType componentType1 = ((PsiArrayType)type1).getComponentType();
            PsiType componentType2 = ((PsiArrayType)type2).getComponentType();
            PsiType componentType = GenericsUtil.getLeastUpperBound(componentType1, componentType2, compared, manager);
            if ((componentType1 instanceof PsiPrimitiveType || componentType2 instanceof PsiPrimitiveType) && componentType.equalsToText("java.lang.Object")) {
                PsiElementFactory factory2 = JavaPsiFacade.getElementFactory(manager.getProject());
                GlobalSearchScope resolveScope = GlobalSearchScope.allScope(manager.getProject());
                PsiClassType cloneable2 = factory2.createTypeByFQClassName("java.lang.Cloneable", resolveScope);
                PsiClassType serializable = factory2.createTypeByFQClassName("java.io.Serializable", resolveScope);
                PsiType psiType2 = PsiIntersectionType.createIntersection(componentType, cloneable2, serializable);
                if (psiType2 == null) {
                    GenericsUtil.$$$reportNull$$$0(0);
                }
                return psiType2;
            }
            PsiArrayType psiArrayType = componentType.createArrayType();
            if (psiArrayType == null) {
                GenericsUtil.$$$reportNull$$$0(1);
            }
            return psiArrayType;
        }
        if (type1 instanceof PsiIntersectionType) {
            PsiType[] conjuncts;
            LinkedHashSet<PsiType> newConjuncts = new LinkedHashSet<PsiType>();
            for (PsiType type3 : conjuncts = ((PsiIntersectionType)type1).getConjuncts()) {
                newConjuncts.add(GenericsUtil.getLeastUpperBound(type3, type2, compared, manager));
            }
            PsiType psiType3 = PsiIntersectionType.createIntersection(newConjuncts.toArray(PsiType.createArray(newConjuncts.size())));
            if (psiType3 == null) {
                GenericsUtil.$$$reportNull$$$0(2);
            }
            return psiType3;
        }
        if (type2 instanceof PsiIntersectionType) {
            return GenericsUtil.getLeastUpperBound(type2, type1, compared, manager);
        }
        if (type1 instanceof PsiClassType && type2 instanceof PsiClassType) {
            PsiClassType.ClassResolveResult classResolveResult1 = ((PsiClassType)type1).resolveGenerics();
            PsiClassType.ClassResolveResult classResolveResult2 = ((PsiClassType)type2).resolveGenerics();
            PsiClass aClass2 = classResolveResult1.getElement();
            PsiClass bClass = classResolveResult2.getElement();
            if (aClass2 == null || bClass == null) {
                PsiClassType psiClassType = PsiType.getJavaLangObject(manager, GlobalSearchScope.allScope(manager.getProject()));
                if (psiClassType == null) {
                    GenericsUtil.$$$reportNull$$$0(3);
                }
                return psiClassType;
            }
            PsiClass[] supers = GenericsUtil.getLeastUpperClasses(aClass2, bClass);
            if (supers.length == 0) {
                PsiClassType psiClassType = PsiType.getJavaLangObject(manager, aClass2.getResolveScope());
                if (psiClassType == null) {
                    GenericsUtil.$$$reportNull$$$0(4);
                }
                return psiClassType;
            }
            PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory(manager.getProject());
            PsiType[] conjuncts = new PsiClassType[supers.length];
            HashSet<Couple<PsiClassType>> siblings2 = new HashSet<Couple<PsiClassType>>();
            try {
                for (int i = 0; i < supers.length; ++i) {
                    PsiClass aSuper = supers[i];
                    PsiSubstitutor subst1 = TypeConversionUtil.getSuperClassSubstitutor(aSuper, aClass2, classResolveResult1.getSubstitutor());
                    PsiSubstitutor subst2 = TypeConversionUtil.getSuperClassSubstitutor(aSuper, bClass, classResolveResult2.getSubstitutor());
                    PsiSubstitutor substitutor2 = PsiSubstitutor.EMPTY;
                    Couple<PsiClassType> types2 = Couple.of(elementFactory.createType(aSuper, subst1), elementFactory.createType(aSuper, subst2));
                    boolean skip2 = compared.contains(types2);
                    for (PsiTypeParameter parameter : PsiUtil.typeParametersIterable(aSuper)) {
                        PsiType mapping1 = subst1.substitute(parameter);
                        PsiType mapping2 = subst2.substitute(parameter);
                        if (mapping1 != null && mapping2 != null) {
                            if (skip2) {
                                substitutor2 = substitutor2.put(parameter, PsiWildcardType.createUnbounded(manager));
                                continue;
                            }
                            compared.add(types2);
                            try {
                                PsiType argument = GenericsUtil.getLeastContainingTypeArgument(mapping1, mapping2, compared, manager);
                                substitutor2 = substitutor2.put(parameter, argument);
                                continue;
                            }
                            finally {
                                siblings2.add(types2);
                                continue;
                            }
                        }
                        substitutor2 = substitutor2.put(parameter, null);
                    }
                    conjuncts[i] = elementFactory.createType(aSuper, substitutor2);
                }
            }
            finally {
                compared.removeAll(siblings2);
            }
            PsiType psiType4 = PsiIntersectionType.createIntersection(conjuncts);
            if (psiType4 == null) {
                GenericsUtil.$$$reportNull$$$0(5);
            }
            return psiType4;
        }
        if (type2 instanceof PsiArrayType && !(type1 instanceof PsiArrayType)) {
            return GenericsUtil.getLeastUpperBound(type2, type1, compared, manager);
        }
        if (type1 instanceof PsiArrayType) {
            PsiElementFactory factory3 = JavaPsiFacade.getElementFactory(manager.getProject());
            GlobalSearchScope all2 = GlobalSearchScope.allScope(manager.getProject());
            PsiClassType serializable = factory3.createTypeByFQClassName("java.io.Serializable", all2);
            PsiClassType cloneable3 = factory3.createTypeByFQClassName("java.lang.Cloneable", all2);
            PsiType arraySupers = PsiIntersectionType.createIntersection(serializable, cloneable3);
            return GenericsUtil.getLeastUpperBound(arraySupers, type2, compared, manager);
        }
        PsiClassType psiClassType = PsiType.getJavaLangObject(manager, GlobalSearchScope.allScope(manager.getProject()));
        if (psiClassType == null) {
            GenericsUtil.$$$reportNull$$$0(6);
        }
        return psiClassType;
    }

    private static PsiType getLeastContainingTypeArgument(PsiType type1, PsiType type2, Set<Couple<PsiType>> compared, PsiManager manager) {
        if (type1 instanceof PsiWildcardType) {
            PsiWildcardType wild1 = (PsiWildcardType)type1;
            PsiType bound1 = wild1.getBound();
            if (bound1 == null) {
                return type1;
            }
            if (type2 instanceof PsiWildcardType) {
                PsiWildcardType wild2 = (PsiWildcardType)type2;
                PsiType bound2 = wild2.getBound();
                if (bound2 == null) {
                    return type2;
                }
                if (wild1.isExtends() == wild2.isExtends()) {
                    return wild1.isExtends() ? PsiWildcardType.createExtends(manager, GenericsUtil.getLeastUpperBound(bound1, bound2, compared, manager)) : PsiWildcardType.createSuper(manager, GenericsUtil.getGreatestLowerBound(bound1, bound2));
                }
                return bound1.equals(bound2) ? bound1 : PsiWildcardType.createUnbounded(manager);
            }
            return wild1.isExtends() ? PsiWildcardType.createExtends(manager, GenericsUtil.getLeastUpperBound(bound1, type2, compared, manager)) : (wild1.isSuper() ? PsiWildcardType.createSuper(manager, GenericsUtil.getGreatestLowerBound(bound1, type2)) : wild1);
        }
        if (type2 instanceof PsiWildcardType) {
            return GenericsUtil.getLeastContainingTypeArgument(type2, type1, compared, manager);
        }
        if (type1.equals(type2)) {
            return type1;
        }
        return PsiWildcardType.createExtends(manager, GenericsUtil.getLeastUpperBound(type1, type2, compared, manager));
    }

    @NotNull
    public static PsiClass[] getLeastUpperClasses(PsiClass aClass2, PsiClass bClass) {
        if (InheritanceUtil.isInheritorOrSelf(aClass2, bClass, true)) {
            PsiClass[] psiClassArray = new PsiClass[]{bClass};
            if (psiClassArray == null) {
                GenericsUtil.$$$reportNull$$$0(7);
            }
            return psiClassArray;
        }
        LinkedHashSet<PsiClass> supers = new LinkedHashSet<PsiClass>();
        HashSet visited2 = new HashSet();
        GenericsUtil.getLeastUpperClassesInner(aClass2, bClass, supers, visited2);
        PsiClass[] psiClassArray = supers.toArray(PsiClass.EMPTY_ARRAY);
        if (psiClassArray == null) {
            GenericsUtil.$$$reportNull$$$0(8);
        }
        return psiClassArray;
    }

    private static void getLeastUpperClassesInner(PsiClass aClass2, PsiClass bClass, Set<PsiClass> supers, Set<? super PsiClass> visited2) {
        if (bClass.isInheritor(aClass2, true)) {
            GenericsUtil.addSuper(supers, aClass2);
        } else {
            PsiClass[] aSupers;
            for (PsiClass aSuper : aSupers = aClass2.getSupers()) {
                if (!visited2.add(aSuper)) continue;
                GenericsUtil.getLeastUpperClassesInner(aSuper, bClass, supers, visited2);
            }
        }
    }

    private static void addSuper(Set<PsiClass> supers, PsiClass classToAdd) {
        Iterator<PsiClass> iterator2 = supers.iterator();
        while (iterator2.hasNext()) {
            PsiClass superClass = iterator2.next();
            if (InheritanceUtil.isInheritorOrSelf(superClass, classToAdd, true)) {
                return;
            }
            if (!classToAdd.isInheritor(superClass, true)) continue;
            iterator2.remove();
        }
        supers.add(classToAdd);
    }

    public static boolean isTypeArgumentsApplicable(PsiTypeParameter[] typeParams, PsiSubstitutor substitutor2, PsiElement context2) {
        return GenericsUtil.isTypeArgumentsApplicable(typeParams, substitutor2, context2, true);
    }

    public static boolean isTypeArgumentsApplicable(PsiTypeParameter[] typeParams, PsiSubstitutor substitutor2, PsiElement context2, boolean allowUncheckedConversion) {
        return GenericsUtil.findTypeParameterWithBoundError(typeParams, substitutor2, context2, allowUncheckedConversion) == null;
    }

    public static Pair<PsiTypeParameter, PsiType> findTypeParameterWithBoundError(PsiTypeParameter[] typeParams, PsiSubstitutor substitutor2, PsiElement context2, boolean allowUncheckedConversion) {
        for (PsiTypeParameter typeParameter : typeParams) {
            PsiType boundError = GenericsUtil.findTypeParameterBoundError(typeParameter, typeParameter.getExtendsListTypes(), substitutor2, context2, allowUncheckedConversion);
            if (boundError == null) continue;
            return Pair.create(typeParameter, boundError);
        }
        return null;
    }

    public static PsiType findTypeParameterBoundError(PsiTypeParameter typeParameter, PsiType[] extendsTypes, PsiSubstitutor substitutor2, PsiElement context2, boolean allowUncheckedConversion) {
        PsiType substituted = substitutor2.substitute(typeParameter);
        if (substituted == null) {
            return null;
        }
        if (context2 != null) {
            substituted = PsiUtil.captureToplevelWildcards(substituted, context2);
        }
        if (substituted instanceof PsiWildcardType && ((PsiWildcardType)substituted).isSuper()) {
            return null;
        }
        for (PsiType type2 : extendsTypes) {
            PsiType extendsType = substitutor2.substitute(type2);
            if (extendsType == null || TypeConversionUtil.isAssignable(extendsType, substituted, allowUncheckedConversion)) continue;
            return extendsType;
        }
        return null;
    }

    public static boolean isFromExternalTypeLanguage(@NotNull PsiType type2) {
        if (type2 == null) {
            GenericsUtil.$$$reportNull$$$0(9);
        }
        return type2.getInternalCanonicalText().equals(type2.getCanonicalText());
    }

    @Contract(value="null -> null")
    public static PsiType getVariableTypeByExpressionType(@Nullable PsiType type2) {
        return GenericsUtil.getVariableTypeByExpressionType(type2, true);
    }

    @Contract(value="null, _ -> null")
    public static PsiType getVariableTypeByExpressionType(@Nullable PsiType type2, final boolean openCaptured) {
        PsiType transformed;
        PsiType componentType;
        PsiType deepComponentType;
        if (type2 == null) {
            return null;
        }
        PsiClass refClass = PsiUtil.resolveClassInType(type2);
        if (refClass instanceof PsiAnonymousClass) {
            type2 = ((PsiAnonymousClass)refClass).getBaseClassType();
        }
        if ((deepComponentType = type2.getDeepComponentType()) instanceof PsiCapturedWildcardType) {
            type2 = PsiTypesUtil.createArrayType(((PsiCapturedWildcardType)deepComponentType).getUpperBound(), type2.getArrayDimensions());
        }
        PsiType psiType2 = componentType = (transformed = type2.accept(new PsiTypeVisitor<PsiType>(){

            @Override
            public PsiType visitArrayType(PsiArrayType arrayType) {
                PsiType componentType = arrayType.getComponentType();
                PsiType type2 = componentType.accept(this);
                if (type2 == componentType) {
                    return arrayType;
                }
                if (type2 instanceof PsiWildcardType) {
                    type2 = ((PsiWildcardType)type2).getBound();
                }
                return type2 != null ? type2.createArrayType() : arrayType;
            }

            @Override
            public PsiType visitType(PsiType type2) {
                return type2;
            }

            @Override
            public PsiType visitWildcardType(PsiWildcardType wildcardType) {
                PsiType bound = wildcardType.getBound();
                PsiManager manager = wildcardType.getManager();
                if (bound != null) {
                    if (wildcardType.isSuper() && bound instanceof PsiIntersectionType) {
                        return PsiWildcardType.createUnbounded(manager);
                    }
                    PsiType acceptedBound = bound.accept(this);
                    if (acceptedBound instanceof PsiWildcardType) {
                        if (((PsiWildcardType)acceptedBound).isExtends() != wildcardType.isExtends()) {
                            return PsiWildcardType.createUnbounded(manager);
                        }
                        return acceptedBound;
                    }
                    if (wildcardType.isExtends() && acceptedBound.equalsToText("java.lang.Object")) {
                        return PsiWildcardType.createUnbounded(manager);
                    }
                    if (acceptedBound.equals(bound)) {
                        return wildcardType;
                    }
                    return wildcardType.isExtends() ? PsiWildcardType.createExtends(manager, acceptedBound) : PsiWildcardType.createSuper(manager, acceptedBound);
                }
                return wildcardType;
            }

            @Override
            public PsiType visitCapturedWildcardType(PsiCapturedWildcardType capturedWildcardType) {
                return openCaptured ? capturedWildcardType.getWildcard().accept(this) : capturedWildcardType;
            }

            @Override
            public PsiType visitClassType(PsiClassType classType) {
                PsiClassType.ClassResolveResult resolveResult = classType.resolveGenerics();
                PsiClass aClass2 = resolveResult.getElement();
                if (aClass2 == null) {
                    return classType;
                }
                boolean toExtend = false;
                PsiSubstitutor substitutor2 = PsiSubstitutor.EMPTY;
                for (PsiTypeParameter typeParameter : PsiUtil.typeParametersIterable(aClass2)) {
                    PsiType toPut;
                    PsiType typeArgument = resolveResult.getSubstitutor().substitute(typeParameter);
                    if (typeArgument instanceof PsiCapturedWildcardType) {
                        toExtend = true;
                    }
                    if (typeArgument instanceof PsiWildcardType && ((PsiWildcardType)typeArgument).getBound() instanceof PsiIntersectionType) {
                        toExtend = true;
                    }
                    if (typeArgument == null) {
                        toPut = null;
                    } else {
                        PsiType accepted = typeArgument.accept(this);
                        toPut = typeArgument instanceof PsiIntersectionType && !(accepted instanceof PsiWildcardType) ? PsiWildcardType.createExtends(typeParameter.getManager(), accepted) : accepted;
                    }
                    LOG.assertTrue(toPut == null || toPut.isValid(), toPut);
                    substitutor2 = substitutor2.put(typeParameter, toPut);
                }
                PsiAnnotation[] applicableAnnotations = classType.getApplicableAnnotations();
                if (substitutor2 == PsiSubstitutor.EMPTY && !toExtend && applicableAnnotations.length == 0 && !(aClass2 instanceof PsiTypeParameter)) {
                    return classType;
                }
                PsiManager manager = aClass2.getManager();
                PsiType result2 = JavaPsiFacade.getElementFactory(manager.getProject()).createType(aClass2, substitutor2, PsiUtil.getLanguageLevel(aClass2)).annotate(TypeAnnotationProvider.Static.create(applicableAnnotations));
                if (toExtend) {
                    result2 = PsiWildcardType.createExtends(manager, result2);
                }
                return result2;
            }
        })) != null ? transformed.getDeepComponentType() : null;
        if (componentType instanceof PsiWildcardType) {
            componentType = ((PsiWildcardType)componentType).getExtendsBound();
            return PsiTypesUtil.createArrayType(componentType, transformed.getArrayDimensions());
        }
        if (transformed instanceof PsiEllipsisType) {
            return ((PsiEllipsisType)transformed).toArrayType();
        }
        return transformed;
    }

    public static PsiSubstitutor substituteByParameterName(PsiClass psiClass, PsiSubstitutor parentSubstitutor) {
        Map<PsiTypeParameter, PsiType> substitutionMap = parentSubstitutor.getSubstitutionMap();
        ArrayList<PsiType> result2 = new ArrayList<PsiType>(substitutionMap.size());
        for (PsiTypeParameter typeParameter : psiClass.getTypeParameters()) {
            String name = typeParameter.getName();
            PsiTypeParameter key = ContainerUtil.find(substitutionMap.keySet(), psiTypeParameter -> name.equals(psiTypeParameter.getName()));
            if (key == null) continue;
            result2.add(substitutionMap.get(key));
        }
        return PsiSubstitutor.EMPTY.putAll(psiClass, result2.toArray(PsiType.createArray(result2.size())));
    }

    public static PsiType eliminateWildcards(PsiType type2) {
        return GenericsUtil.eliminateWildcards(type2, true);
    }

    public static PsiType eliminateWildcards(PsiType type2, boolean eliminateInTypeArguments) {
        return GenericsUtil.eliminateWildcards(type2, eliminateInTypeArguments, !eliminateInTypeArguments);
    }

    public static PsiType eliminateWildcards(PsiType type2, boolean eliminateInTypeArguments, boolean eliminateCapturedWildcards) {
        if (eliminateInTypeArguments && type2 instanceof PsiClassType) {
            PsiClassType classType = (PsiClassType)type2;
            PsiClassType.ClassResolveResult resolveResult = classType.resolveGenerics();
            PsiClass aClass2 = (PsiClass)resolveResult.getElement();
            if (aClass2 != null) {
                PsiManager manager = aClass2.getManager();
                PsiTypeParameter[] typeParams = aClass2.getTypeParameters();
                HashMap<PsiTypeParameter, PsiType> map2 = new HashMap<PsiTypeParameter, PsiType>();
                for (PsiTypeParameter typeParam : typeParams) {
                    PsiType substituted = resolveResult.getSubstitutor().substitute(typeParam);
                    if (substituted instanceof PsiWildcardType) {
                        if ((substituted = ((PsiWildcardType)substituted).getBound()) instanceof PsiCapturedWildcardType) {
                            substituted = ((PsiCapturedWildcardType)substituted).getWildcard().getBound();
                        }
                        if (substituted == null) {
                            substituted = TypeConversionUtil.typeParameterErasure(typeParam);
                        }
                    }
                    map2.put(typeParam, substituted);
                }
                PsiElementFactory factory2 = JavaPsiFacade.getElementFactory(manager.getProject());
                PsiSubstitutor substitutor2 = factory2.createSubstitutor(map2);
                type2 = factory2.createType(aClass2, substitutor2);
            }
        } else {
            if (type2 instanceof PsiArrayType) {
                return GenericsUtil.eliminateWildcards(((PsiArrayType)type2).getComponentType(), false).createArrayType();
            }
            if (type2 instanceof PsiWildcardType) {
                PsiType bound = ((PsiWildcardType)type2).getBound();
                return GenericsUtil.eliminateWildcards(bound != null ? bound : ((PsiWildcardType)type2).getExtendsBound(), false);
            }
            if (type2 instanceof PsiCapturedWildcardType && eliminateCapturedWildcards) {
                return GenericsUtil.eliminateWildcards(((PsiCapturedWildcardType)type2).getUpperBound(), false);
            }
        }
        return type2;
    }

    public static boolean checkNotInBounds(PsiType type2, PsiType bound, PsiReferenceParameterList referenceParameterList) {
        PsiType capturedType = PsiUtil.captureToplevelWildcards(type2, referenceParameterList);
        return GenericsUtil.checkNotInBounds(capturedType, bound, PsiTreeUtil.getParentOfType((PsiElement)referenceParameterList, PsiCallExpression.class) != null);
    }

    public static boolean checkNotInBounds(PsiType type2, PsiType bound, boolean uncheckedConversionByDefault) {
        if (type2 instanceof PsiClassType) {
            return GenericsUtil.checkNotAssignable(bound, type2, uncheckedConversionByDefault);
        }
        if (type2 instanceof PsiWildcardType) {
            if (((PsiWildcardType)type2).isExtends()) {
                return GenericsUtil.checkExtendsWildcardCaptureFailure((PsiWildcardType)type2, bound);
            }
            if (((PsiWildcardType)type2).isSuper()) {
                PsiType superBound = ((PsiWildcardType)type2).getSuperBound();
                if (PsiUtil.resolveClassInType(superBound) instanceof PsiTypeParameter) {
                    return TypesDistinctProver.provablyDistinct(type2, bound);
                }
                return GenericsUtil.checkNotAssignable(bound, superBound, false);
            }
        } else {
            if (type2 instanceof PsiArrayType) {
                return GenericsUtil.checkNotAssignable(bound, type2, true);
            }
            if (type2 instanceof PsiIntersectionType) {
                for (PsiType psiType2 : ((PsiIntersectionType)type2).getConjuncts()) {
                    if (GenericsUtil.checkNotInBounds(psiType2, bound, uncheckedConversionByDefault)) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    private static boolean checkExtendsWildcardCaptureFailure(PsiWildcardType type2, PsiType bound) {
        LOG.assertTrue(type2.isExtends());
        PsiType extendsBound = type2.getExtendsBound();
        PsiType boundBound = bound;
        if (bound instanceof PsiWildcardType) {
            if (((PsiWildcardType)bound).isBounded()) {
                boundBound = ((PsiWildcardType)bound).isSuper() ? ((PsiWildcardType)bound).getSuperBound() : ((PsiWildcardType)bound).getExtendsBound();
            } else {
                return false;
            }
        }
        PsiClass extendsBoundClass = PsiUtil.resolveClassInClassTypeOnly(extendsBound);
        PsiClass boundBoundClass = PsiUtil.resolveClassInClassTypeOnly(boundBound);
        if (boundBoundClass != null && extendsBoundClass != null && !boundBoundClass.isInterface() && !extendsBoundClass.isInterface()) {
            return !InheritanceUtil.isInheritorOrSelf(boundBoundClass, extendsBoundClass, true) && !InheritanceUtil.isInheritorOrSelf(extendsBoundClass, boundBoundClass, true);
        }
        return !TypeConversionUtil.areTypesConvertible(boundBound, extendsBound) && !TypeConversionUtil.areTypesConvertible(extendsBound, boundBound);
    }

    private static boolean checkNotAssignable(PsiType bound, PsiType type2, boolean allowUncheckedConversion) {
        if (bound instanceof PsiWildcardType) {
            if (((PsiWildcardType)bound).isBounded()) {
                PsiType boundBound = ((PsiWildcardType)bound).isExtends() ? ((PsiWildcardType)bound).getExtendsBound() : ((PsiWildcardType)bound).getSuperBound();
                return !TypeConversionUtil.isAssignable(boundBound, type2, allowUncheckedConversion);
            }
            return true;
        }
        return !TypeConversionUtil.isAssignable(bound, type2, allowUncheckedConversion);
    }

    @NotNull
    public static PsiClassType getExpectedGenericType(PsiElement context2, PsiClass aClass2, PsiClassType expectedType) {
        List<PsiType> arguments2 = GenericsUtil.getExpectedTypeArguments(context2, aClass2, Arrays.asList(aClass2.getTypeParameters()), expectedType);
        PsiClassType psiClassType = JavaPsiFacade.getElementFactory(context2.getProject()).createType(aClass2, arguments2.toArray(PsiType.EMPTY_ARRAY));
        if (psiClassType == null) {
            GenericsUtil.$$$reportNull$$$0(10);
        }
        return psiClassType;
    }

    @NotNull
    public static List<PsiType> getExpectedTypeArguments(PsiElement context2, PsiClass aClass2, Iterable<? extends PsiTypeParameter> typeParams, PsiClassType expectedType) {
        PsiClassType.ClassResolveResult resolve2 = expectedType.resolveGenerics();
        PsiClass expectedClass = resolve2.getElement();
        if (!InheritanceUtil.isInheritorOrSelf(aClass2, expectedClass, true)) {
            List<PsiType> list2 = ContainerUtil.map(typeParams, p -> null);
            if (list2 == null) {
                GenericsUtil.$$$reportNull$$$0(11);
            }
            return list2;
        }
        PsiSubstitutor substitutor2 = TypeConversionUtil.getClassSubstitutor(expectedClass, aClass2, PsiSubstitutor.EMPTY);
        assert (substitutor2 != null);
        List<PsiType> list3 = ContainerUtil.map(typeParams, p -> GenericsUtil.getExpectedTypeArg(context2, resolve2, substitutor2, p));
        if (list3 == null) {
            GenericsUtil.$$$reportNull$$$0(12);
        }
        return list3;
    }

    @Nullable
    private static PsiType getExpectedTypeArg(PsiElement context2, PsiClassType.ClassResolveResult expectedType, PsiSubstitutor superClassSubstitutor, PsiTypeParameter typeParam) {
        PsiClass expectedClass = expectedType.getElement();
        assert (expectedClass != null);
        for (PsiTypeParameter parameter : PsiUtil.typeParametersIterable(expectedClass)) {
            PsiType paramSubstitution = superClassSubstitutor.substitute(parameter);
            PsiClass inheritorCandidateParameter = PsiUtil.resolveClassInType(paramSubstitution);
            if (inheritorCandidateParameter instanceof PsiTypeParameter && ((PsiTypeParameter)inheritorCandidateParameter).getOwner() == typeParam.getOwner() && inheritorCandidateParameter != typeParam) continue;
            PsiType argSubstitution = expectedType.getSubstitutor().substitute(parameter);
            PsiType substitution2 = JavaPsiFacade.getInstance(context2.getProject()).getResolveHelper().getSubstitutionForTypeParameter(typeParam, paramSubstitution, argSubstitution, true, PsiUtil.getLanguageLevel(context2));
            if (substitution2 == null || substitution2 == PsiType.NULL) continue;
            return substitution2;
        }
        return null;
    }

    public static boolean isGenericReference(PsiJavaCodeReferenceElement referenceElement, PsiJavaCodeReferenceElement qualifierElement) {
        PsiTypeElement[] typeParameterElements;
        PsiTypeElement[] typeParameterElements2;
        PsiReferenceParameterList qualifierParameterList = qualifierElement.getParameterList();
        if (qualifierParameterList != null && (typeParameterElements2 = qualifierParameterList.getTypeParameterElements()).length > 0) {
            return true;
        }
        PsiReferenceParameterList parameterList = referenceElement.getParameterList();
        return parameterList != null && (typeParameterElements = parameterList.getTypeParameterElements()).length > 0;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
            case 9: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 9: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/psi/GenericsUtil";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getLeastUpperBound";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getLeastUpperClasses";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/GenericsUtil";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getExpectedGenericType";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getExpectedTypeArguments";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isFromExternalTypeLanguage";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
            case 9: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

