/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.Component;
import java.awt.Font;
import javax.swing.JLabel;
import net.miginfocom.swing.MigLayout;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.FontLibrary;
import net.sf.freecol.client.gui.panel.BuildingPanel;
import net.sf.freecol.client.gui.panel.FreeColProgressBar;
import net.sf.freecol.client.gui.panel.ReportPanel;
import net.sf.freecol.client.gui.panel.Utility;
import net.sf.freecol.common.model.Building;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Specification;

public final class ReportReligiousPanel
extends ReportPanel {
    public ReportReligiousPanel(FreeColClient freeColClient) {
        super(freeColClient, "reportReligionAction");
        Font font = FontLibrary.createFont(FontLibrary.FontType.NORMAL, FontLibrary.FontSize.SMALLER, 1, freeColClient.getGUI().getImageLibrary().getScaleFactor());
        Player player = this.getMyPlayer();
        Specification spec = this.getSpecification();
        this.reportPanel.setLayout(new MigLayout("wrap 6, fill", "center"));
        for (GoodsType gt : spec.getImmigrationGoodsTypeList()) {
            JLabel crosses = Utility.localizedLabel(gt);
            crosses.setFont(font);
            this.reportPanel.add((Component)crosses, "span, split 2");
            FreeColProgressBar progressBar = new FreeColProgressBar(gt, 0, player.getImmigrationRequired(), player.getImmigration(), player.getTotalImmigrationProduction());
            this.reportPanel.add((Component)progressBar, "span");
            for (Colony colony : freeColClient.getMySortedColonies()) {
                Building building = colony.getBuildingForProducing(gt);
                if (building == null) continue;
                this.reportPanel.add((Component)this.createColonyButton(colony), "split 2, flowy");
                BuildingPanel bp = new BuildingPanel(this.getFreeColClient(), building);
                bp.initialize();
                this.reportPanel.add(bp);
            }
        }
    }
}

