/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.auth.jdbc.usergroup;

import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.guacamole.GuacamoleException;
import org.apache.guacamole.auth.jdbc.base.ModeledPermissions;
import org.apache.guacamole.auth.jdbc.user.ModeledAuthenticatedUser;
import org.apache.guacamole.auth.jdbc.usergroup.UserGroupMemberUserGroupSet;
import org.apache.guacamole.auth.jdbc.usergroup.UserGroupMemberUserSet;
import org.apache.guacamole.auth.jdbc.usergroup.UserGroupModel;
import org.apache.guacamole.auth.jdbc.usergroup.UserGroupParentUserGroupSet;
import org.apache.guacamole.form.BooleanField;
import org.apache.guacamole.form.Form;
import org.apache.guacamole.net.auth.RelatedObjectSet;
import org.apache.guacamole.net.auth.UserGroup;

public class ModeledUserGroup
extends ModeledPermissions<UserGroupModel>
implements UserGroup {
    public static final String DISABLED_ATTRIBUTE_NAME = "disabled";
    public static final Form ACCOUNT_RESTRICTIONS = new Form("restrictions", Arrays.asList(new BooleanField("disabled", "true")));
    public static final Collection<Form> ATTRIBUTES = Collections.unmodifiableCollection(Arrays.asList(ACCOUNT_RESTRICTIONS));
    public static final Set<String> ATTRIBUTE_NAMES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("disabled")));
    @Inject
    private Provider<UserGroupParentUserGroupSet> parentUserGroupSetProvider;
    @Inject
    private Provider<UserGroupMemberUserSet> memberUserSetProvider;
    @Inject
    private Provider<UserGroupMemberUserGroupSet> memberUserGroupSetProvider;
    private boolean exposeRestrictedAttributes = false;

    public void init(ModeledAuthenticatedUser currentUser, UserGroupModel model, boolean exposeRestrictedAttributes) {
        super.init(currentUser, model);
        this.exposeRestrictedAttributes = exposeRestrictedAttributes;
    }

    private void putRestrictedAttributes(Map<String, String> attributes) {
        attributes.put(DISABLED_ATTRIBUTE_NAME, ((UserGroupModel)this.getModel()).isDisabled() ? "true" : null);
    }

    private void setRestrictedAttributes(Map<String, String> attributes) {
        ((UserGroupModel)this.getModel()).setDisabled("true".equals(attributes.get(DISABLED_ATTRIBUTE_NAME)));
    }

    @Override
    public Set<String> getSupportedAttributeNames() {
        return ATTRIBUTE_NAMES;
    }

    @Override
    public Map<String, String> getAttributes() {
        Map<String, String> attributes = super.getAttributes();
        if (this.exposeRestrictedAttributes) {
            this.putRestrictedAttributes(attributes);
        }
        return attributes;
    }

    @Override
    public void setAttributes(Map<String, String> attributes) {
        super.setAttributes(attributes);
        if (this.exposeRestrictedAttributes) {
            this.setRestrictedAttributes(attributes);
        }
    }

    public RelatedObjectSet getUserGroups() throws GuacamoleException {
        UserGroupParentUserGroupSet parentUserGroupSet = this.parentUserGroupSetProvider.get();
        parentUserGroupSet.init(this.getCurrentUser(), this);
        return parentUserGroupSet;
    }

    public RelatedObjectSet getMemberUsers() throws GuacamoleException {
        UserGroupMemberUserSet memberUserSet = this.memberUserSetProvider.get();
        memberUserSet.init(this.getCurrentUser(), this);
        return memberUserSet;
    }

    public RelatedObjectSet getMemberUserGroups() throws GuacamoleException {
        UserGroupMemberUserGroupSet memberUserGroupSet = this.memberUserGroupSetProvider.get();
        memberUserGroupSet.init(this.getCurrentUser(), this);
        return memberUserGroupSet;
    }
}

