/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.handler.events;

import io.netty.channel.ChannelHandler;
import java.util.Collections;
import java.util.Map;
import javax.inject.Inject;
import org.traccar.handler.events.BaseEventHandler;
import org.traccar.helper.model.PositionUtil;
import org.traccar.model.Device;
import org.traccar.model.Event;
import org.traccar.model.Position;
import org.traccar.reports.common.TripsConfig;
import org.traccar.session.ConnectionManager;
import org.traccar.session.DeviceState;
import org.traccar.session.cache.CacheManager;

@ChannelHandler.Sharable
public class MotionEventHandler
extends BaseEventHandler {
    private final CacheManager cacheManager;
    private final ConnectionManager connectionManager;
    private final TripsConfig tripsConfig;

    @Inject
    public MotionEventHandler(CacheManager cacheManager, ConnectionManager connectionManager, TripsConfig tripsConfig) {
        this.cacheManager = cacheManager;
        this.connectionManager = connectionManager;
        this.tripsConfig = tripsConfig;
    }

    private Map<Event, Position> newEvent(DeviceState deviceState, boolean newMotion) {
        String eventType = newMotion ? "deviceMoving" : "deviceStopped";
        Position position = deviceState.getMotionPosition();
        Event event = new Event(eventType, position);
        deviceState.setMotionState(newMotion);
        deviceState.setMotionPosition(null);
        return Collections.singletonMap(event, position);
    }

    public Map<Event, Position> updateMotionState(DeviceState deviceState) {
        Map<Event, Position> result = null;
        if (deviceState.getMotionState() != null && deviceState.getMotionPosition() != null) {
            boolean newMotion = deviceState.getMotionState() == false;
            Position motionPosition = deviceState.getMotionPosition();
            long currentTime = System.currentTimeMillis();
            long motionTime = motionPosition.getFixTime().getTime() + (newMotion ? this.tripsConfig.getMinimalTripDuration() : this.tripsConfig.getMinimalParkingDuration());
            if (motionTime <= currentTime) {
                result = this.newEvent(deviceState, newMotion);
            }
        }
        return result;
    }

    public Map<Event, Position> updateMotionState(DeviceState deviceState, Position position) {
        return this.updateMotionState(deviceState, position, position.getBoolean("motion"));
    }

    public Map<Event, Position> updateMotionState(DeviceState deviceState, Position position, boolean newMotion) {
        Position motionPosition;
        Map<Event, Position> result = null;
        Boolean oldMotion = deviceState.getMotionState();
        long currentTime = position.getFixTime().getTime();
        if (newMotion != oldMotion) {
            if (deviceState.getMotionPosition() == null) {
                deviceState.setMotionPosition(position);
            }
        } else {
            deviceState.setMotionPosition(null);
        }
        if ((motionPosition = deviceState.getMotionPosition()) != null) {
            long motionTime = motionPosition.getFixTime().getTime();
            double distance = PositionUtil.calculateDistance(motionPosition, position, false);
            Boolean ignition = null;
            if (this.tripsConfig.getUseIgnition() && position.hasAttribute("ignition")) {
                ignition = position.getBoolean("ignition");
            }
            if (newMotion) {
                if (motionTime + this.tripsConfig.getMinimalTripDuration() <= currentTime || distance >= this.tripsConfig.getMinimalTripDistance()) {
                    result = this.newEvent(deviceState, newMotion);
                }
            } else if (motionTime + this.tripsConfig.getMinimalParkingDuration() <= currentTime || ignition != null && !ignition.booleanValue()) {
                result = this.newEvent(deviceState, newMotion);
            }
        }
        return result;
    }

    @Override
    protected Map<Event, Position> analyzePosition(Position position) {
        long deviceId = position.getDeviceId();
        Device device = this.cacheManager.getObject(Device.class, deviceId);
        if (device == null) {
            return null;
        }
        if (!PositionUtil.isLatest(this.cacheManager, position) || !this.tripsConfig.getProcessInvalidPositions() && !position.getValid()) {
            return null;
        }
        Map<Event, Position> result = null;
        DeviceState deviceState = this.connectionManager.getDeviceState(deviceId);
        if (deviceState.getMotionState() == null) {
            deviceState.setMotionState(position.getBoolean("motion"));
        } else {
            result = this.updateMotionState(deviceState, position);
        }
        this.connectionManager.setDeviceState(deviceId, deviceState);
        return result;
    }
}

