/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.explorer;

import java.awt.Component;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileNameExtensionFilter;
import net.sf.mpxj.explorer.FileSaverModel;

public class FileSaverView {
    protected final JFileChooser m_fileChooser = new JFileChooser();
    private final Component m_parent;
    private final FileSaverModel m_model;

    public FileSaverView(Component component, FileSaverModel fileSaverModel) {
        this.m_parent = component;
        this.m_model = fileSaverModel;
    }

    protected void openFileChooser() {
        if (this.m_model.getShowDialog()) {
            if (this.m_fileChooser.showSaveDialog(this.m_parent) == 0) {
                FileNameExtensionFilter fileNameExtensionFilter = (FileNameExtensionFilter)this.m_fileChooser.getFileFilter();
                String string = fileNameExtensionFilter.getDescription();
                this.m_model.setType(string.substring(0, string.indexOf(32)));
                this.m_model.setFile(null);
                this.m_model.setFile(this.m_fileChooser.getSelectedFile());
            }
            this.m_model.setShowDialog(false);
        }
    }

    protected void setFileFilter() {
        this.m_fileChooser.setAcceptAllFileFilterUsed(false);
        String[] stringArray = this.m_model.getExtensions();
        for (int i = 0; i < stringArray.length; i += 2) {
            this.m_fileChooser.setFileFilter(new FileNameExtensionFilter(stringArray[i].toUpperCase() + " File", stringArray[i + 1]));
        }
    }
}

