/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.meow;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.util.meow.MeowU128;

@NativeType(value="union meow_hash")
public class MeowHash
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int U128;
    public static final int U64;
    public static final int U32;

    public MeowHash(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), MeowHash.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="meow_u128")
    public MeowU128 u128() {
        return MeowHash.nu128(this.address());
    }

    @NativeType(value="meow_u64[2]")
    public LongBuffer u64() {
        return MeowHash.nu64(this.address());
    }

    @NativeType(value="meow_u64")
    public long u64(int index) {
        return MeowHash.nu64(this.address(), index);
    }

    @NativeType(value="meow_u32[4]")
    public IntBuffer u32() {
        return MeowHash.nu32(this.address());
    }

    @NativeType(value="meow_u32")
    public int u32(int index) {
        return MeowHash.nu32(this.address(), index);
    }

    public static MeowHash malloc() {
        return (MeowHash)MeowHash.wrap(MeowHash.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static MeowHash calloc() {
        return (MeowHash)MeowHash.wrap(MeowHash.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static MeowHash create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (MeowHash)MeowHash.wrap(MeowHash.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static MeowHash create(long address) {
        return (MeowHash)MeowHash.wrap(MeowHash.class, (long)address);
    }

    @Nullable
    public static MeowHash createSafe(long address) {
        return address == 0L ? null : (MeowHash)MeowHash.wrap(MeowHash.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)MeowHash.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)MeowHash.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)MeowHash.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = MeowHash.__create((int)capacity, (int)SIZEOF);
        return (Buffer)MeowHash.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)MeowHash.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)MeowHash.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static MeowHash mallocStack() {
        return MeowHash.mallocStack(MemoryStack.stackGet());
    }

    public static MeowHash callocStack() {
        return MeowHash.callocStack(MemoryStack.stackGet());
    }

    public static MeowHash mallocStack(MemoryStack stack) {
        return (MeowHash)MeowHash.wrap(MeowHash.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static MeowHash callocStack(MemoryStack stack) {
        return (MeowHash)MeowHash.wrap(MeowHash.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return MeowHash.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return MeowHash.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return (Buffer)MeowHash.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return (Buffer)MeowHash.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static MeowU128 nu128(long struct) {
        return MeowU128.create(struct + (long)U128);
    }

    public static LongBuffer nu64(long struct) {
        return MemoryUtil.memLongBuffer((long)(struct + (long)U64), (int)2);
    }

    public static long nu64(long struct, int index) {
        return UNSAFE.getLong(null, struct + (long)U64 + Checks.check((int)index, (int)2) * 8L);
    }

    public static IntBuffer nu32(long struct) {
        return MemoryUtil.memIntBuffer((long)(struct + (long)U32), (int)4);
    }

    public static int nu32(long struct, int index) {
        return UNSAFE.getInt(null, struct + (long)U32 + Checks.check((int)index, (int)4) * 4L);
    }

    static {
        Struct.Layout layout = MeowHash.__union((Struct.Member[])new Struct.Member[]{MeowHash.__member((int)MeowU128.SIZEOF, (int)MeowU128.ALIGNOF, (boolean)true), MeowHash.__array((int)8, (int)2), MeowHash.__array((int)4, (int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        U128 = layout.offsetof(0);
        U64 = layout.offsetof(1);
        U32 = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<MeowHash, Buffer>
    implements NativeResource {
        private static final MeowHash ELEMENT_FACTORY = MeowHash.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected MeowHash getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="meow_u128")
        public MeowU128 u128() {
            return MeowHash.nu128(this.address());
        }

        @NativeType(value="meow_u64[2]")
        public LongBuffer u64() {
            return MeowHash.nu64(this.address());
        }

        @NativeType(value="meow_u64")
        public long u64(int index) {
            return MeowHash.nu64(this.address(), index);
        }

        @NativeType(value="meow_u32[4]")
        public IntBuffer u32() {
            return MeowHash.nu32(this.address());
        }

        @NativeType(value="meow_u32")
        public int u32(int index) {
            return MeowHash.nu32(this.address(), index);
        }
    }
}

