/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkImageSubresource
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int ASPECTMASK;
    public static final int MIPLEVEL;
    public static final int ARRAYLAYER;

    public VkImageSubresource(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkImageSubresource.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkImageAspectFlags")
    public int aspectMask() {
        return VkImageSubresource.naspectMask(this.address());
    }

    @NativeType(value="uint32_t")
    public int mipLevel() {
        return VkImageSubresource.nmipLevel(this.address());
    }

    @NativeType(value="uint32_t")
    public int arrayLayer() {
        return VkImageSubresource.narrayLayer(this.address());
    }

    public VkImageSubresource aspectMask(@NativeType(value="VkImageAspectFlags") int value) {
        VkImageSubresource.naspectMask(this.address(), value);
        return this;
    }

    public VkImageSubresource mipLevel(@NativeType(value="uint32_t") int value) {
        VkImageSubresource.nmipLevel(this.address(), value);
        return this;
    }

    public VkImageSubresource arrayLayer(@NativeType(value="uint32_t") int value) {
        VkImageSubresource.narrayLayer(this.address(), value);
        return this;
    }

    public VkImageSubresource set(int aspectMask, int mipLevel, int arrayLayer) {
        this.aspectMask(aspectMask);
        this.mipLevel(mipLevel);
        this.arrayLayer(arrayLayer);
        return this;
    }

    public VkImageSubresource set(VkImageSubresource src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkImageSubresource malloc() {
        return (VkImageSubresource)VkImageSubresource.wrap(VkImageSubresource.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static VkImageSubresource calloc() {
        return (VkImageSubresource)VkImageSubresource.wrap(VkImageSubresource.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static VkImageSubresource create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (VkImageSubresource)VkImageSubresource.wrap(VkImageSubresource.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static VkImageSubresource create(long address) {
        return (VkImageSubresource)VkImageSubresource.wrap(VkImageSubresource.class, (long)address);
    }

    @Nullable
    public static VkImageSubresource createSafe(long address) {
        return address == 0L ? null : (VkImageSubresource)VkImageSubresource.wrap(VkImageSubresource.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)VkImageSubresource.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)VkImageSubresource.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)VkImageSubresource.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkImageSubresource.__create((int)capacity, (int)SIZEOF);
        return (Buffer)VkImageSubresource.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)VkImageSubresource.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)VkImageSubresource.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static VkImageSubresource mallocStack() {
        return VkImageSubresource.mallocStack(MemoryStack.stackGet());
    }

    public static VkImageSubresource callocStack() {
        return VkImageSubresource.callocStack(MemoryStack.stackGet());
    }

    public static VkImageSubresource mallocStack(MemoryStack stack) {
        return (VkImageSubresource)VkImageSubresource.wrap(VkImageSubresource.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkImageSubresource callocStack(MemoryStack stack) {
        return (VkImageSubresource)VkImageSubresource.wrap(VkImageSubresource.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkImageSubresource.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkImageSubresource.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return (Buffer)VkImageSubresource.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return (Buffer)VkImageSubresource.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static int naspectMask(long struct) {
        return UNSAFE.getInt(null, struct + (long)ASPECTMASK);
    }

    public static int nmipLevel(long struct) {
        return UNSAFE.getInt(null, struct + (long)MIPLEVEL);
    }

    public static int narrayLayer(long struct) {
        return UNSAFE.getInt(null, struct + (long)ARRAYLAYER);
    }

    public static void naspectMask(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)ASPECTMASK, value);
    }

    public static void nmipLevel(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)MIPLEVEL, value);
    }

    public static void narrayLayer(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)ARRAYLAYER, value);
    }

    static {
        Struct.Layout layout = VkImageSubresource.__struct((Struct.Member[])new Struct.Member[]{VkImageSubresource.__member((int)4), VkImageSubresource.__member((int)4), VkImageSubresource.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        ASPECTMASK = layout.offsetof(0);
        MIPLEVEL = layout.offsetof(1);
        ARRAYLAYER = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<VkImageSubresource, Buffer>
    implements NativeResource {
        private static final VkImageSubresource ELEMENT_FACTORY = VkImageSubresource.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected VkImageSubresource getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkImageAspectFlags")
        public int aspectMask() {
            return VkImageSubresource.naspectMask(this.address());
        }

        @NativeType(value="uint32_t")
        public int mipLevel() {
            return VkImageSubresource.nmipLevel(this.address());
        }

        @NativeType(value="uint32_t")
        public int arrayLayer() {
            return VkImageSubresource.narrayLayer(this.address());
        }

        public Buffer aspectMask(@NativeType(value="VkImageAspectFlags") int value) {
            VkImageSubresource.naspectMask(this.address(), value);
            return this;
        }

        public Buffer mipLevel(@NativeType(value="uint32_t") int value) {
            VkImageSubresource.nmipLevel(this.address(), value);
            return this;
        }

        public Buffer arrayLayer(@NativeType(value="uint32_t") int value) {
            VkImageSubresource.narrayLayer(this.address(), value);
            return this;
        }
    }
}

