/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.util.Map;
import java.util.Set;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.Checks;
import org.lwjgl.system.CustomBuffer;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.vulkan.VK;
import org.lwjgl.vulkan.VkDevice;
import org.lwjgl.vulkan.VkImportSemaphoreWin32HandleInfoKHR;
import org.lwjgl.vulkan.VkSemaphoreGetWin32HandleInfoKHR;

public class KHRExternalSemaphoreWin32 {
    public static final int VK_KHR_EXTERNAL_SEMAPHORE_WIN32_SPEC_VERSION = 1;
    public static final String VK_KHR_EXTERNAL_SEMAPHORE_WIN32_EXTENSION_NAME = "VK_KHR_external_semaphore_win32";
    public static final int VK_STRUCTURE_TYPE_IMPORT_SEMAPHORE_WIN32_HANDLE_INFO_KHR = 1000078000;
    public static final int VK_STRUCTURE_TYPE_EXPORT_SEMAPHORE_WIN32_HANDLE_INFO_KHR = 1000078001;
    public static final int VK_STRUCTURE_TYPE_D3D12_FENCE_SUBMIT_INFO_KHR = 1000078002;
    public static final int VK_STRUCTURE_TYPE_SEMAPHORE_GET_WIN32_HANDLE_INFO_KHR = 1000078003;

    protected KHRExternalSemaphoreWin32() {
        throw new UnsupportedOperationException();
    }

    static boolean checkCapsDevice(FunctionProvider provider, Map<String, Long> caps, Set<String> ext) {
        return ext.contains(VK_KHR_EXTERNAL_SEMAPHORE_WIN32_EXTENSION_NAME) && VK.checkExtension(VK_KHR_EXTERNAL_SEMAPHORE_WIN32_EXTENSION_NAME, VK.isSupported(provider, "vkImportSemaphoreWin32HandleKHR", caps) && VK.isSupported(provider, "vkGetSemaphoreWin32HandleKHR", caps));
    }

    public static int nvkImportSemaphoreWin32HandleKHR(VkDevice device, long pImportSemaphoreWin32HandleInfo) {
        long __functionAddress = device.getCapabilities().vkImportSemaphoreWin32HandleKHR;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            VkImportSemaphoreWin32HandleInfoKHR.validate(pImportSemaphoreWin32HandleInfo);
        }
        return JNI.callPPI((long)device.address(), (long)pImportSemaphoreWin32HandleInfo, (long)__functionAddress);
    }

    @NativeType(value="VkResult")
    public static int vkImportSemaphoreWin32HandleKHR(VkDevice device, @NativeType(value="VkImportSemaphoreWin32HandleInfoKHR const *") VkImportSemaphoreWin32HandleInfoKHR pImportSemaphoreWin32HandleInfo) {
        return KHRExternalSemaphoreWin32.nvkImportSemaphoreWin32HandleKHR(device, pImportSemaphoreWin32HandleInfo.address());
    }

    public static int nvkGetSemaphoreWin32HandleKHR(VkDevice device, long pGetWin32HandleInfo, long pHandle) {
        long __functionAddress = device.getCapabilities().vkGetSemaphoreWin32HandleKHR;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        return JNI.callPPPI((long)device.address(), (long)pGetWin32HandleInfo, (long)pHandle, (long)__functionAddress);
    }

    @NativeType(value="VkResult")
    public static int vkGetSemaphoreWin32HandleKHR(VkDevice device, @NativeType(value="VkSemaphoreGetWin32HandleInfoKHR const *") VkSemaphoreGetWin32HandleInfoKHR pGetWin32HandleInfo, @NativeType(value="HANDLE *") PointerBuffer pHandle) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)pHandle, (int)1);
        }
        return KHRExternalSemaphoreWin32.nvkGetSemaphoreWin32HandleKHR(device, pGetWin32HandleInfo.address(), MemoryUtil.memAddress((CustomBuffer)pHandle));
    }
}

