/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.transport.tls;

import java.io.Serializable;
import java.security.cert.CertificateException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import javax.net.ssl.X509TrustManager;
import javax.security.auth.x500.X500Principal;
import org.snmp4j.TransportStateReference;
import org.snmp4j.event.CounterEvent;
import org.snmp4j.log.LogAdapter;
import org.snmp4j.log.LogFactory;
import org.snmp4j.mp.CounterSupport;
import org.snmp4j.mp.SnmpConstants;
import org.snmp4j.smi.OctetString;
import org.snmp4j.transport.tls.TLSTMUtil;
import org.snmp4j.transport.tls.TlsTmSecurityCallback;
import org.snmp4j.transport.tls.TlsX509CertifiedTarget;

public class TlsTrustManager
implements X509TrustManager {
    private static LogAdapter LOGGER = LogFactory.getLogger(TlsTrustManager.class);
    X509TrustManager trustManager;
    private boolean useClientMode;
    private TransportStateReference tmStateReference;
    private CounterSupport tlstmCounters;
    private TlsTmSecurityCallback<X509Certificate> securityCallback;

    public TlsTrustManager(X509TrustManager trustManager, boolean useClientMode, TransportStateReference tmStateReference, CounterSupport tlstmCounters, TlsTmSecurityCallback<X509Certificate> securityCallback) {
        this.trustManager = trustManager;
        this.useClientMode = useClientMode;
        this.tmStateReference = tmStateReference;
        this.tlstmCounters = tlstmCounters;
        this.securityCallback = securityCallback;
    }

    @Override
    public void checkClientTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
        if (this.tmStateReference != null && this.tmStateReference.getCertifiedIdentity() != null) {
            OctetString fingerprint = this.tmStateReference.getCertifiedIdentity().getClientFingerprint();
            if (this.isMatchingFingerprint(x509Certificates, fingerprint, false)) {
                return;
            }
            this.tlstmCounters.fireIncrementCounter(new CounterEvent(this, SnmpConstants.snmpTlstmSessionInvalidClientCertificates));
            throw new CertificateException("Client certificate validation by fingerprint failed for '" + x509Certificates[0] + "' (does not match " + fingerprint.toHexString() + ")");
        }
        TlsTmSecurityCallback<X509Certificate> callback = this.getSecurityCallback();
        try {
            if (!this.useClientMode && callback != null) {
                if (callback.isClientCertificateAccepted(x509Certificates[0])) {
                    if (LOGGER.isInfoEnabled()) {
                        LOGGER.info("Client is trusted with certificate '" + x509Certificates[0] + "'");
                    }
                    return;
                }
                this.tlstmCounters.fireIncrementCounter(new CounterEvent(this, SnmpConstants.snmpTlstmSessionInvalidClientCertificates));
                throw new CertificateException("Client certificate validation by fingerprint failed for '" + x509Certificates[0] + "'");
            }
            this.trustManager.checkClientTrusted(x509Certificates, s);
        }
        catch (CertificateException cex) {
            this.tlstmCounters.fireIncrementCounter(new CounterEvent(this, SnmpConstants.snmpTlstmSessionOpenErrors));
            this.tlstmCounters.fireIncrementCounter(new CounterEvent(this, SnmpConstants.snmpTlstmSessionInvalidClientCertificates));
            LOGGER.warn((Serializable)((Object)("Client certificate validation failed for '" + x509Certificates[0] + "'")));
            throw cex;
        }
    }

    @Override
    public void checkServerTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
        Boolean isServerCertificateAccepted;
        X500Principal x500Principal;
        OctetString fingerprint = null;
        if (this.tmStateReference.getCertifiedIdentity() != null && this.isMatchingFingerprint(x509Certificates, fingerprint = this.tmStateReference.getCertifiedIdentity().getServerFingerprint(), true)) {
            return;
        }
        Object entry = null;
        try {
            entry = TLSTMUtil.getSubjAltName(x509Certificates[0].getSubjectAlternativeNames(), 2);
        }
        catch (CertificateParsingException e) {
            this.tlstmCounters.fireIncrementCounter(new CounterEvent(this, SnmpConstants.snmpTlstmSessionInvalidServerCertificates));
            LOGGER.warn((Serializable)((Object)("CertificateParsingException while verifying server certificate " + Arrays.asList(x509Certificates))));
        }
        if (entry == null && (x500Principal = x509Certificates[0].getSubjectX500Principal()) != null) {
            entry = x500Principal.getName();
        }
        if (entry != null && fingerprint != null && fingerprint.length() == 0 && this.tmStateReference.getCertifiedIdentity() != null && this.tmStateReference.getCertifiedIdentity().getIdentity() != null) {
            String dNSName = ((String)entry).toLowerCase();
            String hostName = this.tmStateReference.getCertifiedIdentity().getIdentity().toString();
            if (hostName.length() > 0) {
                if (hostName.charAt(0) == '*') {
                    int pos = dNSName.indexOf(46);
                    if (pos > 0) {
                        dNSName = dNSName.substring(pos);
                    }
                    hostName = hostName.substring(1);
                }
                if (hostName.equalsIgnoreCase(dNSName)) {
                    if (LOGGER.isInfoEnabled()) {
                        LOGGER.info("Peer hostname " + hostName + " matches dNSName " + dNSName);
                    }
                    return;
                }
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Serializable)((Object)("Peer hostname " + hostName + " did not match dNSName " + dNSName)));
            }
        }
        try {
            this.trustManager.checkServerTrusted(x509Certificates, s);
        }
        catch (CertificateException cex) {
            this.tlstmCounters.fireIncrementCounter(new CounterEvent(this, SnmpConstants.snmpTlstmSessionOpenErrors));
            this.tlstmCounters.fireIncrementCounter(new CounterEvent(this, SnmpConstants.snmpTlstmSessionInvalidServerCertificates));
            LOGGER.warn((Serializable)((Object)("Server certificate validation failed for '" + x509Certificates[0] + "'")));
            throw cex;
        }
        TlsTmSecurityCallback<X509Certificate> callback = this.getSecurityCallback();
        if (this.useClientMode && callback != null && (isServerCertificateAccepted = Boolean.valueOf(callback.isServerCertificateAccepted(x509Certificates))) != null && !isServerCertificateAccepted.booleanValue()) {
            LOGGER.info("Server is NOT trusted with certificate '" + Arrays.asList(x509Certificates) + "'");
            throw new CertificateException("Server's certificate is not trusted by this application (although it was trusted by the JRE): " + Arrays.asList(x509Certificates));
        }
    }

    private boolean isMatchingFingerprint(X509Certificate[] x509Certificates, OctetString fingerprint, boolean useClientMode) throws CertificateException {
        if (fingerprint != null && fingerprint.length() > 0) {
            for (X509Certificate cert : x509Certificates) {
                OctetString certFingerprint = null;
                certFingerprint = TLSTMUtil.getFingerprint(cert);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Serializable)((Object)("Comparing certificate fingerprint " + certFingerprint + " with " + fingerprint)));
                }
                if (certFingerprint == null) {
                    LOGGER.error((Serializable)((Object)("Failed to determine fingerprint for certificate " + cert + " and algorithm " + cert.getSigAlgName())));
                    continue;
                }
                if (!certFingerprint.equals(fingerprint)) continue;
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info("Peer is trusted by fingerprint '" + fingerprint + "' of certificate: '" + cert + "'");
                }
                return true;
            }
            this.tlstmCounters.fireIncrementCounter(new CounterEvent(this, useClientMode ? SnmpConstants.snmpTlstmSessionInvalidServerCertificates : SnmpConstants.snmpTlstmSessionInvalidClientCertificates));
            throw new CertificateException("No fingerprint of provided certificates " + Arrays.asList(x509Certificates) + " matched " + fingerprint.toHexString());
        }
        return false;
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return TlsTrustManager.getAcceptedIssuers(this.trustManager, this.getSecurityCallback());
    }

    public static X509Certificate[] getAcceptedIssuers(X509TrustManager trustManager, TlsTmSecurityCallback<X509Certificate> securityCallback) {
        X509Certificate[] accepted = trustManager.getAcceptedIssuers();
        if (accepted != null && securityCallback != null) {
            ArrayList<X509Certificate> acceptedIssuers = new ArrayList<X509Certificate>(accepted.length);
            for (X509Certificate cert : accepted) {
                try {
                    if (!securityCallback.isAcceptedIssuer(cert)) continue;
                    acceptedIssuers.add(cert);
                }
                catch (CertificateException certex) {
                    LOGGER.debug((Serializable)((Object)("Security callback " + securityCallback + " rejected " + cert)));
                }
            }
            return acceptedIssuers.toArray(new X509Certificate[0]);
        }
        return accepted;
    }

    protected TlsTmSecurityCallback<X509Certificate> getSecurityCallback() {
        TlsX509CertifiedTarget tlsCertifiedTarget;
        if (this.tmStateReference.getCertifiedIdentity() instanceof TlsX509CertifiedTarget && (tlsCertifiedTarget = (TlsX509CertifiedTarget)this.tmStateReference.getCertifiedIdentity()) != null && tlsCertifiedTarget.getTlsTmSecurityCallback() != null) {
            return tlsCertifiedTarget.getTlsTmSecurityCallback();
        }
        return this.securityCallback;
    }
}

