/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.plugins.inputs;

import co.elastic.logstash.api.Codec;
import co.elastic.logstash.api.Configuration;
import co.elastic.logstash.api.Context;
import co.elastic.logstash.api.Input;
import co.elastic.logstash.api.LogstashPlugin;
import co.elastic.logstash.api.PluginConfigSpec;
import co.elastic.logstash.api.PluginHelper;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousCloseException;
import java.nio.channels.FileChannel;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.function.Consumer;
import org.apache.logging.log4j.Logger;

@LogstashPlugin(name="java_stdin")
public class Stdin
implements Input,
Consumer<Map<String, Object>> {
    private final Logger logger;
    public static final PluginConfigSpec<Codec> CODEC_CONFIG = PluginConfigSpec.codecSetting("codec", "java_line");
    private static final int BUFFER_SIZE = 65536;
    private String hostname;
    private Codec codec;
    private volatile boolean stopRequested = false;
    private final CountDownLatch isStopped = new CountDownLatch(1);
    private FileChannel input;
    private Consumer<Map<String, Object>> writer;
    private String id;

    public Stdin(String id, Configuration configuration, Context context) {
        this(id, configuration, context, new FileInputStream(FileDescriptor.in).getChannel());
    }

    Stdin(String id, Configuration configuration, Context context, FileChannel inputChannel) {
        this.logger = context.getLogger(this);
        this.id = id;
        try {
            this.hostname = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            this.hostname = "[unknownHost]";
        }
        this.codec = configuration.get(CODEC_CONFIG);
        if (this.codec == null) {
            throw new IllegalStateException("Unable to obtain codec");
        }
        this.input = inputChannel;
    }

    @Override
    public void start(Consumer<Map<String, Object>> writer) {
        this.writer = writer;
        ByteBuffer buffer = ByteBuffer.allocateDirect(65536);
        try {
            while (!this.stopRequested && this.input.read(buffer) > -1) {
                buffer.flip();
                this.codec.decode(buffer, this);
                buffer.compact();
            }
        }
        catch (AsynchronousCloseException asynchronousCloseException) {
        }
        catch (IOException e) {
            this.stopRequested = true;
            this.logger.error("Stopping stdin after read error", (Throwable)e);
            throw new IllegalStateException(e);
        }
        finally {
            try {
                this.input.close();
            }
            catch (IOException iOException) {}
            buffer.flip();
            this.codec.flush(buffer, this);
            this.isStopped.countDown();
        }
    }

    @Override
    public void accept(Map<String, Object> event) {
        event.putIfAbsent("hostname", this.hostname);
        this.writer.accept(event);
    }

    @Override
    public void stop() {
        this.stopRequested = true;
        try {
            this.input.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void awaitStop() throws InterruptedException {
        this.isStopped.await();
    }

    @Override
    public Collection<PluginConfigSpec<?>> configSchema() {
        return PluginHelper.commonInputSettings(Collections.singletonList(CODEC_CONFIG));
    }

    @Override
    public String getId() {
        return this.id;
    }
}

