/*
 * Decompiled with CFR 0.152.
 */
package nokogiri.internals;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import nokogiri.NokogiriService;
import nokogiri.XmlAttr;
import nokogiri.XmlDocument;
import nokogiri.XmlSyntaxError;
import nokogiri.internals.NokogiriHelpers;
import org.apache.xerces.xni.XMLAttributes;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBoolean;
import org.jruby.RubyHash;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;

public abstract class ReaderNode {
    final Ruby ruby;
    public ReaderAttributeList attributeList;
    public Map<String, String> namespaces;
    public int depth;
    public int nodeType;
    public String lang;
    public String localName;
    public String xmlBase;
    public String prefix;
    public String name;
    public String uri;
    public String value;
    public String xmlVersion = "1.0";
    public int startOffset;
    public int endOffset;
    public boolean hasChildren = false;
    private Document document = null;

    protected ReaderNode(Ruby ruby) {
        this.ruby = ruby;
    }

    public abstract String getString();

    public IRubyObject getAttributeByIndex(IRubyObject iRubyObject) {
        if (iRubyObject.isNil()) {
            return iRubyObject;
        }
        long l = iRubyObject.convertToInteger().getLongValue();
        if (l > Integer.MAX_VALUE) {
            throw this.ruby.newArgumentError("value too long to be an array index");
        }
        if (this.attributeList == null) {
            return this.ruby.getNil();
        }
        if (l < 0L || (long)this.attributeList.length <= l) {
            return this.ruby.getNil();
        }
        return NokogiriHelpers.stringOrBlank(this.ruby, this.attributeList.values.get(Long.valueOf(l).intValue()));
    }

    public IRubyObject getAttributeByName(IRubyObject iRubyObject) {
        if (this.attributeList == null) {
            return this.ruby.getNil();
        }
        String string = this.attributeList.getByName(NokogiriHelpers.rubyStringToString(iRubyObject));
        return NokogiriHelpers.stringOrNil(this.ruby, string);
    }

    public IRubyObject getAttributeByName(String string) {
        if (this.attributeList == null) {
            return this.ruby.getNil();
        }
        String string2 = this.attributeList.getByName(string);
        return NokogiriHelpers.stringOrNil(this.ruby, string2);
    }

    public IRubyObject getAttributeCount() {
        if (this.attributeList == null) {
            return this.ruby.newFixnum(0);
        }
        return this.ruby.newFixnum(this.attributeList.length);
    }

    public IRubyObject getAttributesNodes() {
        RubyArray rubyArray = RubyArray.newArray((Ruby)this.ruby);
        if (this.attributeList != null && this.attributeList.length > 0) {
            if (this.document == null) {
                XmlDocument xmlDocument = (XmlDocument)XmlDocument.rbNew(this.ruby.getCurrentContext(), (IRubyObject)NokogiriHelpers.getNokogiriClass(this.ruby, "Nokogiri::XML::Document"), new IRubyObject[0]);
                this.document = xmlDocument.getDocument();
            }
            for (int i = 0; i < this.attributeList.length; ++i) {
                if (NokogiriHelpers.isNamespace(this.attributeList.names.get(i))) continue;
                Attr attr = this.document.createAttributeNS(this.attributeList.namespaces.get(i), this.attributeList.names.get(i));
                attr.setValue(this.attributeList.values.get(i));
                XmlAttr xmlAttr = (XmlAttr)NokogiriService.XML_ATTR_ALLOCATOR.allocate(this.ruby, NokogiriHelpers.getNokogiriClass(this.ruby, "Nokogiri::XML::Attr"));
                xmlAttr.setNode(this.ruby.getCurrentContext(), attr);
                rubyArray.append((IRubyObject)xmlAttr);
            }
        }
        return rubyArray;
    }

    public IRubyObject getAttributes(ThreadContext threadContext) {
        Ruby ruby = threadContext.runtime;
        if (this.attributeList == null) {
            return ruby.getNil();
        }
        RubyHash rubyHash = RubyHash.newHash((Ruby)ruby);
        for (int i = 0; i < this.attributeList.length; ++i) {
            IRubyObject iRubyObject = NokogiriHelpers.stringOrBlank(ruby, this.attributeList.names.get(i));
            IRubyObject iRubyObject2 = NokogiriHelpers.stringOrBlank(ruby, this.attributeList.values.get(i));
            rubyHash.fastASetCheckString(ruby, iRubyObject, iRubyObject2);
        }
        return rubyHash;
    }

    public IRubyObject getDepth() {
        return this.ruby.newFixnum(this.depth);
    }

    public IRubyObject getLang() {
        return NokogiriHelpers.stringOrNil(this.ruby, this.lang);
    }

    public IRubyObject getLocalName() {
        return NokogiriHelpers.stringOrNil(this.ruby, this.localName);
    }

    public IRubyObject getName() {
        return NokogiriHelpers.stringOrNil(this.ruby, this.name);
    }

    public IRubyObject getNamespaces(ThreadContext threadContext) {
        Ruby ruby = threadContext.runtime;
        if (this.namespaces == null) {
            return ruby.getNil();
        }
        RubyHash rubyHash = RubyHash.newHash((Ruby)ruby);
        for (Map.Entry<String, String> entry : this.namespaces.entrySet()) {
            IRubyObject iRubyObject = NokogiriHelpers.stringOrBlank(ruby, entry.getKey());
            IRubyObject iRubyObject2 = NokogiriHelpers.stringOrBlank(ruby, entry.getValue());
            rubyHash.fastASetCheckString(ruby, iRubyObject, iRubyObject2);
        }
        return rubyHash;
    }

    public IRubyObject getXmlBase() {
        return NokogiriHelpers.stringOrNil(this.ruby, this.xmlBase);
    }

    public IRubyObject getPrefix() {
        return NokogiriHelpers.stringOrNil(this.ruby, this.prefix);
    }

    public IRubyObject getUri() {
        return NokogiriHelpers.stringOrNil(this.ruby, this.uri);
    }

    public IRubyObject getValue() {
        return NokogiriHelpers.stringOrNil(this.ruby, this.value);
    }

    public IRubyObject getXmlVersion() {
        return this.ruby.newString(this.xmlVersion);
    }

    public RubyBoolean hasAttributes() {
        if (this.attributeList == null || this.attributeList.length == 0) {
            return this.ruby.getFalse();
        }
        return this.ruby.getTrue();
    }

    public abstract RubyBoolean hasValue();

    public RubyBoolean isDefault() {
        return this.ruby.getFalse();
    }

    public boolean isError() {
        return false;
    }

    protected void parsePrefix(String string) {
        int n = string.indexOf(58);
        if (n != -1) {
            this.prefix = string.substring(0, n);
        }
    }

    public void setLang(String string) {
        this.lang = string;
    }

    public IRubyObject toSyntaxError() {
        return this.ruby.getNil();
    }

    public IRubyObject getNodeType() {
        return this.ruby.newFixnum(this.nodeType);
    }

    public static ClosingNode createClosingNode(Ruby ruby, String string, String string2, String string3, int n, Stack<String> stack, Stack<String> stack2) {
        return new ClosingNode(ruby, string, string2, string3, n, stack, stack2);
    }

    public static ElementNode createElementNode(Ruby ruby, String string, String string2, String string3, XMLAttributes xMLAttributes, int n, Stack<String> stack, Stack<String> stack2) {
        return new ElementNode(ruby, string, string2, string3, xMLAttributes, n, stack, stack2);
    }

    public static TextNode createTextNode(Ruby ruby, String string, int n, Stack<String> stack, Stack<String> stack2) {
        return new TextNode(ruby, string, n, stack, stack2);
    }

    public static class TextNode
    extends ReaderNode {
        TextNode(Ruby ruby, String string, int n, Stack<String> stack, Stack<String> stack2) {
            super(ruby);
            this.value = string;
            this.localName = "#text";
            this.name = "#text";
            this.depth = n;
            this.nodeType = !NokogiriHelpers.isBlank(string) ? ReaderNodeType.TEXT.getValue() : ReaderNodeType.SIGNIFICANT_WHITESPACE.getValue();
            if (!stack.isEmpty()) {
                this.lang = stack.peek();
            }
            if (!stack2.isEmpty()) {
                this.xmlBase = stack2.peek();
            }
        }

        @Override
        public RubyBoolean hasValue() {
            return this.ruby.getTrue();
        }

        @Override
        public String getString() {
            return this.value;
        }
    }

    public static class ExceptionNode
    extends EmptyNode {
        private final XmlSyntaxError exception;

        public ExceptionNode(Ruby ruby, Exception exception) {
            super(ruby);
            this.exception = XmlSyntaxError.createXMLSyntaxError(ruby);
            this.exception.setException(exception);
        }

        @Override
        public boolean isError() {
            return true;
        }

        @Override
        public IRubyObject toSyntaxError() {
            return this.exception;
        }
    }

    public static class EmptyNode
    extends ReaderNode {
        public EmptyNode(Ruby ruby) {
            super(ruby);
            this.nodeType = ReaderNodeType.NODE.getValue();
        }

        @Override
        public IRubyObject getXmlVersion() {
            return this.ruby.getNil();
        }

        @Override
        public RubyBoolean hasValue() {
            return this.ruby.getFalse();
        }

        @Override
        public String getString() {
            return null;
        }
    }

    private static class ReaderAttributeList {
        final List<String> namespaces = new ArrayList<String>();
        final List<String> names = new ArrayList<String>();
        final List<String> values = new ArrayList<String>();
        int length = 0;

        private ReaderAttributeList() {
        }

        void add(String string, String string2, String string3) {
            this.namespaces.add(string != null ? string : "");
            this.names.add(string2 != null ? string2 : "");
            this.values.add(string3 != null ? string3 : "");
            ++this.length;
        }

        String getByName(String string) {
            for (int i = 0; i < this.names.size(); ++i) {
                if (!string.equals(this.names.get(i))) continue;
                return this.values.get(i);
            }
            return null;
        }
    }

    public static class ElementNode
    extends ReaderNode {
        ElementNode(Ruby ruby, String string, String string2, String string3, XMLAttributes xMLAttributes, int n, Stack<String> stack, Stack<String> stack2) {
            super(ruby);
            this.nodeType = ReaderNodeType.ELEMENT.getValue();
            this.uri = "".equals(string) ? null : string;
            this.localName = !NokogiriHelpers.isBlank(string2) ? string2 : string3;
            this.name = string3;
            this.parsePrefix(string3);
            this.depth = n;
            this.parseAttributes(xMLAttributes, stack, stack2);
        }

        @Override
        public RubyBoolean hasValue() {
            return this.ruby.getFalse();
        }

        private void parseAttributes(XMLAttributes xMLAttributes, Stack<String> stack, Stack<String> stack2) {
            if (xMLAttributes.getLength() > 0) {
                this.attributeList = new ReaderAttributeList();
            }
            for (int i = 0; i < xMLAttributes.getLength(); ++i) {
                String string = xMLAttributes.getURI(i);
                String string2 = xMLAttributes.getQName(i);
                String string3 = xMLAttributes.getValue(i);
                if (NokogiriHelpers.isNamespace(string2)) {
                    if (this.namespaces == null) {
                        this.namespaces = new HashMap();
                    }
                    this.namespaces.put(string2, string3);
                } else {
                    if (this.lang == null) {
                        this.lang = this.resolveLang(string2, string3, stack);
                    }
                    if (this.xmlBase == null) {
                        this.xmlBase = this.resolveXmlBase(string2, string3, stack2);
                    }
                }
                this.attributeList.add(string, string2, string3);
            }
        }

        private String resolveLang(String string, String string2, Stack<String> stack) {
            if ("xml:lang".equals(string)) {
                return string2;
            }
            if (!stack.isEmpty()) {
                return stack.peek();
            }
            return null;
        }

        private String resolveXmlBase(String string, String string2, Stack<String> stack) {
            if (NokogiriHelpers.isXmlBase(string)) {
                return this.getXmlBaseUri(string, string2, stack);
            }
            if (!stack.isEmpty()) {
                return stack.peek();
            }
            return null;
        }

        private String getXmlBaseUri(String string, String string2, Stack<String> stack) {
            if ("xml:base".equals(string)) {
                if (string2.startsWith("http://")) {
                    return string2;
                }
                if (string2.startsWith("/") && string2.endsWith("/")) {
                    String string3 = string2.substring(1, string2.length() - 2);
                    String string4 = stack.peek();
                    if (string4.endsWith("/")) {
                        string4 = string4.substring(0, string4.length() - 1);
                    }
                    int n = string4.lastIndexOf("/");
                    return string4.substring(0, n).concat(string3);
                }
                String string5 = stack.peek();
                if (string5.endsWith("/")) {
                    return string5.concat(string2);
                }
                return string5.concat("/").concat(string2);
            }
            if ("xlink:href".equals(string)) {
                if (string2.startsWith("http://")) {
                    return string2;
                }
                if (!stack.isEmpty()) {
                    String string6 = stack.peek();
                    return string6;
                }
            }
            return null;
        }

        @Override
        public String getString() {
            StringBuffer stringBuffer = new StringBuffer(24);
            stringBuffer.append('<').append(this.name);
            if (this.attributeList != null) {
                for (int i = 0; i < this.attributeList.length; ++i) {
                    String string = this.attributeList.names.get(i);
                    String string2 = this.attributeList.values.get(i);
                    stringBuffer.append(' ').append(string).append('=').append('\"').append(string2).append('\"');
                }
            }
            if (this.hasChildren) {
                stringBuffer.append('>');
            } else {
                stringBuffer.append("/>");
            }
            return stringBuffer.toString();
        }
    }

    public static class ClosingNode
    extends ReaderNode {
        ClosingNode(Ruby ruby, String string, String string2, String string3, int n, Stack<String> stack, Stack<String> stack2) {
            super(ruby);
            this.nodeType = ReaderNodeType.END_ELEMENT.getValue();
            this.uri = "".equals(string) ? null : string;
            this.localName = !NokogiriHelpers.isBlank(string2) ? string2 : string3;
            this.name = string3;
            this.parsePrefix(string3);
            this.depth = n;
            if (!stack.isEmpty()) {
                this.lang = stack.peek();
            }
            if (!stack2.isEmpty()) {
                this.xmlBase = stack2.peek();
            }
        }

        @Override
        public IRubyObject getAttributeCount() {
            return this.ruby.newFixnum(0);
        }

        @Override
        public RubyBoolean hasValue() {
            return this.ruby.getFalse();
        }

        @Override
        public String getString() {
            return "</" + this.name + '>';
        }
    }

    public static enum ReaderNodeType {
        NODE(0),
        ELEMENT(1),
        ATTRIBUTE(2),
        TEXT(3),
        CDATA(4),
        ENTITY_REFERENCE(5),
        ENTITY(6),
        PROCESSING_INSTRUCTION(7),
        COMMENT(8),
        DOCUMENT(9),
        DOCUMENT_TYPE(10),
        DOCUMENTFRAGMENT(11),
        NOTATION(12),
        WHITESPACE(13),
        SIGNIFICANT_WHITESPACE(14),
        END_ELEMENT(15),
        END_ENTITY(16),
        XML_DECLARATION(17);

        private final int value;

        private ReaderNodeType(int n2) {
            this.value = n2;
        }

        public int getValue() {
            return this.value;
        }
    }
}

