/*
 * Decompiled with CFR 0.152.
 */
package nokogiri.internals;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import nokogiri.XmlNamespace;
import nokogiri.internals.NokogiriHelpers;
import org.w3c.dom.Attr;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class NokogiriNamespaceCache {
    private List<String[]> keys = new ArrayList<String[]>();
    private Map<String[], CacheEntry> cache = new LinkedHashMap<String[], CacheEntry>();
    private XmlNamespace defaultNamespace = null;

    public XmlNamespace getDefault() {
        return this.defaultNamespace;
    }

    private String[] getKey(String string, String string2) {
        for (String[] stringArray : this.keys) {
            if (!stringArray[0].equals(string) || !stringArray[1].equals(string2)) continue;
            return stringArray;
        }
        return null;
    }

    public XmlNamespace get(String string, String string2) {
        if (string == null || string2 == null) {
            return null;
        }
        String[] stringArray = this.getKey(string, string2);
        if (stringArray != null) {
            return this.cache.get(stringArray).namespace;
        }
        return null;
    }

    public XmlNamespace get(Node node, String string) {
        if (string == null) {
            return this.defaultNamespace;
        }
        for (String[] stringArray : this.keys) {
            if (!stringArray[0].equals(string) || this.cache.get(stringArray) == null || !this.cache.get(stringArray).isOwner(node).booleanValue()) continue;
            return this.cache.get(stringArray).namespace;
        }
        return null;
    }

    public List<XmlNamespace> get(String string) {
        ArrayList<XmlNamespace> arrayList = new ArrayList<XmlNamespace>();
        if (string == null) {
            arrayList.add(this.defaultNamespace);
            return arrayList;
        }
        for (String[] stringArray : this.keys) {
            if (!stringArray[0].equals(string) || this.cache.get(stringArray) == null) continue;
            arrayList.add(this.cache.get(stringArray).namespace);
        }
        return arrayList;
    }

    public List<XmlNamespace> get(Node node) {
        ArrayList<XmlNamespace> arrayList = new ArrayList<XmlNamespace>();
        for (String[] stringArray : this.keys) {
            CacheEntry cacheEntry = this.cache.get(stringArray);
            if (!cacheEntry.isOwner(node).booleanValue()) continue;
            arrayList.add(cacheEntry.namespace);
        }
        return arrayList;
    }

    public void put(XmlNamespace xmlNamespace, Node node) {
        String string;
        String string2 = xmlNamespace.getPrefix();
        if (this.getKey(string2, string = xmlNamespace.getHref()) != null) {
            return;
        }
        String[] stringArray = new String[]{string2, string};
        this.keys.add(stringArray);
        CacheEntry cacheEntry = new CacheEntry(xmlNamespace, node);
        this.cache.put(stringArray, cacheEntry);
        if ("".equals(string2)) {
            this.defaultNamespace = xmlNamespace;
        }
    }

    public void remove(String string, String string2) {
        String[] stringArray = this.getKey(string, string2);
        if (stringArray == null) {
            return;
        }
        this.keys.remove(stringArray);
        this.cache.remove(stringArray);
    }

    public void clear() {
        for (String[] stringArray : this.cache.keySet()) {
            CacheEntry cacheEntry = this.cache.get(stringArray);
            NamedNodeMap namedNodeMap = cacheEntry.ownerNode.getAttributes();
            for (int i = 0; i < namedNodeMap.getLength(); ++i) {
                String string = ((Attr)namedNodeMap.item(i)).getName();
                if (!NokogiriHelpers.isNamespace(string)) continue;
                namedNodeMap.removeNamedItem(string);
            }
        }
        this.keys.clear();
        this.cache.clear();
        this.defaultNamespace = null;
    }

    public void replaceNode(Node node, Node node2) {
        for (String[] stringArray : this.keys) {
            CacheEntry cacheEntry = this.cache.get(stringArray);
            if (!cacheEntry.isOwner(node).booleanValue()) continue;
            cacheEntry.replaceOwner(node2);
        }
    }

    private class CacheEntry {
        private XmlNamespace namespace;
        private Node ownerNode;

        CacheEntry(XmlNamespace xmlNamespace, Node node) {
            this.namespace = xmlNamespace;
            this.ownerNode = node;
        }

        public Boolean isOwner(Node node) {
            return this.ownerNode.isSameNode(node);
        }

        public void replaceOwner(Node node) {
            this.ownerNode = node;
        }
    }
}

