"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var re_reselect_1 = __importDefault(require("re-reselect"));
var compute_chart_dimensions_1 = require("../../chart_types/xy_chart/state/selectors/compute_chart_dimensions");
var get_computed_scales_1 = require("../../chart_types/xy_chart/state/selectors/get_computed_scales");
var specs_1 = require("../../specs");
var get_chart_id_1 = require("./get_chart_id");
var get_settings_specs_1 = require("./get_settings_specs");
var has_external_pointer_event_1 = require("./has_external_pointer_event");
var getExternalEventPointer = function (_a) {
    var pointer = _a.externalEvents.pointer;
    return pointer;
};
exports.isExternalTooltipVisibleSelector = re_reselect_1.default([
    get_settings_specs_1.getSettingsSpecSelector,
    has_external_pointer_event_1.hasExternalEventSelector,
    getExternalEventPointer,
    get_computed_scales_1.getComputedScalesSelector,
    compute_chart_dimensions_1.computeChartDimensionsSelector,
], function (_a, hasExternalEvent, pointer, _b, _c) {
    var externalPointerEvents = _a.externalPointerEvents;
    var xScale = _b.xScale;
    var chartDimensions = _c.chartDimensions;
    var _d, _e;
    if (!pointer || pointer.type !== specs_1.PointerEventType.Over || ((_d = externalPointerEvents.tooltip) === null || _d === void 0 ? void 0 : _d.visible) === false) {
        return false;
    }
    var x = xScale.pureScale(pointer.value);
    if (x == null || x > chartDimensions.width + chartDimensions.left || x < 0) {
        return false;
    }
    return hasExternalEvent && ((_e = externalPointerEvents.tooltip) === null || _e === void 0 ? void 0 : _e.visible) === true;
})(get_chart_id_1.getChartIdSelector);
//# sourceMappingURL=is_external_tooltip_visible.js.map