/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.targets.indy;

import com.headius.invokebinder.Binder;
import com.headius.invokebinder.Signature;
import com.headius.invokebinder.SmartBinder;
import com.headius.invokebinder.SmartHandle;
import java.lang.invoke.CallSite;
import java.lang.invoke.ConstantCallSite;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.MutableCallSite;
import java.lang.invoke.SwitchPoint;
import java.lang.invoke.TypeDescriptor;
import java.math.BigInteger;
import org.jcodings.Encoding;
import org.jcodings.EncodingDB;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBasicObject;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyEncoding;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyGlobal;
import org.jruby.RubyHash;
import org.jruby.RubyModule;
import org.jruby.RubyNil;
import org.jruby.RubyString;
import org.jruby.anno.JRubyMethod;
import org.jruby.internal.runtime.GlobalVariable;
import org.jruby.internal.runtime.methods.AttrReaderMethod;
import org.jruby.internal.runtime.methods.AttrWriterMethod;
import org.jruby.internal.runtime.methods.CompiledIRMethod;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.internal.runtime.methods.HandleMethod;
import org.jruby.internal.runtime.methods.MixedModeIRMethod;
import org.jruby.internal.runtime.methods.NativeCallMethod;
import org.jruby.ir.JIT;
import org.jruby.ir.runtime.IRRuntimeHelpers;
import org.jruby.ir.targets.indy.InvokeSite;
import org.jruby.ir.targets.indy.SuperInvokeSite;
import org.jruby.java.invokers.SingletonMethodInvoker;
import org.jruby.javasupport.JavaUtil;
import org.jruby.javasupport.proxy.ReifiedJavaProxy;
import org.jruby.org.objectweb.asm.Handle;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.Binding;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallType;
import org.jruby.runtime.CompiledIRBlockBody;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.Frame;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.callsite.CacheEntry;
import org.jruby.runtime.callsite.CachingCallSite;
import org.jruby.runtime.callsite.FunctionalCachingCallSite;
import org.jruby.runtime.callsite.MonomorphicCallSite;
import org.jruby.runtime.callsite.VariableCachingCallSite;
import org.jruby.runtime.invokedynamic.GlobalSite;
import org.jruby.runtime.invokedynamic.InvocationLinker;
import org.jruby.runtime.invokedynamic.InvokeDynamicSupport;
import org.jruby.runtime.invokedynamic.MathLinker;
import org.jruby.runtime.ivars.FieldVariableAccessor;
import org.jruby.runtime.ivars.VariableAccessor;
import org.jruby.runtime.opto.Invalidator;
import org.jruby.runtime.opto.OptoFactory;
import org.jruby.util.ByteList;
import org.jruby.util.CodegenUtils;
import org.jruby.util.JavaNameMangler;
import org.jruby.util.cli.Options;
import org.jruby.util.log.Logger;
import org.jruby.util.log.LoggerFactory;

public class Bootstrap {
    public static final String BOOTSTRAP_BARE_SIG = CodegenUtils.sig(CallSite.class, MethodHandles.Lookup.class, String.class, MethodType.class);
    public static final String BOOTSTRAP_LONG_STRING_INT_SIG = CodegenUtils.sig(CallSite.class, MethodHandles.Lookup.class, String.class, MethodType.class, Long.TYPE, Integer.TYPE, String.class, Integer.TYPE);
    public static final String BOOTSTRAP_DOUBLE_STRING_INT_SIG = CodegenUtils.sig(CallSite.class, MethodHandles.Lookup.class, String.class, MethodType.class, Double.TYPE, Integer.TYPE, String.class, Integer.TYPE);
    private static final Logger LOG = LoggerFactory.getLogger(Bootstrap.class);
    static final MethodHandles.Lookup LOOKUP = MethodHandles.lookup();
    public static final Handle EMPTY_STRING_BOOTSTRAP = new Handle(6, CodegenUtils.p(Bootstrap.class), "emptyString", CodegenUtils.sig(CallSite.class, MethodHandles.Lookup.class, String.class, MethodType.class, String.class), false);
    private static final String[] GENERIC_CALL_PERMUTE = new String[]{"context", "self", "arg.*"};
    private static final MethodHandle STRING_HANDLE = Binder.from(RubyString.class, ThreadContext.class, ByteList.class, Integer.TYPE).invokeStaticQuiet(LOOKUP, Bootstrap.class, "string");
    private static final MethodHandle FSTRING_HANDLE = Binder.from(RubyString.class, ThreadContext.class, MutableCallSite.class, ByteList.class, Integer.TYPE, String.class, Integer.TYPE).invokeStaticQuiet(LOOKUP, Bootstrap.class, "frozenString");
    public static final Handle CALLSITE = new Handle(6, CodegenUtils.p(Bootstrap.class), "callSite", CodegenUtils.sig(CallSite.class, MethodHandles.Lookup.class, String.class, MethodType.class, String.class, Integer.TYPE), false);
    public static final Handle OPEN_META_CLASS = new Handle(6, CodegenUtils.p(Bootstrap.class), "openMetaClass", CodegenUtils.sig(CallSite.class, MethodHandles.Lookup.class, String.class, MethodType.class, MethodHandle.class, MethodHandle.class, MethodHandle.class, Integer.TYPE, Integer.TYPE, Integer.TYPE), false);
    private static final MethodHandle OPEN_META_CLASS_HANDLE = Binder.from(DynamicMethod.class, ThreadContext.class, IRubyObject.class, String.class, StaticScope.class, MethodHandle.class, StaticScope.class, MethodHandle.class, Integer.TYPE, Boolean.TYPE, Boolean.TYPE).invokeStaticQuiet(LOOKUP, Bootstrap.class, "openMetaClass");
    public static final Handle CHECK_ARITY = new Handle(6, CodegenUtils.p(Bootstrap.class), "checkArity", CodegenUtils.sig(CallSite.class, MethodHandles.Lookup.class, String.class, MethodType.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE), false);
    private static final MethodHandle CHECK_ARITY_HANDLE = Binder.from(Void.TYPE, ThreadContext.class, StaticScope.class, Object[].class, Block.class, Integer.TYPE, Integer.TYPE, Boolean.TYPE, Boolean.TYPE, Integer.TYPE).invokeStaticQuiet(LOOKUP, Bootstrap.class, "checkArity");
    private static final MethodHandle ARRAY_HANDLE = Binder.from(RubyArray.class, ThreadContext.class, IRubyObject[].class).invokeStaticQuiet(LOOKUP, Bootstrap.class, "array");
    private static final MethodHandle HASH_HANDLE = Binder.from(RubyHash.class, ThreadContext.class, IRubyObject[].class).invokeStaticQuiet(LOOKUP, Bootstrap.class, "hash");
    private static final MethodHandle KWARGS_HASH_HANDLE = Binder.from(RubyHash.class, ThreadContext.class, RubyHash.class, IRubyObject[].class).invokeStaticQuiet(LOOKUP, Bootstrap.class, "kwargsHash");
    private static final MethodHandle RUNTIME_HANDLE = Binder.from(Ruby.class, ThreadContext.class, MutableCallSite.class).invokeStaticQuiet(LOOKUP, Bootstrap.class, "runtime");
    private static final MethodHandle NIL_HANDLE = Binder.from(IRubyObject.class, ThreadContext.class, MutableCallSite.class).invokeStaticQuiet(LOOKUP, Bootstrap.class, "nil");
    private static final MethodHandle TRUE_HANDLE = Binder.from(IRubyObject.class, ThreadContext.class, MutableCallSite.class).invokeStaticQuiet(LOOKUP, Bootstrap.class, "True");
    private static final MethodHandle FALSE_HANDLE = Binder.from(IRubyObject.class, ThreadContext.class, MutableCallSite.class).invokeStaticQuiet(LOOKUP, Bootstrap.class, "False");
    private static final MethodHandle ENCODING_HANDLE = Binder.from(RubyEncoding.class, ThreadContext.class, MutableCallSite.class, String.class).invokeStaticQuiet(LOOKUP, Bootstrap.class, "encoding");
    private static final MethodHandle IS_JAVA_SUBCLASS = InvokeDynamicSupport.findStatic(Bootstrap.class, "subclassProxyTest", MethodType.methodType(Boolean.TYPE, Object.class));
    private static final Binder BINDING_MAKER_BINDER = Binder.from(Binding.class, ThreadContext.class, IRubyObject.class, DynamicScope.class);
    private static final MethodHandle FRAME_SCOPE_BINDING = BINDING_MAKER_BINDER.invokeStaticQuiet(LOOKUP, IRRuntimeHelpers.class, "newFrameScopeBinding");
    private static final MethodHandle FRAME_BINDING = BINDING_MAKER_BINDER.invokeStaticQuiet(LOOKUP, Bootstrap.class, "frameBinding");
    private static final MethodHandle SCOPE_BINDING = BINDING_MAKER_BINDER.invokeStaticQuiet(LOOKUP, Bootstrap.class, "scopeBinding");
    private static final MethodHandle SELF_BINDING = BINDING_MAKER_BINDER.invokeStaticQuiet(LOOKUP, Bootstrap.class, "selfBinding");
    private static final MethodHandle CONSTRUCT_BLOCK = Binder.from(Block.class, Binding.class, CompiledIRBlockBody.class).invokeStaticQuiet(LOOKUP, Bootstrap.class, "constructBlock");

    public static CallSite string(MethodHandles.Lookup lookup, String name2, MethodType type2, String value2, String encodingName, int cr) {
        return new ConstantCallSite(MethodHandles.insertArguments(STRING_HANDLE, 1, Bootstrap.bytelist(value2, encodingName), cr));
    }

    public static CallSite fstring(MethodHandles.Lookup lookup, String name2, MethodType type2, String value2, String encodingName, int cr, String file2, int line) {
        MutableCallSite site = new MutableCallSite(type2);
        site.setTarget(MethodHandles.insertArguments(FSTRING_HANDLE, 1, site, Bootstrap.bytelist(value2, encodingName), cr, file2, line));
        return site;
    }

    public static CallSite emptyString(MethodHandles.Lookup lookup, String name2, MethodType type2, String encodingName) {
        RubyString.EmptyByteListHolder holder = RubyString.getEmptyByteList(Bootstrap.encodingFromName(encodingName));
        return new ConstantCallSite(MethodHandles.insertArguments(STRING_HANDLE, 1, holder.bytes, holder.cr));
    }

    public static Handle isNilBoot() {
        return new Handle(6, CodegenUtils.p(Bootstrap.class), "isNil", CodegenUtils.sig(CallSite.class, MethodHandles.Lookup.class, String.class, MethodType.class), false);
    }

    public static CallSite isNil(MethodHandles.Lookup lookup, String name2, MethodType type2) {
        return new IsNilSite();
    }

    public static Handle isTrueBoot() {
        return new Handle(6, CodegenUtils.p(Bootstrap.class), "isTrue", CodegenUtils.sig(CallSite.class, MethodHandles.Lookup.class, String.class, MethodType.class), false);
    }

    public static CallSite isTrue(MethodHandles.Lookup lookup, String name2, MethodType type2) {
        return new IsTrueSite();
    }

    public static CallSite bytelist(MethodHandles.Lookup lookup, String name2, MethodType type2, String value2, String encodingName) {
        return new ConstantCallSite(MethodHandles.constant(ByteList.class, Bootstrap.bytelist(value2, encodingName)));
    }

    public static ByteList bytelist(String value2, String encodingName) {
        Encoding encoding2 = Bootstrap.encodingFromName(encodingName);
        if (value2.length() == 0) {
            return RubyString.getEmptyByteList((Encoding)encoding2).bytes;
        }
        return new ByteList(RubyEncoding.encodeISO(value2), encoding2, false);
    }

    private static Encoding encodingFromName(String encodingName) {
        EncodingDB.Entry entry = EncodingDB.getEncodings().get(encodingName.getBytes());
        if (entry == null) {
            entry = EncodingDB.getAliases().get(encodingName.getBytes());
        }
        if (entry == null) {
            throw new RuntimeException("could not find encoding: " + encodingName);
        }
        Encoding encoding2 = entry.getEncoding();
        return encoding2;
    }

    public static CallSite callSite(MethodHandles.Lookup lookup, String name2, MethodType type2, String id2, int callType) {
        return new ConstantCallSite(MethodHandles.constant(CachingCallSite.class, Bootstrap.callSite(id2, callType)));
    }

    private static CachingCallSite callSite(String id2, int callType) {
        switch (CallType.fromOrdinal(callType)) {
            case NORMAL: {
                return new MonomorphicCallSite(id2);
            }
            case FUNCTIONAL: {
                return new FunctionalCachingCallSite(id2);
            }
            case VARIABLE: {
                return new VariableCachingCallSite(id2);
            }
        }
        throw new RuntimeException("BUG: Unexpected call type " + callType + " in JVM6 invoke logic");
    }

    @JIT
    public static CallSite openMetaClass(MethodHandles.Lookup lookup, String name2, MethodType type2, MethodHandle body, MethodHandle scope, MethodHandle setScope, int line, int dynscopeEliminated, int refinements) {
        try {
            StaticScope staticScope = scope.invokeExact();
            return new ConstantCallSite(MethodHandles.insertArguments(OPEN_META_CLASS_HANDLE, 4, body, staticScope, setScope, line, dynscopeEliminated == 1, refinements == 1));
        }
        catch (Throwable t) {
            Helpers.throwException(t);
            return null;
        }
    }

    @JIT
    public static DynamicMethod openMetaClass(ThreadContext context, IRubyObject object, String descriptor, StaticScope parent, MethodHandle body, StaticScope scope, MethodHandle setScope, int line, boolean dynscopeEliminated, boolean refinements) throws Throwable {
        if (scope == null) {
            scope = Helpers.restoreScope(descriptor, parent);
            setScope.invokeExact(scope);
        }
        return IRRuntimeHelpers.newCompiledMetaClass(context, body, scope, object, line, dynscopeEliminated, refinements);
    }

    @JIT
    public static CallSite checkArity(MethodHandles.Lookup lookup, String name2, MethodType type2, int req, int opt, int rest2, int key2, int keyrest) {
        return new ConstantCallSite(MethodHandles.insertArguments(CHECK_ARITY_HANDLE, 4, req, opt, rest2 != 0, key2 != 0, keyrest));
    }

    @JIT
    public static void checkArity(ThreadContext context, StaticScope scope, Object[] args2, Block block, int req, int opt, boolean rest2, boolean key2, int keyrest) {
        IRRuntimeHelpers.checkArity(context, scope, args2, req, opt, rest2, key2, keyrest, block);
    }

    public static CallSite array(MethodHandles.Lookup lookup, String name2, MethodType type2) {
        MethodHandle handle = Binder.from(type2).collect(1, IRubyObject[].class).invoke(ARRAY_HANDLE);
        return new ConstantCallSite(handle);
    }

    public static CallSite hash(MethodHandles.Lookup lookup, String name2, MethodType type2) {
        MethodHandle handle = Binder.from(lookup, type2).collect(1, IRubyObject[].class).invoke(HASH_HANDLE);
        return new ConstantCallSite(handle);
    }

    public static CallSite kwargsHash(MethodHandles.Lookup lookup, String name2, MethodType type2) {
        MethodHandle handle = Binder.from(lookup, type2).collect(2, IRubyObject[].class).invoke(KWARGS_HASH_HANDLE);
        return new ConstantCallSite(handle);
    }

    public static Handle string() {
        return new Handle(6, CodegenUtils.p(Bootstrap.class), "string", CodegenUtils.sig(CallSite.class, MethodHandles.Lookup.class, String.class, MethodType.class, String.class, String.class, Integer.TYPE), false);
    }

    public static Handle fstring() {
        return new Handle(6, CodegenUtils.p(Bootstrap.class), "fstring", CodegenUtils.sig(CallSite.class, MethodHandles.Lookup.class, String.class, MethodType.class, String.class, String.class, Integer.TYPE, String.class, Integer.TYPE), false);
    }

    public static Handle bytelist() {
        return new Handle(6, CodegenUtils.p(Bootstrap.class), "bytelist", CodegenUtils.sig(CallSite.class, MethodHandles.Lookup.class, String.class, MethodType.class, String.class, String.class), false);
    }

    public static Handle array() {
        return new Handle(6, CodegenUtils.p(Bootstrap.class), "array", CodegenUtils.sig(CallSite.class, MethodHandles.Lookup.class, String.class, MethodType.class), false);
    }

    public static Handle hash() {
        return new Handle(6, CodegenUtils.p(Bootstrap.class), "hash", CodegenUtils.sig(CallSite.class, MethodHandles.Lookup.class, String.class, MethodType.class), false);
    }

    public static Handle kwargsHash() {
        return new Handle(6, CodegenUtils.p(Bootstrap.class), "kwargsHash", CodegenUtils.sig(CallSite.class, MethodHandles.Lookup.class, String.class, MethodType.class), false);
    }

    public static Handle invokeSuper() {
        return SuperInvokeSite.BOOTSTRAP;
    }

    public static Handle global() {
        return new Handle(6, CodegenUtils.p(Bootstrap.class), "globalBootstrap", CodegenUtils.sig(CallSite.class, MethodHandles.Lookup.class, String.class, MethodType.class, String.class, Integer.TYPE), false);
    }

    public static RubyString string(ThreadContext context, ByteList value2, int cr) {
        return RubyString.newStringShared(context.runtime, value2, cr);
    }

    public static RubyString frozenString(ThreadContext context, MutableCallSite site, ByteList value2, int cr, String file2, int line) {
        RubyString frozen = IRRuntimeHelpers.newFrozenString(context, value2, cr, file2, line);
        site.setTarget(MethodHandles.dropArguments(MethodHandles.constant(RubyString.class, frozen), 0, new Class[]{ThreadContext.class}));
        return frozen;
    }

    public static RubyArray array(ThreadContext context, IRubyObject[] ary) {
        assert (ary.length > 2);
        return RubyArray.newArrayNoCopy(context.runtime, ary);
    }

    public static Handle contextValue() {
        return new Handle(6, CodegenUtils.p(Bootstrap.class), "contextValue", CodegenUtils.sig(CallSite.class, MethodHandles.Lookup.class, String.class, MethodType.class), false);
    }

    public static Handle contextValueString() {
        return new Handle(6, CodegenUtils.p(Bootstrap.class), "contextValueString", CodegenUtils.sig(CallSite.class, MethodHandles.Lookup.class, String.class, MethodType.class, String.class), false);
    }

    public static CallSite contextValue(MethodHandles.Lookup lookup, String name2, MethodType type2) {
        MethodHandle dmh;
        MutableCallSite site = new MutableCallSite(type2);
        switch (name2) {
            case "runtime": {
                dmh = RUNTIME_HANDLE;
                break;
            }
            case "nil": {
                dmh = NIL_HANDLE;
                break;
            }
            case "True": {
                dmh = TRUE_HANDLE;
                break;
            }
            case "False": {
                dmh = FALSE_HANDLE;
                break;
            }
            case "encoding": {
                dmh = ENCODING_HANDLE;
                break;
            }
            default: {
                throw new RuntimeException("BUG: invalid context value " + name2);
            }
        }
        site.setTarget(Binder.from(type2).append(site).invoke(dmh));
        return site;
    }

    public static CallSite contextValueString(MethodHandles.Lookup lookup, String name2, MethodType type2, String str) {
        MethodHandle dmh;
        MutableCallSite site = new MutableCallSite(type2);
        switch (name2) {
            case "encoding": {
                dmh = ENCODING_HANDLE;
                break;
            }
            default: {
                throw new RuntimeException("BUG: invalid context value " + name2);
            }
        }
        site.setTarget(Binder.from(type2).append(site, str).invoke(dmh));
        return site;
    }

    public static IRubyObject nil(ThreadContext context, MutableCallSite site) {
        RubyNil nil = (RubyNil)context.nil;
        MethodHandle constant = (MethodHandle)nil.constant();
        if (constant == null) {
            constant = (MethodHandle)OptoFactory.newConstantWrapper(IRubyObject.class, context.nil);
        }
        site.setTarget(constant);
        return nil;
    }

    public static IRubyObject True(ThreadContext context, MutableCallSite site) {
        MethodHandle constant = (MethodHandle)context.tru.constant();
        if (constant == null) {
            constant = (MethodHandle)OptoFactory.newConstantWrapper(IRubyObject.class, context.tru);
        }
        site.setTarget(constant);
        return context.tru;
    }

    public static IRubyObject False(ThreadContext context, MutableCallSite site) {
        MethodHandle constant = (MethodHandle)context.fals.constant();
        if (constant == null) {
            constant = (MethodHandle)OptoFactory.newConstantWrapper(IRubyObject.class, context.fals);
        }
        site.setTarget(constant);
        return context.fals;
    }

    public static Ruby runtime(ThreadContext context, MutableCallSite site) {
        MethodHandle constant = (MethodHandle)context.runtime.constant();
        if (constant == null) {
            constant = (MethodHandle)OptoFactory.newConstantWrapper(Ruby.class, context.runtime);
        }
        site.setTarget(constant);
        return context.runtime;
    }

    public static RubyEncoding encoding(ThreadContext context, MutableCallSite site, String name2) {
        RubyEncoding rubyEncoding = IRRuntimeHelpers.retrieveEncoding(context, name2);
        MethodHandle constant = (MethodHandle)rubyEncoding.constant();
        if (constant == null) {
            constant = (MethodHandle)OptoFactory.newConstantWrapper(RubyEncoding.class, rubyEncoding);
        }
        site.setTarget(constant);
        return rubyEncoding;
    }

    public static RubyHash hash(ThreadContext context, IRubyObject[] pairs) {
        Ruby runtime2 = context.runtime;
        RubyHash hash2 = new RubyHash(runtime2, pairs.length / 2 + 1);
        int i2 = 0;
        while (i2 < pairs.length) {
            hash2.fastASetCheckString(runtime2, pairs[i2++], pairs[i2++]);
        }
        return hash2;
    }

    public static RubyHash kwargsHash(ThreadContext context, RubyHash hash2, IRubyObject[] pairs) {
        return IRRuntimeHelpers.dupKwargsHashAndPopulateFromArray(context, hash2, pairs);
    }

    static MethodHandle buildIndyHandle(InvokeSite site, CacheEntry entry) {
        MethodHandle mh = null;
        Signature siteToDyncall = site.signature.insertArgs(3, Helpers.arrayOf("class", "name"), Helpers.arrayOf(RubyModule.class, String.class));
        DynamicMethod method2 = entry.method;
        if (method2 instanceof HandleMethod) {
            boolean blockGiven;
            HandleMethod handleMethod = (HandleMethod)method2;
            boolean bl = blockGiven = site.signature.lastArgType() == Block.class;
            if (site.arity >= 0) {
                mh = handleMethod.getHandle(site.arity);
                if (mh != null) {
                    if (!blockGiven) {
                        mh = MethodHandles.insertArguments(mh, mh.type().parameterCount() - 1, Block.NULL_BLOCK);
                    }
                    mh = MethodHandles.dropArguments(mh, 1, new Class[]{IRubyObject.class});
                } else {
                    mh = handleMethod.getHandle(-1);
                    mh = MethodHandles.dropArguments(mh, 1, new Class[]{IRubyObject.class});
                    if (site.arity == 0) {
                        mh = !blockGiven ? MethodHandles.insertArguments(mh, mh.type().parameterCount() - 2, IRubyObject.NULL_ARRAY, Block.NULL_BLOCK) : MethodHandles.insertArguments(mh, mh.type().parameterCount() - 2, new Object[]{IRubyObject.NULL_ARRAY});
                    } else {
                        if (!blockGiven) {
                            mh = MethodHandles.insertArguments(mh, mh.type().parameterCount() - 1, Block.NULL_BLOCK);
                        }
                        mh = SmartBinder.from(MethodHandles.lookup(), siteToDyncall).collect("args", "arg.*", Helpers.constructObjectArrayHandle(site.arity)).invoke(mh).handle();
                    }
                }
            } else {
                mh = handleMethod.getHandle(-1);
                if (mh != null) {
                    mh = MethodHandles.dropArguments(mh, 1, new Class[]{IRubyObject.class});
                    if (!blockGiven) {
                        mh = MethodHandles.insertArguments(mh, mh.type().parameterCount() - 1, Block.NULL_BLOCK);
                    }
                    mh = SmartBinder.from(MethodHandles.lookup(), siteToDyncall).invoke(mh).handle();
                }
            }
            if (mh != null) {
                mh = MethodHandles.insertArguments(mh, 3, entry.sourceModule, site.name());
                if (Options.INVOKEDYNAMIC_LOG_BINDING.load().booleanValue()) {
                    LOG.info(site.name() + "\tbound directly to handle " + Bootstrap.logMethod(method2), new Object[0]);
                }
            }
        }
        return mh;
    }

    static MethodHandle buildGenericHandle(InvokeSite site, CacheEntry entry) {
        DynamicMethod method2 = entry.method;
        SmartBinder binder = SmartBinder.from(site.signature);
        binder = Bootstrap.permuteForGenericCall(binder, method2, GENERIC_CALL_PERMUTE);
        binder = binder.insert(2, new String[]{"rubyClass", "name"}, new Class[]{RubyModule.class, String.class}, entry.sourceModule, site.name()).insert(0, "method", DynamicMethod.class, (Object)method2);
        if (site.arity > 3) {
            binder = binder.collect("args", "arg.*", Helpers.constructObjectArrayHandle(site.arity));
        }
        if (Options.INVOKEDYNAMIC_LOG_BINDING.load().booleanValue()) {
            LOG.info(site.name() + "\tbound indirectly " + method2 + ", " + Bootstrap.logMethod(method2), new Object[0]);
        }
        return binder.invokeVirtualQuiet(LOOKUP, "call").handle();
    }

    private static SmartBinder permuteForGenericCall(SmartBinder binder, DynamicMethod method2, String ... basePermutes) {
        binder = Bootstrap.methodWantsBlock(method2) ? binder.permute(Helpers.arrayOf(basePermutes, "block", String[]::new)) : binder.permute(basePermutes);
        return binder;
    }

    private static boolean methodWantsBlock(DynamicMethod method2) {
        Class[] nativeSignature;
        DynamicMethod.NativeCall nativeCall;
        boolean wantsBlock = true;
        if (method2 instanceof NativeCallMethod && (nativeCall = ((NativeCallMethod)((Object)method2)).getNativeCall()) != null && !nativeCall.isJava() && ((nativeSignature = nativeCall.getNativeSignature()).length == 0 || nativeSignature[nativeSignature.length - 1] != Block.class)) {
            wantsBlock = false;
        }
        return wantsBlock;
    }

    static MethodHandle buildMethodMissingHandle(InvokeSite site, CacheEntry entry, IRubyObject self2) {
        SmartBinder binder;
        DynamicMethod method2 = entry.method;
        if (site.arity >= 0) {
            binder = SmartBinder.from(site.signature);
            binder = Bootstrap.permuteForGenericCall(binder, method2, GENERIC_CALL_PERMUTE).insert(2, new String[]{"rubyClass", "name", "argName"}, new Class[]{RubyModule.class, String.class, IRubyObject.class}, entry.sourceModule, site.name(), self2.getRuntime().newSymbol(site.methodName)).insert(0, "method", DynamicMethod.class, (Object)method2).collect("args", "arg.*", Helpers.constructObjectArrayHandle(site.arity + 1));
        } else {
            SmartHandle fold = SmartBinder.from(site.signature.permute("context", "self", "args", "block").changeReturn(IRubyObject[].class)).permute("args").insert(0, "argName", IRubyObject.class, (Object)self2.getRuntime().newSymbol(site.methodName)).invokeStaticQuiet(LOOKUP, Helpers.class, "arrayOf");
            binder = SmartBinder.from(site.signature);
            binder = Bootstrap.permuteForGenericCall(binder, method2, "context", "self", "args").fold("args2", fold);
            binder = Bootstrap.permuteForGenericCall(binder, method2, "context", "self", "args2").insert(2, new String[]{"rubyClass", "name"}, new Class[]{RubyModule.class, String.class}, entry.sourceModule, site.name()).insert(0, "method", DynamicMethod.class, (Object)method2);
        }
        if (Options.INVOKEDYNAMIC_LOG_BINDING.load().booleanValue()) {
            LOG.info(site.name() + "\tbound to method_missing for " + method2 + ", " + Bootstrap.logMethod(method2), new Object[0]);
        }
        return binder.invokeVirtualQuiet(LOOKUP, "call").handle();
    }

    static MethodHandle buildAttrHandle(InvokeSite site, CacheEntry entry, IRubyObject self2) {
        DynamicMethod method2 = entry.method;
        if (method2 instanceof AttrReaderMethod && site.arity == 0) {
            AttrReaderMethod attrReader = (AttrReaderMethod)method2;
            String varName = attrReader.getVariableName();
            VariableAccessor accessor = self2.getType().getVariableAccessorForWrite(varName);
            if (Options.INVOKEDYNAMIC_LOG_BINDING.load().booleanValue()) {
                if (accessor instanceof FieldVariableAccessor) {
                    LOG.info(site.name() + "\tbound as field attr reader " + Bootstrap.logMethod(method2) + ":" + ((AttrReaderMethod)method2).getVariableName(), new Object[0]);
                } else {
                    LOG.info(site.name() + "\tbound as attr reader " + Bootstrap.logMethod(method2) + ":" + ((AttrReaderMethod)method2).getVariableName(), new Object[0]);
                }
            }
            return Bootstrap.createAttrReaderHandle(site, self2, self2.getType(), accessor);
        }
        if (method2 instanceof AttrWriterMethod && site.arity == 1) {
            AttrWriterMethod attrReader = (AttrWriterMethod)method2;
            String varName = attrReader.getVariableName();
            VariableAccessor accessor = self2.getType().getVariableAccessorForWrite(varName);
            if (Options.INVOKEDYNAMIC_LOG_BINDING.load().booleanValue()) {
                if (accessor instanceof FieldVariableAccessor) {
                    LOG.info(site.name() + "\tbound as field attr writer " + Bootstrap.logMethod(method2) + ":" + ((AttrWriterMethod)method2).getVariableName(), new Object[0]);
                } else {
                    LOG.info(site.name() + "\tbound as attr writer " + Bootstrap.logMethod(method2) + ":" + ((AttrWriterMethod)method2).getVariableName(), new Object[0]);
                }
            }
            return Bootstrap.createAttrWriterHandle(site, self2, self2.getType(), accessor);
        }
        return null;
    }

    private static MethodHandle createAttrReaderHandle(InvokeSite site, IRubyObject self2, RubyClass cls, VariableAccessor accessor) {
        MethodHandle getValue2;
        MethodHandle filter = cls.getClassRuntime().getNullToNilHandle();
        if (accessor instanceof FieldVariableAccessor) {
            MethodHandle getter = ((FieldVariableAccessor)accessor).getGetter();
            getValue2 = Binder.from(site.type()).drop(0, 2).filterReturn(filter).cast(MethodType.methodType(Object.class, self2.getClass())).invoke(getter);
        } else {
            getValue2 = Binder.from(site.type()).drop(0, 2).filterReturn(filter).cast(MethodType.methodType(Object.class, Object.class)).prepend(accessor).invokeVirtualQuiet(LOOKUP, "get");
        }
        return getValue2;
    }

    public static IRubyObject valueOrNil(IRubyObject value2, IRubyObject nil) {
        return value2 == null ? nil : value2;
    }

    private static MethodHandle createAttrWriterHandle(InvokeSite site, IRubyObject self2, RubyClass cls, VariableAccessor accessor) {
        MethodHandle setValue2;
        MethodHandle filter = Binder.from(IRubyObject.class, Object.class, new Class[0]).drop(0).constant(cls.getRuntime().getNil());
        if (accessor instanceof FieldVariableAccessor) {
            MethodHandle setter = ((FieldVariableAccessor)accessor).getSetter();
            setValue2 = Binder.from(site.type()).drop(0, 2).filterReturn(filter).cast(MethodType.methodType(Void.TYPE, self2.getClass(), Object.class)).invoke(setter);
        } else {
            setValue2 = Binder.from(site.type()).drop(0, 2).filterReturn(filter).cast(MethodType.methodType(Void.TYPE, Object.class, Object.class)).prepend(accessor).invokeVirtualQuiet(LOOKUP, "set");
        }
        return setValue2;
    }

    static MethodHandle buildJittedHandle(InvokeSite site, CacheEntry entry, boolean blockGiven) {
        MethodHandle mh = null;
        CompiledIRMethod compiledIRMethod = null;
        DynamicMethod method2 = entry.method;
        RubyModule sourceModule = entry.sourceModule;
        if (method2 instanceof CompiledIRMethod) {
            compiledIRMethod = (CompiledIRMethod)method2;
        } else if (method2 instanceof MixedModeIRMethod) {
            DynamicMethod actualMethod = ((MixedModeIRMethod)method2).getActualMethod();
            if (actualMethod instanceof CompiledIRMethod) {
                compiledIRMethod = (CompiledIRMethod)actualMethod;
            } else if (Options.INVOKEDYNAMIC_LOG_BINDING.load().booleanValue()) {
                LOG.info(site.name() + "\tfailed direct binding due to unjitted method " + Bootstrap.logMethod(method2), new Object[0]);
            }
        }
        if (compiledIRMethod != null) {
            MethodHandle specific;
            SmartBinder binder = SmartBinder.from(site.signature).permute("context", "self", "arg.*", "block");
            if (site.arity == -1) {
                mh = (MethodHandle)compiledIRMethod.getHandle();
            } else if (site.arity == 0) {
                specific = compiledIRMethod.getHandleFor(site.arity);
                if (specific != null) {
                    mh = specific;
                } else {
                    mh = (MethodHandle)compiledIRMethod.getHandle();
                    binder = binder.insert(2, "args", IRubyObject.NULL_ARRAY);
                }
            } else {
                specific = compiledIRMethod.getHandleFor(site.arity);
                if (specific != null) {
                    mh = specific;
                } else {
                    mh = (MethodHandle)compiledIRMethod.getHandle();
                    binder = binder.collect("args", "arg.*", Helpers.constructObjectArrayHandle(site.arity));
                }
            }
            if (!blockGiven) {
                binder = binder.append("block", Block.class, (Object)Block.NULL_BLOCK);
            }
            binder = binder.insert(1, "scope", StaticScope.class, (Object)compiledIRMethod.getStaticScope()).append("class", RubyModule.class, (Object)sourceModule).append("frameName", String.class, (Object)site.name());
            mh = binder.invoke(mh).handle();
            if (Options.INVOKEDYNAMIC_LOG_BINDING.load().booleanValue()) {
                LOG.info(site.name() + "\tbound directly to jitted method " + Bootstrap.logMethod(method2), new Object[0]);
            }
        }
        return mh;
    }

    static MethodHandle buildNativeHandle(InvokeSite site, CacheEntry entry, boolean blockGiven) {
        MethodHandle mh = null;
        SmartBinder binder = null;
        DynamicMethod method2 = entry.method;
        if (method2 instanceof NativeCallMethod && ((NativeCallMethod)((Object)method2)).getNativeCall() != null) {
            JRubyMethod anno;
            NativeCallMethod nativeMethod = (NativeCallMethod)((Object)method2);
            DynamicMethod.NativeCall nativeCall = nativeMethod.getNativeCall();
            DynamicMethod.NativeCall nc = nativeCall;
            if (nc.isJava()) {
                return Bootstrap.createJavaHandle(site, method2);
            }
            int nativeArgCount = Bootstrap.getNativeArgCount(method2, nativeCall);
            if (nativeArgCount >= 0) {
                if (nativeArgCount == site.arity) {
                    binder = SmartBinder.from(MethodHandles.lookup(), site.signature);
                } else if (Options.INVOKEDYNAMIC_LOG_BINDING.load().booleanValue()) {
                    LOG.info(site.name() + "\tdid not match the primary arity for a native method " + Bootstrap.logMethod(method2), new Object[0]);
                }
            } else {
                binder = site.arity == -1 ? SmartBinder.from(MethodHandles.lookup(), site.signature) : (site.arity == 0 ? SmartBinder.from(MethodHandles.lookup(), site.signature).insert(2, "args", IRubyObject.NULL_ARRAY) : SmartBinder.from(MethodHandles.lookup(), site.signature).collect("args", "arg.*", Helpers.constructObjectArrayHandle(site.arity)));
            }
            if (binder != null) {
                if (!nc.hasContext()) {
                    binder = binder.drop("context");
                }
                if (nc.hasBlock() && !blockGiven) {
                    binder = binder.append("block", Block.NULL_BLOCK);
                } else if (!nc.hasBlock() && blockGiven) {
                    binder = binder.drop("block");
                }
                mh = nc.isStatic() ? binder.permute("context", "self", "arg.*", "block").cast(nc.getNativeReturn(), nc.getNativeSignature()).invokeStaticQuiet(LOOKUP, nc.getNativeTarget(), nc.getNativeName()).handle() : binder.permute("self", "context", "arg.*", "block").castArg("self", nc.getNativeTarget()).castVirtual(nc.getNativeReturn(), nc.getNativeTarget(), nc.getNativeSignature()).invokeVirtualQuiet(LOOKUP, nc.getNativeName()).handle();
                if (Options.INVOKEDYNAMIC_LOG_BINDING.load().booleanValue()) {
                    LOG.info(site.name() + "\tbound directly to JVM method " + Bootstrap.logMethod(method2), new Object[0]);
                }
            }
            if ((anno = nativeCall.getMethod().getAnnotation(JRubyMethod.class)) != null && anno.frame()) {
                mh = InvocationLinker.wrapWithFrameOnly(site.signature, entry.sourceModule, site.name(), mh);
            }
        }
        return mh;
    }

    public static int getNativeArgCount(DynamicMethod method2, DynamicMethod.NativeCall nativeCall) {
        return Bootstrap.getArgCount(nativeCall.getNativeSignature(), nativeCall.isStatic());
    }

    private static int getArgCount(Class[] args2, boolean isStatic) {
        int length2 = args2.length;
        boolean hasContext = false;
        if (isStatic) {
            if (args2.length > 1 && args2[0] == ThreadContext.class) {
                --length2;
                hasContext = true;
            }
            assert (args2.length >= 1);
            --length2;
            if (args2.length > 1 && args2[args2.length - 1] == Block.class) {
                --length2;
            }
            if (length2 == 1) {
                if (hasContext && args2[2] == IRubyObject[].class) {
                    length2 = -1;
                } else if (args2[1] == IRubyObject[].class) {
                    length2 = -1;
                }
            }
        } else {
            if (args2.length > 0 && args2[0] == ThreadContext.class) {
                --length2;
                hasContext = true;
            }
            if (args2.length > 0 && args2[args2.length - 1] == Block.class) {
                --length2;
            }
            if (length2 == 1) {
                if (hasContext && args2[1] == IRubyObject[].class) {
                    length2 = -1;
                } else if (args2[0] == IRubyObject[].class) {
                    length2 = -1;
                }
            }
        }
        return length2;
    }

    public static boolean testType(RubyClass original, IRubyObject self2) {
        return original == RubyBasicObject.getMetaClass(self2);
    }

    private static MethodHandle createJavaHandle(InvokeSite site, DynamicMethod method2) {
        MethodHandle nativeTarget = (MethodHandle)method2.getHandle();
        if (nativeTarget != null) {
            return nativeTarget;
        }
        MethodHandle returnFilter = null;
        Ruby runtime2 = method2.getImplementationClass().getRuntime();
        if (!(method2 instanceof NativeCallMethod)) {
            return null;
        }
        DynamicMethod.NativeCall nativeCall = ((NativeCallMethod)((Object)method2)).getNativeCall();
        if (nativeCall == null) {
            return null;
        }
        boolean isStatic = nativeCall.isStatic();
        if (site.fullSignature.lastArgType() == Block.class) {
            if (Options.INVOKEDYNAMIC_LOG_BINDING.load().booleanValue()) {
                LOG.info(site.name() + "\tpassed a closure to Java method " + nativeCall + ": " + Bootstrap.logMethod(method2), new Object[0]);
            }
            return null;
        }
        if (isStatic ? site.arity != nativeCall.getNativeSignature().length - 1 : site.arity != nativeCall.getNativeSignature().length) {
            return null;
        }
        Class[] signature = nativeCall.getNativeSignature();
        if (signature.length > 0 && signature[signature.length - 1].isArray()) {
            return null;
        }
        if (method2 instanceof SingletonMethodInvoker) {
            return null;
        }
        MethodType apparentType = MethodType.methodType(nativeCall.getNativeReturn(), nativeCall.getNativeSignature());
        nativeTarget = isStatic ? InvokeDynamicSupport.findStatic(nativeCall.getNativeTarget(), nativeCall.getNativeName(), apparentType) : InvokeDynamicSupport.findVirtual(nativeCall.getNativeTarget(), nativeCall.getNativeName(), apparentType);
        MethodType nativeType = nativeTarget.type();
        Class<?>[] nativeParams = nativeType.parameterArray();
        TypeDescriptor.OfField nativeReturn = nativeType.returnType();
        MethodHandle[] argConverters = new MethodHandle[nativeType.parameterCount()];
        for (int i2 = 0; i2 < argConverters.length; ++i2) {
            MethodHandle converter = !isStatic && i2 == 0 ? Binder.from(nativeParams[0], IRubyObject.class, new Class[0]).cast(Object.class, IRubyObject.class).invokeStaticQuiet(MethodHandles.lookup(), JavaUtil.class, "objectFromJavaProxy") : Binder.from(nativeParams[i2], IRubyObject.class, new Class[0]).insert(1, nativeParams[i2]).cast(Object.class, IRubyObject.class, Class.class).invokeVirtualQuiet(MethodHandles.lookup(), "toJava");
            argConverters[i2] = converter;
        }
        nativeTarget = MethodHandles.filterArguments(nativeTarget, 0, argConverters);
        Class[] convertedParams = CodegenUtils.params(IRubyObject.class, nativeTarget.type().parameterCount());
        if (nativeReturn == Byte.TYPE || nativeReturn == Short.TYPE || nativeReturn == Character.TYPE || nativeReturn == Integer.TYPE || nativeReturn == Long.TYPE) {
            nativeTarget = MethodHandles.explicitCastArguments(nativeTarget, MethodType.methodType(Long.TYPE, convertedParams));
            returnFilter = MethodHandles.insertArguments(InvokeDynamicSupport.findStatic(RubyFixnum.class, "newFixnum", MethodType.methodType(RubyFixnum.class, Ruby.class, Long.TYPE)), 0, runtime2);
        } else if (nativeReturn == Byte.class || nativeReturn == Short.class || nativeReturn == Character.class || nativeReturn == Integer.class || nativeReturn == Long.class) {
            returnFilter = MethodHandles.insertArguments(InvokeDynamicSupport.findStatic(Bootstrap.class, "fixnumOrNil", MethodType.methodType(IRubyObject.class, Ruby.class, new Class[]{nativeReturn})), 0, runtime2);
        } else if (nativeReturn == Float.TYPE || nativeReturn == Double.TYPE) {
            nativeTarget = MethodHandles.explicitCastArguments(nativeTarget, MethodType.methodType(Double.TYPE, convertedParams));
            returnFilter = MethodHandles.insertArguments(InvokeDynamicSupport.findStatic(RubyFloat.class, "newFloat", MethodType.methodType(RubyFloat.class, Ruby.class, Double.TYPE)), 0, runtime2);
        } else if (nativeReturn == Float.class || nativeReturn == Double.class) {
            returnFilter = MethodHandles.insertArguments(InvokeDynamicSupport.findStatic(Bootstrap.class, "floatOrNil", MethodType.methodType(IRubyObject.class, Ruby.class, new Class[]{nativeReturn})), 0, runtime2);
        } else if (nativeReturn == Boolean.TYPE) {
            nativeTarget = MethodHandles.explicitCastArguments(nativeTarget, MethodType.methodType(Boolean.TYPE, convertedParams));
            returnFilter = MethodHandles.insertArguments(InvokeDynamicSupport.findStatic(RubyBoolean.class, "newBoolean", MethodType.methodType(RubyBoolean.class, Ruby.class, Boolean.TYPE)), 0, runtime2);
        } else if (nativeReturn == Boolean.class) {
            returnFilter = MethodHandles.insertArguments(InvokeDynamicSupport.findStatic(Bootstrap.class, "booleanOrNil", MethodType.methodType(IRubyObject.class, Ruby.class, Boolean.class)), 0, runtime2);
        } else if (CharSequence.class.isAssignableFrom((Class<?>)nativeReturn)) {
            nativeTarget = MethodHandles.explicitCastArguments(nativeTarget, MethodType.methodType(CharSequence.class, convertedParams));
            returnFilter = MethodHandles.insertArguments(InvokeDynamicSupport.findStatic(Bootstrap.class, "stringOrNil", MethodType.methodType(IRubyObject.class, Ruby.class, CharSequence.class)), 0, runtime2);
        } else if (nativeReturn == Void.TYPE) {
            returnFilter = MethodHandles.constant(IRubyObject.class, runtime2.getNil());
        } else if (nativeReturn != ByteList.class && nativeReturn != BigInteger.class) {
            nativeTarget = MethodHandles.explicitCastArguments(nativeTarget, MethodType.methodType(Object.class, convertedParams));
            returnFilter = MethodHandles.insertArguments(InvokeDynamicSupport.findStatic(JavaUtil.class, "convertJavaToUsableRubyObject", MethodType.methodType(IRubyObject.class, Ruby.class, Object.class)), 0, runtime2);
        }
        if (returnFilter != null) {
            Class<?>[] newNativeParams = nativeTarget.type().parameterArray();
            TypeDescriptor.OfField newNativeReturn = nativeTarget.type().returnType();
            Binder exBinder = Binder.from(newNativeReturn, Throwable.class, newNativeParams).drop(1, newNativeParams.length).insert(0, runtime2);
            if (nativeReturn != Void.TYPE) {
                exBinder = exBinder.filterReturn(Binder.from(newNativeReturn).constant(Bootstrap.nullValue((Class)newNativeReturn)));
            }
            nativeTarget = Binder.from(site.type()).drop(0, isStatic ? 3 : 2).filterReturn(returnFilter).invoke(nativeTarget);
            method2.setHandle(nativeTarget);
            return nativeTarget;
        }
        return null;
    }

    public static boolean subclassProxyTest(Object target) {
        return target instanceof ReifiedJavaProxy;
    }

    private static Object nullValue(Class type2) {
        if (type2 == Boolean.TYPE || type2 == Boolean.class) {
            return false;
        }
        if (type2 == Byte.TYPE || type2 == Byte.class) {
            return (byte)0;
        }
        if (type2 == Short.TYPE || type2 == Short.class) {
            return (short)0;
        }
        if (type2 == Integer.TYPE || type2 == Integer.class) {
            return 0;
        }
        if (type2 == Long.TYPE || type2 == Long.class) {
            return 0L;
        }
        if (type2 == Float.TYPE || type2 == Float.class) {
            return Float.valueOf(0.0f);
        }
        if (type2 == Double.TYPE || type2 == Double.class) {
            return 0.0;
        }
        return null;
    }

    public static IRubyObject fixnumOrNil(Ruby runtime2, Byte b2) {
        return b2 == null ? runtime2.getNil() : RubyFixnum.newFixnum(runtime2, b2.byteValue());
    }

    public static IRubyObject fixnumOrNil(Ruby runtime2, Short s2) {
        return s2 == null ? runtime2.getNil() : RubyFixnum.newFixnum(runtime2, s2.shortValue());
    }

    public static IRubyObject fixnumOrNil(Ruby runtime2, Character c) {
        return c == null ? runtime2.getNil() : RubyFixnum.newFixnum(runtime2, c.charValue());
    }

    public static IRubyObject fixnumOrNil(Ruby runtime2, Integer i2) {
        return i2 == null ? runtime2.getNil() : RubyFixnum.newFixnum(runtime2, i2.intValue());
    }

    public static IRubyObject fixnumOrNil(Ruby runtime2, Long l) {
        return l == null ? runtime2.getNil() : RubyFixnum.newFixnum(runtime2, l);
    }

    public static IRubyObject floatOrNil(Ruby runtime2, Float f) {
        return f == null ? runtime2.getNil() : RubyFloat.newFloat(runtime2, f.floatValue());
    }

    public static IRubyObject floatOrNil(Ruby runtime2, Double d) {
        return d == null ? runtime2.getNil() : RubyFloat.newFloat(runtime2, d);
    }

    public static IRubyObject booleanOrNil(Ruby runtime2, Boolean b2) {
        return b2 == null ? runtime2.getNil() : RubyBoolean.newBoolean(runtime2, (boolean)b2);
    }

    public static IRubyObject stringOrNil(Ruby runtime2, CharSequence cs) {
        return cs == null ? runtime2.getNil() : RubyString.newUnicodeString(runtime2, cs);
    }

    public static boolean testModuleMatch(ThreadContext context, IRubyObject arg0, int id2) {
        return arg0 instanceof RubyModule && ((RubyModule)arg0).id == id2;
    }

    public static Handle getFixnumOperatorHandle() {
        return Bootstrap.getBootstrapHandle("fixnumOperatorBootstrap", MathLinker.class, BOOTSTRAP_LONG_STRING_INT_SIG);
    }

    public static Handle getFloatOperatorHandle() {
        return Bootstrap.getBootstrapHandle("floatOperatorBootstrap", MathLinker.class, BOOTSTRAP_DOUBLE_STRING_INT_SIG);
    }

    public static Handle checkpointHandle() {
        return Bootstrap.getBootstrapHandle("checkpointBootstrap", BOOTSTRAP_BARE_SIG);
    }

    public static Handle coverLineHandle() {
        return Bootstrap.getBootstrapHandle("coverLineBootstrap", CodegenUtils.sig(CallSite.class, MethodHandles.Lookup.class, String.class, MethodType.class, String.class, Integer.TYPE, Integer.TYPE));
    }

    public static Handle getBootstrapHandle(String name2, String sig) {
        return Bootstrap.getBootstrapHandle(name2, Bootstrap.class, sig);
    }

    public static Handle getBootstrapHandle(String name2, Class type2, String sig) {
        return new Handle(6, CodegenUtils.p(type2), name2, sig, false);
    }

    public static CallSite checkpointBootstrap(MethodHandles.Lookup lookup, String name2, MethodType type2) throws Throwable {
        MutableCallSite site = new MutableCallSite(type2);
        MethodHandle handle = lookup.findStatic(Bootstrap.class, "checkpointFallback", MethodType.methodType(Void.TYPE, MutableCallSite.class, ThreadContext.class));
        handle = handle.bindTo(site);
        site.setTarget(handle);
        return site;
    }

    public static void checkpointFallback(MutableCallSite site, ThreadContext context) throws Throwable {
        Ruby runtime2 = context.runtime;
        Invalidator invalidator = runtime2.getCheckpointInvalidator();
        MethodHandle target = Binder.from(Void.TYPE, ThreadContext.class, new Class[0]).nop();
        MethodHandle fallback = MethodHandles.lookup().findStatic(Bootstrap.class, "checkpointFallback", MethodType.methodType(Void.TYPE, MutableCallSite.class, ThreadContext.class));
        fallback = fallback.bindTo(site);
        target = ((SwitchPoint)invalidator.getData()).guardWithTest(target, fallback);
        site.setTarget(target);
    }

    public static CallSite coverLineBootstrap(MethodHandles.Lookup lookup, String name2, MethodType type2, String filename2, int line, int oneshot) throws Throwable {
        MutableCallSite site = new MutableCallSite(type2);
        MethodHandle handle = lookup.findStatic(Bootstrap.class, "coverLineFallback", MethodType.methodType(Void.TYPE, MutableCallSite.class, ThreadContext.class, String.class, Integer.TYPE, Boolean.TYPE));
        handle = handle.bindTo(site);
        handle = MethodHandles.insertArguments(handle, 1, filename2, line, oneshot != 0);
        site.setTarget(handle);
        return site;
    }

    public static void coverLineFallback(MutableCallSite site, ThreadContext context, String filename2, int line, boolean oneshot) throws Throwable {
        IRRuntimeHelpers.updateCoverage(context, filename2, line);
        if (oneshot) {
            site.setTarget(Binder.from(Void.TYPE, ThreadContext.class, new Class[0]).dropAll().nop());
        }
    }

    public static CallSite globalBootstrap(MethodHandles.Lookup lookup, String name2, MethodType type2, String file2, int line) throws Throwable {
        String[] names2 = name2.split(":");
        String operation = names2[0];
        String varName = JavaNameMangler.demangleMethodName(names2[1]);
        GlobalSite site = new GlobalSite(type2, varName, file2, line);
        MethodHandle handle = operation.equals("get") ? lookup.findStatic(Bootstrap.class, "getGlobalFallback", MethodType.methodType(IRubyObject.class, GlobalSite.class, ThreadContext.class)) : lookup.findStatic(Bootstrap.class, "setGlobalFallback", MethodType.methodType(Void.TYPE, GlobalSite.class, IRubyObject.class, ThreadContext.class));
        handle = handle.bindTo(site);
        site.setTarget(handle);
        return site;
    }

    public static IRubyObject getGlobalFallback(GlobalSite site, ThreadContext context) throws Throwable {
        Ruby runtime2 = context.runtime;
        GlobalVariable variable = runtime2.getGlobalVariables().getVariable(site.name());
        if (site.failures() > Options.INVOKEDYNAMIC_GLOBAL_MAXFAIL.load() || variable.getScope() != GlobalVariable.Scope.GLOBAL || RubyGlobal.UNCACHED_GLOBALS.contains(site.name())) {
            if (Options.INVOKEDYNAMIC_LOG_GLOBALS.load().booleanValue()) {
                LOG.info("global " + site.name() + " (" + site.file() + ":" + site.line() + ") uncacheable or rebound > " + Options.INVOKEDYNAMIC_GLOBAL_MAXFAIL.load() + " times, reverting to simple lookup", new Object[0]);
            }
            MethodHandle uncached = MethodHandles.lookup().findStatic(Bootstrap.class, "getGlobalUncached", MethodType.methodType(IRubyObject.class, GlobalVariable.class));
            uncached = uncached.bindTo(variable);
            uncached = MethodHandles.dropArguments(uncached, 0, new Class[]{ThreadContext.class});
            site.setTarget(uncached);
            return (IRubyObject)uncached.invokeWithArguments(context);
        }
        Invalidator invalidator = variable.getInvalidator();
        IRubyObject value2 = variable.getAccessor().getValue();
        MethodHandle target = MethodHandles.constant(IRubyObject.class, value2);
        target = MethodHandles.dropArguments(target, 0, new Class[]{ThreadContext.class});
        MethodHandle fallback = MethodHandles.lookup().findStatic(Bootstrap.class, "getGlobalFallback", MethodType.methodType(IRubyObject.class, GlobalSite.class, ThreadContext.class));
        fallback = fallback.bindTo(site);
        target = ((SwitchPoint)invalidator.getData()).guardWithTest(target, fallback);
        site.setTarget(target);
        return value2;
    }

    public static IRubyObject getGlobalUncached(GlobalVariable variable) throws Throwable {
        return variable.getAccessor().getValue();
    }

    public static void setGlobalFallback(GlobalSite site, IRubyObject value2, ThreadContext context) throws Throwable {
        Ruby runtime2 = context.runtime;
        GlobalVariable variable = runtime2.getGlobalVariables().getVariable(site.name());
        MethodHandle uncached = MethodHandles.lookup().findStatic(Bootstrap.class, "setGlobalUncached", MethodType.methodType(Void.TYPE, GlobalVariable.class, IRubyObject.class));
        uncached = uncached.bindTo(variable);
        uncached = MethodHandles.dropArguments(uncached, 1, new Class[]{ThreadContext.class});
        site.setTarget(uncached);
        uncached.invokeWithArguments(value2, context);
    }

    public static void setGlobalUncached(GlobalVariable variable, IRubyObject value2) throws Throwable {
        variable.getAccessor().setValue(value2);
        variable.trace(value2);
        variable.invalidate();
    }

    public static Handle prepareBlock() {
        return new Handle(6, CodegenUtils.p(Bootstrap.class), "prepareBlock", CodegenUtils.sig(CallSite.class, MethodHandles.Lookup.class, String.class, MethodType.class, MethodHandle.class, MethodHandle.class, MethodHandle.class, MethodHandle.class, String.class, Long.TYPE, String.class, Integer.TYPE, String.class), false);
    }

    public static CallSite prepareBlock(MethodHandles.Lookup lookup, String name2, MethodType type2, MethodHandle bodyHandle, MethodHandle scopeHandle, MethodHandle setScopeHandle, MethodHandle parentHandle, String scopeDescriptor, long encodedSignature, String file2, int line, String encodedArgumentDescriptors) throws Throwable {
        StaticScope staticScope = scopeHandle.invokeExact();
        if (staticScope == null) {
            staticScope = Helpers.restoreScope(scopeDescriptor, parentHandle.invokeExact());
            setScopeHandle.invokeExact(staticScope);
        }
        CompiledIRBlockBody body = new CompiledIRBlockBody(bodyHandle, staticScope, file2, line, encodedArgumentDescriptors, encodedSignature);
        Binder binder = Binder.from(type2);
        binder = binder.fold(FRAME_SCOPE_BINDING);
        MethodHandle blockMaker = binder.drop(1, 3).append(body).invoke(CONSTRUCT_BLOCK);
        return new ConstantCallSite(blockMaker);
    }

    static String logMethod(DynamicMethod method2) {
        return "[#" + method2.getSerialNumber() + " " + method2.getImplementationClass().getMethodLocation() + "]";
    }

    static String logBlock(Block block) {
        return "[" + block.getBody().getFile() + ":" + block.getBody().getLine() + "]";
    }

    public static Binding frameBinding(ThreadContext context, IRubyObject self2, DynamicScope scope) {
        Frame frame = context.getCurrentFrame().capture();
        return new Binding(self2, frame, frame.getVisibility());
    }

    public static Binding scopeBinding(ThreadContext context, IRubyObject self2, DynamicScope scope) {
        return new Binding(self2, scope);
    }

    public static Binding selfBinding(ThreadContext context, IRubyObject self2, DynamicScope scope) {
        return new Binding(self2);
    }

    public static Block constructBlock(Binding binding2, CompiledIRBlockBody body) throws Throwable {
        return new Block(body, binding2);
    }

    public static class IsTrueSite
    extends MutableCallSite {
        public static final MethodType TYPE = MethodType.methodType(Boolean.TYPE, IRubyObject.class);
        public static final MethodHandle INIT_HANDLE = Binder.from(TYPE.insertParameterTypes(0, IsTrueSite.class)).invokeVirtualQuiet(LOOKUP, "init");
        private static final MethodHandle IS_TRUE_HANDLE = Binder.from(Boolean.TYPE, IRubyObject.class, RubyNil.class, RubyBoolean.False.class).invokeStaticQuiet(LOOKUP, IsTrueSite.class, "isTruthy");

        public IsTrueSite() {
            super(TYPE);
            this.setTarget(INIT_HANDLE.bindTo(this));
        }

        public boolean init(IRubyObject obj) {
            Ruby runtime2 = obj.getRuntime();
            IRubyObject nil = runtime2.getNil();
            RubyBoolean fals = runtime2.getFalse();
            this.setTarget(MethodHandles.insertArguments(IS_TRUE_HANDLE, 1, nil, fals));
            return nil != obj && fals != obj;
        }

        public static boolean isTruthy(IRubyObject obj, RubyNil nil, RubyBoolean.False fals) {
            return nil != obj && fals != obj;
        }
    }

    public static class IsNilSite
    extends MutableCallSite {
        public static final MethodType TYPE = MethodType.methodType(Boolean.TYPE, IRubyObject.class);
        private static final MethodHandle INIT_HANDLE = Binder.from(TYPE.insertParameterTypes(0, IsNilSite.class)).invokeVirtualQuiet(LOOKUP, "init");
        private static final MethodHandle IS_NIL_HANDLE = Binder.from(Boolean.TYPE, IRubyObject.class, RubyNil.class).invokeStaticQuiet(LOOKUP, IsNilSite.class, "isNil");

        public IsNilSite() {
            super(TYPE);
            this.setTarget(INIT_HANDLE.bindTo(this));
        }

        public boolean init(IRubyObject obj) {
            IRubyObject nil = obj.getRuntime().getNil();
            this.setTarget(MethodHandles.insertArguments(IS_NIL_HANDLE, 1, nil));
            return nil == obj;
        }

        public static boolean isNil(IRubyObject obj, RubyNil nil) {
            return nil == obj;
        }
    }
}

