/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.instructions;

import org.jruby.RubyInstanceConfig;
import org.jruby.RubySymbol;
import org.jruby.ir.IRScope;
import org.jruby.ir.IRVisitor;
import org.jruby.ir.Operation;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.instructions.NoResultCallInstr;
import org.jruby.ir.instructions.specialized.OneArgOperandAttrAssignInstr;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.operands.Self;
import org.jruby.ir.persistence.IRReaderDecoder;
import org.jruby.ir.persistence.IRWriterEncoder;
import org.jruby.ir.transformations.inlining.CloneInfo;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallSite;
import org.jruby.runtime.CallType;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class AttrAssignInstr
extends NoResultCallInstr {
    public static AttrAssignInstr create(IRScope scope, Operand obj, RubySymbol attr2, Operand[] args2, Operand block, boolean isPotentiallyRefined) {
        if (block == null && args2.length == 1 && !AttrAssignInstr.containsArgSplat(args2)) {
            return new OneArgOperandAttrAssignInstr(scope, obj, attr2, args2, isPotentiallyRefined);
        }
        return new AttrAssignInstr(scope, obj, attr2, args2, block, isPotentiallyRefined);
    }

    public static AttrAssignInstr create(IRScope scope, Operand obj, RubySymbol attr2, Operand[] args2, boolean isPotentiallyRefined) {
        if (!AttrAssignInstr.containsArgSplat(args2) && args2.length == 1) {
            return new OneArgOperandAttrAssignInstr(scope, obj, attr2, args2, isPotentiallyRefined);
        }
        return new AttrAssignInstr(scope, obj, attr2, args2, null, isPotentiallyRefined);
    }

    protected AttrAssignInstr(IRScope scope, CallType callType, RubySymbol name2, Operand receiver2, Operand[] args2, boolean potentiallyRefined, CallSite callSite, long callSiteId) {
        super(scope, Operation.ATTR_ASSIGN, callType, name2, receiver2, args2, null, potentiallyRefined, callSite, callSiteId);
    }

    public AttrAssignInstr(IRScope scope, Operand obj, RubySymbol attr2, Operand[] args2, Operand block, boolean isPotentiallyRefined) {
        super(scope, Operation.ATTR_ASSIGN, obj instanceof Self ? CallType.FUNCTIONAL : CallType.NORMAL, attr2, obj, args2, block, isPotentiallyRefined);
    }

    @Override
    public Instr clone(CloneInfo ii) {
        return new AttrAssignInstr(ii.getScope(), this.getCallType(), this.getName(), this.getReceiver().cloneForInlining(ii), this.cloneCallArgs(ii), this.isPotentiallyRefined(), this.getCallSite(), this.getCallSiteId());
    }

    @Override
    public void encode(IRWriterEncoder e) {
        if (RubyInstanceConfig.IR_WRITING_DEBUG) {
            System.out.println("Instr(" + (Object)((Object)this.getOperation()) + "): " + this);
        }
        e.encode(this.getOperation());
        e.encode(this.getReceiver());
        e.encode(this.getName());
        e.encode(this.getCallArgs());
    }

    public static AttrAssignInstr decode(IRReaderDecoder d) {
        return AttrAssignInstr.create(d.getCurrentScope(), d.decodeOperand(), d.decodeSymbol(), d.decodeOperandArray(), d.getCurrentScope().maybeUsingRefinements());
    }

    @Override
    public Object interpret(ThreadContext context, StaticScope currScope, DynamicScope dynamicScope, IRubyObject self2, Object[] temp) {
        IRubyObject object = (IRubyObject)this.getReceiver().retrieve(context, self2, currScope, dynamicScope, temp);
        IRubyObject[] values2 = this.prepareArguments(context, self2, currScope, dynamicScope, temp);
        Block block = this.prepareBlock(context, self2, currScope, dynamicScope, temp);
        this.callSite.call(context, self2, object, values2, block);
        return null;
    }

    @Override
    public void visit(IRVisitor visitor) {
        visitor.AttrAssignInstr(this);
    }
}

