/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.jruby.Ruby;
import org.jruby.RubyException;
import org.jruby.RubyInstanceConfig;
import org.jruby.RubyNumeric;
import org.jruby.exceptions.JumpException;
import org.jruby.exceptions.MainExitException;
import org.jruby.exceptions.RaiseException;
import org.jruby.exceptions.ThreadKill;
import org.jruby.main.DripMain;
import org.jruby.platform.Platform;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.backtrace.TraceType;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.SafePropertyAccessor;
import org.jruby.util.cli.OutputStrings;
import org.jruby.util.log.Logger;
import org.jruby.util.log.LoggerFactory;

public class Main {
    private static final Logger LOG = LoggerFactory.getLogger(Main.class);
    private final RubyInstanceConfig config;

    public Main(RubyInstanceConfig config) {
        this(config, false);
    }

    public Main(InputStream in, PrintStream out, PrintStream err) {
        this(new RubyInstanceConfig(in, out, err));
    }

    public Main() {
        this(new RubyInstanceConfig());
    }

    private Main(RubyInstanceConfig config, boolean hardExit) {
        this.config = config;
        config.setHardExit(hardExit);
    }

    private Main(boolean hardExit) {
        Main.processDotfile();
        this.config = new RubyInstanceConfig();
        this.config.setHardExit(hardExit);
    }

    private static List<String> getDotfileDirectories() {
        ArrayList<String> searchList = new ArrayList<String>(4);
        for (String homeProp : new String[]{"user.dir", "user.home"}) {
            String home2 = SafePropertyAccessor.getProperty(homeProp);
            if (home2 == null) continue;
            searchList.add(home2);
        }
        if (Platform.IS_WINDOWS) {
            String homeDrive = System.getenv("HOMEDRIVE");
            String homePath = System.getenv("HOMEPATH");
            if (homeDrive != null && homePath != null) {
                searchList.add(1, (homeDrive + homePath).replace('\\', '/'));
            }
        }
        return searchList;
    }

    public static void processDotfile() {
        StringBuilder path2 = new StringBuilder();
        for (String home2 : Main.getDotfileDirectories()) {
            path2.setLength(0);
            path2.append(home2).append("/.jrubyrc");
            File dotfile = new File(path2.toString());
            if (!dotfile.exists()) continue;
            Main.loadJRubyProperties(dotfile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadJRubyProperties(File dotfile) {
        FileInputStream fis = null;
        try {
            Properties sysProps = System.getProperties();
            Properties newProps = new Properties();
            fis = new FileInputStream(dotfile);
            newProps.load(fis);
            for (Map.Entry<Object, Object> entry : newProps.entrySet()) {
                sysProps.put("jruby." + entry.getKey(), entry.getValue());
            }
        }
        catch (IOException | SecurityException ex) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("exception loading properties from: " + dotfile, ex);
            }
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (Exception exception2) {}
            }
        }
    }

    public static void main(String[] args2) {
        Main.doGCJCheck();
        Main main2 = DripMain.DRIP_RUNTIME != null ? new Main(DripMain.DRIP_CONFIG, true) : new Main(true);
        try {
            Status status2 = main2.run(args2);
            if (status2.isExit()) {
                System.exit(status2.getStatus());
            }
        }
        catch (RaiseException ex) {
            System.exit(Main.handleRaiseException(ex));
        }
        catch (JumpException ex) {
            System.exit(Main.handleUnexpectedJump(ex));
        }
        catch (Throwable t) {
            System.err.println("Unhandled Java exception: " + t);
            System.err.println(ThreadContext.createRawBacktraceStringFromThrowable(t, false));
            while ((t = t.getCause()) != null) {
                System.err.println("Caused by:");
                System.err.println(ThreadContext.createRawBacktraceStringFromThrowable(t, false));
            }
            System.exit(1);
        }
    }

    public Status run(String[] args2) {
        try {
            this.config.processArguments(args2);
            return this.internalRun();
        }
        catch (MainExitException mee) {
            return this.handleMainExit(mee);
        }
        catch (OutOfMemoryError oome) {
            return this.handleOutOfMemory(oome);
        }
        catch (StackOverflowError soe) {
            return this.handleStackOverflow(soe);
        }
        catch (UnsupportedClassVersionError ucve) {
            return this.handleUnsupportedClassVersion(ucve);
        }
        catch (ThreadKill kill2) {
            return new Status();
        }
    }

    @Deprecated
    public Status run() {
        return this.internalRun();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Status internalRun() {
        Ruby runtime2;
        this.doShowVersion();
        this.doShowCopyright();
        this.doPrintProperties();
        if (!this.config.getShouldRunInterpreter()) {
            this.doPrintUsage(false);
            return new Status();
        }
        InputStream in = this.config.getScriptSource();
        String filename2 = this.config.displayedFileName();
        if (DripMain.DRIP_RUNTIME != null) {
            runtime2 = DripMain.DRIP_RUNTIME;
            runtime2.reinitialize(true);
        } else {
            runtime2 = Ruby.newInstance(this.config);
        }
        Status status2 = null;
        try {
            try {
                this.doSetContextClassLoader(runtime2);
                if (in == null) {
                    Status status3 = new Status();
                    return status3;
                }
                if (this.config.getShouldCheckSyntax()) {
                    Status status4 = this.doCheckSyntax(runtime2, in, filename2);
                    return status4;
                }
                this.doRunFromMain(runtime2, in, filename2);
                status2 = new Status();
                return status2;
            }
            finally {
                try {
                    runtime2.tearDown();
                }
                catch (RaiseException rj) {
                    status2 = new Status(Main.handleRaiseException(rj));
                }
            }
        }
        catch (RaiseException rj) {
            int ret = Main.handleRaiseException(rj);
            if (status2 != null) return status2;
            return new Status(ret);
        }
    }

    private Status handleUnsupportedClassVersion(UnsupportedClassVersionError ex) {
        this.config.getError().println("Error: Some library (perhaps JRuby) was built with a later JVM version.");
        this.config.getError().println("Please use libraries built with the version you intend to use or an earlier one.");
        if (this.config.isVerbose()) {
            ex.printStackTrace(this.config.getError());
        } else {
            this.config.getError().println("Specify -w for full " + ex + " stack trace");
        }
        return new Status(1);
    }

    private Status handleStackOverflow(StackOverflowError ex) {
        String memoryMax = this.getRuntimeFlagValue("-Xss");
        if (memoryMax != null) {
            this.config.getError().println("Error: Your application used more stack memory than the safety cap of " + memoryMax + '.');
        } else {
            this.config.getError().println("Error: Your application used more stack memory than the default safety cap.");
        }
        this.config.getError().println("Specify -J-Xss####k to increase it (#### = cap size in KB).");
        if (this.config.isVerbose()) {
            ex.printStackTrace(this.config.getError());
        } else {
            this.config.getError().println("Specify -w for full " + ex + " stack trace");
        }
        return new Status(1);
    }

    private Status handleOutOfMemory(OutOfMemoryError ex) {
        System.gc();
        String oomeMessage = ex.getMessage();
        boolean heapError = false;
        if (oomeMessage != null) {
            if (oomeMessage.contains("unable to create new native thread")) {
                this.config.getError().println("Error: Your application demanded too many live threads, perhaps for Fiber or Enumerator.");
                this.config.getError().println("Ensure your old Fibers and Enumerators are being cleaned up.");
            } else {
                heapError = true;
            }
        }
        if (heapError) {
            String memoryMax = this.getRuntimeFlagValue("-Xmx");
            if (memoryMax != null) {
                this.config.getError().println("Error: Your application used more memory than the safety cap of " + memoryMax + ".");
            } else {
                this.config.getError().println("Error: Your application used more memory than the automatic cap of " + Runtime.getRuntime().maxMemory() / 1024L / 1024L + "MB.");
            }
            this.config.getError().println("Specify -J-Xmx####M to increase it (#### = cap size in MB).");
        }
        if (this.config.isVerbose()) {
            ex.printStackTrace(this.config.getError());
        } else {
            this.config.getError().println("Specify -w for full " + ex + " stack trace");
        }
        return new Status(1);
    }

    private String getRuntimeFlagValue(String prefix) {
        RuntimeMXBean runtime2 = ManagementFactory.getRuntimeMXBean();
        for (String param : runtime2.getInputArguments()) {
            if (!param.startsWith(prefix)) continue;
            return param.substring(prefix.length()).toUpperCase();
        }
        return null;
    }

    private Status handleMainExit(MainExitException mee) {
        if (!mee.isAborted()) {
            this.config.getError().println(mee.getMessage());
            if (mee.isUsageError()) {
                this.doPrintUsage(true);
            }
        }
        return new Status(mee.getStatus());
    }

    private void doRunFromMain(Ruby runtime2, InputStream in, String filename2) {
        this.doCheckSecurityManager();
        runtime2.runFromMain(in, filename2);
    }

    private Status doCheckSyntax(Ruby runtime2, InputStream in, String filename2) throws RaiseException {
        boolean status2 = this.checkStreamSyntax(runtime2, in, filename2);
        for (String arg2 : this.config.getArgv()) {
            status2 = status2 && this.checkFileSyntax(runtime2, arg2);
        }
        return new Status(status2 ? 0 : -1);
    }

    private boolean checkFileSyntax(Ruby runtime2, String filename2) {
        File file2 = new File(filename2);
        if (file2.exists()) {
            try {
                return this.checkStreamSyntax(runtime2, new FileInputStream(file2), filename2);
            }
            catch (FileNotFoundException fnfe) {
                this.config.getError().println("File not found: " + filename2);
                return false;
            }
        }
        return false;
    }

    private boolean checkStreamSyntax(Ruby runtime2, InputStream in, String filename2) {
        ThreadContext context = runtime2.getCurrentContext();
        IRubyObject $ex = context.getErrorInfo();
        try {
            runtime2.parseFromMain(in, filename2);
            this.config.getOutput().println("Syntax OK");
            return true;
        }
        catch (RaiseException re) {
            if (re.getException().getMetaClass().getBaseName().equals("SyntaxError")) {
                context.setErrorInfo($ex);
                this.config.getError().println("SyntaxError in " + re.getException().message(context));
                return false;
            }
            throw re;
        }
    }

    private void doSetContextClassLoader(Ruby runtime2) {
        block2: {
            try {
                Thread.currentThread().setContextClassLoader(runtime2.getJRubyClassLoader());
            }
            catch (SecurityException se) {
                if (!runtime2.getInstanceConfig().isVerbose()) break block2;
                this.config.getError().println("WARNING: Security restrictions disallowed setting context classloader for main thread.");
            }
        }
    }

    private void doPrintProperties() {
        if (this.config.getShouldPrintProperties()) {
            this.config.getOutput().print(OutputStrings.getPropertyHelp());
        }
    }

    private void doPrintUsage(boolean force) {
        if (this.config.getShouldPrintUsage() || force) {
            this.config.getOutput().print(OutputStrings.getBasicUsageHelp());
            this.config.getOutput().print(OutputStrings.getFeaturesHelp());
        }
    }

    private void doShowCopyright() {
        if (this.config.isShowCopyright()) {
            this.config.getOutput().println(OutputStrings.getCopyrightString());
        }
    }

    private void doShowVersion() {
        if (this.config.isShowVersion()) {
            this.config.getOutput().println(OutputStrings.getVersionString());
        }
    }

    private static void doGCJCheck() {
        if (Platform.IS_GCJ) {
            System.err.println("Fatal: GCJ (GNU Compiler for Java) is not supported by JRuby.");
            System.exit(1);
        }
    }

    private void doCheckSecurityManager() {
        if (Main.class.getClassLoader() == null && System.getSecurityManager() != null) {
            System.err.println("Warning: security manager and JRuby running from boot classpath.\nRun from jruby.jar or set env VERIFY_JRUBY=true to enable security.");
        }
    }

    protected static int handleRaiseException(RaiseException ex) {
        RubyException raisedException = ex.getException();
        Ruby runtime2 = raisedException.getRuntime();
        if (runtime2.getSystemExit().isInstance(raisedException)) {
            IRubyObject status2 = raisedException.callMethod(runtime2.getCurrentContext(), "status");
            if (status2 != null && !status2.isNil()) {
                return RubyNumeric.fix2int(status2);
            }
            return 0;
        }
        if (runtime2.getSignalException().isInstance(raisedException)) {
            IRubyObject status3 = raisedException.callMethod(runtime2.getCurrentContext(), "signo");
            if (status3 != null && !status3.isNil()) {
                return RubyNumeric.fix2int(status3) + 128;
            }
            return 0;
        }
        TraceType traceType = runtime2.getInstanceConfig().getTraceType();
        boolean isatty = runtime2.getPosix().isatty(FileDescriptor.err);
        System.err.print(traceType.printBacktrace(raisedException, isatty));
        HashSet<Object> shownCauses = new HashSet<Object>();
        shownCauses.add(raisedException);
        Object cause2 = raisedException.getCause();
        while (cause2 != null && cause2 instanceof RubyException && !shownCauses.contains(cause2)) {
            System.err.print(traceType.printBacktrace((RubyException)cause2, isatty));
            shownCauses.add(cause2);
            cause2 = ((RubyException)cause2).getCause();
        }
        return 1;
    }

    private static int handleUnexpectedJump(JumpException ex) {
        if (ex instanceof JumpException.SpecialJump) {
            System.err.println("Unexpected break: " + ex);
        } else if (ex instanceof JumpException.FlowControlException) {
            if (Ruby.isGlobalRuntimeReady()) {
                Ruby runtime2 = Ruby.getGlobalRuntime();
                RaiseException raise2 = ((JumpException.FlowControlException)ex).buildException(runtime2);
                if (raise2 != null) {
                    Main.handleRaiseException(raise2);
                }
            } else {
                System.err.println("Unexpected jump: " + ex);
            }
        } else {
            System.err.println("Unexpected: " + ex);
        }
        StackTraceElement[] trace2 = ex.getStackTrace();
        if (trace2 != null && trace2.length > 0) {
            System.err.println(ThreadContext.createRawBacktraceStringFromThrowable(ex, false));
        } else {
            System.err.println("HINT: to get backtrace for jump exceptions run with -Xjump.backtrace=true");
        }
        return 2;
    }

    public static class Status {
        private boolean isExit = false;
        private int status = 0;

        Status(int status2) {
            this.isExit = true;
            this.status = status2;
        }

        Status() {
        }

        public boolean isExit() {
            return this.isExit;
        }

        public int getStatus() {
            return this.status;
        }
    }
}

