/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.crypto.impl.bc;

import java.io.IOException;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.params.DSAPrivateKeyParameters;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.params.Ed25519PrivateKeyParameters;
import org.bouncycastle.crypto.params.Ed448PrivateKeyParameters;
import org.bouncycastle.crypto.params.RSAKeyParameters;
import org.bouncycastle.tls.Certificate;
import org.bouncycastle.tls.DefaultTlsCredentialedSigner;
import org.bouncycastle.tls.SignatureAndHashAlgorithm;
import org.bouncycastle.tls.crypto.TlsCryptoParameters;
import org.bouncycastle.tls.crypto.TlsSigner;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsCertificate;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsCrypto;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsDSASigner;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsECDSASigner;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsEd25519Signer;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsEd448Signer;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsRSAPSSSigner;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsRSASigner;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsSigner;

public class BcDefaultTlsCredentialedSigner
extends DefaultTlsCredentialedSigner {
    private static BcTlsCertificate getEndEntity(BcTlsCrypto bcTlsCrypto, Certificate certificate) throws IOException {
        if (certificate == null || certificate.isEmpty()) {
            throw new IllegalArgumentException("No certificate");
        }
        return BcTlsCertificate.convert(bcTlsCrypto, certificate.getCertificateAt(0));
    }

    private static TlsSigner makeSigner(BcTlsCrypto bcTlsCrypto, AsymmetricKeyParameter asymmetricKeyParameter, Certificate certificate, SignatureAndHashAlgorithm signatureAndHashAlgorithm) {
        BcTlsSigner bcTlsSigner;
        if (asymmetricKeyParameter instanceof RSAKeyParameters) {
            RSAKeyParameters rSAKeyParameters;
            RSAKeyParameters rSAKeyParameters2 = (RSAKeyParameters)asymmetricKeyParameter;
            if (signatureAndHashAlgorithm != null) {
                short s = signatureAndHashAlgorithm.getSignature();
                switch (s) {
                    case 4: 
                    case 5: 
                    case 6: 
                    case 9: 
                    case 10: 
                    case 11: {
                        return new BcTlsRSAPSSSigner(bcTlsCrypto, rSAKeyParameters2, s);
                    }
                }
            }
            try {
                rSAKeyParameters = BcDefaultTlsCredentialedSigner.getEndEntity(bcTlsCrypto, certificate).getPubKeyRSA();
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
            bcTlsSigner = new BcTlsRSASigner(bcTlsCrypto, rSAKeyParameters2, rSAKeyParameters);
        } else if (asymmetricKeyParameter instanceof DSAPrivateKeyParameters) {
            bcTlsSigner = new BcTlsDSASigner(bcTlsCrypto, (DSAPrivateKeyParameters)asymmetricKeyParameter);
        } else if (asymmetricKeyParameter instanceof ECPrivateKeyParameters) {
            bcTlsSigner = new BcTlsECDSASigner(bcTlsCrypto, (ECPrivateKeyParameters)asymmetricKeyParameter);
        } else if (asymmetricKeyParameter instanceof Ed25519PrivateKeyParameters) {
            bcTlsSigner = new BcTlsEd25519Signer(bcTlsCrypto, (Ed25519PrivateKeyParameters)asymmetricKeyParameter);
        } else if (asymmetricKeyParameter instanceof Ed448PrivateKeyParameters) {
            bcTlsSigner = new BcTlsEd448Signer(bcTlsCrypto, (Ed448PrivateKeyParameters)asymmetricKeyParameter);
        } else {
            throw new IllegalArgumentException("'privateKey' type not supported: " + asymmetricKeyParameter.getClass().getName());
        }
        return bcTlsSigner;
    }

    public BcDefaultTlsCredentialedSigner(TlsCryptoParameters tlsCryptoParameters, BcTlsCrypto bcTlsCrypto, AsymmetricKeyParameter asymmetricKeyParameter, Certificate certificate, SignatureAndHashAlgorithm signatureAndHashAlgorithm) {
        super(tlsCryptoParameters, BcDefaultTlsCredentialedSigner.makeSigner(bcTlsCrypto, asymmetricKeyParameter, certificate, signatureAndHashAlgorithm), certificate, signatureAndHashAlgorithm);
    }
}

