/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.io.importexport;

import java.io.File;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.openstreetmap.josm.data.StructUtils;
import org.openstreetmap.josm.data.imagery.ImageryInfo;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.io.importexport.FileExporter;
import org.openstreetmap.josm.gui.io.importexport.WMSLayerImporter;
import org.openstreetmap.josm.gui.layer.AbstractTileSourceLayer;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.MainLayerManager;
import org.openstreetmap.josm.tools.CheckParameterUtil;

public class WMSLayerExporter
extends FileExporter {
    public static final int CURRENT_FILE_VERSION = 6;

    public WMSLayerExporter() {
        super(WMSLayerImporter.FILE_FILTER);
    }

    @Override
    public void exportData(File file, Layer layer) throws IOException {
        CheckParameterUtil.ensureParameterNotNull(file, "file");
        CheckParameterUtil.ensureParameterNotNull(layer, "layer");
        if (layer instanceof AbstractTileSourceLayer) {
            try (ObjectOutputStream oos = new ObjectOutputStream(Files.newOutputStream(file.toPath(), new OpenOption[0]));){
                oos.writeInt(6);
                oos.writeObject(MainApplication.getMap().mapView.getCenter());
                ImageryInfo.ImageryPreferenceEntry entry = new ImageryInfo.ImageryPreferenceEntry(((AbstractTileSourceLayer)layer).getInfo());
                oos.writeObject(StructUtils.serializeStruct(entry, ImageryInfo.ImageryPreferenceEntry.class));
            }
        }
    }

    @Override
    public void activeOrEditLayerChanged(MainLayerManager.ActiveLayerChangeEvent e) {
        this.setEnabled(e.getSource().getActiveLayer() instanceof AbstractTileSourceLayer);
    }
}

