/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.jicofo.conference;

import java.time.Clock;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jitsi.impl.protocol.xmpp.ChatRoomMember;
import org.jitsi.jicofo.ConferenceConfig;
import org.jitsi.jicofo.TaskPools;
import org.jitsi.jicofo.conference.AddOrRemove;
import org.jitsi.jicofo.conference.JitsiMeetConferenceImpl;
import org.jitsi.jicofo.conference.SourceSignaling;
import org.jitsi.jicofo.conference.SourcesToAddOrRemove;
import org.jitsi.jicofo.conference.source.ConferenceSourceMap;
import org.jitsi.jicofo.conference.source.SourceInfo;
import org.jitsi.jicofo.conference.source.VideoType;
import org.jitsi.jicofo.discovery.DiscoveryUtil;
import org.jitsi.jicofo.util.Cancelable;
import org.jitsi.jicofo.xmpp.muc.MemberRoleKt;
import org.jitsi.protocol.xmpp.JingleSession;
import org.jitsi.protocol.xmpp.OperationSetJingle;
import org.jitsi.utils.OrderedJsonObject;
import org.jitsi.utils.logging2.Logger;
import org.jxmpp.jid.EntityFullJid;
import org.jxmpp.jid.Jid;

public class Participant {
    private final SourceSignaling sourceSignaling;
    private final Object inviteRunnableSyncRoot = new Object();
    private Cancelable inviteRunnable = null;
    private Clock clock = Clock.systemUTC();
    private final Deque<Instant> restartRequests = new LinkedList<Instant>();
    @NotNull
    private final ChatRoomMember roomMember;
    private JingleSession jingleSession;
    private final Logger logger;
    @NotNull
    private final List<String> supportedFeatures;
    private final JitsiMeetConferenceImpl conference;
    private ScheduledFuture<?> signalQueuedSourcesTask;
    private final Object signalQueuedSourcesTaskSyncRoot = new Object();
    private boolean desktopSourceIsMuted = false;

    public static String getEndpointId(ChatRoomMember chatRoomMember) {
        return chatRoomMember.getName();
    }

    public Participant(@NotNull ChatRoomMember roomMember, @NotNull List<String> supportedFeatures, Logger parentLogger, JitsiMeetConferenceImpl conference) {
        this.supportedFeatures = supportedFeatures;
        this.conference = conference;
        this.roomMember = roomMember;
        this.updateDesktopSourceIsMuted(roomMember.getSourceInfos());
        this.logger = parentLogger.createChildLogger(this.getClass().getName());
        this.logger.addContext("participant", this.getEndpointId());
        this.sourceSignaling = new SourceSignaling(this.hasAudioSupport(), this.hasVideoSupport(), ConferenceConfig.config.stripSimulcast(), this.supportsReceivingMultipleVideoStreams() || !ConferenceConfig.config.getMultiStreamBackwardCompat());
    }

    void presenceChanged() {
        if (this.updateDesktopSourceIsMuted(this.roomMember.getSourceInfos())) {
            this.conference.desktopSourceIsMutedChanged(this, this.desktopSourceIsMuted);
        }
    }

    private boolean updateDesktopSourceIsMuted(@NotNull Set<SourceInfo> sourceInfos) {
        boolean newValue = sourceInfos.stream().anyMatch(si -> si.getVideoType() == VideoType.Desktop && si.getMuted());
        if (this.desktopSourceIsMuted != newValue) {
            this.desktopSourceIsMuted = newValue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void remoteDesktopSourceIsMutedChanged(Jid owner, Boolean muted) {
        if (this.supportsReceivingMultipleVideoStreams()) {
            return;
        }
        this.sourceSignaling.remoteDesktopSourceIsMutedChanged(owner, muted);
        Object object = this.signalQueuedSourcesTaskSyncRoot;
        synchronized (object) {
            this.scheduleSignalingOfQueuedSources();
        }
    }

    public Participant(@NotNull ChatRoomMember roomMember, Logger parentLogger, JitsiMeetConferenceImpl conference) {
        this(roomMember, DiscoveryUtil.getDefaultParticipantFeatureSet(), parentLogger, conference);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setInviteRunnable(Cancelable inviteRunnable) {
        Object object = this.inviteRunnableSyncRoot;
        synchronized (object) {
            if (this.inviteRunnable != null) {
                this.logger.warn("Canceling " + this.inviteRunnable);
                this.inviteRunnable.cancel();
            }
            this.inviteRunnable = inviteRunnable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void inviteRunnableCompleted(Cancelable channelAllocator) {
        Object object = this.inviteRunnableSyncRoot;
        synchronized (object) {
            if (this.inviteRunnable == channelAllocator) {
                this.inviteRunnable = null;
            }
        }
    }

    public JingleSession getJingleSession() {
        return this.jingleSession;
    }

    public void setClock(Clock newClock) {
        this.clock = newClock;
    }

    public void setJingleSession(JingleSession jingleSession) {
        this.jingleSession = jingleSession;
    }

    @NotNull
    public ChatRoomMember getChatMember() {
        return this.roomMember;
    }

    public Clock getClock() {
        return this.clock;
    }

    public boolean hasSourceNameSupport() {
        return this.supportedFeatures.contains("http://jitsi.org/source-name");
    }

    public boolean supportsJsonEncodedSources() {
        return this.supportedFeatures.contains("http://jitsi.org/json-encoded-sources");
    }

    public boolean supportsReceivingMultipleVideoStreams() {
        return this.supportedFeatures.contains("http://jitsi.org/receive-multiple-video-streams");
    }

    public boolean hasLipSyncSupport() {
        return this.supportedFeatures.contains("http://jitsi.org/meet/lipsync");
    }

    public boolean hasRembSupport() {
        return this.supportedFeatures.contains("http://jitsi.org/remb");
    }

    public boolean hasTccSupport() {
        return this.supportedFeatures.contains("http://jitsi.org/tcc");
    }

    public boolean hasRtxSupport() {
        return this.supportedFeatures.contains("urn:ietf:rfc:4588");
    }

    public boolean hasOpusRedSupport() {
        return this.supportedFeatures.contains("http://jitsi.org/opus-red");
    }

    public boolean incrementAndCheckRestartRequests() {
        Instant now = Instant.now(this.clock);
        Instant previousRequest = this.restartRequests.peekLast();
        if (previousRequest == null) {
            this.restartRequests.add(now);
            return true;
        }
        if (previousRequest.until(now, ChronoUnit.SECONDS) < 10L) {
            return false;
        }
        this.restartRequests.removeIf(requestTime -> requestTime.until(now, ChronoUnit.SECONDS) > 60L);
        if (this.restartRequests.size() > 2) {
            return false;
        }
        this.restartRequests.add(now);
        return true;
    }

    public boolean hasAudioSupport() {
        return this.supportedFeatures.contains("urn:xmpp:jingle:apps:rtp:audio");
    }

    public boolean hasAudioMuteSupport() {
        return this.supportedFeatures.contains("http://jitsi.org/protocol/audio-mute");
    }

    public boolean hasVideoSupport() {
        return this.supportedFeatures.contains("urn:xmpp:jingle:apps:rtp:video");
    }

    public boolean hasSctpSupport() {
        return this.supportedFeatures.contains("urn:xmpp:jingle:transports:dtls-sctp:1");
    }

    public String getEndpointId() {
        return Participant.getEndpointId(this.roomMember);
    }

    public String getStatId() {
        return this.roomMember.getStatsId();
    }

    public EntityFullJid getMucJid() {
        return this.roomMember.getOccupantJid();
    }

    @NotNull
    public ConferenceSourceMap getSources() {
        return this.conference == null ? new ConferenceSourceMap() : this.conference.getSourcesForParticipant(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRemoteSources(ConferenceSourceMap sources) {
        SourceSignaling sourceSignaling = this.sourceSignaling;
        synchronized (sourceSignaling) {
            this.sourceSignaling.addSources(sources);
        }
        JingleSession jingleSession = this.getJingleSession();
        if (jingleSession == null) {
            this.logger.debug("No Jingle session yet, queueing source-add.");
            return;
        }
        Object object = this.signalQueuedSourcesTaskSyncRoot;
        synchronized (object) {
            this.scheduleSignalingOfQueuedSources();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public ConferenceSourceMap resetSignaledSources(@NotNull ConferenceSourceMap sources) {
        SourceSignaling sourceSignaling = this.sourceSignaling;
        synchronized (sourceSignaling) {
            return this.sourceSignaling.reset(sources);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleSignalingOfQueuedSources() {
        int delayMs = ConferenceConfig.config.getSourceSignalingDelayMs(this.conference.getParticipantCount());
        Object object = this.signalQueuedSourcesTaskSyncRoot;
        synchronized (object) {
            if (this.signalQueuedSourcesTask == null) {
                this.logger.debug("Scheduling a task to signal queued remote sources after " + delayMs + " ms.");
                this.signalQueuedSourcesTask = TaskPools.getScheduledPool().schedule(() -> {
                    Object object = this.signalQueuedSourcesTaskSyncRoot;
                    synchronized (object) {
                        this.sendQueuedRemoteSources();
                        this.signalQueuedSourcesTask = null;
                    }
                }, (long)delayMs, TimeUnit.MILLISECONDS);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRemoteSources(ConferenceSourceMap sources) {
        SourceSignaling sourceSignaling = this.sourceSignaling;
        synchronized (sourceSignaling) {
            this.sourceSignaling.removeSources(sources);
        }
        JingleSession jingleSession = this.getJingleSession();
        if (jingleSession == null) {
            this.logger.debug("No Jingle session yet, queueing source-remove.");
            return;
        }
        Object object = this.signalQueuedSourcesTaskSyncRoot;
        synchronized (object) {
            this.scheduleSignalingOfQueuedSources();
        }
    }

    public void sendQueuedRemoteSources() {
        OperationSetJingle jingle = this.conference.getJingle();
        if (jingle == null) {
            this.logger.error("Can not signal remote sources, no Jingle API available");
            return;
        }
        JingleSession jingleSession = this.getJingleSession();
        if (jingleSession == null) {
            this.logger.warn("Can not signal remote sources, Jingle session not established.");
            return;
        }
        boolean encodeSourcesAsJson = ConferenceConfig.config.getUseJsonEncodedSources() && this.supportsJsonEncodedSources();
        for (SourcesToAddOrRemove sourcesToAddOrRemove : this.sourceSignaling.update()) {
            AddOrRemove action = sourcesToAddOrRemove.getAction();
            ConferenceSourceMap sources = sourcesToAddOrRemove.getSources();
            this.logger.info("Sending a queued source-" + action.toString().toLowerCase() + ", sources:" + sources);
            if (action == AddOrRemove.Add) {
                jingle.sendAddSourceIQ(sources, jingleSession, encodeSourcesAsJson);
                continue;
            }
            if (action != AddOrRemove.Remove) continue;
            jingle.sendRemoveSourceIQ(sources, jingleSession, encodeSourcesAsJson);
        }
    }

    public boolean shouldSuppressForceMute() {
        return this.getChatMember().isJigasi() && !this.hasAudioMuteSupport() || this.getChatMember().isJibri();
    }

    public boolean hasModeratorRights() {
        return MemberRoleKt.hasModeratorRights(this.roomMember.getRole());
    }

    public String toString() {
        return "Participant[" + this.getMucJid() + "]@" + this.hashCode();
    }

    @NotNull
    public OrderedJsonObject getDebugState() {
        OrderedJsonObject o = new OrderedJsonObject();
        o.put("id", this.getEndpointId());
        o.put("source_signaling", this.sourceSignaling.getDebugState());
        o.put("invite_runnable", this.inviteRunnable != null ? "Running" : "Not running");
        o.put("jingle_session", this.jingleSession == null ? "null" : "not null");
        return o;
    }
}

