/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.web;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Semaphore;
import net.i2p.I2PAppContext;
import net.i2p.app.ClientApp;
import net.i2p.app.ClientAppState;
import net.i2p.data.DataHelper;
import net.i2p.router.RouterContext;
import net.i2p.router.web.Messages;
import net.i2p.router.web.SummaryListener;
import net.i2p.router.web.SummaryRenderer;
import net.i2p.stat.Rate;
import net.i2p.stat.RateStat;
import net.i2p.util.FileSuffixFilter;
import net.i2p.util.FileUtil;
import net.i2p.util.Log;
import net.i2p.util.SystemVersion;
import org.rrd4j.core.RrdBackendFactory;
import org.rrd4j.core.RrdNioBackendFactory;

public class StatSummarizer
implements Runnable,
ClientApp {
    private final RouterContext _context;
    private final Log _log;
    private final List<SummaryListener> _listeners;
    private static final int MAX_CONCURRENT_PNG = SystemVersion.isSlow() ? 1 : 3;
    private final Semaphore _sem;
    private volatile boolean _isRunning;
    private volatile Thread _thread;
    private static final String NAME = "StatSummarizer";
    public static final String DEFAULT_DATABASES = "bw.sendRate.60000,bw.recvRate.60000,router.memoryUsed.60000,router.activePeers.60000";
    private static final boolean IS_WIN = SystemVersion.isWindows();

    public StatSummarizer(RouterContext ctx) {
        this._context = ctx;
        this._log = this._context.logManager().getLog(this.getClass());
        this._listeners = new CopyOnWriteArrayList<SummaryListener>();
        this._sem = new Semaphore(MAX_CONCURRENT_PNG, true);
        this._context.addShutdownTask(new Shutdown());
    }

    public static StatSummarizer instance() {
        return StatSummarizer.instance(I2PAppContext.getGlobalContext());
    }

    public static StatSummarizer instance(I2PAppContext ctx) {
        ClientApp app = ctx.clientAppManager().getRegisteredApp(NAME);
        return app != null ? (StatSummarizer)app : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        int syncThreads;
        if (SystemVersion.isApache() || SystemVersion.isGNU()) {
            this._log.logAlways(30, "Graphing not supported with this JVM: " + System.getProperty("java.vendor") + ' ' + System.getProperty("java.version") + " (" + System.getProperty("java.runtime.name") + ' ' + System.getProperty("java.runtime.version") + ')');
            return;
        }
        this._isRunning = true;
        boolean isPersistent = this._context.getBooleanPropertyDefaultTrue("routerconsole.graphPersistent");
        if (isPersistent) {
            FileSuffixFilter filter;
            String spec = this._context.getProperty("stat.summaries", DEFAULT_DATABASES);
            String[] rates = DataHelper.split(spec, ",");
            syncThreads = Math.min(rates.length / 2, 4);
            HashSet<String> configured = new HashSet<String>(rates.length);
            for (String r : rates) {
                configured.add(SummaryListener.createName(this._context, r));
            }
            File rrdDir = new File(this._context.getRouterDir(), "rrd");
            File[] files = rrdDir.listFiles(filter = new FileSuffixFilter("rrd-", ".jrb"));
            if (files != null) {
                for (int i = 0; i < files.length; ++i) {
                    File f = files[i];
                    String name = f.getName();
                    String hash = name.substring("rrd-".length(), name.length() - ".jrb".length());
                    if (configured.contains(hash)) continue;
                    f.delete();
                }
            }
        } else {
            syncThreads = 0;
            this.deleteOldRRDs();
        }
        RrdNioBackendFactory.setSyncPoolSize(syncThreads);
        this._thread = Thread.currentThread();
        this._context.clientAppManager().register(this);
        String specs = "";
        try {
            while (this._isRunning && this._context.router().isAlive()) {
                specs = this.adjustDatabases(specs);
                try {
                    Thread.sleep(60000L);
                }
                catch (InterruptedException ie) {
                    // empty catch block
                    break;
                }
            }
        }
        finally {
            this._isRunning = false;
            this._context.clientAppManager().unregister(this);
        }
    }

    public static boolean isDisabled(I2PAppContext ctx) {
        return ctx.clientAppManager().getRegisteredApp(NAME) == null;
    }

    static void setDisabled(I2PAppContext ctx) {
        StatSummarizer ss = StatSummarizer.instance(ctx);
        if (ss != null) {
            ss.setDisabled();
        }
    }

    synchronized void setDisabled() {
        if (this._isRunning) {
            this._isRunning = false;
            Thread t = this._thread;
            if (t != null) {
                t.interrupt();
            }
        }
    }

    @Override
    public void startup() {
    }

    @Override
    public void shutdown(String[] args) {
    }

    @Override
    public ClientAppState getState() {
        return ClientAppState.RUNNING;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getDisplayName() {
        return "Console stats summarizer";
    }

    public List<SummaryListener> getListeners() {
        return this._listeners;
    }

    private String adjustDatabases(String oldSpecs) {
        String spec = this._context.getProperty("stat.summaries", DEFAULT_DATABASES);
        if (spec == null && oldSpecs == null || spec != null && oldSpecs != null && oldSpecs.equals(spec)) {
            return oldSpecs;
        }
        Set<Rate> old = this.parseSpecs(oldSpecs);
        Set<Rate> newSpecs = this.parseSpecs(spec);
        for (Rate r : old) {
            if (newSpecs.contains(r)) continue;
            this.removeDb(r);
        }
        StringBuilder buf = new StringBuilder();
        boolean comma = false;
        for (Rate r : newSpecs) {
            if (!old.contains(r)) {
                this.addDb(r);
            }
            if (comma) {
                buf.append(',');
            } else {
                comma = true;
            }
            buf.append(r.getRateStat().getName()).append(".").append(r.getPeriod());
        }
        return buf.toString();
    }

    private void removeDb(Rate r) {
        for (SummaryListener lsnr : this._listeners) {
            if (!lsnr.getRate().equals(r)) continue;
            this._listeners.remove(lsnr);
            lsnr.stopListening();
            return;
        }
    }

    private void addDb(Rate r) {
        SummaryListener lsnr = new SummaryListener(r);
        boolean success = lsnr.startListening();
        if (success) {
            this._listeners.add(lsnr);
        } else {
            this._log.error("Failed to add RRD for rate " + r.getRateStat().getName() + '.' + r.getPeriod());
        }
    }

    public boolean renderPng(Rate rate, OutputStream out) throws IOException {
        return this.renderPng(rate, out, 400, 100, false, false, false, false, -1, 0, true);
    }

    public boolean renderPng(Rate rate, OutputStream out, int width, int height, boolean hideLegend, boolean hideGrid, boolean hideTitle, boolean showEvents, int periodCount, int end, boolean showCredit) throws IOException {
        try {
            try {
                this._sem.acquire();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            try {
                boolean bl = this.locked_renderPng(rate, out, width, height, hideLegend, hideGrid, hideTitle, showEvents, periodCount, end, showCredit);
                return bl;
            }
            catch (NoClassDefFoundError ncdfe) {
                this.setDisabled();
                String s = "Error rendering - disabling graph generation. Install fonts-dejavu font package?";
                this._log.logAlways(30, s);
                IOException ioe = new IOException(s);
                ioe.initCause(ncdfe);
                throw ioe;
            }
        }
        finally {
            this._sem.release();
        }
    }

    private boolean locked_renderPng(Rate rate, OutputStream out, int width, int height, boolean hideLegend, boolean hideGrid, boolean hideTitle, boolean showEvents, int periodCount, int end, boolean showCredit) throws IOException {
        if (width > 2048) {
            width = 2048;
        } else if (width <= 0) {
            width = 400;
        }
        if (height > 1024) {
            height = 1024;
        } else if (height <= 0) {
            height = 100;
        }
        if (end < 0) {
            end = 0;
        }
        for (SummaryListener lsnr : this._listeners) {
            if (!lsnr.getRate().equals(rate)) continue;
            lsnr.renderPng(out, width, height, hideLegend, hideGrid, hideTitle, showEvents, periodCount, end, showCredit);
            return true;
        }
        return false;
    }

    @Deprecated
    public boolean renderPng(OutputStream out, String templateFilename) throws IOException {
        SummaryRenderer.render(this._context, out, templateFilename);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getXML(Rate rate, OutputStream out) throws IOException {
        try {
            try {
                this._sem.acquire();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            boolean bl = this.locked_getXML(rate, out);
            return bl;
        }
        finally {
            this._sem.release();
        }
    }

    private boolean locked_getXML(Rate rate, OutputStream out) throws IOException {
        for (SummaryListener lsnr : this._listeners) {
            if (!lsnr.getRate().equals(rate)) continue;
            lsnr.getData().exportXml(out);
            out.write(DataHelper.getUTF8("<!-- Rate: " + lsnr.getRate().getRateStat().getName() + " for period " + lsnr.getRate().getPeriod() + " -->\n"));
            out.write(DataHelper.getUTF8("<!-- Average data source name: " + lsnr.getName() + " event count data source name: " + lsnr.getEventName() + " -->\n"));
            return true;
        }
        return false;
    }

    public boolean renderRatePng(OutputStream out, int width, int height, boolean hideLegend, boolean hideGrid, boolean hideTitle, boolean showEvents, int periodCount, int end, boolean showCredit) throws IOException {
        try {
            try {
                this._sem.acquire();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            try {
                boolean bl = this.locked_renderRatePng(out, width, height, hideLegend, hideGrid, hideTitle, showEvents, periodCount, end, showCredit);
                return bl;
            }
            catch (NoClassDefFoundError ncdfe) {
                this.setDisabled();
                String s = "Error rendering - disabling graph generation. Install fonts-dejavu font package?";
                this._log.logAlways(30, s);
                IOException ioe = new IOException(s);
                ioe.initCause(ncdfe);
                throw ioe;
            }
        }
        finally {
            this._sem.release();
        }
    }

    private boolean locked_renderRatePng(OutputStream out, int width, int height, boolean hideLegend, boolean hideGrid, boolean hideTitle, boolean showEvents, int periodCount, int end, boolean showCredit) throws IOException {
        SummaryListener txLsnr = null;
        SummaryListener rxLsnr = null;
        for (SummaryListener lsnr : this.getListeners()) {
            String title = lsnr.getRate().getRateStat().getName();
            if (title.equals("bw.sendRate")) {
                txLsnr = lsnr;
                continue;
            }
            if (!title.equals("bw.recvRate")) continue;
            rxLsnr = lsnr;
        }
        if (txLsnr == null || rxLsnr == null) {
            throw new IOException("no rates for combined graph");
        }
        if (width > 2048) {
            width = 2048;
        } else if (width <= 0) {
            width = 400;
        }
        if (height > 1024) {
            height = 1024;
        } else if (height <= 0) {
            height = 100;
        }
        txLsnr.renderPng(out, width, height, hideLegend, hideGrid, hideTitle, showEvents, periodCount, end, showCredit, rxLsnr, this._t("Bandwidth usage"));
        return true;
    }

    public Set<Rate> parseSpecs(String specs) {
        if (specs == null) {
            return Collections.emptySet();
        }
        StringTokenizer tok = new StringTokenizer(specs, ",");
        HashSet<Rate> rv = new HashSet<Rate>();
        while (tok.hasMoreTokens()) {
            String spec = tok.nextToken();
            int split = spec.lastIndexOf(46);
            if (split <= 0 || split + 1 >= spec.length()) continue;
            String name = spec.substring(0, split);
            String per = spec.substring(split + 1);
            long period = -1L;
            try {
                Rate r;
                period = Long.parseLong(per);
                RateStat rs = this._context.statManager().getRate(name);
                if (rs == null || (r = rs.getRate(period)) == null) continue;
                rv.add(r);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return rv;
    }

    private void deleteOldRRDs() {
        File rrdDir = new File(this._context.getRouterDir(), "rrd");
        FileUtil.rmdir(rrdDir, false);
    }

    private String _t(String s) {
        if (IS_WIN && "zh".equals(Messages.getLanguage(this._context))) {
            return s;
        }
        return Messages.getString(s, this._context);
    }

    private class Shutdown
    implements Runnable {
        private Shutdown() {
        }

        @Override
        public void run() {
            StatSummarizer.this.setDisabled();
            for (SummaryListener lsnr : StatSummarizer.this._listeners) {
                lsnr.stopListening();
            }
            StatSummarizer.this._listeners.clear();
            try {
                RrdBackendFactory.getDefaultFactory().close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

