/* ###
 * IP: GHIDRA
 * REVIEWED: YES
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package docking.widgets;

/**
 * A simple tracker of position in an object for that allows more specialized users to extend and
 * add functionality.
 */
public class CursorPosition {

	private int position;

	public CursorPosition(int position) {
		this.position = position;
	}

	public void setOffset(int offset) {
		position += offset;
	}

	public int getPosition() {
		return position;
	}

	@Override
	public String toString() {
		return getClass().getSimpleName() + " - " + position;
	}
}
