/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.pcode;

import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressFactory;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.data.DataType;
import ghidra.program.model.lang.UnknownInstructionException;
import ghidra.program.model.listing.VariableStorage;
import ghidra.program.model.pcode.BlockMap;
import ghidra.program.model.pcode.HighSymbol;
import ghidra.program.model.pcode.PcodeBlockBasic;
import ghidra.program.model.pcode.PcodeDataTypeManager;
import ghidra.program.model.pcode.PcodeFactory;
import ghidra.program.model.pcode.PcodeOp;
import ghidra.program.model.pcode.PcodeOpAST;
import ghidra.program.model.pcode.PcodeOpBank;
import ghidra.program.model.pcode.PcodeXMLException;
import ghidra.program.model.pcode.SequenceNumber;
import ghidra.program.model.pcode.Varnode;
import ghidra.program.model.pcode.VarnodeAST;
import ghidra.program.model.pcode.VarnodeBank;
import ghidra.util.exception.InvalidInputException;
import ghidra.util.xml.SpecXmlUtils;
import ghidra.xml.XmlElement;
import ghidra.xml.XmlPullParser;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public class PcodeSyntaxTree
implements PcodeFactory {
    private AddressFactory addrFactory;
    private PcodeDataTypeManager datatypeManager;
    private HashMap<Integer, Varnode> refmap;
    private HashMap<Integer, PcodeOp> oprefmap;
    private HashMap<Integer, VariableStorage> joinmap;
    private int joinAllocate;
    private PcodeOpBank opbank;
    private VarnodeBank vbank;
    private ArrayList<PcodeBlockBasic> bblocks;
    private int uniqId;

    public PcodeSyntaxTree(AddressFactory afact, PcodeDataTypeManager dtmanage) {
        this.addrFactory = afact;
        this.datatypeManager = dtmanage;
        this.refmap = null;
        this.oprefmap = null;
        this.joinmap = null;
        this.joinAllocate = 0;
        this.opbank = new PcodeOpBank();
        this.vbank = new VarnodeBank();
        this.bblocks = new ArrayList();
        this.uniqId = 0;
    }

    public void clear() {
        this.refmap = null;
        this.oprefmap = null;
        this.joinmap = null;
        this.joinAllocate = 0;
        this.vbank.clear();
        this.opbank.clear();
        this.bblocks = new ArrayList();
        this.uniqId = 0;
    }

    private static Varnode getVarnodePiece(String pieceStr, AddressFactory addrFactory) throws PcodeXMLException {
        int size;
        long offset;
        String[] varnodeTokens = pieceStr.split(":");
        if (varnodeTokens.length != 3) {
            throw new PcodeXMLException("Invalid XML addr piece: " + pieceStr);
        }
        AddressSpace space = addrFactory.getAddressSpace(varnodeTokens[0]);
        if (space == null) {
            throw new PcodeXMLException("Invalid XML addr, space not found: " + pieceStr);
        }
        if (!varnodeTokens[1].startsWith("0x")) {
            throw new PcodeXMLException("Invalid XML addr piece offset: " + pieceStr);
        }
        try {
            offset = Long.parseUnsignedLong(varnodeTokens[1].substring(2), 16);
        }
        catch (NumberFormatException e) {
            throw new PcodeXMLException("Invalid XML addr piece offset: " + pieceStr);
        }
        try {
            size = Integer.parseInt(varnodeTokens[2]);
        }
        catch (NumberFormatException e) {
            throw new PcodeXMLException("Invalid XML addr piece size: " + pieceStr);
        }
        return new Varnode(space.getAddress(offset), size);
    }

    @Override
    public VariableStorage readXMLVarnodePieces(XmlElement el, Address addr) throws PcodeXMLException, InvalidInputException {
        ArrayList<Varnode> list = new ArrayList<Varnode>();
        int index = 1;
        String nextPiece = "piece" + index;
        while (el.hasAttribute(nextPiece)) {
            String pieceStr = el.getAttribute(nextPiece);
            list.add(PcodeSyntaxTree.getVarnodePiece(pieceStr, this.addrFactory));
            nextPiece = "piece" + ++index;
        }
        Varnode[] pieces = new Varnode[list.size()];
        list.toArray(pieces);
        return this.allocateJoinStorage(addr.getOffset(), pieces);
    }

    private VariableStorage allocateJoinStorage(long offset, Varnode[] pieces) throws InvalidInputException {
        Integer offObject;
        VariableStorage storage;
        try {
            storage = new VariableStorage(this.datatypeManager.getProgram(), pieces);
        }
        catch (InvalidInputException e) {
            storage = null;
        }
        if (storage == null) {
            int sz = 0;
            for (Varnode piece : pieces) {
                sz += piece.getSize();
            }
            Address uniqaddr = this.addrFactory.getUniqueSpace().getAddress(0x20000000L);
            storage = new VariableStorage(this.datatypeManager.getProgram(), uniqaddr, sz);
        }
        int roundsize = storage.size() + 15 & 0xFFFFFFF0;
        if (offset < 0L) {
            offObject = new Integer(this.joinAllocate);
            this.joinAllocate += roundsize;
        } else {
            offObject = new Integer((int)offset);
            if ((offset += (long)roundsize) > (long)this.joinAllocate) {
                this.joinAllocate = (int)offset;
            }
        }
        if (this.joinmap == null) {
            this.joinmap = new HashMap();
        }
        this.joinmap.put(offObject, storage);
        return storage;
    }

    private VariableStorage findJoinStorage(long offset) {
        if (this.joinmap == null) {
            return null;
        }
        return this.joinmap.get(new Integer((int)offset));
    }

    @Override
    public VariableStorage buildStorage(Varnode vn) throws InvalidInputException {
        Address addr = vn.getAddress();
        if (addr.getAddressSpace().getType() == 11) {
            return this.findJoinStorage(addr.getOffset());
        }
        return new VariableStorage(this.datatypeManager.getProgram(), vn);
    }

    public Iterator<VarnodeAST> locRange() {
        return this.vbank.locRange();
    }

    public Iterator<VarnodeAST> getVarnodes(AddressSpace spc) {
        return this.vbank.locRange(spc);
    }

    public Iterator<VarnodeAST> getVarnodes(Address addr) {
        return this.vbank.locRange(addr);
    }

    public Iterator<VarnodeAST> getVarnodes(int sz, Address addr) {
        return this.vbank.locRange(sz, addr);
    }

    public Varnode findVarnode(int sz, Address addr, Address pc) {
        return this.vbank.find(sz, addr, pc, -1);
    }

    public Varnode findVarnode(int sz, Address addr, SequenceNumber sq) {
        return this.vbank.find(sz, addr, sq.getTarget(), sq.getTime());
    }

    public Varnode findInputVarnode(int sz, Address addr) {
        return this.vbank.findInput(sz, addr);
    }

    public int getNumVarnodes() {
        return this.vbank.size();
    }

    public Iterator<PcodeOpAST> getPcodeOps() {
        return this.opbank.allOrdered();
    }

    public Iterator<PcodeOpAST> getPcodeOps(Address addr) {
        return this.opbank.allOrdered(addr);
    }

    public PcodeOp getPcodeOp(SequenceNumber sq) {
        return this.opbank.findOp(sq);
    }

    @Deprecated
    public VarnodeBank getVbank() {
        return this.vbank;
    }

    public ArrayList<PcodeBlockBasic> getBasicBlocks() {
        return this.bblocks;
    }

    @Override
    public AddressFactory getAddressFactory() {
        return this.addrFactory;
    }

    @Override
    public PcodeDataTypeManager getDataTypeManager() {
        return this.datatypeManager;
    }

    @Override
    public Varnode newVarnode(int sz, Address addr) {
        Varnode vn = this.vbank.create(sz, addr, this.uniqId);
        ++this.uniqId;
        return vn;
    }

    @Override
    public Varnode newVarnode(int sz, Address addr, int id) {
        Varnode vn = this.vbank.create(sz, addr, id);
        if (this.uniqId <= id) {
            this.uniqId = id + 1;
        }
        if (this.refmap != null) {
            this.refmap.put(id, vn);
        }
        return vn;
    }

    @Override
    public Varnode createFromStorage(Address addr, VariableStorage storage, int logicalSize) {
        Varnode[] pieces = storage.getVarnodes();
        if (pieces.length == 1 && addr == null) {
            Varnode vn = this.newVarnode(pieces[0].getSize(), pieces[0].getAddress());
            return vn;
        }
        try {
            if (addr == null) {
                long joinoffset = this.joinAllocate;
                storage = this.allocateJoinStorage(-1L, pieces);
                addr = AddressSpace.VARIABLE_SPACE.getAddress(joinoffset);
            } else {
                storage = this.allocateJoinStorage(addr.getOffset(), pieces);
            }
        }
        catch (InvalidInputException e) {
            return null;
        }
        Varnode vn = this.newVarnode(logicalSize, addr);
        return vn;
    }

    @Override
    public Varnode setInput(Varnode vn, boolean val) {
        if (!vn.isInput() && val) {
            return this.vbank.setInput(vn);
        }
        if (vn.isInput() && !val) {
            this.vbank.makeFree(vn);
        }
        return vn;
    }

    private void buildVarnodeRefs() {
        this.refmap = new HashMap((int)(1.5 * (double)this.vbank.size()));
        Iterator<VarnodeAST> iter = this.vbank.locRange();
        while (iter.hasNext()) {
            VarnodeAST vn = iter.next();
            this.refmap.put(vn.getUniqueId(), vn);
        }
    }

    @Override
    public Varnode getRef(int id) {
        if (this.refmap == null) {
            return null;
        }
        return this.refmap.get(id);
    }

    @Override
    public HighSymbol getSymbol(int symbolId) {
        return null;
    }

    @Override
    public void setDataType(Varnode vn, DataType type) {
    }

    @Override
    public void setAddrTied(Varnode vn, boolean val) {
        VarnodeAST vnast = (VarnodeAST)vn;
        vnast.setAddrtied(val);
    }

    @Override
    public void setPersistant(Varnode vn, boolean val) {
        VarnodeAST vnast = (VarnodeAST)vn;
        vnast.setPersistant(val);
    }

    @Override
    public void setUnaffected(Varnode vn, boolean val) {
        VarnodeAST vnast = (VarnodeAST)vn;
        vnast.setUnaffected(val);
    }

    @Override
    public void setMergeGroup(Varnode vn, short val) {
        VarnodeAST vnast = (VarnodeAST)vn;
        vnast.setMergeGroup(val);
    }

    private void buildOpRefs() {
        this.oprefmap = new HashMap((int)(1.5 * (double)this.opbank.size()));
        Iterator<PcodeOpAST> iter = this.opbank.allOrdered();
        while (iter.hasNext()) {
            PcodeOp op = iter.next();
            this.oprefmap.put(op.getSeqnum().getTime(), op);
        }
    }

    @Override
    public PcodeOp getOpRef(int id) {
        if (this.oprefmap == null) {
            this.buildOpRefs();
        }
        return this.oprefmap.get(id);
    }

    public void insertBefore(PcodeOp newop, PcodeOp follow) {
        PcodeOpAST newopast = (PcodeOpAST)newop;
        PcodeOpAST followast = (PcodeOpAST)follow;
        PcodeBlockBasic bblock = followast.getParent();
        bblock.insertBefore(followast.getBasicIter(), newopast);
        this.opbank.markAlive(newopast);
    }

    public void insertAfter(PcodeOp newop, PcodeOp prev) {
        PcodeOpAST newopast = (PcodeOpAST)newop;
        PcodeOpAST prevast = (PcodeOpAST)prev;
        PcodeBlockBasic bblock = prevast.getParent();
        bblock.insertAfter(prevast.getBasicIter(), newopast);
        this.opbank.markAlive(newopast);
    }

    public void setOpcode(PcodeOp op, int opc) {
        this.opbank.changeOpcode(op, opc);
    }

    public void setOutput(PcodeOp op, Varnode vn) {
        if (vn == op.getOutput()) {
            return;
        }
        if (op.getOutput() != null) {
            this.unSetOutput(op);
        }
        if (vn.getDef() != null) {
            this.unSetOutput(vn.getDef());
        }
        vn = this.vbank.setDef(vn, op);
        op.setOutput(vn);
    }

    public void unSetOutput(PcodeOp op) {
        Varnode vn = op.getOutput();
        if (vn == null) {
            return;
        }
        op.setOutput(null);
        this.vbank.makeFree(vn);
    }

    public void setInput(PcodeOp op, Varnode vn, int slot) {
        if (slot >= op.getNumInputs()) {
            op.setInput(null, slot);
        }
        if (op.getInput(slot) != null) {
            this.unSetInput(op, slot);
        }
        if (vn != null) {
            VarnodeAST vnast = (VarnodeAST)vn;
            vnast.addDescendant(op);
            op.setInput(vnast, slot);
        }
    }

    public void unSetInput(PcodeOp op, int slot) {
        VarnodeAST vn = (VarnodeAST)op.getInput(slot);
        vn.removeDescendant(op);
        op.setInput(null, slot);
    }

    public void unInsert(PcodeOp op) {
        this.opbank.markDead(op);
        op.getParent().remove(op);
    }

    public void delete(PcodeOp op) {
        this.opbank.destroy(op);
    }

    public void unlink(PcodeOpAST op) {
        this.unSetOutput(op);
        for (int i = 0; i < op.getNumInputs(); ++i) {
            this.unSetInput(op, i);
        }
        if (op.getParent() != null) {
            this.unInsert(op);
        }
    }

    @Override
    public PcodeOp newOp(SequenceNumber sq, int opc, ArrayList<Varnode> inputs, Varnode output) throws UnknownInstructionException {
        PcodeOp op = this.opbank.create(opc, inputs.size(), sq);
        if (output != null) {
            this.setOutput(op, output);
        }
        for (int i = 0; i < inputs.size(); ++i) {
            this.setInput(op, inputs.get(i), i);
        }
        if (this.oprefmap != null) {
            this.oprefmap.put(sq.getTime(), op);
        }
        return op;
    }

    private void readVarnodeXML(XmlPullParser parser) throws PcodeXMLException {
        XmlElement el = parser.start(new String[]{"varnodes"});
        while (parser.peek().isStart()) {
            Varnode.readXML(parser, this);
        }
        parser.end(el);
    }

    private void readBasicBlockXML(XmlPullParser parser, BlockMap resolver) throws PcodeXMLException {
        XmlElement el = parser.start(new String[]{"block"});
        int order = 0;
        PcodeBlockBasic bl = new PcodeBlockBasic();
        bl.restoreXmlHeader(el);
        bl.restoreXmlBody(parser, resolver);
        while (parser.peek().isStart()) {
            PcodeOp op = PcodeOp.readXML(parser, this);
            op.setOrder(order);
            ++order;
            bl.insertEnd(op);
        }
        int index = bl.getIndex();
        while (this.bblocks.size() <= index) {
            this.bblocks.add(null);
        }
        this.bblocks.set(index, bl);
        parser.end(el);
    }

    private void readBlockEdgeXML(XmlPullParser parser) throws PcodeXMLException {
        XmlElement el = parser.start(new String[]{"blockedge"});
        int blockInd = SpecXmlUtils.decodeInt((String)el.getAttribute("index"));
        PcodeBlockBasic curBlock = this.bblocks.get(blockInd);
        while (parser.peek().isStart()) {
            curBlock.restoreNextInEdge(parser, this.bblocks);
        }
        parser.end(el);
    }

    public void readXML(XmlPullParser parser) throws PcodeXMLException {
        XmlElement el = parser.start(new String[]{"ast"});
        if (!this.vbank.isEmpty()) {
            this.clear();
        }
        this.readVarnodeXML(parser);
        this.buildVarnodeRefs();
        BlockMap blockMap = new BlockMap(this.addrFactory);
        while (parser.peek().isStart()) {
            XmlElement subel = parser.peek();
            if (subel.getName().equals("block")) {
                this.readBasicBlockXML(parser, blockMap);
                continue;
            }
            this.readBlockEdgeXML(parser);
        }
        parser.end(el);
    }
}

