/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.data;

import db.DBHandle;
import db.Field;
import db.IntField;
import db.LongField;
import db.Record;
import db.Schema;
import db.StringField;
import db.Table;
import ghidra.program.database.data.ComponentDBAdapter;
import ghidra.program.database.data.DataTypeManagerDB;
import ghidra.util.exception.VersionException;
import java.io.IOException;

class ComponentDBAdapterV0
extends ComponentDBAdapter {
    static final int VERSION = 0;
    static final int V0_COMPONENT_PARENT_ID_COL = 0;
    static final int V0_COMPONENT_OFFSET_COL = 1;
    static final int V0_COMPONENT_DT_ID_COL = 2;
    static final int V0_COMPONENT_FIELD_NAME_COL = 3;
    static final int V0_COMPONENT_COMMENT_COL = 4;
    static final int V0_COMPONENT_SIZE_COL = 5;
    static final int V0_COMPONENT_ORDINAL_COL = 6;
    static final Schema V0_COMPONENT_SCHEMA = new Schema(0, "Data Type ID", new Class[]{LongField.class, IntField.class, LongField.class, StringField.class, StringField.class, IntField.class, IntField.class}, new String[]{"Parent", "Offset", "Data Type ID", "Field Name", "Comment", "Component Size", "Ordinal"});
    private Table componentTable;

    public ComponentDBAdapterV0(DBHandle handle, int openMode) throws VersionException, IOException {
        if (openMode == 0) {
            this.componentTable = handle.createTable("Component Data Types", V0_COMPONENT_SCHEMA, new int[]{0});
        } else {
            this.componentTable = handle.getTable("Component Data Types");
            if (this.componentTable == null) {
                throw new VersionException("Missing Table: Component Data Types");
            }
            int version = this.componentTable.getSchema().getVersion();
            if (version != 0) {
                String msg = "Expected version 0 for table Component Data Types but got " + this.componentTable.getSchema().getVersion();
                if (version < 0) {
                    throw new VersionException(msg, 1, true);
                }
                throw new VersionException(msg, 2, false);
            }
        }
    }

    @Override
    public Record createRecord(long dataTypeID, long parentID, int length, int ordinal, int offset, String name, String comment) throws IOException {
        long tableKey = this.componentTable.getKey();
        long key = DataTypeManagerDB.createKey(2, tableKey);
        Record record = ComponentDBAdapter.COMPONENT_SCHEMA.createRecord(key);
        record.setLongValue(0, parentID);
        record.setLongValue(1, (long)offset);
        record.setLongValue(2, dataTypeID);
        record.setString(3, name);
        record.setString(4, comment);
        record.setIntValue(5, length);
        record.setIntValue(6, ordinal);
        this.componentTable.putRecord(record);
        return record;
    }

    @Override
    public Record getRecord(long componentID) throws IOException {
        return this.componentTable.getRecord(componentID);
    }

    @Override
    public void updateRecord(Record record) throws IOException {
        this.componentTable.putRecord(record);
    }

    @Override
    public boolean removeRecord(long componentID) throws IOException {
        return this.componentTable.deleteRecord(componentID);
    }

    @Override
    public long[] getComponentIdsInComposite(long compositeID) throws IOException {
        return this.componentTable.findRecords((Field)new LongField(compositeID), 0);
    }
}

