/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.fieldpanel.internal;

import docking.widgets.fieldpanel.FieldPanel;
import docking.widgets.fieldpanel.Layout;
import docking.widgets.fieldpanel.LayoutModel;
import docking.widgets.fieldpanel.internal.LineLockedFieldPanelCoordinator;
import ghidra.util.exception.AssertException;
import java.math.BigInteger;

public class LayoutLockedFieldPanelCoordinator
extends LineLockedFieldPanelCoordinator {
    public LayoutLockedFieldPanelCoordinator(FieldPanel[] panels) {
        super(panels);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void viewChanged(FieldPanel fp, BigInteger index, int xPos, int yPos) {
        if (this.valuesChanging) {
            return;
        }
        try {
            Layout currentLayout;
            BigInteger currentIndex1;
            this.valuesChanging = true;
            BigInteger lockedLineIndex1 = this.getLockedLineForPanel(fp);
            if (lockedLineIndex1 == null) {
                throw new AssertException("Couldn't find line number for indicated field panel. FieldPanel is not one of those being managed by this coordinator.");
            }
            BigInteger topIndex1 = index;
            LayoutModel layoutModel1 = fp.getLayoutModel();
            Layout lockedLineLayout1 = layoutModel1.getLayout(lockedLineIndex1);
            if (lockedLineLayout1 == null) {
                return;
            }
            int lockedLineHeight1 = lockedLineLayout1.getHeight();
            BigInteger numIndexes1 = layoutModel1.getNumIndexes();
            Layout firstLayout1 = layoutModel1.getLayout(topIndex1);
            int remainingHeight = firstLayout1.getHeight() + yPos;
            int offsetInLayout1 = 0;
            int offsetFromLockedIndex1 = 0;
            if (lockedLineIndex1.compareTo(topIndex1) == 0) {
                offsetFromLockedIndex1 += (offsetInLayout1 -= yPos);
            } else if (lockedLineIndex1.compareTo(topIndex1) < 0) {
                currentIndex1 = lockedLineIndex1;
                while (currentIndex1 != null && currentIndex1.compareTo(numIndexes1) < 0 && currentIndex1.compareTo(topIndex1) < 0) {
                    currentLayout = layoutModel1.getLayout(currentIndex1);
                    if (currentLayout != null) {
                        offsetFromLockedIndex1 += currentLayout.getHeight();
                    }
                    currentIndex1 = layoutModel1.getIndexAfter(currentIndex1);
                }
                offsetFromLockedIndex1 -= yPos;
            } else {
                currentIndex1 = layoutModel1.getIndexAfter(topIndex1);
                while (currentIndex1 != null && currentIndex1.compareTo(numIndexes1) < 0 && currentIndex1.compareTo(lockedLineIndex1) < 0) {
                    currentLayout = layoutModel1.getLayout(currentIndex1);
                    if (currentLayout != null) {
                        offsetFromLockedIndex1 -= currentLayout.getHeight();
                    }
                    currentIndex1 = layoutModel1.getIndexAfter(currentIndex1);
                }
                offsetFromLockedIndex1 -= remainingHeight;
            }
            for (int i = 0; i < this.panels.length; ++i) {
                int offsetFromLockedIndex2;
                if (this.panels[i] == fp) continue;
                LayoutModel layoutModel2 = this.panels[i].getLayoutModel();
                BigInteger numIndexes2 = layoutModel2.getNumIndexes();
                BigInteger lockedLineIndex2 = this.lockedLineNumbers[i];
                Layout lockedLineLayout2 = layoutModel2.getLayout(lockedLineIndex2);
                if (lockedLineLayout2 == null) {
                    return;
                }
                int lockedLineHeight2 = lockedLineLayout2.getHeight();
                if (lockedLineIndex1.equals(topIndex1)) {
                    int difference = lockedLineHeight1 - lockedLineHeight2;
                    int yPos2 = yPos + difference;
                    this.panels[i].setViewerPosition(lockedLineIndex2, xPos, yPos2);
                    return;
                }
                int remainingOffset2 = offsetFromLockedIndex2 = offsetFromLockedIndex1 + (lockedLineHeight2 - lockedLineHeight1);
                BigInteger currentIndex2 = lockedLineIndex2;
                if (remainingOffset2 < 0) {
                    currentIndex2 = layoutModel2.getIndexBefore(currentIndex2);
                }
                while (currentIndex2 != null && currentIndex2.compareTo(BigInteger.ZERO) >= 0 && currentIndex2.compareTo(numIndexes2) < 0) {
                    Layout currentLayout2 = layoutModel2.getLayout(currentIndex2);
                    if (currentLayout2 == null) {
                        if (remainingOffset2 < 0) {
                            currentIndex2 = layoutModel2.getIndexBefore(currentIndex2);
                            continue;
                        }
                        if (remainingOffset2 > 0) {
                            currentIndex2 = layoutModel2.getIndexAfter(currentIndex2);
                            continue;
                        }
                        return;
                    }
                    int height = currentLayout2.getHeight();
                    if (remainingOffset2 == 0) {
                        this.panels[i].setViewerPosition(currentIndex2, xPos, 0);
                        return;
                    }
                    if (remainingOffset2 < 0) {
                        int offset = height + remainingOffset2;
                        if (offset >= 0) {
                            this.panels[i].setViewerPosition(currentIndex2, xPos, -offset);
                            return;
                        }
                        currentIndex2 = layoutModel2.getIndexBefore(currentIndex2);
                        remainingOffset2 = offset;
                        continue;
                    }
                    if (remainingOffset2 < height) {
                        this.panels[i].setViewerPosition(currentIndex2, xPos, -remainingOffset2);
                        return;
                    }
                    currentIndex2 = layoutModel2.getIndexAfter(currentIndex2);
                    remainingOffset2 -= height;
                }
            }
        }
        finally {
            this.valuesChanging = false;
        }
    }
}

