/*
 * Decompiled with CFR 0.152.
 */
package ghidra.server.remote;

import ghidra.util.Msg;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;

public class RMIClassServer
implements Runnable {
    private static RMIClassServer classServer;
    private ServerSocket server;
    private ArrayList<Thread> threads = new ArrayList();

    private RMIClassServer(int port) throws IOException {
        if (classServer != null) {
            throw new RuntimeException("Class server already running");
        }
        classServer = this;
        this.server = new ServerSocket(port);
        this.newListener();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispose() {
        Class<RMIClassServer> clazz = RMIClassServer.class;
        synchronized (RMIClassServer.class) {
            classServer = null;
            for (Thread t : this.threads) {
                t.interrupt();
            }
            if (this.server != null) {
                try {
                    this.server.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.server = null;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void newListener() {
        Class<RMIClassServer> clazz = RMIClassServer.class;
        synchronized (RMIClassServer.class) {
            if (classServer == this) {
                Thread t = new Thread((Runnable)this, "RMI Class Server");
                this.threads.add(t);
                t.start();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Socket socket = null;
        try {
            socket = this.server.accept();
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (InterruptedIOException interruptedIOException) {
        }
        catch (Throwable t) {
            Msg.error((Object)this, (Object)("Class server error: " + t.toString()), (Throwable)t);
        }
        Class<RMIClassServer> t = RMIClassServer.class;
        synchronized (RMIClassServer.class) {
            this.newListener();
            if (socket == null) {
                this.threads.remove(Thread.currentThread());
                // ** MonitorExit[t] (shouldn't be in output)
                return;
            }
            // ** MonitorExit[t] (shouldn't be in output)
            try {
                DataOutputStream out = new DataOutputStream(socket.getOutputStream());
                try {
                    DataInputStream in = new DataInputStream(socket.getInputStream());
                    String path = this.getClassName(in);
                    byte[] bytecodes = this.getBytes(path);
                    try {
                        out.writeBytes("HTTP/1.0 200 OK\r\n");
                        out.writeBytes("Content-Length: " + bytecodes.length + "\r\n");
                        out.writeBytes("Content-Type: application/java\r\n\r\n");
                        out.write(bytecodes);
                        out.flush();
                    }
                    catch (IOException ie) {
                        return;
                    }
                }
                catch (Exception e) {
                    out.writeBytes("HTTP/1.0 400 " + e.getMessage() + "\r\n");
                    out.writeBytes("Content-Type: text/html\r\n\r\n");
                    out.flush();
                }
            }
            catch (InterruptedIOException out) {
            }
            catch (Throwable t2) {
                Msg.error((Object)this, (Object)("error writing response: " + t2.getMessage()), (Throwable)t2);
            }
            try {
                socket.close();
            }
            catch (IOException iOException) {
                Class<RMIClassServer> clazz = RMIClassServer.class;
                synchronized (RMIClassServer.class) {
                    this.threads.remove(Thread.currentThread());
                    // ** MonitorExit[var2_9] (shouldn't be in output)
                }
            }
            finally {
                Class<RMIClassServer> clazz = RMIClassServer.class;
                synchronized (RMIClassServer.class) {
                    this.threads.remove(Thread.currentThread());
                    // ** MonitorExit[var2_5] (shouldn't be in output)
                }
            }
            {
                return;
            }
        }
    }

    private String getClassName(DataInputStream in) throws IOException {
        int index;
        String line = in.readLine();
        String path = "";
        if (line.startsWith("GET /") && (index = (line = line.substring(5, line.length() - 1).trim()).indexOf(".class")) != -1) {
            path = line.substring(0, index + 6);
        }
        while ((line = in.readLine()).length() != 0) {
        }
        if (path.length() != 0) {
            return path;
        }
        throw new IOException("Malformed Header");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] getBytes(String classname) throws IOException {
        InputStream istream = ClassLoader.getSystemResourceAsStream(classname);
        if (istream == null) {
            throw new IOException("Class not found");
        }
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            DataInputStream in = new DataInputStream(istream);
            byte[] buf = new byte[4096];
            int readLen = 0;
            while ((readLen = in.read(buf)) >= 0) {
                out.write(buf, 0, readLen);
            }
            byte[] byArray = out.toByteArray();
            return byArray;
        }
        finally {
            istream.close();
        }
    }

    static synchronized void startServer(int port) throws IOException {
        new RMIClassServer(port);
    }

    static synchronized void stopServer() {
        if (classServer != null) {
            Msg.info(RMIClassServer.class, (Object)"Stopping class server...");
            classServer.dispose();
        }
    }
}

