/*
 * Decompiled with CFR 0.152.
 */
package db;

import db.BinaryField;
import db.BooleanField;
import db.Buffer;
import db.ByteField;
import db.IllegalFieldAccessException;
import db.IndexField;
import db.IntField;
import db.LongField;
import db.ShortField;
import db.StringField;
import java.io.IOException;

public abstract class Field
implements Comparable<Field> {
    static final byte BYTE_TYPE = 0;
    static final byte SHORT_TYPE = 1;
    static final byte INT_TYPE = 2;
    static final byte LONG_TYPE = 3;
    static final byte STRING_TYPE = 4;
    static final byte BINARY_OBJ_TYPE = 5;
    static final byte BOOLEAN_TYPE = 6;
    static final byte TYPE_FLAG_MASK = -64;
    static final byte BASE_TYPE_MASK = 63;
    static final byte INDEX_TYPE_FLAG = -128;

    public long getLongValue() {
        throw new IllegalFieldAccessException();
    }

    public void setLongValue(long value) {
        throw new IllegalFieldAccessException();
    }

    public int getIntValue() {
        throw new IllegalFieldAccessException();
    }

    public void setIntValue(int value) {
        throw new IllegalFieldAccessException();
    }

    public short getShortValue() {
        throw new IllegalFieldAccessException();
    }

    public void setShortValue(short value) {
        throw new IllegalFieldAccessException();
    }

    public byte getByteValue() {
        throw new IllegalFieldAccessException();
    }

    public void setByteValue(byte value) {
        throw new IllegalFieldAccessException();
    }

    public boolean getBooleanValue() {
        throw new IllegalFieldAccessException();
    }

    public void setBooleanValue(boolean value) {
        throw new IllegalFieldAccessException();
    }

    public abstract byte[] getBinaryData();

    public void setBinaryData(byte[] bytes) {
        throw new IllegalFieldAccessException();
    }

    public String getString() {
        throw new IllegalFieldAccessException();
    }

    public void setString(String str) {
        throw new IllegalFieldAccessException();
    }

    void truncate(int length) {
        throw new IllegalFieldAccessException();
    }

    public boolean isVariableLength() {
        return false;
    }

    public abstract Field newField(Field var1);

    public abstract Field newField();

    protected abstract byte getFieldType();

    abstract int write(Buffer var1, int var2) throws IOException;

    abstract int read(Buffer var1, int var2) throws IOException;

    abstract int readLength(Buffer var1, int var2) throws IOException;

    abstract int length();

    public abstract boolean equals(Object var1);

    public abstract int hashCode();

    public abstract String getValueAsString();

    static Field getField(byte fieldType) throws UnsupportedFieldException {
        if ((fieldType & 0xFFFFFF80) == 0) {
            switch (fieldType & 0x3F) {
                case 3: {
                    return new LongField();
                }
                case 2: {
                    return new IntField();
                }
                case 4: {
                    return new StringField();
                }
                case 1: {
                    return new ShortField();
                }
                case 0: {
                    return new ByteField();
                }
                case 6: {
                    return new BooleanField();
                }
                case 5: {
                    return new BinaryField();
                }
            }
        } else {
            return IndexField.getIndexField(fieldType);
        }
        throw new UnsupportedFieldException(fieldType);
    }

    public static class UnsupportedFieldException
    extends IOException {
        UnsupportedFieldException(byte fieldType) {
            super("Unsupported DB field type: 0x" + Integer.toHexString(fieldType & 0xFF));
        }
    }
}

