/*
 * Decompiled with CFR 0.152.
 */
package db;

import db.Buffer;
import db.Field;
import java.io.IOException;
import java.util.Arrays;

public class BinaryField
extends Field {
    protected byte[] data;

    public BinaryField() {
    }

    public BinaryField(byte[] data) {
        this.data = data;
    }

    @Override
    public byte[] getBinaryData() {
        return this.data;
    }

    @Override
    public void setBinaryData(byte[] data) {
        this.data = data;
    }

    @Override
    int length() {
        return this.data == null ? 4 : this.data.length + 4;
    }

    @Override
    int write(Buffer buf, int offset) throws IOException {
        if (this.data == null) {
            return buf.putInt(offset, -1);
        }
        offset = buf.putInt(offset, this.data.length);
        return buf.put(offset, this.data);
    }

    @Override
    int read(Buffer buf, int offset) throws IOException {
        int len = buf.getInt(offset);
        offset += 4;
        if (len < 0) {
            this.data = null;
        } else {
            this.data = buf.get(offset, len);
            offset += len;
        }
        return offset;
    }

    @Override
    int readLength(Buffer buf, int offset) throws IOException {
        int len = buf.getInt(offset);
        return (len < 0 ? 0 : len) + 4;
    }

    @Override
    public boolean isVariableLength() {
        return true;
    }

    @Override
    protected byte getFieldType() {
        return 5;
    }

    public String toString() {
        if (this.data == null) {
            return "BinaryField: null";
        }
        return "BinaryField[" + this.data.length + "] = " + this.getValueAsString();
    }

    @Override
    public String getValueAsString() {
        int i;
        StringBuffer buf = new StringBuffer();
        for (i = 0; i < 24 && i < this.data.length; ++i) {
            String b = Integer.toHexString(this.data[i] & 0xFF);
            if (b.length() == 1) {
                buf.append('0');
            }
            buf.append(b);
            buf.append(' ');
        }
        if (i < this.data.length) {
            buf.append("...");
        }
        return buf.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof BinaryField)) {
            return false;
        }
        BinaryField f = (BinaryField)obj;
        return Arrays.equals(f.data, this.data);
    }

    @Override
    void truncate(int length) {
        int maxLen = length - 4;
        if (this.data != null && this.data.length > maxLen) {
            byte[] newData = new byte[maxLen];
            System.arraycopy(this.data, 0, newData, 0, maxLen);
            this.data = newData;
        }
    }

    @Override
    public int compareTo(Field o) {
        BinaryField f = (BinaryField)o;
        if (this.data == null) {
            if (f.data == null) {
                return 0;
            }
            return -1;
        }
        if (f.data == null) {
            return 1;
        }
        int len1 = this.data.length;
        int len2 = f.data.length;
        int offset1 = 0;
        int offset2 = 0;
        int n = Math.min(len1, len2);
        while (n-- != 0) {
            int b2;
            int b1;
            if ((b1 = this.data[offset1++] & 0xFF) == (b2 = f.data[offset2++] & 0xFF)) continue;
            return b1 - b2;
        }
        return len1 - len2;
    }

    @Override
    public Field newField(Field fieldValue) {
        return new BinaryField(fieldValue.getBinaryData());
    }

    @Override
    public Field newField() {
        return new BinaryField();
    }

    @Override
    public int hashCode() {
        return this.data.hashCode();
    }
}

