/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.hfsexplorer.tools;

import java.io.File;
import java.io.FileOutputStream;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.JOptionPane;
import javax.swing.UIManager;
import org.catacombae.hfsexplorer.GUIUtil;
import org.catacombae.hfsexplorer.PartitionSystemRecognizer;
import org.catacombae.hfsexplorer.SelectWindowsDeviceDialog;
import org.catacombae.hfsexplorer.partitioning.ApplePartitionMap;
import org.catacombae.hfsexplorer.partitioning.GUIDPartitionTable;
import org.catacombae.hfsexplorer.partitioning.MBRPartitionTable;
import org.catacombae.hfsexplorer.partitioning.Partition;
import org.catacombae.hfsexplorer.partitioning.PartitionSystem;
import org.catacombae.hfsexplorer.win32.WindowsLowLevelIO;
import org.catacombae.io.ReadableFileStream;
import org.catacombae.io.ReadableRandomAccessStream;
import org.catacombae.jparted.lib.ps.PartitionType;

public class DumpFSInfo {
    public static void main(String[] args) throws Throwable {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Throwable e) {
            // empty catch block
        }
        try {
            DumpFSInfo.dumpInfo(args);
            System.exit(0);
        }
        catch (Exception e) {
            GUIUtil.displayExceptionDialog((Throwable)e, (int)25, null);
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw t;
        }
        System.exit(1);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void dumpInfo(String[] args) throws Exception {
        long pos;
        File last64File;
        File first64File;
        long fsLength;
        long fsOffset;
        int partNum;
        LinkedList<File> generatedFiles;
        WindowsLowLevelIO fsFile;
        long runTimestamp;
        block27: {
            int i;
            int firstPreferredPartition;
            Object[] partitions;
            PartitionSystem partSys;
            block28: {
                block25: {
                    File mbrFile;
                    FileOutputStream fos;
                    block26: {
                        block24: {
                            block23: {
                                runTimestamp = System.currentTimeMillis();
                                if (!WindowsLowLevelIO.isSystemSupported()) break block23;
                                if (args.length == 1) {
                                    fsFile = new WindowsLowLevelIO(args[0]);
                                    break block24;
                                } else {
                                    if (args.length != 0) {
                                        System.out.println("Usage: java DumpFSInfo <filename>");
                                        System.out.println("        for reading directly from a specified file, or...");
                                        System.out.println("       java DumpFSInfo");
                                        System.out.println("        to pop up a Windows device dialog where you can choose which device to read");
                                        return;
                                    }
                                    SelectWindowsDeviceDialog swdd = new SelectWindowsDeviceDialog(null, true, "Select device to extract info from");
                                    swdd.setVisible(true);
                                    fsFile = swdd.getPartitionStream();
                                    if (fsFile == null) {
                                        System.exit(0);
                                    }
                                }
                                break block24;
                            }
                            if (args.length != 1) {
                                System.out.println("Usage: java DumpFSInfo <filename>");
                                return;
                            }
                            fsFile = new ReadableFileStream(args[0]);
                        }
                        generatedFiles = new LinkedList<File>();
                        partNum = -1;
                        PartitionSystemRecognizer psr = new PartitionSystemRecognizer(fsFile);
                        partSys = psr.getPartitionSystem();
                        if (partSys == null) break block25;
                        partitions = partSys.getUsedPartitionEntries();
                        if (partitions.length != 0) break block26;
                        fsOffset = 0L;
                        try {
                            fsLength = fsFile.length();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            fsLength = -1L;
                        }
                        break block27;
                    }
                    if (partSys instanceof ApplePartitionMap) {
                        ApplePartitionMap apm = (ApplePartitionMap)partSys;
                        File ddrFile = new File("fsdump-" + runTimestamp + "_ddr.dat");
                        byte[] ddrData = new byte[512];
                        fos = new FileOutputStream(ddrFile);
                        fsFile.seek(0L);
                        fsFile.readFully(ddrData);
                        fos.write(ddrData);
                        fos.close();
                        generatedFiles.add(ddrFile);
                        File apmFile = new File("fsdump-" + runTimestamp + "_apm.dat");
                        fos = new FileOutputStream(apmFile);
                        fos.write(apm.getData());
                        fos.close();
                        generatedFiles.add(apmFile);
                    } else if (partSys instanceof GUIDPartitionTable) {
                        GUIDPartitionTable gpt = (GUIDPartitionTable)partSys;
                        mbrFile = new File("fsdump-" + runTimestamp + "_protectivembr.dat");
                        byte[] mbrData = new byte[512];
                        fos = new FileOutputStream(mbrFile);
                        fsFile.seek(0L);
                        fsFile.readFully(mbrData);
                        fos.write(mbrData);
                        fos.close();
                        generatedFiles.add(mbrFile);
                        File gptBeginFile = new File("fsdump-" + runTimestamp + "_gptprimary.dat");
                        fos = new FileOutputStream(gptBeginFile);
                        fos.write(gpt.getPrimaryTableBytes());
                        fos.close();
                        generatedFiles.add(gptBeginFile);
                        File gptEndFile = new File("fsdump-" + runTimestamp + "_gptbackup.dat");
                        fos = new FileOutputStream(gptEndFile);
                        fos.write(gpt.getBackupTableBytes());
                        fos.close();
                        generatedFiles.add(gptEndFile);
                    } else {
                        if (!(partSys instanceof MBRPartitionTable)) {
                            throw new RuntimeException("Unknown partition system type!");
                        }
                        MBRPartitionTable mbr = (MBRPartitionTable)partSys;
                        mbrFile = new File("fsdump-" + runTimestamp + "_mbr.dat");
                        FileOutputStream fos2 = new FileOutputStream(mbrFile);
                        fos2.write(mbr.getMasterBootRecord().getBytes());
                        fos2.close();
                        generatedFiles.add(mbrFile);
                    }
                    firstPreferredPartition = 0;
                    break block28;
                }
                fsOffset = 0L;
                try {
                    fsLength = fsFile.length();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    fsLength = -1L;
                }
                break block27;
            }
            for (i = 0; i < partitions.length; ++i) {
                Partition p = partitions[i];
                PartitionType pt = p.getType();
                if (pt != PartitionType.APPLE_HFS_CONTAINER && pt != PartitionType.APPLE_HFSX) continue;
                firstPreferredPartition = i;
                break;
            }
            Object selectedValue = JOptionPane.showInputDialog(null, "Select which partition to read", "Choose " + partSys.getLongName() + " partition", 3, null, partitions, partitions[firstPreferredPartition]);
            for (i = 0; i < partitions.length; ++i) {
                if (partitions[i] != selectedValue) continue;
                partNum = i;
                break;
            }
            if (!(selectedValue instanceof Partition)) {
                throw new RuntimeException("Impossible error!");
            }
            Partition selectedPartition = (Partition)selectedValue;
            fsOffset = selectedPartition.getStartOffset();
            fsLength = selectedPartition.getLength();
        }
        byte[] buffer = new byte[65536];
        if (partNum == -1) {
            first64File = new File("fsdump-" + runTimestamp + "_first64.dat");
            last64File = new File("fsdump-" + runTimestamp + "_last64.dat");
        } else {
            first64File = new File("fsdump-" + runTimestamp + "_p" + partNum + "_first64.dat");
            last64File = new File("fsdump-" + runTimestamp + "_p" + partNum + "_last64.dat");
        }
        if (DumpFSInfo.extractDataToFile(fsFile, fsOffset, first64File, 65536)) {
            generatedFiles.add(first64File);
        }
        if ((pos = fsOffset + fsLength - (long)buffer.length) > fsOffset && DumpFSInfo.extractDataToFile(fsFile, pos, last64File, 65536)) {
            generatedFiles.add(last64File);
        }
        StringBuilder sb = new StringBuilder();
        sb.append("Dumped FS info to directory:\n    ");
        File firstFile = ((File)generatedFiles.getFirst()).getAbsoluteFile();
        File firstParent = firstFile.getParentFile();
        sb.append(firstParent.getAbsolutePath());
        sb.append("\nThe following files were generated:\n    ");
        Iterator i$ = generatedFiles.iterator();
        while (true) {
            if (!i$.hasNext()) {
                JOptionPane.showMessageDialog(null, sb.toString(), "Result", 1);
                return;
            }
            File f = (File)i$.next();
            sb.append(f.toString() + "\n    ");
        }
    }

    private static boolean extractDataToFile(ReadableRandomAccessStream fsFile, long pos, File outFile, int dataSize) {
        try {
            byte[] buffer = new byte[dataSize];
            fsFile.seek(pos);
            int bytesRead = fsFile.read(buffer);
            FileOutputStream fileOut = new FileOutputStream(outFile);
            fileOut.write(buffer, 0, bytesRead);
            fileOut.close();
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }
}

