/*
 * Decompiled with CFR 0.152.
 */
package ghidra.test.processors.support;

import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolUtilities;
import ghidra.test.processors.support.PCodeTestControlBlock;
import ghidra.test.processors.support.PCodeTestGroupControlBlock;
import ghidra.test.processors.support.TestLogger;
import ghidra.util.Msg;
import java.util.ArrayList;
import java.util.List;

public class PCodeTestGroup
implements Comparable<PCodeTestGroup> {
    public static final String FUNCTION_NAME_PREFIX = "main_";
    public final String testGroupName;
    public final Address functionEntryPtr;
    public final PCodeTestControlBlock mainTestControlBlock;
    public final PCodeTestGroupControlBlock controlBlock;
    private ArrayList<String> testFailures = new ArrayList();

    PCodeTestGroup(PCodeTestGroupControlBlock controlBlock) {
        this.testGroupName = controlBlock.getTestGroupName();
        this.functionEntryPtr = controlBlock.getTestGroupMainAddress();
        this.controlBlock = controlBlock;
        this.mainTestControlBlock = controlBlock.mainTestControlBlock;
    }

    public String toString() {
        return this.testGroupName + "@" + this.functionEntryPtr;
    }

    void testPassed(String testName, String errFileName, int errLineNum, Program program, TestLogger logger) {
        this.mainTestControlBlock.getTestResults().addPassResult(this.testGroupName, testName);
    }

    void testFailed(String testName, String errFileName, int errLineNum, boolean callOtherFailure, Program program, TestLogger logger) {
        if (callOtherFailure) {
            this.mainTestControlBlock.getTestResults().addCallOtherResult(this.testGroupName, testName);
        } else {
            this.mainTestControlBlock.getTestResults().addFailResult(this.testGroupName, testName);
        }
        Object failure = testName;
        if (testName != null) {
            Symbol symbol = SymbolUtilities.getLabelOrFunctionSymbol((Program)program, (String)testName, err -> Msg.error((Object)this, (Object)err));
            if (symbol != null) {
                failure = (String)failure + " @ " + symbol.getAddress().toString(true);
            }
            failure = (String)failure + " (" + errFileName + ":" + errLineNum + ")";
        }
        this.testFailures.add((String)failure);
        logger.log(this, "Test Failed: " + (String)failure + (callOtherFailure ? " (callother error)" : ""));
    }

    void severeTestFailure(String testName, String errFileName, int errLineNum, Program program, TestLogger logger) {
        this.mainTestControlBlock.getTestResults().addSevereFailResult(this.testGroupName, testName);
        this.testFailed(testName, errFileName, errLineNum, false, program, logger);
    }

    void clearFailures() {
        this.testFailures.clear();
    }

    public List<String> getTestFailures() {
        return new ArrayList<String>(this.testFailures);
    }

    public int hashCode() {
        return this.testGroupName.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof PCodeTestGroup)) {
            return false;
        }
        PCodeTestGroup other = (PCodeTestGroup)obj;
        return this.controlBlock == other.controlBlock && this.testGroupName.equals(other.testGroupName);
    }

    @Override
    public int compareTo(PCodeTestGroup o) {
        return this.testGroupName.compareTo(o.testGroupName);
    }
}

