/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.xml;

import ghidra.app.util.importer.MessageLog;
import ghidra.framework.options.CustomOption;
import ghidra.framework.options.OptionType;
import ghidra.framework.options.Options;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressFactory;
import ghidra.program.model.address.AddressFormatException;
import ghidra.program.model.address.AddressIterator;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Bookmark;
import ghidra.program.model.listing.BookmarkManager;
import ghidra.program.model.listing.Program;
import ghidra.program.model.util.IntPropertyMap;
import ghidra.program.model.util.LongPropertyMap;
import ghidra.program.model.util.PropertyMap;
import ghidra.program.model.util.PropertyMapManager;
import ghidra.program.model.util.StringPropertyMap;
import ghidra.program.model.util.VoidPropertyMap;
import ghidra.util.XmlProgramUtilities;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.NoValueException;
import ghidra.util.task.TaskMonitor;
import ghidra.util.xml.XmlAttributes;
import ghidra.util.xml.XmlUtilities;
import ghidra.util.xml.XmlWriter;
import ghidra.xml.XmlElement;
import ghidra.xml.XmlPullParser;
import java.awt.Color;
import java.awt.Font;
import java.io.File;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.KeyStroke;
import org.xml.sax.SAXParseException;

class PropertiesXmlMgr {
    private static final String PROPERTY_LIST_CATEGORY_DELIMITER = Options.DELIMITER_STRING;
    private Program program;
    private PropertyMapManager propMapMgr;
    private AddressFactory factory;
    private MessageLog log;

    PropertiesXmlMgr(Program program, MessageLog log) {
        this.program = program;
        this.propMapMgr = program.getUsrPropertyManager();
        this.factory = program.getAddressFactory();
        this.log = log;
    }

    void read(XmlPullParser parser, boolean overwrite, TaskMonitor monitor) throws SAXParseException, CancelledException {
        XmlElement element = parser.next();
        if (!element.isStart() || !element.getName().equals("PROPERTIES")) {
            throw new SAXParseException("Expected PROPERTIES start tag", null, null, parser.getLineNumber(), parser.getColumnNumber());
        }
        element = parser.next();
        while (element.getName().equals("PROPERTY")) {
            if (monitor.isCancelled()) {
                throw new CancelledException();
            }
            this.processProperty(element, parser, overwrite);
            element = parser.next();
        }
        if (element.isStart() || !element.getName().equals("PROPERTIES")) {
            throw new SAXParseException("Expected PROPERTY element or PROPERTIES end tag", null, null, parser.getLineNumber(), parser.getColumnNumber());
        }
    }

    private void processProperty(XmlElement element, XmlPullParser parser, boolean overwrite) throws SAXParseException {
        String name = element.getAttribute("NAME");
        if (name == null) {
            throw new SAXParseException("NAME attribute missing for PROPERTY element", null, null, parser.getLineNumber(), parser.getColumnNumber());
        }
        String addrStr = element.getAttribute("ADDRESS");
        try {
            if (addrStr != null) {
                Address addr = XmlProgramUtilities.parseAddress((AddressFactory)this.factory, (String)addrStr);
                if (addr == null) {
                    throw new AddressFormatException("Incompatible Property [" + name + "] Address " + addrStr + " at Line: " + parser.getLineNumber());
                }
                this.processPropertyMapEntry(addr, name, element, overwrite, parser);
            } else {
                this.processPropertyListEntry(name, element, overwrite);
            }
        }
        catch (Exception e) {
            this.log.appendException((Throwable)e);
            parser.discardSubTree(element);
            return;
        }
        element = parser.next();
        if (element.isStart() || !element.getName().equals("PROPERTY")) {
            throw new SAXParseException("Expected PROPERTY end tag", null, null, parser.getLineNumber(), parser.getColumnNumber());
        }
    }

    private void processPropertyMapEntry(Address addr, String name, XmlElement element, boolean overwrite, XmlPullParser parser) throws Exception {
        PropertyMap map;
        String type = element.getAttribute("TYPE");
        if (type != null) {
            type = type.toLowerCase();
        }
        if (!overwrite && !"bookmarks".equals(type) && (map = this.propMapMgr.getPropertyMap(name)) != null && map.hasProperty(addr)) {
            this.log.appendMsg("Conflicting '" + name + "' PROPERTY ignored at: " + addr);
            return;
        }
        if (type == null || "void".equals(type)) {
            VoidPropertyMap voidMap;
            if (element.getAttribute("VALUE") != null) {
                this.log.appendMsg("VALUE attribute ignored for void property");
            }
            if ((voidMap = this.propMapMgr.getVoidPropertyMap(name)) == null) {
                voidMap = this.propMapMgr.createVoidPropertyMap(name);
            }
            voidMap.add(addr);
        } else if ("int".equals(type)) {
            int value = XmlUtilities.parseInt((String)element.getAttribute("VALUE"));
            IntPropertyMap intMap = this.propMapMgr.getIntPropertyMap(name);
            if (intMap == null) {
                intMap = this.propMapMgr.createIntPropertyMap(name);
            }
            intMap.add(addr, value);
        } else if ("long".equals(type)) {
            long value = XmlUtilities.parseLong((String)element.getAttribute("VALUE"));
            LongPropertyMap longMap = this.propMapMgr.getLongPropertyMap(name);
            if (longMap == null) {
                longMap = this.propMapMgr.createLongPropertyMap(name);
            }
            longMap.add(addr, value);
        } else if ("string".equals(type)) {
            String str = element.getAttribute("VALUE");
            StringPropertyMap strMap = this.propMapMgr.getStringPropertyMap(name);
            if (strMap == null) {
                strMap = this.propMapMgr.createStringPropertyMap(name);
            }
            strMap.add(addr, str);
        } else if ("bookmarks".equals(type)) {
            Bookmark[] bookmarks;
            BookmarkManager bmMgr = this.program.getBookmarkManager();
            if (!overwrite && (bookmarks = bmMgr.getBookmarks(addr, "Note")).length != 0) {
                this.log.appendMsg("Conflicting BOOKMARK ignored at: " + addr);
                return;
            }
            bmMgr.setBookmark(addr, "Note", name, element.getAttribute("VALUE"));
        } else {
            this.log.appendMsg("Unsupported PROPERTY usage");
        }
    }

    private String getPropertyList(String path) {
        StringTokenizer st = new StringTokenizer(path, PROPERTY_LIST_CATEGORY_DELIMITER);
        if (st.hasMoreElements()) {
            return st.nextToken();
        }
        return null;
    }

    private String getPropertyName(String path) {
        int ix = path.indexOf(PROPERTY_LIST_CATEGORY_DELIMITER);
        if (ix >= 0) {
            if (path.length() > ix + 1) {
                return path.substring(ix + 1);
            }
            return null;
        }
        return path;
    }

    private void processPropertyListEntry(String pathname, XmlElement element, boolean overwrite) throws Exception {
        String listName = this.getPropertyList(pathname);
        String name = this.getPropertyName(pathname);
        if (listName == null || name == null) {
            this.log.appendMsg("Property NAME attribute must contain both category prefix and property name");
            return;
        }
        Options list = this.program.getOptions(listName);
        if (!overwrite && list.contains(name)) {
            this.log.appendMsg("Conflicting PROPERTY ignored: " + pathname);
            return;
        }
        String type = element.getAttribute("TYPE");
        if (type != null) {
            type = type.toLowerCase();
        }
        if (type == null || "void".equals(type)) {
            this.log.appendMsg("Unsupported PROPERTY usage");
        } else if ("int".equals(type)) {
            int value = XmlUtilities.parseInt((String)element.getAttribute("VALUE"));
            list.setInt(name, value);
        } else if ("long".equals(type)) {
            long value = XmlUtilities.parseLong((String)element.getAttribute("VALUE"));
            list.setLong(name, value);
        } else if ("double".equals(type)) {
            double value = Double.parseDouble(element.getAttribute("VALUE"));
            list.setDouble(name, value);
        } else if ("float".equals(type)) {
            float value = Float.parseFloat(element.getAttribute("VALUE"));
            list.setFloat(name, value);
        } else if ("bool".equals(type)) {
            boolean value = XmlUtilities.parseBoolean((String)element.getAttribute("VALUE"));
            list.setBoolean(name, value);
        } else if ("string".equals(type)) {
            String str = element.getAttribute("VALUE");
            list.setString(name, str);
        } else if ("date".equals(type)) {
            long value = XmlUtilities.parseLong((String)element.getAttribute("VALUE"));
            list.setDate(name, new Date(value));
        } else if ("color".equals(type)) {
            Color color = new Color(XmlUtilities.parseInt((String)element.getAttribute("VALUE")));
            list.setColor(name, color);
        } else if ("file".equals(type)) {
            File file = new File(element.getAttribute("VALUE"));
            list.setFile(name, file);
        } else if ("enum".equals(type)) {
            String escapedXML = element.getAttribute("VALUE");
            String xmlString = XmlUtilities.unEscapeElementEntities((String)escapedXML);
            Enum enuum = (Enum)OptionType.ENUM_TYPE.convertStringToObject(xmlString);
            list.setEnum(name, enuum);
        } else if ("font".equals(type)) {
            String escapedXML = element.getAttribute("VALUE");
            String xmlString = XmlUtilities.unEscapeElementEntities((String)escapedXML);
            Font font = (Font)OptionType.FONT_TYPE.convertStringToObject(xmlString);
            list.setFont(name, font);
        } else if ("keyStroke".equals(type)) {
            String escapedXML = element.getAttribute("VALUE");
            String xmlString = XmlUtilities.unEscapeElementEntities((String)escapedXML);
            KeyStroke keyStroke = (KeyStroke)OptionType.KEYSTROKE_TYPE.convertStringToObject(xmlString);
            list.setKeyStroke(name, keyStroke);
        } else if ("custom".equals(type)) {
            String escapedXML = element.getAttribute("VALUE");
            String xmlString = XmlUtilities.unEscapeElementEntities((String)escapedXML);
            CustomOption custom = (CustomOption)OptionType.CUSTOM_TYPE.convertStringToObject(xmlString);
            list.setCustomOption(name, custom);
        } else if ("bytes".equals(type)) {
            String escapedXML = element.getAttribute("VALUE");
            String xmlString = XmlUtilities.unEscapeElementEntities((String)escapedXML);
            byte[] bytes = (byte[])OptionType.BYTE_ARRAY_TYPE.convertStringToObject(xmlString);
            list.setByteArray(name, bytes);
        } else {
            this.log.appendMsg("Unsupported PROPERTY usage");
        }
    }

    void readV1(XmlPullParser parser, boolean overwrite, TaskMonitor monitor) throws SAXParseException, CancelledException {
        this.read(parser, overwrite, monitor);
    }

    void write(XmlWriter writer, AddressSetView set, TaskMonitor monitor) throws CancelledException {
        monitor.setMessage("Writing PROPERTIES ...");
        writer.startElement("PROPERTIES");
        this.writePropertyMaps(writer, set, monitor);
        this.writePropertyLists(writer, monitor);
        writer.endElement("PROPERTIES");
    }

    private void writePropertyLists(XmlWriter writer, TaskMonitor monitor) throws CancelledException {
        List listNames = this.program.getOptionsNames();
        Collections.sort(listNames);
        for (int i = 0; i < listNames.size(); ++i) {
            Options propList = this.program.getOptions((String)listNames.get(i));
            List propNames = propList.getOptionNames();
            Collections.sort(propNames);
            String prefix = (String)listNames.get(i) + PROPERTY_LIST_CATEGORY_DELIMITER;
            for (String name : propNames) {
                if (monitor.isCancelled()) {
                    throw new CancelledException();
                }
                if (propList.isAlias(name) || propList.isDefaultValue(name)) continue;
                OptionType type = propList.getType(name);
                XmlAttributes attrs = new XmlAttributes();
                attrs.addAttribute("NAME", prefix + name);
                switch (type) {
                    case INT_TYPE: {
                        attrs.addAttribute("TYPE", "int");
                        attrs.addAttribute("VALUE", propList.getInt(name, 0), true);
                        break;
                    }
                    case LONG_TYPE: {
                        attrs.addAttribute("TYPE", "long");
                        attrs.addAttribute("VALUE", propList.getLong(name, 0L), true);
                        break;
                    }
                    case STRING_TYPE: {
                        attrs.addAttribute("TYPE", "string");
                        attrs.addAttribute("VALUE", propList.getString(name, ""));
                        break;
                    }
                    case BOOLEAN_TYPE: {
                        attrs.addAttribute("TYPE", "bool");
                        attrs.addAttribute("VALUE", propList.getBoolean(name, true));
                        break;
                    }
                    case DOUBLE_TYPE: {
                        attrs.addAttribute("TYPE", "double");
                        attrs.addAttribute("VALUE", propList.getDouble(name, 0.0));
                        break;
                    }
                    case FLOAT_TYPE: {
                        attrs.addAttribute("TYPE", "float");
                        attrs.addAttribute("VALUE", propList.getFloat(name, 0.0f));
                        break;
                    }
                    case DATE_TYPE: {
                        attrs.addAttribute("TYPE", "date");
                        Date date = propList.getDate(name, (Date)null);
                        long time = date == null ? 0L : date.getTime();
                        attrs.addAttribute("VALUE", time, true);
                        break;
                    }
                    case COLOR_TYPE: {
                        attrs.addAttribute("TYPE", "color");
                        Color color = propList.getColor(name, null);
                        int rgb = color.getRGB();
                        attrs.addAttribute("VALUE", rgb, true);
                        break;
                    }
                    case ENUM_TYPE: {
                        attrs.addAttribute("TYPE", "enum");
                        Enum enuum = propList.getEnum(name, null);
                        String xmlString = OptionType.ENUM_TYPE.convertObjectToString((Object)enuum);
                        attrs.addAttribute("VALUE", XmlUtilities.escapeElementEntities((String)xmlString));
                        break;
                    }
                    case FILE_TYPE: {
                        attrs.addAttribute("TYPE", "file");
                        File file = propList.getFile(name, null);
                        String path = file.getAbsolutePath();
                        attrs.addAttribute("VALUE", path);
                        break;
                    }
                    case FONT_TYPE: {
                        attrs.addAttribute("TYPE", "font");
                        Font font = propList.getFont(name, null);
                        String xmlString = OptionType.FONT_TYPE.convertObjectToString((Object)font);
                        attrs.addAttribute("VALUE", XmlUtilities.escapeElementEntities((String)xmlString));
                        break;
                    }
                    case KEYSTROKE_TYPE: {
                        attrs.addAttribute("TYPE", "keyStroke");
                        KeyStroke keyStroke = propList.getKeyStroke(name, null);
                        String xmlString = OptionType.KEYSTROKE_TYPE.convertObjectToString((Object)keyStroke);
                        attrs.addAttribute("VALUE", XmlUtilities.escapeElementEntities((String)xmlString));
                        break;
                    }
                    case CUSTOM_TYPE: {
                        attrs.addAttribute("TYPE", "custom");
                        CustomOption custom = propList.getCustomOption(name, null);
                        String xmlString = OptionType.KEYSTROKE_TYPE.convertObjectToString((Object)custom);
                        attrs.addAttribute("VALUE", XmlUtilities.escapeElementEntities((String)xmlString));
                        break;
                    }
                    case BYTE_ARRAY_TYPE: {
                        attrs.addAttribute("TYPE", "bytes");
                        byte[] bytes = propList.getByteArray(name, null);
                        String xmlString = OptionType.BYTE_ARRAY_TYPE.convertObjectToString((Object)bytes);
                        attrs.addAttribute("VALUE", XmlUtilities.escapeElementEntities((String)xmlString));
                        break;
                    }
                    default: {
                        throw new AssertException();
                    }
                }
                writer.startElement("PROPERTY", attrs);
                writer.endElement("PROPERTY");
            }
        }
    }

    private void writePropertyMaps(XmlWriter writer, AddressSetView set, TaskMonitor monitor) throws CancelledException {
        Iterator mapNames = this.propMapMgr.propertyManagers();
        while (mapNames.hasNext()) {
            if (monitor.isCancelled()) {
                throw new CancelledException();
            }
            String mapName = (String)mapNames.next();
            PropertyMap map = this.propMapMgr.getPropertyMap(mapName);
            if (map instanceof VoidPropertyMap) {
                this.writeVoidMap((VoidPropertyMap)map, writer, set, monitor);
                continue;
            }
            if (map instanceof IntPropertyMap) {
                this.writeIntMap((IntPropertyMap)map, writer, set, monitor);
                continue;
            }
            if (map instanceof LongPropertyMap) {
                this.writeLongMap((LongPropertyMap)map, writer, set, monitor);
                continue;
            }
            if (!(map instanceof StringPropertyMap)) continue;
            this.writeStringMap((StringPropertyMap)map, writer, set, monitor);
        }
    }

    private void writeStringMap(StringPropertyMap map, XmlWriter writer, AddressSetView set, TaskMonitor monitor) throws CancelledException {
        AddressIterator iter;
        AddressIterator addressIterator = iter = set != null ? map.getPropertyIterator(set) : map.getPropertyIterator();
        while (iter.hasNext()) {
            if (monitor.isCancelled()) {
                throw new CancelledException();
            }
            Address addr = iter.next();
            String value = map.getString(addr);
            XmlAttributes attrs = new XmlAttributes();
            attrs.addAttribute("NAME", map.getName());
            attrs.addAttribute("ADDRESS", XmlProgramUtilities.toString((Address)addr));
            attrs.addAttribute("TYPE", "string");
            attrs.addAttribute("VALUE", value);
            writer.startElement("PROPERTY", attrs);
            writer.endElement("PROPERTY");
        }
    }

    private void writeLongMap(LongPropertyMap map, XmlWriter writer, AddressSetView set, TaskMonitor monitor) throws CancelledException {
        AddressIterator iter;
        AddressIterator addressIterator = iter = set != null ? map.getPropertyIterator(set) : map.getPropertyIterator();
        while (iter.hasNext()) {
            if (monitor.isCancelled()) {
                throw new CancelledException();
            }
            try {
                Address addr = iter.next();
                long value = map.getLong(addr);
                XmlAttributes attrs = new XmlAttributes();
                attrs.addAttribute("NAME", map.getName());
                attrs.addAttribute("ADDRESS", XmlProgramUtilities.toString((Address)addr));
                attrs.addAttribute("TYPE", "long");
                attrs.addAttribute("VALUE", value, true);
                writer.startElement("PROPERTY", attrs);
                writer.endElement("PROPERTY");
            }
            catch (NoValueException noValueException) {}
        }
    }

    private void writeIntMap(IntPropertyMap map, XmlWriter writer, AddressSetView set, TaskMonitor monitor) throws CancelledException {
        AddressIterator iter;
        AddressIterator addressIterator = iter = set != null ? map.getPropertyIterator(set) : map.getPropertyIterator();
        while (iter.hasNext()) {
            if (monitor.isCancelled()) {
                throw new CancelledException();
            }
            try {
                Address addr = iter.next();
                int value = map.getInt(addr);
                XmlAttributes attrs = new XmlAttributes();
                attrs.addAttribute("NAME", map.getName());
                attrs.addAttribute("ADDRESS", XmlProgramUtilities.toString((Address)addr));
                attrs.addAttribute("TYPE", "int");
                attrs.addAttribute("VALUE", value, true);
                writer.startElement("PROPERTY", attrs);
                writer.endElement("PROPERTY");
            }
            catch (NoValueException noValueException) {}
        }
    }

    private void writeVoidMap(VoidPropertyMap map, XmlWriter writer, AddressSetView set, TaskMonitor monitor) throws CancelledException {
        AddressIterator iter;
        AddressIterator addressIterator = iter = set != null ? map.getPropertyIterator(set) : map.getPropertyIterator();
        while (iter.hasNext()) {
            if (monitor.isCancelled()) {
                throw new CancelledException();
            }
            Address addr = iter.next();
            XmlAttributes attrs = new XmlAttributes();
            attrs.addAttribute("NAME", map.getName());
            attrs.addAttribute("ADDRESS", XmlProgramUtilities.toString((Address)addr));
            attrs.addAttribute("TYPE", "void");
            writer.startElement("PROPERTY", attrs);
            writer.endElement("PROPERTY");
        }
    }
}

