/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.viewer.field;

import ghidra.app.util.viewer.field.BrowserCodeUnitFormat;
import ghidra.framework.options.ToolOptions;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.DataType;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolUtilities;

public class LabelCodeUnitFormat
extends BrowserCodeUnitFormat {
    public LabelCodeUnitFormat(ToolOptions fieldOptions) {
        super(fieldOptions, true);
    }

    @Override
    protected String getOffcutLabelStringForInstruction(Address offcutAddress, Instruction instruction) {
        Program program = instruction.getProgram();
        Symbol offsym = program.getSymbolTable().getPrimarySymbol(offcutAddress);
        Address instructionAddress = instruction.getMinAddress();
        long diff = offcutAddress.subtract(instructionAddress);
        if (!offsym.isDynamic()) {
            return this.getDefaultOffcutString(offsym, (CodeUnit)instruction, diff, true);
        }
        Symbol containingSymbol = program.getSymbolTable().getPrimarySymbol(instructionAddress);
        if (containingSymbol != null) {
            return containingSymbol.getName() + "+" + diff;
        }
        return this.getDefaultOffcutString(offsym, (CodeUnit)instruction, diff, true);
    }

    @Override
    protected String getOffcutDataString(Address offcutAddress, Data data) {
        Program program = data.getProgram();
        Symbol offcutSymbol = program.getSymbolTable().getPrimarySymbol(offcutAddress);
        Address dataAddress = data.getMinAddress();
        int diff = (int)offcutAddress.subtract(dataAddress);
        if (!offcutSymbol.isDynamic()) {
            return this.getDefaultOffcutString(offcutSymbol, (CodeUnit)data, diff, true);
        }
        DataType dt = data.getBaseDataType();
        String prefix = this.getPrefixForStringData(data, dataAddress, diff, dt);
        if (prefix != null) {
            String addressString = SymbolUtilities.getAddressString((Address)dataAddress);
            return this.addOffcutInformation(prefix, addressString, diff, true);
        }
        return this.getDefaultOffcutString(offcutSymbol, (CodeUnit)data, diff, true);
    }
}

