/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.dwarf.line;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.dwarf.line.LEB128;
import java.io.IOException;

public class FileEntry {
    private String fileName;
    private LEB128 directoryIndex;
    private LEB128 lastModifiedTime;
    private LEB128 fileLengthInBytes;

    FileEntry(BinaryReader reader) throws IOException {
        this.fileName = reader.readNextAsciiString();
        if (this.fileName.length() == 0) {
            return;
        }
        this.directoryIndex = new LEB128(reader, false);
        this.lastModifiedTime = new LEB128(reader, false);
        this.fileLengthInBytes = new LEB128(reader, false);
    }

    public String getFileName() {
        return this.fileName;
    }

    public LEB128 getDirectoryIndex() {
        return this.directoryIndex;
    }

    public LEB128 getLastModifiedTime() {
        return this.lastModifiedTime;
    }

    public LEB128 getFileLengthInBytes() {
        return this.fileLengthInBytes;
    }

    public String toString() {
        return this.fileName;
    }
}

