/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.script;

import docking.widgets.tree.AbstractGTreeRootNode;
import docking.widgets.tree.GTreeNode;
import generic.jar.ResourceFile;
import ghidra.app.plugin.core.script.ScriptCategoryNode;
import ghidra.app.script.GhidraScriptUtil;
import ghidra.app.script.ScriptInfo;
import java.util.List;
import javax.swing.Icon;
import resources.ResourceManager;

class RootNode
extends AbstractGTreeRootNode {
    private static Icon icon = ResourceManager.loadImage((String)"images/play.png");

    RootNode() {
    }

    public Icon getIcon(boolean expanded) {
        return icon;
    }

    public String getName() {
        return "Scripts";
    }

    public String getToolTip() {
        return null;
    }

    public boolean isLeaf() {
        return false;
    }

    void insert(ResourceFile script) {
        ScriptInfo info = GhidraScriptUtil.getScriptInfo(script);
        String[] categoryPath = info.getCategory();
        RootNode parent = this;
        for (String categoryName : categoryPath) {
            Object child = this.getChildRegardlessOfFilter((GTreeNode)parent, categoryName);
            if (child == null) {
                child = new ScriptCategoryNode(categoryName);
                this.insertSorted((GTreeNode)parent, (GTreeNode)child);
            }
            parent = child;
        }
    }

    private GTreeNode getChildRegardlessOfFilter(GTreeNode parent, String name) {
        List children = parent.getAllChildren();
        for (GTreeNode child : children) {
            if (!child.getName().equals(name)) continue;
            return child;
        }
        return null;
    }

    private void insertSorted(GTreeNode parent, GTreeNode newChild) {
        List allChildren = parent.getAllChildren();
        for (GTreeNode child : allChildren) {
            String newNodeName;
            String nodeName = child.getName();
            if (nodeName.compareToIgnoreCase(newNodeName = newChild.getName()) <= 0) continue;
            parent.addNode(parent.getIndexOfChild(child), newChild);
            return;
        }
        parent.addNode(newChild);
    }
}

