/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.function;

import docking.action.KeyBindingData;
import docking.action.KeyBindingType;
import docking.action.MenuData;
import ghidra.app.context.ListingActionContext;
import ghidra.app.context.ListingContextAction;
import ghidra.app.plugin.core.function.FunctionPlugin;
import ghidra.program.model.data.CycleGroup;
import ghidra.program.model.data.DataType;
import ghidra.program.util.ProgramLocation;
import ghidra.program.util.VariableLocation;
import ghidra.util.HelpLocation;
import javax.swing.KeyStroke;

public class CycleGroupAction
extends ListingContextAction {
    private FunctionPlugin plugin;
    private CycleGroup cycleGroup;

    CycleGroupAction(CycleGroup group, FunctionPlugin plugin) {
        super(group.getName(), plugin.getName(), KeyBindingType.SHARED);
        this.plugin = plugin;
        this.cycleGroup = group;
        this.setPopupMenu(plugin.getDataActionMenuName(null), true);
        this.setHelpLocation(new HelpLocation("DataPlugin", group.getName()));
        this.initKeyStroke(this.cycleGroup.getDefaultKeyStroke());
    }

    private void initKeyStroke(KeyStroke keyStroke) {
        if (keyStroke == null) {
            return;
        }
        this.setKeyBindingData(new KeyBindingData(keyStroke));
    }

    private void setPopupMenu(String name, boolean isSignatureAction) {
        this.setPopupMenuData(new MenuData(new String[]{"Set Data Type", "Cycle", this.cycleGroup.getName()}, null, null));
    }

    @Override
    protected boolean isEnabledForContext(ListingActionContext context) {
        if (context.hasSelection() || context.getAddress() == null) {
            return false;
        }
        ProgramLocation location = context.getLocation();
        if (this.plugin.isValidDataLocation(location)) {
            this.setPopupMenu(this.plugin.getDataActionMenuName(location), true);
            return true;
        }
        if (location instanceof VariableLocation) {
            this.setPopupMenu(this.plugin.getDataActionMenuName(location), false);
            return true;
        }
        return false;
    }

    public void dispose() {
        this.cycleGroup = null;
        this.plugin = null;
        super.dispose();
    }

    @Override
    public void actionPerformed(ListingActionContext context) {
        DataType dt = this.plugin.getCurrentDataType(context);
        if ((dt = this.cycleGroup.getNextDataType(dt, true)) != null && !this.plugin.createData(dt, context, false, false)) {
            this.plugin.createData(DataType.DEFAULT, context, true, false);
        }
    }
}

