/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.flowarrow;

import docking.DockingWindowManager;
import docking.util.AnimationUtils;
import docking.util.SwingAnimationCallback;
import ghidra.app.plugin.core.flowarrow.FlowArrow;
import ghidra.app.plugin.core.flowarrow.FlowArrowPlugin;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.util.HelpLocation;
import ghidra.util.task.SwingUpdateManager;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.Iterator;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.ToolTipManager;
import org.jdesktop.animation.timing.Animator;

class FlowArrowPanel
extends JPanel {
    private Cursor clickCursor;
    private Cursor defaultCursor;
    private FlowArrowPlugin plugin;
    private Color foregroundColor;
    private Color highlightColor;
    private Color selectedColor;
    private SwingUpdateManager mouseClickUpdater;
    private Point pendingMouseClickPoint;

    FlowArrowPanel(FlowArrowPlugin p) {
        this.plugin = p;
        this.setMinimumSize(new Dimension(0, 0));
        this.setPreferredSize(new Dimension(32, 1));
        this.defaultCursor = this.getCursor();
        this.clickCursor = Cursor.getPredefinedCursor(12);
        ToolTipManager.sharedInstance().registerComponent(this);
        DockingWindowManager.setHelpLocation((JComponent)this, (HelpLocation)new HelpLocation("CodeBrowserPlugin", "CBFlowArrows"));
        int min = 350;
        this.mouseClickUpdater = new SwingUpdateManager(min, () -> {
            if (this.pendingMouseClickPoint == null) {
                return;
            }
            this.processSingleClick(this.pendingMouseClickPoint);
            this.pendingMouseClickPoint = null;
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    FlowArrowPanel.this.pendingMouseClickPoint = null;
                    FlowArrowPanel.this.processDoubleClick(e);
                    return;
                }
                if (e.getClickCount() == 1) {
                    FlowArrowPanel.this.pendingMouseClickPoint = e.getPoint();
                    FlowArrowPanel.this.mouseClickUpdater.updateLater();
                }
            }
        });
        this.addMouseWheelListener(new FlowArrowPanelMouseWheelListener());
        FlowArrowCursorMouseListener cursorListener = new FlowArrowCursorMouseListener();
        this.addMouseMotionListener(cursorListener);
        this.addMouseListener(cursorListener);
    }

    public void updateCursor(Point point) {
        FlowArrow arrow = this.getArrow(point);
        if (arrow != null) {
            this.setCursor(this.clickCursor);
        } else {
            this.setCursor(this.defaultCursor);
        }
    }

    public void resetCursor() {
        this.setCursor(this.defaultCursor);
    }

    private void processDoubleClick(MouseEvent e) {
        Point point = e.getPoint();
        FlowArrow arrow = this.getArrow(point);
        this.navigateArrow(arrow);
    }

    private FlowArrow getArrow(Point p) {
        FlowArrow arrow = this.getArrow(p, this.plugin.getFlowArrowIterator());
        if (arrow != null) {
            return arrow;
        }
        arrow = this.getArrow(p, this.plugin.getSelectedFlowArrows());
        if (arrow != null) {
            return arrow;
        }
        return this.getArrow(p, this.plugin.getActiveArrows());
    }

    private FlowArrow getArrow(Point p, Iterator<FlowArrow> it) {
        while (it.hasNext()) {
            FlowArrow arrow = it.next();
            if (!arrow.intersects(p)) continue;
            return arrow;
        }
        return null;
    }

    private void navigateArrow(FlowArrow arrow) {
        if (arrow == null) {
            return;
        }
        arrow.selected = true;
        this.plugin.setArrowSelected(arrow, true);
        Address end = arrow.end;
        if (end.equals((Object)this.plugin.getCurrentAddress())) {
            end = arrow.start;
        }
        if (this.plugin.isOnScreen(end)) {
            this.plugin.goTo(end);
            return;
        }
        Address start = this.plugin.getLastAddressOnScreen(end, arrow.isUp());
        ScrollingCallback callback = new ScrollingCallback(start, end);
        Animator animator = AnimationUtils.executeSwingAnimationCallback((SwingAnimationCallback)callback);
        callback.setAnimator(animator);
    }

    private void processSingleClick(Point point) {
        FlowArrow arrow = this.getArrow(point);
        if (arrow != null) {
            arrow.selected = !arrow.selected;
            this.plugin.setArrowSelected(arrow, arrow.selected);
            this.repaint();
            return;
        }
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, width, height);
        this.plugin.updateAndRepaint();
    }

    @Override
    public String getToolTipText(MouseEvent e) {
        Point point = e.getPoint();
        Iterator<FlowArrow> it = this.plugin.getFlowArrowIterator();
        while (it.hasNext()) {
            FlowArrow arrow = it.next();
            if (!arrow.intersects(point)) continue;
            return arrow.getDisplayString();
        }
        return super.getToolTipText(e);
    }

    @Override
    public void setForeground(Color c) {
        super.setForeground(c);
        this.foregroundColor = c;
        this.repaint();
    }

    @Override
    public void setBackground(Color c) {
        super.setBackground(c);
        this.repaint();
    }

    void setHighlightColor(Color c) {
        this.highlightColor = c;
        this.repaint();
    }

    void setSelectedColor(Color c) {
        this.selectedColor = c;
        this.repaint();
    }

    @Override
    protected void paintComponent(Graphics g) {
        FlowArrow arrow;
        super.paintComponent(g);
        Address currentAddress = this.plugin.getCurrentAddress();
        if (currentAddress == null) {
            return;
        }
        Graphics2D g2 = (Graphics2D)g;
        Color fgColor = this.foregroundColor;
        Iterator<FlowArrow> it = this.plugin.getFlowArrowIterator();
        while (it.hasNext()) {
            arrow = it.next();
            if (arrow.active || arrow.selected) continue;
            this.paintJump(g2, arrow, fgColor);
        }
        fgColor = this.highlightColor;
        it = this.plugin.getActiveArrows();
        while (it.hasNext()) {
            arrow = it.next();
            if (arrow.selected) continue;
            this.paintJump(g2, arrow, fgColor);
        }
        fgColor = this.selectedColor;
        it = this.plugin.getSelectedFlowArrows();
        while (it.hasNext()) {
            arrow = it.next();
            this.paintJump(g2, arrow, fgColor);
        }
    }

    private void paintJump(Graphics2D g2, FlowArrow arrow, Color fgColor) {
        if (this.plugin.isOffscreen(arrow)) {
            return;
        }
        Color bgColor = this.getBackground();
        arrow.paint(g2, fgColor, bgColor);
    }

    void dispose() {
        this.mouseClickUpdater.dispose();
    }

    private class FlowArrowPanelMouseWheelListener
    implements MouseWheelListener {
        private FlowArrowPanelMouseWheelListener() {
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent e) {
            FlowArrowPanel.this.plugin.forwardMouseEventToListing(e);
        }
    }

    private class FlowArrowCursorMouseListener
    implements MouseMotionListener,
    MouseListener {
        private FlowArrowCursorMouseListener() {
        }

        @Override
        public void mouseDragged(MouseEvent e) {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            FlowArrowPanel.this.updateCursor(e.getPoint());
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            FlowArrowPanel.this.resetCursor();
        }

        @Override
        public void mouseExited(MouseEvent e) {
            FlowArrowPanel.this.resetCursor();
        }
    }

    private class ScrollingCallback
    implements SwingAnimationCallback {
        private Address start;
        private Address end;
        private AddressRange range;
        private Address lastAddress;
        private Animator animator;

        ScrollingCallback(Address start, Address end) {
            this.start = start;
            this.end = end;
            this.range = new AddressRangeImpl(start, end);
        }

        public void progress(double percentComplete) {
            long length = this.range.getLength();
            long offset = Math.round((double)length * percentComplete);
            Address current = null;
            current = this.start.compareTo((Object)this.end) > 0 ? this.start.subtract(offset) : this.start.add(offset);
            if (current.equals((Object)this.lastAddress)) {
                return;
            }
            if (current.equals((Object)this.end)) {
                this.animator.stop();
                return;
            }
            FlowArrowPanel.this.plugin.scrollTo(current);
            this.lastAddress = current;
        }

        public void done() {
            FlowArrowPanel.this.plugin.goTo(this.end);
        }

        void setAnimator(Animator animator) {
            this.animator = animator;
        }
    }
}

