/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.equate;

import ghidra.framework.cmd.BackgroundCommand;
import ghidra.framework.model.DomainObject;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.data.Enum;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.EquateTable;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;

public class CreateEnumEquateCommand
extends BackgroundCommand {
    private AddressSetView addresses;
    private Enum enoom;
    private Program program;
    private boolean shouldDoOnSubOps;

    public CreateEnumEquateCommand(Program program, AddressSetView addresses, Enum enoom, boolean shouldDoOnSubOps) {
        this.program = program;
        this.addresses = addresses;
        this.enoom = enoom;
        this.shouldDoOnSubOps = shouldDoOnSubOps;
    }

    public boolean applyTo(DomainObject obj, TaskMonitor monitor) {
        EquateTable et = this.program.getEquateTable();
        try {
            et.applyEnum(this.addresses, this.enoom, monitor, this.shouldDoOnSubOps);
        }
        catch (CancelledException e) {
            return false;
        }
        return true;
    }

    public String getName() {
        return "Create Enum Equate Command";
    }
}

