/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.equate;

import ghidra.app.plugin.core.equate.AbstractConvertAction;
import ghidra.app.plugin.core.equate.EquatePlugin;
import ghidra.program.model.listing.Program;
import ghidra.program.model.scalar.Scalar;
import ghidra.util.StringUtilities;

public class ConvertToCharAction
extends AbstractConvertAction {
    public static final String ACTION_NAME = "Convert To Char";

    public ConvertToCharAction(EquatePlugin plugin) {
        super(plugin, ACTION_NAME, false);
    }

    @Override
    protected String getMenuName(Program program, Scalar scalar, boolean isData) {
        String valueString = this.convertToString(program, scalar, isData);
        if (valueString == null) {
            return null;
        }
        if (scalar.bitLength() > 8) {
            return this.getStandardLengthString("Char Sequence:") + valueString;
        }
        return this.getStandardLengthString("Char") + valueString;
    }

    @Override
    protected int getFormatChoice() {
        return 4;
    }

    @Override
    protected String convertToString(Program program, Scalar scalar, boolean isData) {
        long value = scalar.getUnsignedValue();
        if (value >= 0L && value <= 255L) {
            return StringUtilities.toQuotedString((byte[])new byte[]{(byte)value});
        }
        byte[] bytes = scalar.byteArrayValue();
        if (!program.getMemory().isBigEndian()) {
            this.reverseBytes(bytes);
        }
        return StringUtilities.toQuotedString((byte[])bytes);
    }

    private void reverseBytes(byte[] bytes) {
        int n = bytes.length / 2;
        int j = bytes.length - 1;
        int i = 0;
        while (i < n) {
            byte b = bytes[i];
            bytes[i] = bytes[j];
            bytes[j] = b;
            ++i;
            --j;
        }
    }
}

