/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.diff;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.jboss.galleon.Errors;
import org.jboss.galleon.MessageWriter;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.diff.FsEntry;
import org.jboss.galleon.util.CollectionUtils;
import org.jboss.galleon.util.HashUtils;
import org.jboss.galleon.util.IoUtils;
import org.jboss.galleon.util.StringUtils;

public class FsDiff {
    private static final char REPLAY_SKIP = 'S';
    private static final char ADDED = '+';
    private static final char MODIFIED = 'C';
    private static final char REMOVED = '-';
    public static final String CONFLICTS_WITH_THE_UPDATED_VERSION = "conflicts with the updated version";
    public static final String HAS_CHANGED_IN_THE_UPDATED_VERSION = "has changed in the updated version";
    public static final String HAS_BEEN_REMOVED_FROM_THE_UPDATED_VERSION = "has been removed from the updated version";
    public static final String MATCHES_THE_UPDATED_VERSION = "matches the updated version";
    private final FsEntry original;
    private final FsEntry other;
    private Map<String, FsEntry> added = Collections.emptyMap();
    private Map<String, FsEntry> removed = Collections.emptyMap();
    private Map<String, FsEntry[]> modified = Collections.emptyMap();

    public static FsDiff diff(FsEntry original, FsEntry other) throws ProvisioningException {
        return new FsDiff(original, other);
    }

    public static Map<String, Boolean> replay(FsDiff diff, Path home, MessageWriter log) throws ProvisioningException {
        log.print("Replaying your changes on top");
        Map<String, Boolean> undoTasks = Collections.emptyMap();
        if (diff.hasRemovedEntries()) {
            for (FsEntry removed : diff.getRemovedEntries()) {
                if (removed.isDiffStatusSuppressed()) continue;
                Path target = home.resolve(removed.getRelativePath());
                if (Files.exists(target, new LinkOption[0])) {
                    log.print(FsDiff.formatMessage('-', removed.getRelativePath(), null));
                    IoUtils.recursiveDelete(target);
                    continue;
                }
                log.verbose(FsDiff.formatMessage('-', removed.getRelativePath(), HAS_BEEN_REMOVED_FROM_THE_UPDATED_VERSION));
                undoTasks = CollectionUtils.putLinked(undoTasks, removed.getRelativePath(), false);
            }
        }
        if (diff.hasAddedEntries()) {
            for (FsEntry added : diff.getAddedEntries()) {
                if (added.isDiffStatusSuppressed()) continue;
                undoTasks = FsDiff.addFsEntry(home, added, undoTasks, log);
            }
        }
        if (diff.hasModifiedEntries()) {
            for (FsEntry[] modified : diff.getModifiedEntries()) {
                if (modified[0].isDiffStatusSuppressed()) continue;
                FsEntry update = modified[1];
                Path target = home.resolve(update.getRelativePath());
                int action = 67;
                String warning = null;
                if (Files.exists(target, new LinkOption[0])) {
                    byte[] targetHash;
                    try {
                        targetHash = HashUtils.hashPath(target);
                    }
                    catch (IOException e) {
                        throw new ProvisioningException(Errors.hashCalculation(target), e);
                    }
                    if (Arrays.equals(update.getHash(), targetHash)) {
                        if (!FsDiff.modifiedPathMatchesExisting(update)) {
                            action = 83;
                        }
                        undoTasks = CollectionUtils.putLinked(undoTasks, update.getRelativePath(), true);
                    } else if (!Arrays.equals(modified[0].getHash(), targetHash)) {
                        if (FsDiff.modifiedPathUpdated(update)) {
                            warning = HAS_CHANGED_IN_THE_UPDATED_VERSION;
                            FsDiff.glnew(target);
                        } else {
                            action = 83;
                        }
                    } else if (FsDiff.modifiedPathConflict(update)) {
                        FsDiff.glnew(target);
                    } else {
                        action = 83;
                    }
                } else if (FsDiff.modifiedPathNotPresent(update)) {
                    warning = HAS_BEEN_REMOVED_FROM_THE_UPDATED_VERSION;
                    action = 43;
                } else {
                    action = 83;
                }
                if (action == 83) continue;
                log.print(FsDiff.formatMessage((char)action, update.getRelativePath(), warning));
                try {
                    IoUtils.copy(update.getPath(), target);
                }
                catch (IOException e) {
                    throw new ProvisioningException(Errors.copyFile(update.getPath(), target), e);
                }
            }
        }
        return undoTasks;
    }

    private static Map<String, Boolean> addFsEntry(Path home, FsEntry added, Map<String, Boolean> undoTasks, MessageWriter log) throws ProvisioningException {
        Path target = home.resolve(added.getRelativePath());
        int action = 43;
        String warning = null;
        if (Files.exists(target, new LinkOption[0])) {
            byte[] targetHash;
            if (added.isDir()) {
                for (FsEntry child : added.getChildren()) {
                    if (child.isDiffStatusSuppressed()) continue;
                    undoTasks = FsDiff.addFsEntry(home, child, undoTasks, log);
                }
                return undoTasks;
            }
            try {
                targetHash = HashUtils.hashPath(target);
            }
            catch (IOException e) {
                throw new ProvisioningException(Errors.hashCalculation(target), e);
            }
            if (Arrays.equals(added.getHash(), targetHash)) {
                if (!FsDiff.addedPathMatchesExisting(added)) {
                    action = 83;
                } else {
                    warning = MATCHES_THE_UPDATED_VERSION;
                    action = 67;
                }
                undoTasks = CollectionUtils.putLinked(undoTasks, added.getRelativePath(), true);
            } else if (FsDiff.addedPathConflict(added) && !added.isDir()) {
                warning = CONFLICTS_WITH_THE_UPDATED_VERSION;
                FsDiff.glnew(target);
                action = 67;
            }
        }
        if (action != 83) {
            log.print(FsDiff.formatMessage((char)action, added.getRelativePath(), warning));
            try {
                IoUtils.copy(added.getPath(), target);
            }
            catch (IOException e) {
                throw new ProvisioningException(Errors.copyFile(added.getPath(), target), e);
            }
        }
        return undoTasks;
    }

    private static boolean addedPathMatchesExisting(FsEntry userEntry) throws ProvisioningException {
        return false;
    }

    private static boolean addedPathConflict(FsEntry userEntry) throws ProvisioningException {
        return true;
    }

    private static boolean modifiedPathMatchesExisting(FsEntry userEntry) throws ProvisioningException {
        return false;
    }

    private static boolean modifiedPathConflict(FsEntry userEntry) throws ProvisioningException {
        return true;
    }

    private static boolean modifiedPathUpdated(FsEntry userEntry) throws ProvisioningException {
        return true;
    }

    private static boolean modifiedPathNotPresent(FsEntry userEntry) throws ProvisioningException {
        return true;
    }

    private static String formatMessage(char action, String path, String warning) {
        StringBuilder buf = new StringBuilder();
        buf.append(' ').append(action).append(' ').append(path);
        if (warning != null) {
            buf.setCharAt(0, '!');
            buf.append(' ').append(warning);
        }
        return buf.toString();
    }

    private static void glnew(Path target) throws ProvisioningException {
        try {
            IoUtils.copy(target, target.getParent().resolve(target.getFileName() + ".glnew"));
        }
        catch (IOException e) {
            throw new ProvisioningException("Failed to persist " + target.getParent().resolve(target.getFileName() + ".glnew"), e);
        }
    }

    public static void log(FsDiff diff, Consumer<String> log, PathResolver resolver) {
        if (diff.isEmpty()) {
            return;
        }
        ArrayList<Change> changes = new ArrayList<Change>();
        if (diff.hasRemovedEntries()) {
            for (FsEntry fsEntry : diff.getRemovedEntries()) {
                FsDiff.addEntries(fsEntry, changes, '-');
            }
        }
        if (diff.hasAddedEntries()) {
            for (FsEntry fsEntry : diff.getAddedEntries()) {
                FsDiff.addEntries(fsEntry, changes, '+');
            }
        }
        if (diff.hasModifiedEntries()) {
            for (FsEntry[] fsEntryArray : diff.getModifiedEntries()) {
                FsDiff.addEntries(fsEntryArray[0], changes, 'C');
            }
        }
        Collections.sort(changes);
        for (Change change : changes) {
            String path = resolver == null ? change.path : resolver.resolve(change.path);
            log.accept(FsDiff.formatMessage(change.tag, path, null));
        }
    }

    private static void addEntries(FsEntry entry, List<Change> changes, char tag) {
        if (entry.hasChildren()) {
            for (FsEntry child : entry.getChildren()) {
                FsDiff.addEntries(child, changes, tag);
            }
        } else {
            changes.add(new Change(entry.getRelativePath(), tag));
        }
    }

    private FsDiff(FsEntry original, FsEntry other) throws ProvisioningException {
        this.original = original;
        this.other = other;
        this.doDiff(original, other);
    }

    private void doDiff(FsEntry originalEntry, FsEntry otherEntry) throws ProvisioningException {
        if (originalEntry.isDir() != otherEntry.isDir()) {
            this.removed = CollectionUtils.put(this.removed, originalEntry.getRelativePath(), originalEntry);
            this.added = CollectionUtils.put(this.added, otherEntry.getRelativePath(), otherEntry);
            return;
        }
        if (originalEntry.dir) {
            if (originalEntry.hasChildren()) {
                Map<String, FsEntry> otherChildren = otherEntry.cloneChildren();
                for (FsEntry originalChild : originalEntry.getChildren()) {
                    FsEntry otherChild = otherChildren.remove(originalChild.getName());
                    if (otherChild == null) {
                        originalChild.diffRemoved();
                        this.removed = CollectionUtils.put(this.removed, originalChild.getRelativePath(), originalChild);
                        continue;
                    }
                    this.doDiff(originalChild, otherChild);
                }
                if (!otherChildren.isEmpty()) {
                    for (FsEntry otherChild : otherChildren.values()) {
                        otherChild.diffAdded();
                        this.added = CollectionUtils.put(this.added, otherChild.getRelativePath(), otherChild);
                    }
                }
            } else if (otherEntry.hasChildren()) {
                for (FsEntry otherChild : otherEntry.getChildren()) {
                    otherChild.diffAdded();
                    this.added = CollectionUtils.put(this.added, otherChild.getRelativePath(), otherChild);
                }
            }
            return;
        }
        if (!Arrays.equals(originalEntry.getHash(), otherEntry.getHash())) {
            originalEntry.diffModified();
            otherEntry.diffModified();
            this.modified = CollectionUtils.put(this.modified, originalEntry.getRelativePath(), new FsEntry[]{originalEntry, otherEntry});
        }
    }

    public FsEntry getOriginalRoot() {
        return this.original;
    }

    public FsEntry getOtherRoot() {
        return this.other;
    }

    public boolean isEmpty() {
        return this.modified.isEmpty() && this.added.isEmpty() && this.removed.isEmpty();
    }

    public boolean hasAddedEntries() {
        return !this.added.isEmpty();
    }

    public Collection<FsEntry> getAddedEntries() {
        return this.added.values();
    }

    public Set<String> getAddedPaths() {
        return this.added.keySet();
    }

    public FsEntry getAddedEntry(String relativePath) {
        return this.added.get(relativePath);
    }

    public boolean hasRemovedEntries() {
        return !this.removed.isEmpty();
    }

    public Collection<FsEntry> getRemovedEntries() {
        return this.removed.values();
    }

    public Set<String> getRemovedPaths() {
        return this.removed.keySet();
    }

    public FsEntry getRemovedEntry(String relativePath) {
        return this.removed.get(relativePath);
    }

    public boolean hasModifiedEntries() {
        return !this.modified.isEmpty();
    }

    public Collection<FsEntry[]> getModifiedEntries() {
        return this.modified.values();
    }

    public Set<String> getModifiedPaths() {
        return this.modified.keySet();
    }

    public FsEntry[] getModifiedEntry(String relativePath) {
        return this.modified.get(relativePath);
    }

    public FsEntry getEntry(String relativePath) {
        FsEntry[] fsEntries = this.modified.get(relativePath);
        if (fsEntries != null) {
            return fsEntries[1];
        }
        FsEntry fsEntry = this.added.get(relativePath);
        if (fsEntry == null && (fsEntry = this.removed.get(relativePath)) == null) {
            String[] pathElements = relativePath.split("/");
            FsEntry originalEntry = this.original;
            FsEntry otherEntry = this.other;
            for (String name : pathElements) {
                originalEntry = originalEntry == null ? null : originalEntry.getChild(name);
                FsEntry fsEntry2 = otherEntry = otherEntry == null ? null : otherEntry.getChild(name);
                if (originalEntry != null || otherEntry != null) continue;
                return null;
            }
            fsEntry = originalEntry == null ? otherEntry : originalEntry;
        }
        return fsEntry;
    }

    public void suppress(String relativePath) throws ProvisioningException {
        FsEntry[] fsEntries = this.modified.get(relativePath);
        if (fsEntries != null) {
            fsEntries[0].diffSuppress();
            fsEntries[1].diffSuppress();
            return;
        }
        FsEntry entry = this.getEntry(relativePath);
        if (entry == null) {
            throw new ProvisioningException("Failed to locate " + relativePath + " in the diff");
        }
        entry.diffSuppress();
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append('[');
        ArrayList<String> names = null;
        if (!this.added.isEmpty()) {
            buf.append("added: ");
            names = new ArrayList<String>(this.added.keySet());
            Collections.sort(names);
            StringUtils.append(buf, names);
        }
        if (!this.removed.isEmpty()) {
            if (buf.length() > 1) {
                buf.append("; ");
            }
            buf.append("removed: ");
            if (names == null) {
                names = new ArrayList(this.removed.size());
            } else {
                names.clear();
            }
            names.addAll(this.removed.keySet());
            Collections.sort(names);
            StringUtils.append(buf, names);
        }
        if (!this.modified.isEmpty()) {
            if (buf.length() > 1) {
                buf.append("; ");
            }
            buf.append("modified: ");
            if (names == null) {
                names = new ArrayList(this.modified.size());
            } else {
                names.clear();
            }
            names.addAll(this.modified.keySet());
            Collections.sort(names);
            StringUtils.append(buf, names);
        }
        return buf.append(']').toString();
    }

    public static interface PathResolver {
        public String resolve(String var1);
    }

    private static class Change
    implements Comparable<Change> {
        private final String path;
        private final char tag;

        Change(String path, char tag) {
            this.path = path;
            this.tag = tag;
        }

        @Override
        public int compareTo(Change o) {
            return this.path.compareTo(o.path);
        }
    }
}

