/*
 * Decompiled with CFR 0.152.
 */
package org.aesh.readline.terminal;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.aesh.readline.terminal.impl.CygwinPty;
import org.aesh.readline.terminal.impl.ExecPty;
import org.aesh.readline.terminal.impl.ExternalTerminal;
import org.aesh.readline.terminal.impl.PosixSysTerminal;
import org.aesh.readline.terminal.impl.Pty;
import org.aesh.readline.terminal.impl.WinExternalTerminal;
import org.aesh.readline.terminal.impl.WinSysTerminal;
import org.aesh.readline.util.LoggerUtil;
import org.aesh.terminal.Terminal;
import org.aesh.utils.OSUtils;

public final class TerminalBuilder {
    private static final Logger LOGGER = LoggerUtil.getLogger(TerminalBuilder.class.getName());
    private String name;
    private InputStream in;
    private OutputStream out;
    private String type;
    private Boolean system;
    private boolean nativeSignals = true;

    public static Terminal console() throws IOException {
        return TerminalBuilder.builder().build();
    }

    public static TerminalBuilder builder() {
        return new TerminalBuilder();
    }

    private TerminalBuilder() {
    }

    private TerminalBuilder apply(Consumer<TerminalBuilder> consumer) {
        consumer.accept(this);
        return this;
    }

    public TerminalBuilder name(String name) {
        return this.apply(c -> {
            c.name = name;
        });
    }

    public TerminalBuilder input(InputStream in) {
        return this.apply(c -> {
            c.in = in;
        });
    }

    public TerminalBuilder output(OutputStream out) {
        return this.apply(c -> {
            c.out = out;
        });
    }

    public TerminalBuilder system(boolean system) {
        return this.apply(c -> {
            c.system = system;
        });
    }

    public TerminalBuilder nativeSignals(boolean nativeSignals) {
        return this.apply(c -> {
            c.nativeSignals = nativeSignals;
        });
    }

    public TerminalBuilder type(String type) {
        return this.apply(c -> {
            c.type = type;
        });
    }

    public Terminal build() throws IOException {
        String name = this.name;
        if (name == null) {
            name = "Aesh console";
        }
        if (this.system != null && this.system.booleanValue() || this.system == null && (this.in == null || this.in == System.in) && (this.out == null || this.out == System.out)) {
            if (OSUtils.IS_CYGWIN) {
                String type = this.type;
                if (type == null) {
                    type = System.getenv("TERM");
                }
                try {
                    Pty pty = CygwinPty.current();
                    return new PosixSysTerminal(name, type, pty, this.nativeSignals);
                }
                catch (IOException ioe) {
                    return this.createWindowsTerminal(name);
                }
            }
            if (OSUtils.IS_WINDOWS) {
                return this.createWindowsTerminal(name);
            }
            String type = this.type;
            if (type == null) {
                type = System.getenv("TERM");
            }
            Pty pty = null;
            try {
                pty = ExecPty.current();
            }
            catch (IOException e) {
                LOGGER.log(Level.FINE, "Failed to get a local tty", e);
            }
            if (pty != null) {
                return new PosixSysTerminal(name, type, pty, this.nativeSignals);
            }
            return new ExternalTerminal(name, type, this.in == null ? System.in : this.in, this.out == null ? System.out : this.out);
        }
        return new ExternalTerminal(name, this.type, this.in == null ? System.in : this.in, this.out == null ? System.out : this.out);
    }

    private Terminal createWindowsTerminal(String name) throws IOException {
        try {
            if (System.console() != null) {
                return new WinSysTerminal(name, this.nativeSignals);
            }
            return new WinExternalTerminal(name, this.type, this.in == null ? System.in : this.in, this.out == null ? System.out : this.out);
        }
        catch (IOException e) {
            return new WinExternalTerminal(name, this.type, this.in == null ? System.in : this.in, this.out == null ? System.out : this.out);
        }
    }
}

