/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.olap;

import ca.sqlpower.architect.olap.MondrianModel;
import ca.sqlpower.architect.olap.OLAPObject;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class MondrianXMLWriter {
    private static final Logger logger = Logger.getLogger(MondrianXMLWriter.class);
    private final PrintWriter out;
    private int indent;
    private Map<OLAPObject, String> idMap;

    public static void exportXML(File f, MondrianModel.Schema schema) throws IOException {
        PrintWriter out = new PrintWriter(f, "UTF-8");
        out.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        MondrianXMLWriter writer = new MondrianXMLWriter(out);
        writer.writeSchema(schema);
        out.flush();
        out.close();
    }

    public static Map<OLAPObject, String> write(File f, MondrianModel.Schema schema) throws IOException {
        PrintWriter out = new PrintWriter(f, "UTF-8");
        return MondrianXMLWriter.write(out, schema, true, 0, new IdentityHashMap<OLAPObject, String>());
    }

    public static Map<OLAPObject, String> write(PrintWriter out, MondrianModel.Schema schema, boolean closeWriter, int indent, Map<OLAPObject, String> idMap) {
        MondrianXMLWriter writer = new MondrianXMLWriter(out, indent, idMap);
        writer.writeSchema(schema);
        out.flush();
        if (closeWriter) {
            out.close();
        }
        return idMap;
    }

    public MondrianXMLWriter(PrintWriter out) {
        this.out = out;
    }

    public MondrianXMLWriter(PrintWriter out, int indent, Map<OLAPObject, String> idMap) {
        this(out);
        this.indent = indent;
        this.idMap = idMap;
    }

    private void indentLine() {
        for (int i = 0; i < this.indent; ++i) {
            this.out.print(" ");
        }
    }

    private void writeStartTag(String elemName, Map<String, Object> atts) {
        this.indentLine();
        this.out.print("<" + elemName);
        for (Map.Entry<String, Object> att : atts.entrySet()) {
            if (att.getValue() == null) continue;
            this.out.print(" " + att.getKey() + "=\"" + att.getValue() + "\"");
        }
    }

    private void foolishWrite(OLAPObject obj) {
        if (((Object)((Object)obj)).getClass().equals(MondrianModel.Schema.class)) {
            this.writeSchema((MondrianModel.Schema)obj);
        } else if (((Object)((Object)obj)).getClass().equals(MondrianModel.Cube.class)) {
            this.writeCube((MondrianModel.Cube)obj);
        } else if (((Object)((Object)obj)).getClass().equals(MondrianModel.VirtualCube.class)) {
            this.writeVirtualCube((MondrianModel.VirtualCube)obj);
        } else if (((Object)((Object)obj)).getClass().equals(MondrianModel.CubeUsages.class)) {
            this.writeCubeUsages((MondrianModel.CubeUsages)obj);
        } else if (((Object)((Object)obj)).getClass().equals(MondrianModel.CubeUsage.class)) {
            this.writeCubeUsage((MondrianModel.CubeUsage)obj);
        } else if (((Object)((Object)obj)).getClass().equals(MondrianModel.VirtualCubeDimension.class)) {
            this.writeVirtualCubeDimension((MondrianModel.VirtualCubeDimension)obj);
        } else if (((Object)((Object)obj)).getClass().equals(MondrianModel.VirtualCubeMeasure.class)) {
            this.writeVirtualCubeMeasure((MondrianModel.VirtualCubeMeasure)obj);
        } else if (((Object)((Object)obj)).getClass().equals(MondrianModel.DimensionUsage.class)) {
            this.writeDimensionUsage((MondrianModel.DimensionUsage)obj);
        } else if (((Object)((Object)obj)).getClass().equals(MondrianModel.Dimension.class)) {
            this.writeDimension((MondrianModel.Dimension)obj);
        } else if (((Object)((Object)obj)).getClass().equals(MondrianModel.Hierarchy.class)) {
            this.writeHierarchy((MondrianModel.Hierarchy)obj);
        } else if (((Object)((Object)obj)).getClass().equals(MondrianModel.Level.class)) {
            this.writeLevel((MondrianModel.Level)obj);
        } else if (((Object)((Object)obj)).getClass().equals(MondrianModel.Closure.class)) {
            this.writeClosure((MondrianModel.Closure)obj);
        } else if (((Object)((Object)obj)).getClass().equals(MondrianModel.Property.class)) {
            this.writeProperty((MondrianModel.Property)obj);
        } else if (((Object)((Object)obj)).getClass().equals(MondrianModel.Measure.class)) {
            this.writeMeasure((MondrianModel.Measure)obj);
        } else if (((Object)((Object)obj)).getClass().equals(MondrianModel.CalculatedMember.class)) {
            this.writeCalculatedMember((MondrianModel.CalculatedMember)obj);
        } else if (((Object)((Object)obj)).getClass().equals(MondrianModel.CalculatedMemberProperty.class)) {
            this.writeCalculatedMemberProperty((MondrianModel.CalculatedMemberProperty)obj);
        } else if (((Object)((Object)obj)).getClass().equals(MondrianModel.NamedSet.class)) {
            this.writeNamedSet((MondrianModel.NamedSet)obj);
        } else if (((Object)((Object)obj)).getClass().equals(MondrianModel.Formula.class)) {
            this.writeFormula((MondrianModel.Formula)obj);
        } else if (((Object)((Object)obj)).getClass().equals(MondrianModel.MemberReaderParameter.class)) {
            this.writeMemberReaderParameter((MondrianModel.MemberReaderParameter)obj);
        } else if (((Object)((Object)obj)).getClass().equals(MondrianModel.View.class)) {
            this.writeView((MondrianModel.View)obj);
        } else if (((Object)((Object)obj)).getClass().equals(MondrianModel.SQL.class)) {
            this.writeSQL((MondrianModel.SQL)obj);
        } else if (((Object)((Object)obj)).getClass().equals(MondrianModel.Join.class)) {
            this.writeJoin((MondrianModel.Join)obj);
        } else if (((Object)((Object)obj)).getClass().equals(MondrianModel.Table.class)) {
            this.writeTable((MondrianModel.Table)obj);
        } else if (((Object)((Object)obj)).getClass().equals(MondrianModel.InlineTable.class)) {
            this.writeInlineTable((MondrianModel.InlineTable)obj);
        } else if (((Object)((Object)obj)).getClass().equals(MondrianModel.ColumnDefs.class)) {
            this.writeColumnDefs((MondrianModel.ColumnDefs)obj);
        } else if (((Object)((Object)obj)).getClass().equals(MondrianModel.ColumnDef.class)) {
            this.writeColumnDef((MondrianModel.ColumnDef)obj);
        } else if (((Object)((Object)obj)).getClass().equals(MondrianModel.Rows.class)) {
            this.writeRows((MondrianModel.Rows)obj);
        } else if (((Object)((Object)obj)).getClass().equals(MondrianModel.Row.class)) {
            this.writeRow((MondrianModel.Row)obj);
        } else if (((Object)((Object)obj)).getClass().equals(MondrianModel.Value.class)) {
            this.writeValue((MondrianModel.Value)obj);
        } else if (((Object)((Object)obj)).getClass().equals(MondrianModel.AggName.class)) {
            this.writeAggName((MondrianModel.AggName)obj);
        } else if (((Object)((Object)obj)).getClass().equals(MondrianModel.AggPattern.class)) {
            this.writeAggPattern((MondrianModel.AggPattern)obj);
        } else if (((Object)((Object)obj)).getClass().equals(MondrianModel.AggExclude.class)) {
            this.writeAggExclude((MondrianModel.AggExclude)obj);
        } else if (((Object)((Object)obj)).getClass().equals(MondrianModel.AggFactCount.class)) {
            this.writeAggFactCount((MondrianModel.AggFactCount)obj);
        } else if (((Object)((Object)obj)).getClass().equals(MondrianModel.AggIgnoreColumn.class)) {
            this.writeAggIgnoreColumn((MondrianModel.AggIgnoreColumn)obj);
        } else if (((Object)((Object)obj)).getClass().equals(MondrianModel.AggForeignKey.class)) {
            this.writeAggForeignKey((MondrianModel.AggForeignKey)obj);
        } else if (((Object)((Object)obj)).getClass().equals(MondrianModel.AggLevel.class)) {
            this.writeAggLevel((MondrianModel.AggLevel)obj);
        } else if (((Object)((Object)obj)).getClass().equals(MondrianModel.AggMeasure.class)) {
            this.writeAggMeasure((MondrianModel.AggMeasure)obj);
        } else if (((Object)((Object)obj)).getClass().equals(MondrianModel.Column.class)) {
            this.writeColumn((MondrianModel.Column)obj);
        } else if (((Object)((Object)obj)).getClass().equals(MondrianModel.KeyExpression.class)) {
            this.writeKeyExpression((MondrianModel.KeyExpression)obj);
        } else if (((Object)((Object)obj)).getClass().equals(MondrianModel.ParentExpression.class)) {
            this.writeParentExpression((MondrianModel.ParentExpression)obj);
        } else if (((Object)((Object)obj)).getClass().equals(MondrianModel.OrdinalExpression.class)) {
            this.writeOrdinalExpression((MondrianModel.OrdinalExpression)obj);
        } else if (((Object)((Object)obj)).getClass().equals(MondrianModel.NameExpression.class)) {
            this.writeNameExpression((MondrianModel.NameExpression)obj);
        } else if (((Object)((Object)obj)).getClass().equals(MondrianModel.CaptionExpression.class)) {
            this.writeCaptionExpression((MondrianModel.CaptionExpression)obj);
        } else if (((Object)((Object)obj)).getClass().equals(MondrianModel.MeasureExpression.class)) {
            this.writeMeasureExpression((MondrianModel.MeasureExpression)obj);
        } else if (((Object)((Object)obj)).getClass().equals(MondrianModel.Role.class)) {
            this.writeRole((MondrianModel.Role)obj);
        } else if (((Object)((Object)obj)).getClass().equals(MondrianModel.SchemaGrant.class)) {
            this.writeSchemaGrant((MondrianModel.SchemaGrant)obj);
        } else if (((Object)((Object)obj)).getClass().equals(MondrianModel.CubeGrant.class)) {
            this.writeCubeGrant((MondrianModel.CubeGrant)obj);
        } else if (((Object)((Object)obj)).getClass().equals(MondrianModel.DimensionGrant.class)) {
            this.writeDimensionGrant((MondrianModel.DimensionGrant)obj);
        } else if (((Object)((Object)obj)).getClass().equals(MondrianModel.HierarchyGrant.class)) {
            this.writeHierarchyGrant((MondrianModel.HierarchyGrant)obj);
        } else if (((Object)((Object)obj)).getClass().equals(MondrianModel.MemberGrant.class)) {
            this.writeMemberGrant((MondrianModel.MemberGrant)obj);
        } else if (((Object)((Object)obj)).getClass().equals(MondrianModel.Union.class)) {
            this.writeUnion((MondrianModel.Union)obj);
        } else if (((Object)((Object)obj)).getClass().equals(MondrianModel.RoleUsage.class)) {
            this.writeRoleUsage((MondrianModel.RoleUsage)obj);
        } else if (((Object)((Object)obj)).getClass().equals(MondrianModel.UserDefinedFunction.class)) {
            this.writeUserDefinedFunction((MondrianModel.UserDefinedFunction)obj);
        } else if (((Object)((Object)obj)).getClass().equals(MondrianModel.Parameter.class)) {
            this.writeParameter((MondrianModel.Parameter)obj);
        } else if (((Object)((Object)obj)).getClass().equals(MondrianModel.CubeDimension.class)) {
            this.writeCubeDimension((MondrianModel.CubeDimension)obj);
        } else if (((Object)((Object)obj)).getClass().equals(MondrianModel.RelationOrJoin.class)) {
            this.writeRelationOrJoin((MondrianModel.RelationOrJoin)obj);
        } else if (((Object)((Object)obj)).getClass().equals(MondrianModel.Relation.class)) {
            this.writeRelation((MondrianModel.Relation)obj);
        } else if (((Object)((Object)obj)).getClass().equals(MondrianModel.AggTable.class)) {
            this.writeAggTable((MondrianModel.AggTable)obj);
        } else if (((Object)((Object)obj)).getClass().equals(MondrianModel.AggColumnName.class)) {
            this.writeAggColumnName((MondrianModel.AggColumnName)obj);
        } else if (((Object)((Object)obj)).getClass().equals(MondrianModel.Expression.class)) {
            this.writeExpression((MondrianModel.Expression)obj);
        } else if (((Object)((Object)obj)).getClass().equals(MondrianModel.ExpressionView.class)) {
            this.writeExpressionView((MondrianModel.ExpressionView)obj);
        } else if (((Object)((Object)obj)).getClass().equals(MondrianModel.Grant.class)) {
            this.writeGrant((MondrianModel.Grant)obj);
        } else {
            logger.warn((Object)("Skipping unknown content \"" + ((Object)((Object)obj)).getClass()));
        }
    }

    public void writeSchema(MondrianModel.Schema elem) {
        boolean oneTag = true;
        LinkedHashMap<String, Object> atts = new LinkedHashMap<String, Object>();
        if (this.idMap != null) {
            String id = Integer.toString(this.idMap.size());
            if (this.idMap.put(elem, id) != null) {
                throw new IllegalStateException("Duplicate OLAPObject found: " + (Object)((Object)elem));
            }
            atts.put("id", id);
        }
        atts.put("name", elem.getName());
        atts.put("measuresCaption", elem.getMeasuresCaption());
        atts.put("defaultRole", elem.getDefaultRole());
        this.writeStartTag("Schema", atts);
        LinkedHashMap<String, List<OLAPObject>> arrays = new LinkedHashMap<String, List<OLAPObject>>();
        arrays.put("parameters", elem.getParameters());
        arrays.put("dimensions", elem.getDimensions());
        arrays.put("cubes", elem.getCubes());
        arrays.put("virtualCubes", elem.getVirtualCubes());
        arrays.put("namedSets", elem.getNamedSets());
        arrays.put("roles", elem.getRoles());
        arrays.put("userDefinedFunctions", elem.getUserDefinedFunctions());
        ++this.indent;
        for (Map.Entry array : arrays.entrySet()) {
            if (array.getValue() instanceof List) {
                List list = (List)array.getValue();
                if (oneTag && list.size() > 0) {
                    this.out.println(">");
                    oneTag = false;
                }
                for (OLAPObject obj : list) {
                    this.foolishWrite(obj);
                }
                continue;
            }
            if (!(array.getValue() instanceof OLAPObject)) continue;
            if (oneTag) {
                this.out.println(">");
                oneTag = false;
            }
            this.foolishWrite((OLAPObject)((Object)array.getValue()));
        }
        --this.indent;
        if (oneTag) {
            this.out.println("/>");
        } else {
            this.indentLine();
            this.out.println("</Schema>");
        }
    }

    private void writeCubeDimension(MondrianModel.CubeDimension elem) {
        this.foolishWrite(elem);
    }

    private void populateCubeDimensionAttributes(MondrianModel.CubeDimension elem, Map<String, Object> atts) {
        atts.put("name", elem.getName());
        atts.put("caption", elem.getCaption());
        atts.put("foreignKey", elem.getForeignKey());
    }

    private void populateCubeDimensionArrays(MondrianModel.CubeDimension elem, Map<String, Object> arrays) {
    }

    public void writeCube(MondrianModel.Cube elem) {
        boolean oneTag = true;
        LinkedHashMap<String, Object> atts = new LinkedHashMap<String, Object>();
        if (this.idMap != null) {
            String id = Integer.toString(this.idMap.size());
            if (this.idMap.put(elem, id) != null) {
                throw new IllegalStateException("Duplicate OLAPObject found: " + (Object)((Object)elem));
            }
            atts.put("id", id);
        }
        atts.put("name", elem.getName());
        atts.put("caption", elem.getCaption());
        atts.put("defaultMeasure", elem.getDefaultMeasure());
        atts.put("cache", elem.getCache());
        atts.put("enabled", elem.getEnabled());
        this.writeStartTag("Cube", atts);
        LinkedHashMap<String, Object> arrays = new LinkedHashMap<String, Object>();
        arrays.put("fact", (Object)elem.getFact());
        arrays.put("dimensions", elem.getDimensions());
        arrays.put("measures", elem.getMeasures());
        arrays.put("calculatedMembers", elem.getCalculatedMembers());
        arrays.put("namedSets", elem.getNamedSets());
        ++this.indent;
        for (Map.Entry array : arrays.entrySet()) {
            if (array.getValue() instanceof List) {
                List list = (List)array.getValue();
                if (oneTag && list.size() > 0) {
                    this.out.println(">");
                    oneTag = false;
                }
                for (OLAPObject obj : list) {
                    this.foolishWrite(obj);
                }
                continue;
            }
            if (!(array.getValue() instanceof OLAPObject)) continue;
            if (oneTag) {
                this.out.println(">");
                oneTag = false;
            }
            this.foolishWrite((OLAPObject)((Object)array.getValue()));
        }
        --this.indent;
        if (oneTag) {
            this.out.println("/>");
        } else {
            this.indentLine();
            this.out.println("</Cube>");
        }
    }

    public void writeVirtualCube(MondrianModel.VirtualCube elem) {
        boolean oneTag = true;
        LinkedHashMap<String, Object> atts = new LinkedHashMap<String, Object>();
        if (this.idMap != null) {
            String id = Integer.toString(this.idMap.size());
            if (this.idMap.put(elem, id) != null) {
                throw new IllegalStateException("Duplicate OLAPObject found: " + (Object)((Object)elem));
            }
            atts.put("id", id);
        }
        atts.put("enabled", elem.getEnabled());
        atts.put("name", elem.getName());
        atts.put("defaultMeasure", elem.getDefaultMeasure());
        atts.put("caption", elem.getCaption());
        this.writeStartTag("VirtualCube", atts);
        LinkedHashMap<String, Object> arrays = new LinkedHashMap<String, Object>();
        arrays.put("cubeUsage", (Object)elem.getCubeUsage());
        arrays.put("dimensions", elem.getDimensions());
        arrays.put("measures", elem.getMeasures());
        arrays.put("calculatedMembers", elem.getCalculatedMembers());
        arrays.put("namedSets", elem.getNamedSets());
        ++this.indent;
        for (Map.Entry array : arrays.entrySet()) {
            if (array.getValue() instanceof List) {
                List list = (List)array.getValue();
                if (oneTag && list.size() > 0) {
                    this.out.println(">");
                    oneTag = false;
                }
                for (OLAPObject obj : list) {
                    this.foolishWrite(obj);
                }
                continue;
            }
            if (!(array.getValue() instanceof OLAPObject)) continue;
            if (oneTag) {
                this.out.println(">");
                oneTag = false;
            }
            this.foolishWrite((OLAPObject)((Object)array.getValue()));
        }
        --this.indent;
        if (oneTag) {
            this.out.println("/>");
        } else {
            this.indentLine();
            this.out.println("</VirtualCube>");
        }
    }

    public void writeCubeUsages(MondrianModel.CubeUsages elem) {
        boolean oneTag = true;
        LinkedHashMap<String, Object> atts = new LinkedHashMap<String, Object>();
        if (this.idMap != null) {
            String id = Integer.toString(this.idMap.size());
            if (this.idMap.put(elem, id) != null) {
                throw new IllegalStateException("Duplicate OLAPObject found: " + (Object)((Object)elem));
            }
            atts.put("id", id);
        }
        this.writeStartTag("CubeUsages", atts);
        LinkedHashMap<String, List<MondrianModel.CubeUsage>> arrays = new LinkedHashMap<String, List<MondrianModel.CubeUsage>>();
        arrays.put("cubeUsages", elem.getCubeUsages());
        ++this.indent;
        for (Map.Entry array : arrays.entrySet()) {
            if (array.getValue() instanceof List) {
                List list = (List)array.getValue();
                if (oneTag && list.size() > 0) {
                    this.out.println(">");
                    oneTag = false;
                }
                for (OLAPObject obj : list) {
                    this.foolishWrite(obj);
                }
                continue;
            }
            if (!(array.getValue() instanceof OLAPObject)) continue;
            if (oneTag) {
                this.out.println(">");
                oneTag = false;
            }
            this.foolishWrite((OLAPObject)((Object)array.getValue()));
        }
        --this.indent;
        if (oneTag) {
            this.out.println("/>");
        } else {
            this.indentLine();
            this.out.println("</CubeUsages>");
        }
    }

    public void writeCubeUsage(MondrianModel.CubeUsage elem) {
        boolean oneTag = true;
        LinkedHashMap<String, Object> atts = new LinkedHashMap<String, Object>();
        if (this.idMap != null) {
            String id = Integer.toString(this.idMap.size());
            if (this.idMap.put(elem, id) != null) {
                throw new IllegalStateException("Duplicate OLAPObject found: " + (Object)((Object)elem));
            }
            atts.put("id", id);
        }
        atts.put("cubeName", elem.getCubeName());
        atts.put("ignoreUnrelatedDimensions", elem.getIgnoreUnrelatedDimensions());
        this.writeStartTag("CubeUsage", atts);
        LinkedHashMap arrays = new LinkedHashMap();
        ++this.indent;
        for (Map.Entry array : arrays.entrySet()) {
            if (array.getValue() instanceof List) {
                List list = (List)array.getValue();
                if (oneTag && list.size() > 0) {
                    this.out.println(">");
                    oneTag = false;
                }
                for (OLAPObject obj : list) {
                    this.foolishWrite(obj);
                }
                continue;
            }
            if (!(array.getValue() instanceof OLAPObject)) continue;
            if (oneTag) {
                this.out.println(">");
                oneTag = false;
            }
            this.foolishWrite((OLAPObject)((Object)array.getValue()));
        }
        --this.indent;
        if (oneTag) {
            this.out.println("/>");
        } else {
            this.indentLine();
            this.out.println("</CubeUsage>");
        }
    }

    public void writeVirtualCubeDimension(MondrianModel.VirtualCubeDimension elem) {
        boolean oneTag = true;
        LinkedHashMap<String, Object> atts = new LinkedHashMap<String, Object>();
        if (this.idMap != null) {
            String id = Integer.toString(this.idMap.size());
            if (this.idMap.put(elem, id) != null) {
                throw new IllegalStateException("Duplicate OLAPObject found: " + (Object)((Object)elem));
            }
            atts.put("id", id);
        }
        atts.put("cubeName", elem.getCubeName());
        atts.put("name", elem.getName());
        this.populateCubeDimensionAttributes(elem, atts);
        this.writeStartTag("VirtualCubeDimension", atts);
        LinkedHashMap<String, Object> arrays = new LinkedHashMap<String, Object>();
        this.populateCubeDimensionArrays(elem, arrays);
        ++this.indent;
        for (Map.Entry array : arrays.entrySet()) {
            if (array.getValue() instanceof List) {
                List list = (List)array.getValue();
                if (oneTag && list.size() > 0) {
                    this.out.println(">");
                    oneTag = false;
                }
                for (OLAPObject obj : list) {
                    this.foolishWrite(obj);
                }
                continue;
            }
            if (!(array.getValue() instanceof OLAPObject)) continue;
            if (oneTag) {
                this.out.println(">");
                oneTag = false;
            }
            this.foolishWrite((OLAPObject)((Object)array.getValue()));
        }
        --this.indent;
        if (oneTag) {
            this.out.println("/>");
        } else {
            this.indentLine();
            this.out.println("</VirtualCubeDimension>");
        }
    }

    public void writeVirtualCubeMeasure(MondrianModel.VirtualCubeMeasure elem) {
        boolean oneTag = true;
        LinkedHashMap<String, Object> atts = new LinkedHashMap<String, Object>();
        if (this.idMap != null) {
            String id = Integer.toString(this.idMap.size());
            if (this.idMap.put(elem, id) != null) {
                throw new IllegalStateException("Duplicate OLAPObject found: " + (Object)((Object)elem));
            }
            atts.put("id", id);
        }
        atts.put("cubeName", elem.getCubeName());
        atts.put("name", elem.getName());
        atts.put("visible", elem.getVisible());
        this.writeStartTag("VirtualCubeMeasure", atts);
        LinkedHashMap arrays = new LinkedHashMap();
        ++this.indent;
        for (Map.Entry array : arrays.entrySet()) {
            if (array.getValue() instanceof List) {
                List list = (List)array.getValue();
                if (oneTag && list.size() > 0) {
                    this.out.println(">");
                    oneTag = false;
                }
                for (OLAPObject obj : list) {
                    this.foolishWrite(obj);
                }
                continue;
            }
            if (!(array.getValue() instanceof OLAPObject)) continue;
            if (oneTag) {
                this.out.println(">");
                oneTag = false;
            }
            this.foolishWrite((OLAPObject)((Object)array.getValue()));
        }
        --this.indent;
        if (oneTag) {
            this.out.println("/>");
        } else {
            this.indentLine();
            this.out.println("</VirtualCubeMeasure>");
        }
    }

    public void writeDimensionUsage(MondrianModel.DimensionUsage elem) {
        boolean oneTag = true;
        LinkedHashMap<String, Object> atts = new LinkedHashMap<String, Object>();
        if (this.idMap != null) {
            String id = Integer.toString(this.idMap.size());
            if (this.idMap.put(elem, id) != null) {
                throw new IllegalStateException("Duplicate OLAPObject found: " + (Object)((Object)elem));
            }
            atts.put("id", id);
        }
        atts.put("source", elem.getSource());
        atts.put("level", elem.getLevel());
        atts.put("usagePrefix", elem.getUsagePrefix());
        this.populateCubeDimensionAttributes(elem, atts);
        this.writeStartTag("DimensionUsage", atts);
        LinkedHashMap<String, Object> arrays = new LinkedHashMap<String, Object>();
        this.populateCubeDimensionArrays(elem, arrays);
        ++this.indent;
        for (Map.Entry array : arrays.entrySet()) {
            if (array.getValue() instanceof List) {
                List list = (List)array.getValue();
                if (oneTag && list.size() > 0) {
                    this.out.println(">");
                    oneTag = false;
                }
                for (OLAPObject obj : list) {
                    this.foolishWrite(obj);
                }
                continue;
            }
            if (!(array.getValue() instanceof OLAPObject)) continue;
            if (oneTag) {
                this.out.println(">");
                oneTag = false;
            }
            this.foolishWrite((OLAPObject)((Object)array.getValue()));
        }
        --this.indent;
        if (oneTag) {
            this.out.println("/>");
        } else {
            this.indentLine();
            this.out.println("</DimensionUsage>");
        }
    }

    public void writeDimension(MondrianModel.Dimension elem) {
        boolean oneTag = true;
        LinkedHashMap<String, Object> atts = new LinkedHashMap<String, Object>();
        if (this.idMap != null) {
            String id = Integer.toString(this.idMap.size());
            if (this.idMap.put(elem, id) != null) {
                throw new IllegalStateException("Duplicate OLAPObject found: " + (Object)((Object)elem));
            }
            atts.put("id", id);
        }
        atts.put("name", elem.getName());
        atts.put("type", elem.getType());
        atts.put("caption", elem.getCaption());
        atts.put("usagePrefix", elem.getUsagePrefix());
        this.populateCubeDimensionAttributes(elem, atts);
        this.writeStartTag("Dimension", atts);
        LinkedHashMap<String, Object> arrays = new LinkedHashMap<String, Object>();
        arrays.put("hierarchies", elem.getHierarchies());
        this.populateCubeDimensionArrays(elem, arrays);
        ++this.indent;
        for (Map.Entry array : arrays.entrySet()) {
            if (array.getValue() instanceof List) {
                List list = (List)array.getValue();
                if (oneTag && list.size() > 0) {
                    this.out.println(">");
                    oneTag = false;
                }
                for (OLAPObject obj : list) {
                    this.foolishWrite(obj);
                }
                continue;
            }
            if (!(array.getValue() instanceof OLAPObject)) continue;
            if (oneTag) {
                this.out.println(">");
                oneTag = false;
            }
            this.foolishWrite((OLAPObject)((Object)array.getValue()));
        }
        --this.indent;
        if (oneTag) {
            this.out.println("/>");
        } else {
            this.indentLine();
            this.out.println("</Dimension>");
        }
    }

    public void writeHierarchy(MondrianModel.Hierarchy elem) {
        boolean oneTag = true;
        LinkedHashMap<String, Object> atts = new LinkedHashMap<String, Object>();
        if (this.idMap != null) {
            String id = Integer.toString(this.idMap.size());
            if (this.idMap.put(elem, id) != null) {
                throw new IllegalStateException("Duplicate OLAPObject found: " + (Object)((Object)elem));
            }
            atts.put("id", id);
        }
        atts.put("name", elem.getName());
        atts.put("hasAll", elem.getHasAll());
        atts.put("allMemberName", elem.getAllMemberName());
        atts.put("allMemberCaption", elem.getAllMemberCaption());
        atts.put("allLevelName", elem.getAllLevelName());
        atts.put("primaryKey", elem.getPrimaryKey());
        atts.put("primaryKeyTable", elem.getPrimaryKeyTable());
        atts.put("defaultMember", elem.getDefaultMember());
        atts.put("memberReaderClass", elem.getMemberReaderClass());
        atts.put("caption", elem.getCaption());
        this.writeStartTag("Hierarchy", atts);
        LinkedHashMap<String, Object> arrays = new LinkedHashMap<String, Object>();
        arrays.put("relation", (Object)elem.getRelation());
        arrays.put("levels", elem.getLevels());
        arrays.put("memberReaderParameters", elem.getMemberReaderParameters());
        ++this.indent;
        for (Map.Entry array : arrays.entrySet()) {
            if (array.getValue() instanceof List) {
                List list = (List)array.getValue();
                if (oneTag && list.size() > 0) {
                    this.out.println(">");
                    oneTag = false;
                }
                for (OLAPObject obj : list) {
                    this.foolishWrite(obj);
                }
                continue;
            }
            if (!(array.getValue() instanceof OLAPObject)) continue;
            if (oneTag) {
                this.out.println(">");
                oneTag = false;
            }
            this.foolishWrite((OLAPObject)((Object)array.getValue()));
        }
        --this.indent;
        if (oneTag) {
            this.out.println("/>");
        } else {
            this.indentLine();
            this.out.println("</Hierarchy>");
        }
    }

    public void writeLevel(MondrianModel.Level elem) {
        boolean oneTag = true;
        LinkedHashMap<String, Object> atts = new LinkedHashMap<String, Object>();
        if (this.idMap != null) {
            String id = Integer.toString(this.idMap.size());
            if (this.idMap.put(elem, id) != null) {
                throw new IllegalStateException("Duplicate OLAPObject found: " + (Object)((Object)elem));
            }
            atts.put("id", id);
        }
        atts.put("approxRowCount", elem.getApproxRowCount());
        atts.put("name", elem.getName());
        atts.put("table", elem.getTable());
        atts.put("column", elem.getColumn());
        atts.put("nameColumn", elem.getNameColumn());
        atts.put("ordinalColumn", elem.getOrdinalColumn());
        atts.put("parentColumn", elem.getParentColumn());
        atts.put("nullParentValue", elem.getNullParentValue());
        atts.put("type", elem.getType());
        atts.put("uniqueMembers", elem.getUniqueMembers());
        atts.put("levelType", elem.getLevelType());
        atts.put("hideMemberIf", elem.getHideMemberIf());
        atts.put("formatter", elem.getFormatter());
        atts.put("caption", elem.getCaption());
        atts.put("captionColumn", elem.getCaptionColumn());
        this.writeStartTag("Level", atts);
        LinkedHashMap<String, Object> arrays = new LinkedHashMap<String, Object>();
        arrays.put("keyExp", (Object)elem.getKeyExp());
        arrays.put("nameExp", (Object)elem.getNameExp());
        arrays.put("ordinalExp", (Object)elem.getOrdinalExp());
        arrays.put("parentExp", (Object)elem.getParentExp());
        arrays.put("closure", (Object)elem.getClosure());
        arrays.put("properties", elem.getProperties());
        ++this.indent;
        for (Map.Entry array : arrays.entrySet()) {
            if (array.getValue() instanceof List) {
                List list = (List)array.getValue();
                if (oneTag && list.size() > 0) {
                    this.out.println(">");
                    oneTag = false;
                }
                for (OLAPObject obj : list) {
                    this.foolishWrite(obj);
                }
                continue;
            }
            if (!(array.getValue() instanceof OLAPObject)) continue;
            if (oneTag) {
                this.out.println(">");
                oneTag = false;
            }
            this.foolishWrite((OLAPObject)((Object)array.getValue()));
        }
        --this.indent;
        if (oneTag) {
            this.out.println("/>");
        } else {
            this.indentLine();
            this.out.println("</Level>");
        }
    }

    public void writeClosure(MondrianModel.Closure elem) {
        boolean oneTag = true;
        LinkedHashMap<String, Object> atts = new LinkedHashMap<String, Object>();
        if (this.idMap != null) {
            String id = Integer.toString(this.idMap.size());
            if (this.idMap.put(elem, id) != null) {
                throw new IllegalStateException("Duplicate OLAPObject found: " + (Object)((Object)elem));
            }
            atts.put("id", id);
        }
        atts.put("parentColumn", elem.getParentColumn());
        atts.put("childColumn", elem.getChildColumn());
        this.writeStartTag("Closure", atts);
        LinkedHashMap<String, MondrianModel.Table> arrays = new LinkedHashMap<String, MondrianModel.Table>();
        arrays.put("table", elem.getTable());
        ++this.indent;
        for (Map.Entry array : arrays.entrySet()) {
            if (array.getValue() instanceof List) {
                List list = (List)array.getValue();
                if (oneTag && list.size() > 0) {
                    this.out.println(">");
                    oneTag = false;
                }
                for (OLAPObject obj : list) {
                    this.foolishWrite(obj);
                }
                continue;
            }
            if (!(array.getValue() instanceof OLAPObject)) continue;
            if (oneTag) {
                this.out.println(">");
                oneTag = false;
            }
            this.foolishWrite((OLAPObject)((Object)array.getValue()));
        }
        --this.indent;
        if (oneTag) {
            this.out.println("/>");
        } else {
            this.indentLine();
            this.out.println("</Closure>");
        }
    }

    public void writeProperty(MondrianModel.Property elem) {
        boolean oneTag = true;
        LinkedHashMap<String, Object> atts = new LinkedHashMap<String, Object>();
        if (this.idMap != null) {
            String id = Integer.toString(this.idMap.size());
            if (this.idMap.put(elem, id) != null) {
                throw new IllegalStateException("Duplicate OLAPObject found: " + (Object)((Object)elem));
            }
            atts.put("id", id);
        }
        atts.put("name", elem.getName());
        atts.put("column", elem.getColumn());
        atts.put("type", elem.getType());
        atts.put("formatter", elem.getFormatter());
        atts.put("caption", elem.getCaption());
        this.writeStartTag("Property", atts);
        LinkedHashMap arrays = new LinkedHashMap();
        ++this.indent;
        for (Map.Entry array : arrays.entrySet()) {
            if (array.getValue() instanceof List) {
                List list = (List)array.getValue();
                if (oneTag && list.size() > 0) {
                    this.out.println(">");
                    oneTag = false;
                }
                for (OLAPObject obj : list) {
                    this.foolishWrite(obj);
                }
                continue;
            }
            if (!(array.getValue() instanceof OLAPObject)) continue;
            if (oneTag) {
                this.out.println(">");
                oneTag = false;
            }
            this.foolishWrite((OLAPObject)((Object)array.getValue()));
        }
        --this.indent;
        if (oneTag) {
            this.out.println("/>");
        } else {
            this.indentLine();
            this.out.println("</Property>");
        }
    }

    public void writeMeasure(MondrianModel.Measure elem) {
        boolean oneTag = true;
        LinkedHashMap<String, Object> atts = new LinkedHashMap<String, Object>();
        if (this.idMap != null) {
            String id = Integer.toString(this.idMap.size());
            if (this.idMap.put(elem, id) != null) {
                throw new IllegalStateException("Duplicate OLAPObject found: " + (Object)((Object)elem));
            }
            atts.put("id", id);
        }
        atts.put("name", elem.getName());
        atts.put("column", elem.getColumn());
        atts.put("datatype", elem.getDatatype());
        atts.put("formatString", elem.getFormatString());
        atts.put("aggregator", elem.getAggregator());
        atts.put("formatter", elem.getFormatter());
        atts.put("caption", elem.getCaption());
        atts.put("visible", elem.getVisible());
        this.writeStartTag("Measure", atts);
        LinkedHashMap<String, Object> arrays = new LinkedHashMap<String, Object>();
        arrays.put("measureExp", (Object)elem.getMeasureExp());
        arrays.put("memberProperties", elem.getMemberProperties());
        ++this.indent;
        for (Map.Entry array : arrays.entrySet()) {
            if (array.getValue() instanceof List) {
                List list = (List)array.getValue();
                if (oneTag && list.size() > 0) {
                    this.out.println(">");
                    oneTag = false;
                }
                for (OLAPObject obj : list) {
                    this.foolishWrite(obj);
                }
                continue;
            }
            if (!(array.getValue() instanceof OLAPObject)) continue;
            if (oneTag) {
                this.out.println(">");
                oneTag = false;
            }
            this.foolishWrite((OLAPObject)((Object)array.getValue()));
        }
        --this.indent;
        if (oneTag) {
            this.out.println("/>");
        } else {
            this.indentLine();
            this.out.println("</Measure>");
        }
    }

    public void writeCalculatedMember(MondrianModel.CalculatedMember elem) {
        boolean oneTag = true;
        LinkedHashMap<String, Object> atts = new LinkedHashMap<String, Object>();
        if (this.idMap != null) {
            String id = Integer.toString(this.idMap.size());
            if (this.idMap.put(elem, id) != null) {
                throw new IllegalStateException("Duplicate OLAPObject found: " + (Object)((Object)elem));
            }
            atts.put("id", id);
        }
        atts.put("name", elem.getName());
        atts.put("formatString", elem.getFormatString());
        atts.put("caption", elem.getCaption());
        atts.put("formula", elem.getFormula());
        atts.put("dimension", elem.getDimension());
        atts.put("visible", elem.getVisible());
        this.writeStartTag("CalculatedMember", atts);
        LinkedHashMap<String, Object> arrays = new LinkedHashMap<String, Object>();
        arrays.put("formulaElement", (Object)elem.getFormulaElement());
        arrays.put("memberProperties", elem.getMemberProperties());
        ++this.indent;
        for (Map.Entry array : arrays.entrySet()) {
            if (array.getValue() instanceof List) {
                List list = (List)array.getValue();
                if (oneTag && list.size() > 0) {
                    this.out.println(">");
                    oneTag = false;
                }
                for (OLAPObject obj : list) {
                    this.foolishWrite(obj);
                }
                continue;
            }
            if (!(array.getValue() instanceof OLAPObject)) continue;
            if (oneTag) {
                this.out.println(">");
                oneTag = false;
            }
            this.foolishWrite((OLAPObject)((Object)array.getValue()));
        }
        --this.indent;
        if (oneTag) {
            this.out.println("/>");
        } else {
            this.indentLine();
            this.out.println("</CalculatedMember>");
        }
    }

    public void writeCalculatedMemberProperty(MondrianModel.CalculatedMemberProperty elem) {
        boolean oneTag = true;
        LinkedHashMap<String, Object> atts = new LinkedHashMap<String, Object>();
        if (this.idMap != null) {
            String id = Integer.toString(this.idMap.size());
            if (this.idMap.put(elem, id) != null) {
                throw new IllegalStateException("Duplicate OLAPObject found: " + (Object)((Object)elem));
            }
            atts.put("id", id);
        }
        atts.put("name", elem.getName());
        atts.put("caption", elem.getCaption());
        atts.put("expression", elem.getExpression());
        atts.put("value", elem.getValue());
        this.writeStartTag("CalculatedMemberProperty", atts);
        LinkedHashMap arrays = new LinkedHashMap();
        ++this.indent;
        for (Map.Entry array : arrays.entrySet()) {
            if (array.getValue() instanceof List) {
                List list = (List)array.getValue();
                if (oneTag && list.size() > 0) {
                    this.out.println(">");
                    oneTag = false;
                }
                for (OLAPObject obj : list) {
                    this.foolishWrite(obj);
                }
                continue;
            }
            if (!(array.getValue() instanceof OLAPObject)) continue;
            if (oneTag) {
                this.out.println(">");
                oneTag = false;
            }
            this.foolishWrite((OLAPObject)((Object)array.getValue()));
        }
        --this.indent;
        if (oneTag) {
            this.out.println("/>");
        } else {
            this.indentLine();
            this.out.println("</CalculatedMemberProperty>");
        }
    }

    public void writeNamedSet(MondrianModel.NamedSet elem) {
        boolean oneTag = true;
        LinkedHashMap<String, Object> atts = new LinkedHashMap<String, Object>();
        if (this.idMap != null) {
            String id = Integer.toString(this.idMap.size());
            if (this.idMap.put(elem, id) != null) {
                throw new IllegalStateException("Duplicate OLAPObject found: " + (Object)((Object)elem));
            }
            atts.put("id", id);
        }
        atts.put("name", elem.getName());
        atts.put("formula", elem.getFormula());
        this.writeStartTag("NamedSet", atts);
        LinkedHashMap<String, MondrianModel.Formula> arrays = new LinkedHashMap<String, MondrianModel.Formula>();
        arrays.put("formulaElement", elem.getFormulaElement());
        ++this.indent;
        for (Map.Entry array : arrays.entrySet()) {
            if (array.getValue() instanceof List) {
                List list = (List)array.getValue();
                if (oneTag && list.size() > 0) {
                    this.out.println(">");
                    oneTag = false;
                }
                for (OLAPObject obj : list) {
                    this.foolishWrite(obj);
                }
                continue;
            }
            if (!(array.getValue() instanceof OLAPObject)) continue;
            if (oneTag) {
                this.out.println(">");
                oneTag = false;
            }
            this.foolishWrite((OLAPObject)((Object)array.getValue()));
        }
        --this.indent;
        if (oneTag) {
            this.out.println("/>");
        } else {
            this.indentLine();
            this.out.println("</NamedSet>");
        }
    }

    public void writeFormula(MondrianModel.Formula elem) {
        boolean oneTag = true;
        LinkedHashMap<String, Object> atts = new LinkedHashMap<String, Object>();
        if (this.idMap != null) {
            String id = Integer.toString(this.idMap.size());
            if (this.idMap.put(elem, id) != null) {
                throw new IllegalStateException("Duplicate OLAPObject found: " + (Object)((Object)elem));
            }
            atts.put("id", id);
        }
        this.writeStartTag("Formula", atts);
        LinkedHashMap arrays = new LinkedHashMap();
        oneTag = false;
        this.out.println(">");
        ++this.indent;
        this.indentLine();
        --this.indent;
        this.out.println(elem.getText());
        ++this.indent;
        for (Map.Entry array : arrays.entrySet()) {
            if (array.getValue() instanceof List) {
                List list = (List)array.getValue();
                if (oneTag && list.size() > 0) {
                    this.out.println(">");
                    oneTag = false;
                }
                for (OLAPObject obj : list) {
                    this.foolishWrite(obj);
                }
                continue;
            }
            if (!(array.getValue() instanceof OLAPObject)) continue;
            if (oneTag) {
                this.out.println(">");
                oneTag = false;
            }
            this.foolishWrite((OLAPObject)((Object)array.getValue()));
        }
        --this.indent;
        if (oneTag) {
            this.out.println("/>");
        } else {
            this.indentLine();
            this.out.println("</Formula>");
        }
    }

    public void writeMemberReaderParameter(MondrianModel.MemberReaderParameter elem) {
        boolean oneTag = true;
        LinkedHashMap<String, Object> atts = new LinkedHashMap<String, Object>();
        if (this.idMap != null) {
            String id = Integer.toString(this.idMap.size());
            if (this.idMap.put(elem, id) != null) {
                throw new IllegalStateException("Duplicate OLAPObject found: " + (Object)((Object)elem));
            }
            atts.put("id", id);
        }
        atts.put("name", elem.getName());
        atts.put("value", elem.getValue());
        this.writeStartTag("MemberReaderParameter", atts);
        LinkedHashMap arrays = new LinkedHashMap();
        ++this.indent;
        for (Map.Entry array : arrays.entrySet()) {
            if (array.getValue() instanceof List) {
                List list = (List)array.getValue();
                if (oneTag && list.size() > 0) {
                    this.out.println(">");
                    oneTag = false;
                }
                for (OLAPObject obj : list) {
                    this.foolishWrite(obj);
                }
                continue;
            }
            if (!(array.getValue() instanceof OLAPObject)) continue;
            if (oneTag) {
                this.out.println(">");
                oneTag = false;
            }
            this.foolishWrite((OLAPObject)((Object)array.getValue()));
        }
        --this.indent;
        if (oneTag) {
            this.out.println("/>");
        } else {
            this.indentLine();
            this.out.println("</MemberReaderParameter>");
        }
    }

    private void writeRelationOrJoin(MondrianModel.RelationOrJoin elem) {
        this.foolishWrite(elem);
    }

    private void populateRelationOrJoinAttributes(MondrianModel.RelationOrJoin elem, Map<String, Object> atts) {
    }

    private void populateRelationOrJoinArrays(MondrianModel.RelationOrJoin elem, Map<String, Object> arrays) {
    }

    private void writeRelation(MondrianModel.Relation elem) {
        this.foolishWrite(elem);
    }

    private void populateRelationAttributes(MondrianModel.Relation elem, Map<String, Object> atts) {
        this.populateRelationOrJoinAttributes(elem, atts);
    }

    private void populateRelationArrays(MondrianModel.Relation elem, Map<String, Object> arrays) {
        this.populateRelationOrJoinArrays(elem, arrays);
    }

    public void writeView(MondrianModel.View elem) {
        boolean oneTag = true;
        LinkedHashMap<String, Object> atts = new LinkedHashMap<String, Object>();
        if (this.idMap != null) {
            String id = Integer.toString(this.idMap.size());
            if (this.idMap.put(elem, id) != null) {
                throw new IllegalStateException("Duplicate OLAPObject found: " + (Object)((Object)elem));
            }
            atts.put("id", id);
        }
        atts.put("alias", elem.getAlias());
        this.populateRelationAttributes(elem, atts);
        this.writeStartTag("View", atts);
        LinkedHashMap<String, Object> arrays = new LinkedHashMap<String, Object>();
        arrays.put("selects", elem.getSelects());
        this.populateRelationArrays(elem, arrays);
        ++this.indent;
        for (Map.Entry array : arrays.entrySet()) {
            if (array.getValue() instanceof List) {
                List list = (List)array.getValue();
                if (oneTag && list.size() > 0) {
                    this.out.println(">");
                    oneTag = false;
                }
                for (OLAPObject obj : list) {
                    this.foolishWrite(obj);
                }
                continue;
            }
            if (!(array.getValue() instanceof OLAPObject)) continue;
            if (oneTag) {
                this.out.println(">");
                oneTag = false;
            }
            this.foolishWrite((OLAPObject)((Object)array.getValue()));
        }
        --this.indent;
        if (oneTag) {
            this.out.println("/>");
        } else {
            this.indentLine();
            this.out.println("</View>");
        }
    }

    public void writeSQL(MondrianModel.SQL elem) {
        boolean oneTag = true;
        LinkedHashMap<String, Object> atts = new LinkedHashMap<String, Object>();
        if (this.idMap != null) {
            String id = Integer.toString(this.idMap.size());
            if (this.idMap.put(elem, id) != null) {
                throw new IllegalStateException("Duplicate OLAPObject found: " + (Object)((Object)elem));
            }
            atts.put("id", id);
        }
        atts.put("dialect", elem.getDialect());
        this.writeStartTag("SQL", atts);
        LinkedHashMap arrays = new LinkedHashMap();
        oneTag = false;
        this.out.println(">");
        ++this.indent;
        this.indentLine();
        --this.indent;
        this.out.println(elem.getText());
        ++this.indent;
        for (Map.Entry array : arrays.entrySet()) {
            if (array.getValue() instanceof List) {
                List list = (List)array.getValue();
                if (oneTag && list.size() > 0) {
                    this.out.println(">");
                    oneTag = false;
                }
                for (OLAPObject obj : list) {
                    this.foolishWrite(obj);
                }
                continue;
            }
            if (!(array.getValue() instanceof OLAPObject)) continue;
            if (oneTag) {
                this.out.println(">");
                oneTag = false;
            }
            this.foolishWrite((OLAPObject)((Object)array.getValue()));
        }
        --this.indent;
        if (oneTag) {
            this.out.println("/>");
        } else {
            this.indentLine();
            this.out.println("</SQL>");
        }
    }

    public void writeJoin(MondrianModel.Join elem) {
        boolean oneTag = true;
        LinkedHashMap<String, Object> atts = new LinkedHashMap<String, Object>();
        if (this.idMap != null) {
            String id = Integer.toString(this.idMap.size());
            if (this.idMap.put(elem, id) != null) {
                throw new IllegalStateException("Duplicate OLAPObject found: " + (Object)((Object)elem));
            }
            atts.put("id", id);
        }
        atts.put("leftAlias", elem.getLeftAlias());
        atts.put("leftKey", elem.getLeftKey());
        atts.put("rightAlias", elem.getRightAlias());
        atts.put("rightKey", elem.getRightKey());
        this.populateRelationOrJoinAttributes(elem, atts);
        this.writeStartTag("Join", atts);
        LinkedHashMap<String, Object> arrays = new LinkedHashMap<String, Object>();
        arrays.put("left", (Object)elem.getLeft());
        arrays.put("right", (Object)elem.getRight());
        this.populateRelationOrJoinArrays(elem, arrays);
        ++this.indent;
        for (Map.Entry array : arrays.entrySet()) {
            if (array.getValue() instanceof List) {
                List list = (List)array.getValue();
                if (oneTag && list.size() > 0) {
                    this.out.println(">");
                    oneTag = false;
                }
                for (OLAPObject obj : list) {
                    this.foolishWrite(obj);
                }
                continue;
            }
            if (!(array.getValue() instanceof OLAPObject)) continue;
            if (oneTag) {
                this.out.println(">");
                oneTag = false;
            }
            this.foolishWrite((OLAPObject)((Object)array.getValue()));
        }
        --this.indent;
        if (oneTag) {
            this.out.println("/>");
        } else {
            this.indentLine();
            this.out.println("</Join>");
        }
    }

    public void writeTable(MondrianModel.Table elem) {
        boolean oneTag = true;
        LinkedHashMap<String, Object> atts = new LinkedHashMap<String, Object>();
        if (this.idMap != null) {
            String id = Integer.toString(this.idMap.size());
            if (this.idMap.put(elem, id) != null) {
                throw new IllegalStateException("Duplicate OLAPObject found: " + (Object)((Object)elem));
            }
            atts.put("id", id);
        }
        atts.put("name", elem.getName());
        atts.put("schema", elem.getSchema());
        atts.put("alias", elem.getAlias());
        this.populateRelationAttributes(elem, atts);
        this.writeStartTag("Table", atts);
        LinkedHashMap<String, Object> arrays = new LinkedHashMap<String, Object>();
        arrays.put("filter", (Object)elem.getFilter());
        arrays.put("aggExcludes", elem.getAggExcludes());
        arrays.put("aggTables", elem.getAggTables());
        this.populateRelationArrays(elem, arrays);
        ++this.indent;
        for (Map.Entry array : arrays.entrySet()) {
            if (array.getValue() instanceof List) {
                List list = (List)array.getValue();
                if (oneTag && list.size() > 0) {
                    this.out.println(">");
                    oneTag = false;
                }
                for (OLAPObject obj : list) {
                    this.foolishWrite(obj);
                }
                continue;
            }
            if (!(array.getValue() instanceof OLAPObject)) continue;
            if (oneTag) {
                this.out.println(">");
                oneTag = false;
            }
            this.foolishWrite((OLAPObject)((Object)array.getValue()));
        }
        --this.indent;
        if (oneTag) {
            this.out.println("/>");
        } else {
            this.indentLine();
            this.out.println("</Table>");
        }
    }

    public void writeInlineTable(MondrianModel.InlineTable elem) {
        boolean oneTag = true;
        LinkedHashMap<String, Object> atts = new LinkedHashMap<String, Object>();
        if (this.idMap != null) {
            String id = Integer.toString(this.idMap.size());
            if (this.idMap.put(elem, id) != null) {
                throw new IllegalStateException("Duplicate OLAPObject found: " + (Object)((Object)elem));
            }
            atts.put("id", id);
        }
        atts.put("alias", elem.getAlias());
        this.populateRelationAttributes(elem, atts);
        this.writeStartTag("InlineTable", atts);
        LinkedHashMap<String, Object> arrays = new LinkedHashMap<String, Object>();
        arrays.put("columnDefs", (Object)elem.getColumnDefs());
        arrays.put("rows", (Object)elem.getRows());
        this.populateRelationArrays(elem, arrays);
        ++this.indent;
        for (Map.Entry array : arrays.entrySet()) {
            if (array.getValue() instanceof List) {
                List list = (List)array.getValue();
                if (oneTag && list.size() > 0) {
                    this.out.println(">");
                    oneTag = false;
                }
                for (OLAPObject obj : list) {
                    this.foolishWrite(obj);
                }
                continue;
            }
            if (!(array.getValue() instanceof OLAPObject)) continue;
            if (oneTag) {
                this.out.println(">");
                oneTag = false;
            }
            this.foolishWrite((OLAPObject)((Object)array.getValue()));
        }
        --this.indent;
        if (oneTag) {
            this.out.println("/>");
        } else {
            this.indentLine();
            this.out.println("</InlineTable>");
        }
    }

    public void writeColumnDefs(MondrianModel.ColumnDefs elem) {
        boolean oneTag = true;
        LinkedHashMap<String, Object> atts = new LinkedHashMap<String, Object>();
        if (this.idMap != null) {
            String id = Integer.toString(this.idMap.size());
            if (this.idMap.put(elem, id) != null) {
                throw new IllegalStateException("Duplicate OLAPObject found: " + (Object)((Object)elem));
            }
            atts.put("id", id);
        }
        this.writeStartTag("ColumnDefs", atts);
        LinkedHashMap<String, List<MondrianModel.ColumnDef>> arrays = new LinkedHashMap<String, List<MondrianModel.ColumnDef>>();
        arrays.put("array", elem.getArray());
        ++this.indent;
        for (Map.Entry array : arrays.entrySet()) {
            if (array.getValue() instanceof List) {
                List list = (List)array.getValue();
                if (oneTag && list.size() > 0) {
                    this.out.println(">");
                    oneTag = false;
                }
                for (OLAPObject obj : list) {
                    this.foolishWrite(obj);
                }
                continue;
            }
            if (!(array.getValue() instanceof OLAPObject)) continue;
            if (oneTag) {
                this.out.println(">");
                oneTag = false;
            }
            this.foolishWrite((OLAPObject)((Object)array.getValue()));
        }
        --this.indent;
        if (oneTag) {
            this.out.println("/>");
        } else {
            this.indentLine();
            this.out.println("</ColumnDefs>");
        }
    }

    public void writeColumnDef(MondrianModel.ColumnDef elem) {
        boolean oneTag = true;
        LinkedHashMap<String, Object> atts = new LinkedHashMap<String, Object>();
        if (this.idMap != null) {
            String id = Integer.toString(this.idMap.size());
            if (this.idMap.put(elem, id) != null) {
                throw new IllegalStateException("Duplicate OLAPObject found: " + (Object)((Object)elem));
            }
            atts.put("id", id);
        }
        atts.put("name", elem.getName());
        atts.put("type", elem.getType());
        this.writeStartTag("ColumnDef", atts);
        LinkedHashMap arrays = new LinkedHashMap();
        ++this.indent;
        for (Map.Entry array : arrays.entrySet()) {
            if (array.getValue() instanceof List) {
                List list = (List)array.getValue();
                if (oneTag && list.size() > 0) {
                    this.out.println(">");
                    oneTag = false;
                }
                for (OLAPObject obj : list) {
                    this.foolishWrite(obj);
                }
                continue;
            }
            if (!(array.getValue() instanceof OLAPObject)) continue;
            if (oneTag) {
                this.out.println(">");
                oneTag = false;
            }
            this.foolishWrite((OLAPObject)((Object)array.getValue()));
        }
        --this.indent;
        if (oneTag) {
            this.out.println("/>");
        } else {
            this.indentLine();
            this.out.println("</ColumnDef>");
        }
    }

    public void writeRows(MondrianModel.Rows elem) {
        boolean oneTag = true;
        LinkedHashMap<String, Object> atts = new LinkedHashMap<String, Object>();
        if (this.idMap != null) {
            String id = Integer.toString(this.idMap.size());
            if (this.idMap.put(elem, id) != null) {
                throw new IllegalStateException("Duplicate OLAPObject found: " + (Object)((Object)elem));
            }
            atts.put("id", id);
        }
        this.writeStartTag("Rows", atts);
        LinkedHashMap<String, List<MondrianModel.Row>> arrays = new LinkedHashMap<String, List<MondrianModel.Row>>();
        arrays.put("array", elem.getArray());
        ++this.indent;
        for (Map.Entry array : arrays.entrySet()) {
            if (array.getValue() instanceof List) {
                List list = (List)array.getValue();
                if (oneTag && list.size() > 0) {
                    this.out.println(">");
                    oneTag = false;
                }
                for (OLAPObject obj : list) {
                    this.foolishWrite(obj);
                }
                continue;
            }
            if (!(array.getValue() instanceof OLAPObject)) continue;
            if (oneTag) {
                this.out.println(">");
                oneTag = false;
            }
            this.foolishWrite((OLAPObject)((Object)array.getValue()));
        }
        --this.indent;
        if (oneTag) {
            this.out.println("/>");
        } else {
            this.indentLine();
            this.out.println("</Rows>");
        }
    }

    public void writeRow(MondrianModel.Row elem) {
        boolean oneTag = true;
        LinkedHashMap<String, Object> atts = new LinkedHashMap<String, Object>();
        if (this.idMap != null) {
            String id = Integer.toString(this.idMap.size());
            if (this.idMap.put(elem, id) != null) {
                throw new IllegalStateException("Duplicate OLAPObject found: " + (Object)((Object)elem));
            }
            atts.put("id", id);
        }
        this.writeStartTag("Row", atts);
        LinkedHashMap<String, List<MondrianModel.Value>> arrays = new LinkedHashMap<String, List<MondrianModel.Value>>();
        arrays.put("values", elem.getValues());
        ++this.indent;
        for (Map.Entry array : arrays.entrySet()) {
            if (array.getValue() instanceof List) {
                List list = (List)array.getValue();
                if (oneTag && list.size() > 0) {
                    this.out.println(">");
                    oneTag = false;
                }
                for (OLAPObject obj : list) {
                    this.foolishWrite(obj);
                }
                continue;
            }
            if (!(array.getValue() instanceof OLAPObject)) continue;
            if (oneTag) {
                this.out.println(">");
                oneTag = false;
            }
            this.foolishWrite((OLAPObject)((Object)array.getValue()));
        }
        --this.indent;
        if (oneTag) {
            this.out.println("/>");
        } else {
            this.indentLine();
            this.out.println("</Row>");
        }
    }

    public void writeValue(MondrianModel.Value elem) {
        boolean oneTag = true;
        LinkedHashMap<String, Object> atts = new LinkedHashMap<String, Object>();
        if (this.idMap != null) {
            String id = Integer.toString(this.idMap.size());
            if (this.idMap.put(elem, id) != null) {
                throw new IllegalStateException("Duplicate OLAPObject found: " + (Object)((Object)elem));
            }
            atts.put("id", id);
        }
        atts.put("column", elem.getColumn());
        this.writeStartTag("Value", atts);
        LinkedHashMap arrays = new LinkedHashMap();
        oneTag = false;
        this.out.println(">");
        ++this.indent;
        this.indentLine();
        --this.indent;
        this.out.println(elem.getText());
        ++this.indent;
        for (Map.Entry array : arrays.entrySet()) {
            if (array.getValue() instanceof List) {
                List list = (List)array.getValue();
                if (oneTag && list.size() > 0) {
                    this.out.println(">");
                    oneTag = false;
                }
                for (OLAPObject obj : list) {
                    this.foolishWrite(obj);
                }
                continue;
            }
            if (!(array.getValue() instanceof OLAPObject)) continue;
            if (oneTag) {
                this.out.println(">");
                oneTag = false;
            }
            this.foolishWrite((OLAPObject)((Object)array.getValue()));
        }
        --this.indent;
        if (oneTag) {
            this.out.println("/>");
        } else {
            this.indentLine();
            this.out.println("</Value>");
        }
    }

    private void writeAggTable(MondrianModel.AggTable elem) {
        this.foolishWrite(elem);
    }

    private void populateAggTableAttributes(MondrianModel.AggTable elem, Map<String, Object> atts) {
        atts.put("ignorecase", elem.getIgnorecase());
    }

    private void populateAggTableArrays(MondrianModel.AggTable elem, Map<String, Object> arrays) {
        arrays.put("factcount", (Object)elem.getFactcount());
        arrays.put("ignoreColumns", elem.getIgnoreColumns());
        arrays.put("foreignKeys", elem.getForeignKeys());
        arrays.put("measures", elem.getMeasures());
        arrays.put("levels", elem.getLevels());
    }

    public void writeAggName(MondrianModel.AggName elem) {
        boolean oneTag = true;
        LinkedHashMap<String, Object> atts = new LinkedHashMap<String, Object>();
        if (this.idMap != null) {
            String id = Integer.toString(this.idMap.size());
            if (this.idMap.put(elem, id) != null) {
                throw new IllegalStateException("Duplicate OLAPObject found: " + (Object)((Object)elem));
            }
            atts.put("id", id);
        }
        atts.put("name", elem.getName());
        this.populateAggTableAttributes(elem, atts);
        this.writeStartTag("AggName", atts);
        LinkedHashMap<String, Object> arrays = new LinkedHashMap<String, Object>();
        this.populateAggTableArrays(elem, arrays);
        ++this.indent;
        for (Map.Entry array : arrays.entrySet()) {
            if (array.getValue() instanceof List) {
                List list = (List)array.getValue();
                if (oneTag && list.size() > 0) {
                    this.out.println(">");
                    oneTag = false;
                }
                for (OLAPObject obj : list) {
                    this.foolishWrite(obj);
                }
                continue;
            }
            if (!(array.getValue() instanceof OLAPObject)) continue;
            if (oneTag) {
                this.out.println(">");
                oneTag = false;
            }
            this.foolishWrite((OLAPObject)((Object)array.getValue()));
        }
        --this.indent;
        if (oneTag) {
            this.out.println("/>");
        } else {
            this.indentLine();
            this.out.println("</AggName>");
        }
    }

    public void writeAggPattern(MondrianModel.AggPattern elem) {
        boolean oneTag = true;
        LinkedHashMap<String, Object> atts = new LinkedHashMap<String, Object>();
        if (this.idMap != null) {
            String id = Integer.toString(this.idMap.size());
            if (this.idMap.put(elem, id) != null) {
                throw new IllegalStateException("Duplicate OLAPObject found: " + (Object)((Object)elem));
            }
            atts.put("id", id);
        }
        atts.put("pattern", elem.getPattern());
        this.populateAggTableAttributes(elem, atts);
        this.writeStartTag("AggPattern", atts);
        LinkedHashMap<String, Object> arrays = new LinkedHashMap<String, Object>();
        arrays.put("excludes", elem.getExcludes());
        this.populateAggTableArrays(elem, arrays);
        ++this.indent;
        for (Map.Entry array : arrays.entrySet()) {
            if (array.getValue() instanceof List) {
                List list = (List)array.getValue();
                if (oneTag && list.size() > 0) {
                    this.out.println(">");
                    oneTag = false;
                }
                for (OLAPObject obj : list) {
                    this.foolishWrite(obj);
                }
                continue;
            }
            if (!(array.getValue() instanceof OLAPObject)) continue;
            if (oneTag) {
                this.out.println(">");
                oneTag = false;
            }
            this.foolishWrite((OLAPObject)((Object)array.getValue()));
        }
        --this.indent;
        if (oneTag) {
            this.out.println("/>");
        } else {
            this.indentLine();
            this.out.println("</AggPattern>");
        }
    }

    public void writeAggExclude(MondrianModel.AggExclude elem) {
        boolean oneTag = true;
        LinkedHashMap<String, Object> atts = new LinkedHashMap<String, Object>();
        if (this.idMap != null) {
            String id = Integer.toString(this.idMap.size());
            if (this.idMap.put(elem, id) != null) {
                throw new IllegalStateException("Duplicate OLAPObject found: " + (Object)((Object)elem));
            }
            atts.put("id", id);
        }
        atts.put("pattern", elem.getPattern());
        atts.put("name", elem.getName());
        atts.put("ignorecase", elem.getIgnorecase());
        this.writeStartTag("AggExclude", atts);
        LinkedHashMap arrays = new LinkedHashMap();
        ++this.indent;
        for (Map.Entry array : arrays.entrySet()) {
            if (array.getValue() instanceof List) {
                List list = (List)array.getValue();
                if (oneTag && list.size() > 0) {
                    this.out.println(">");
                    oneTag = false;
                }
                for (OLAPObject obj : list) {
                    this.foolishWrite(obj);
                }
                continue;
            }
            if (!(array.getValue() instanceof OLAPObject)) continue;
            if (oneTag) {
                this.out.println(">");
                oneTag = false;
            }
            this.foolishWrite((OLAPObject)((Object)array.getValue()));
        }
        --this.indent;
        if (oneTag) {
            this.out.println("/>");
        } else {
            this.indentLine();
            this.out.println("</AggExclude>");
        }
    }

    private void writeAggColumnName(MondrianModel.AggColumnName elem) {
        this.foolishWrite(elem);
    }

    private void populateAggColumnNameAttributes(MondrianModel.AggColumnName elem, Map<String, Object> atts) {
        atts.put("column", elem.getColumn());
    }

    private void populateAggColumnNameArrays(MondrianModel.AggColumnName elem, Map<String, Object> arrays) {
    }

    public void writeAggFactCount(MondrianModel.AggFactCount elem) {
        boolean oneTag = true;
        LinkedHashMap<String, Object> atts = new LinkedHashMap<String, Object>();
        if (this.idMap != null) {
            String id = Integer.toString(this.idMap.size());
            if (this.idMap.put(elem, id) != null) {
                throw new IllegalStateException("Duplicate OLAPObject found: " + (Object)((Object)elem));
            }
            atts.put("id", id);
        }
        this.populateAggColumnNameAttributes(elem, atts);
        this.writeStartTag("AggFactCount", atts);
        LinkedHashMap<String, Object> arrays = new LinkedHashMap<String, Object>();
        this.populateAggColumnNameArrays(elem, arrays);
        ++this.indent;
        for (Map.Entry array : arrays.entrySet()) {
            if (array.getValue() instanceof List) {
                List list = (List)array.getValue();
                if (oneTag && list.size() > 0) {
                    this.out.println(">");
                    oneTag = false;
                }
                for (OLAPObject obj : list) {
                    this.foolishWrite(obj);
                }
                continue;
            }
            if (!(array.getValue() instanceof OLAPObject)) continue;
            if (oneTag) {
                this.out.println(">");
                oneTag = false;
            }
            this.foolishWrite((OLAPObject)((Object)array.getValue()));
        }
        --this.indent;
        if (oneTag) {
            this.out.println("/>");
        } else {
            this.indentLine();
            this.out.println("</AggFactCount>");
        }
    }

    public void writeAggIgnoreColumn(MondrianModel.AggIgnoreColumn elem) {
        boolean oneTag = true;
        LinkedHashMap<String, Object> atts = new LinkedHashMap<String, Object>();
        if (this.idMap != null) {
            String id = Integer.toString(this.idMap.size());
            if (this.idMap.put(elem, id) != null) {
                throw new IllegalStateException("Duplicate OLAPObject found: " + (Object)((Object)elem));
            }
            atts.put("id", id);
        }
        this.populateAggColumnNameAttributes(elem, atts);
        this.writeStartTag("AggIgnoreColumn", atts);
        LinkedHashMap<String, Object> arrays = new LinkedHashMap<String, Object>();
        this.populateAggColumnNameArrays(elem, arrays);
        ++this.indent;
        for (Map.Entry array : arrays.entrySet()) {
            if (array.getValue() instanceof List) {
                List list = (List)array.getValue();
                if (oneTag && list.size() > 0) {
                    this.out.println(">");
                    oneTag = false;
                }
                for (OLAPObject obj : list) {
                    this.foolishWrite(obj);
                }
                continue;
            }
            if (!(array.getValue() instanceof OLAPObject)) continue;
            if (oneTag) {
                this.out.println(">");
                oneTag = false;
            }
            this.foolishWrite((OLAPObject)((Object)array.getValue()));
        }
        --this.indent;
        if (oneTag) {
            this.out.println("/>");
        } else {
            this.indentLine();
            this.out.println("</AggIgnoreColumn>");
        }
    }

    public void writeAggForeignKey(MondrianModel.AggForeignKey elem) {
        boolean oneTag = true;
        LinkedHashMap<String, Object> atts = new LinkedHashMap<String, Object>();
        if (this.idMap != null) {
            String id = Integer.toString(this.idMap.size());
            if (this.idMap.put(elem, id) != null) {
                throw new IllegalStateException("Duplicate OLAPObject found: " + (Object)((Object)elem));
            }
            atts.put("id", id);
        }
        atts.put("factColumn", elem.getFactColumn());
        atts.put("aggColumn", elem.getAggColumn());
        this.writeStartTag("AggForeignKey", atts);
        LinkedHashMap arrays = new LinkedHashMap();
        ++this.indent;
        for (Map.Entry array : arrays.entrySet()) {
            if (array.getValue() instanceof List) {
                List list = (List)array.getValue();
                if (oneTag && list.size() > 0) {
                    this.out.println(">");
                    oneTag = false;
                }
                for (OLAPObject obj : list) {
                    this.foolishWrite(obj);
                }
                continue;
            }
            if (!(array.getValue() instanceof OLAPObject)) continue;
            if (oneTag) {
                this.out.println(">");
                oneTag = false;
            }
            this.foolishWrite((OLAPObject)((Object)array.getValue()));
        }
        --this.indent;
        if (oneTag) {
            this.out.println("/>");
        } else {
            this.indentLine();
            this.out.println("</AggForeignKey>");
        }
    }

    public void writeAggLevel(MondrianModel.AggLevel elem) {
        boolean oneTag = true;
        LinkedHashMap<String, Object> atts = new LinkedHashMap<String, Object>();
        if (this.idMap != null) {
            String id = Integer.toString(this.idMap.size());
            if (this.idMap.put(elem, id) != null) {
                throw new IllegalStateException("Duplicate OLAPObject found: " + (Object)((Object)elem));
            }
            atts.put("id", id);
        }
        atts.put("column", elem.getColumn());
        atts.put("name", elem.getName());
        this.writeStartTag("AggLevel", atts);
        LinkedHashMap arrays = new LinkedHashMap();
        ++this.indent;
        for (Map.Entry array : arrays.entrySet()) {
            if (array.getValue() instanceof List) {
                List list = (List)array.getValue();
                if (oneTag && list.size() > 0) {
                    this.out.println(">");
                    oneTag = false;
                }
                for (OLAPObject obj : list) {
                    this.foolishWrite(obj);
                }
                continue;
            }
            if (!(array.getValue() instanceof OLAPObject)) continue;
            if (oneTag) {
                this.out.println(">");
                oneTag = false;
            }
            this.foolishWrite((OLAPObject)((Object)array.getValue()));
        }
        --this.indent;
        if (oneTag) {
            this.out.println("/>");
        } else {
            this.indentLine();
            this.out.println("</AggLevel>");
        }
    }

    public void writeAggMeasure(MondrianModel.AggMeasure elem) {
        boolean oneTag = true;
        LinkedHashMap<String, Object> atts = new LinkedHashMap<String, Object>();
        if (this.idMap != null) {
            String id = Integer.toString(this.idMap.size());
            if (this.idMap.put(elem, id) != null) {
                throw new IllegalStateException("Duplicate OLAPObject found: " + (Object)((Object)elem));
            }
            atts.put("id", id);
        }
        atts.put("column", elem.getColumn());
        atts.put("name", elem.getName());
        this.writeStartTag("AggMeasure", atts);
        LinkedHashMap arrays = new LinkedHashMap();
        ++this.indent;
        for (Map.Entry array : arrays.entrySet()) {
            if (array.getValue() instanceof List) {
                List list = (List)array.getValue();
                if (oneTag && list.size() > 0) {
                    this.out.println(">");
                    oneTag = false;
                }
                for (OLAPObject obj : list) {
                    this.foolishWrite(obj);
                }
                continue;
            }
            if (!(array.getValue() instanceof OLAPObject)) continue;
            if (oneTag) {
                this.out.println(">");
                oneTag = false;
            }
            this.foolishWrite((OLAPObject)((Object)array.getValue()));
        }
        --this.indent;
        if (oneTag) {
            this.out.println("/>");
        } else {
            this.indentLine();
            this.out.println("</AggMeasure>");
        }
    }

    private void writeExpression(MondrianModel.Expression elem) {
        this.foolishWrite(elem);
    }

    private void populateExpressionAttributes(MondrianModel.Expression elem, Map<String, Object> atts) {
    }

    private void populateExpressionArrays(MondrianModel.Expression elem, Map<String, Object> arrays) {
    }

    public void writeColumn(MondrianModel.Column elem) {
        boolean oneTag = true;
        LinkedHashMap<String, Object> atts = new LinkedHashMap<String, Object>();
        if (this.idMap != null) {
            String id = Integer.toString(this.idMap.size());
            if (this.idMap.put(elem, id) != null) {
                throw new IllegalStateException("Duplicate OLAPObject found: " + (Object)((Object)elem));
            }
            atts.put("id", id);
        }
        atts.put("table", elem.getTable());
        atts.put("name", elem.getName());
        this.populateExpressionAttributes(elem, atts);
        this.writeStartTag("Column", atts);
        LinkedHashMap<String, Object> arrays = new LinkedHashMap<String, Object>();
        this.populateExpressionArrays(elem, arrays);
        ++this.indent;
        for (Map.Entry array : arrays.entrySet()) {
            if (array.getValue() instanceof List) {
                List list = (List)array.getValue();
                if (oneTag && list.size() > 0) {
                    this.out.println(">");
                    oneTag = false;
                }
                for (OLAPObject obj : list) {
                    this.foolishWrite(obj);
                }
                continue;
            }
            if (!(array.getValue() instanceof OLAPObject)) continue;
            if (oneTag) {
                this.out.println(">");
                oneTag = false;
            }
            this.foolishWrite((OLAPObject)((Object)array.getValue()));
        }
        --this.indent;
        if (oneTag) {
            this.out.println("/>");
        } else {
            this.indentLine();
            this.out.println("</Column>");
        }
    }

    private void writeExpressionView(MondrianModel.ExpressionView elem) {
        this.foolishWrite(elem);
    }

    private void populateExpressionViewAttributes(MondrianModel.ExpressionView elem, Map<String, Object> atts) {
        this.populateExpressionAttributes(elem, atts);
    }

    private void populateExpressionViewArrays(MondrianModel.ExpressionView elem, Map<String, Object> arrays) {
        arrays.put("expressions", elem.getExpressions());
        this.populateExpressionArrays(elem, arrays);
    }

    public void writeKeyExpression(MondrianModel.KeyExpression elem) {
        boolean oneTag = true;
        LinkedHashMap<String, Object> atts = new LinkedHashMap<String, Object>();
        if (this.idMap != null) {
            String id = Integer.toString(this.idMap.size());
            if (this.idMap.put(elem, id) != null) {
                throw new IllegalStateException("Duplicate OLAPObject found: " + (Object)((Object)elem));
            }
            atts.put("id", id);
        }
        this.populateExpressionViewAttributes(elem, atts);
        this.writeStartTag("KeyExpression", atts);
        LinkedHashMap<String, Object> arrays = new LinkedHashMap<String, Object>();
        this.populateExpressionViewArrays(elem, arrays);
        ++this.indent;
        for (Map.Entry array : arrays.entrySet()) {
            if (array.getValue() instanceof List) {
                List list = (List)array.getValue();
                if (oneTag && list.size() > 0) {
                    this.out.println(">");
                    oneTag = false;
                }
                for (OLAPObject obj : list) {
                    this.foolishWrite(obj);
                }
                continue;
            }
            if (!(array.getValue() instanceof OLAPObject)) continue;
            if (oneTag) {
                this.out.println(">");
                oneTag = false;
            }
            this.foolishWrite((OLAPObject)((Object)array.getValue()));
        }
        --this.indent;
        if (oneTag) {
            this.out.println("/>");
        } else {
            this.indentLine();
            this.out.println("</KeyExpression>");
        }
    }

    public void writeParentExpression(MondrianModel.ParentExpression elem) {
        boolean oneTag = true;
        LinkedHashMap<String, Object> atts = new LinkedHashMap<String, Object>();
        if (this.idMap != null) {
            String id = Integer.toString(this.idMap.size());
            if (this.idMap.put(elem, id) != null) {
                throw new IllegalStateException("Duplicate OLAPObject found: " + (Object)((Object)elem));
            }
            atts.put("id", id);
        }
        this.populateExpressionViewAttributes(elem, atts);
        this.writeStartTag("ParentExpression", atts);
        LinkedHashMap<String, Object> arrays = new LinkedHashMap<String, Object>();
        this.populateExpressionViewArrays(elem, arrays);
        ++this.indent;
        for (Map.Entry array : arrays.entrySet()) {
            if (array.getValue() instanceof List) {
                List list = (List)array.getValue();
                if (oneTag && list.size() > 0) {
                    this.out.println(">");
                    oneTag = false;
                }
                for (OLAPObject obj : list) {
                    this.foolishWrite(obj);
                }
                continue;
            }
            if (!(array.getValue() instanceof OLAPObject)) continue;
            if (oneTag) {
                this.out.println(">");
                oneTag = false;
            }
            this.foolishWrite((OLAPObject)((Object)array.getValue()));
        }
        --this.indent;
        if (oneTag) {
            this.out.println("/>");
        } else {
            this.indentLine();
            this.out.println("</ParentExpression>");
        }
    }

    public void writeOrdinalExpression(MondrianModel.OrdinalExpression elem) {
        boolean oneTag = true;
        LinkedHashMap<String, Object> atts = new LinkedHashMap<String, Object>();
        if (this.idMap != null) {
            String id = Integer.toString(this.idMap.size());
            if (this.idMap.put(elem, id) != null) {
                throw new IllegalStateException("Duplicate OLAPObject found: " + (Object)((Object)elem));
            }
            atts.put("id", id);
        }
        this.populateExpressionViewAttributes(elem, atts);
        this.writeStartTag("OrdinalExpression", atts);
        LinkedHashMap<String, Object> arrays = new LinkedHashMap<String, Object>();
        this.populateExpressionViewArrays(elem, arrays);
        ++this.indent;
        for (Map.Entry array : arrays.entrySet()) {
            if (array.getValue() instanceof List) {
                List list = (List)array.getValue();
                if (oneTag && list.size() > 0) {
                    this.out.println(">");
                    oneTag = false;
                }
                for (OLAPObject obj : list) {
                    this.foolishWrite(obj);
                }
                continue;
            }
            if (!(array.getValue() instanceof OLAPObject)) continue;
            if (oneTag) {
                this.out.println(">");
                oneTag = false;
            }
            this.foolishWrite((OLAPObject)((Object)array.getValue()));
        }
        --this.indent;
        if (oneTag) {
            this.out.println("/>");
        } else {
            this.indentLine();
            this.out.println("</OrdinalExpression>");
        }
    }

    public void writeNameExpression(MondrianModel.NameExpression elem) {
        boolean oneTag = true;
        LinkedHashMap<String, Object> atts = new LinkedHashMap<String, Object>();
        if (this.idMap != null) {
            String id = Integer.toString(this.idMap.size());
            if (this.idMap.put(elem, id) != null) {
                throw new IllegalStateException("Duplicate OLAPObject found: " + (Object)((Object)elem));
            }
            atts.put("id", id);
        }
        this.populateExpressionViewAttributes(elem, atts);
        this.writeStartTag("NameExpression", atts);
        LinkedHashMap<String, Object> arrays = new LinkedHashMap<String, Object>();
        this.populateExpressionViewArrays(elem, arrays);
        ++this.indent;
        for (Map.Entry array : arrays.entrySet()) {
            if (array.getValue() instanceof List) {
                List list = (List)array.getValue();
                if (oneTag && list.size() > 0) {
                    this.out.println(">");
                    oneTag = false;
                }
                for (OLAPObject obj : list) {
                    this.foolishWrite(obj);
                }
                continue;
            }
            if (!(array.getValue() instanceof OLAPObject)) continue;
            if (oneTag) {
                this.out.println(">");
                oneTag = false;
            }
            this.foolishWrite((OLAPObject)((Object)array.getValue()));
        }
        --this.indent;
        if (oneTag) {
            this.out.println("/>");
        } else {
            this.indentLine();
            this.out.println("</NameExpression>");
        }
    }

    public void writeCaptionExpression(MondrianModel.CaptionExpression elem) {
        boolean oneTag = true;
        LinkedHashMap<String, Object> atts = new LinkedHashMap<String, Object>();
        if (this.idMap != null) {
            String id = Integer.toString(this.idMap.size());
            if (this.idMap.put(elem, id) != null) {
                throw new IllegalStateException("Duplicate OLAPObject found: " + (Object)((Object)elem));
            }
            atts.put("id", id);
        }
        this.populateExpressionViewAttributes(elem, atts);
        this.writeStartTag("CaptionExpression", atts);
        LinkedHashMap<String, Object> arrays = new LinkedHashMap<String, Object>();
        this.populateExpressionViewArrays(elem, arrays);
        ++this.indent;
        for (Map.Entry array : arrays.entrySet()) {
            if (array.getValue() instanceof List) {
                List list = (List)array.getValue();
                if (oneTag && list.size() > 0) {
                    this.out.println(">");
                    oneTag = false;
                }
                for (OLAPObject obj : list) {
                    this.foolishWrite(obj);
                }
                continue;
            }
            if (!(array.getValue() instanceof OLAPObject)) continue;
            if (oneTag) {
                this.out.println(">");
                oneTag = false;
            }
            this.foolishWrite((OLAPObject)((Object)array.getValue()));
        }
        --this.indent;
        if (oneTag) {
            this.out.println("/>");
        } else {
            this.indentLine();
            this.out.println("</CaptionExpression>");
        }
    }

    public void writeMeasureExpression(MondrianModel.MeasureExpression elem) {
        boolean oneTag = true;
        LinkedHashMap<String, Object> atts = new LinkedHashMap<String, Object>();
        if (this.idMap != null) {
            String id = Integer.toString(this.idMap.size());
            if (this.idMap.put(elem, id) != null) {
                throw new IllegalStateException("Duplicate OLAPObject found: " + (Object)((Object)elem));
            }
            atts.put("id", id);
        }
        this.populateExpressionViewAttributes(elem, atts);
        this.writeStartTag("MeasureExpression", atts);
        LinkedHashMap<String, Object> arrays = new LinkedHashMap<String, Object>();
        this.populateExpressionViewArrays(elem, arrays);
        ++this.indent;
        for (Map.Entry array : arrays.entrySet()) {
            if (array.getValue() instanceof List) {
                List list = (List)array.getValue();
                if (oneTag && list.size() > 0) {
                    this.out.println(">");
                    oneTag = false;
                }
                for (OLAPObject obj : list) {
                    this.foolishWrite(obj);
                }
                continue;
            }
            if (!(array.getValue() instanceof OLAPObject)) continue;
            if (oneTag) {
                this.out.println(">");
                oneTag = false;
            }
            this.foolishWrite((OLAPObject)((Object)array.getValue()));
        }
        --this.indent;
        if (oneTag) {
            this.out.println("/>");
        } else {
            this.indentLine();
            this.out.println("</MeasureExpression>");
        }
    }

    public void writeRole(MondrianModel.Role elem) {
        boolean oneTag = true;
        LinkedHashMap<String, Object> atts = new LinkedHashMap<String, Object>();
        if (this.idMap != null) {
            String id = Integer.toString(this.idMap.size());
            if (this.idMap.put(elem, id) != null) {
                throw new IllegalStateException("Duplicate OLAPObject found: " + (Object)((Object)elem));
            }
            atts.put("id", id);
        }
        atts.put("name", elem.getName());
        this.writeStartTag("Role", atts);
        LinkedHashMap<String, Object> arrays = new LinkedHashMap<String, Object>();
        arrays.put("schemaGrants", elem.getSchemaGrants());
        arrays.put("union", (Object)elem.getUnion());
        ++this.indent;
        for (Map.Entry array : arrays.entrySet()) {
            if (array.getValue() instanceof List) {
                List list = (List)array.getValue();
                if (oneTag && list.size() > 0) {
                    this.out.println(">");
                    oneTag = false;
                }
                for (OLAPObject obj : list) {
                    this.foolishWrite(obj);
                }
                continue;
            }
            if (!(array.getValue() instanceof OLAPObject)) continue;
            if (oneTag) {
                this.out.println(">");
                oneTag = false;
            }
            this.foolishWrite((OLAPObject)((Object)array.getValue()));
        }
        --this.indent;
        if (oneTag) {
            this.out.println("/>");
        } else {
            this.indentLine();
            this.out.println("</Role>");
        }
    }

    private void writeGrant(MondrianModel.Grant elem) {
        this.foolishWrite(elem);
    }

    private void populateGrantAttributes(MondrianModel.Grant elem, Map<String, Object> atts) {
        atts.put("access", elem.getAccess());
    }

    private void populateGrantArrays(MondrianModel.Grant elem, Map<String, Object> arrays) {
    }

    public void writeSchemaGrant(MondrianModel.SchemaGrant elem) {
        boolean oneTag = true;
        LinkedHashMap<String, Object> atts = new LinkedHashMap<String, Object>();
        if (this.idMap != null) {
            String id = Integer.toString(this.idMap.size());
            if (this.idMap.put(elem, id) != null) {
                throw new IllegalStateException("Duplicate OLAPObject found: " + (Object)((Object)elem));
            }
            atts.put("id", id);
        }
        this.populateGrantAttributes(elem, atts);
        this.writeStartTag("SchemaGrant", atts);
        LinkedHashMap<String, Object> arrays = new LinkedHashMap<String, Object>();
        arrays.put("cubeGrants", elem.getCubeGrants());
        this.populateGrantArrays(elem, arrays);
        ++this.indent;
        for (Map.Entry array : arrays.entrySet()) {
            if (array.getValue() instanceof List) {
                List list = (List)array.getValue();
                if (oneTag && list.size() > 0) {
                    this.out.println(">");
                    oneTag = false;
                }
                for (OLAPObject obj : list) {
                    this.foolishWrite(obj);
                }
                continue;
            }
            if (!(array.getValue() instanceof OLAPObject)) continue;
            if (oneTag) {
                this.out.println(">");
                oneTag = false;
            }
            this.foolishWrite((OLAPObject)((Object)array.getValue()));
        }
        --this.indent;
        if (oneTag) {
            this.out.println("/>");
        } else {
            this.indentLine();
            this.out.println("</SchemaGrant>");
        }
    }

    public void writeCubeGrant(MondrianModel.CubeGrant elem) {
        boolean oneTag = true;
        LinkedHashMap<String, Object> atts = new LinkedHashMap<String, Object>();
        if (this.idMap != null) {
            String id = Integer.toString(this.idMap.size());
            if (this.idMap.put(elem, id) != null) {
                throw new IllegalStateException("Duplicate OLAPObject found: " + (Object)((Object)elem));
            }
            atts.put("id", id);
        }
        atts.put("cube", elem.getCube());
        this.populateGrantAttributes(elem, atts);
        this.writeStartTag("CubeGrant", atts);
        LinkedHashMap<String, Object> arrays = new LinkedHashMap<String, Object>();
        arrays.put("dimensionGrants", elem.getDimensionGrants());
        arrays.put("hierarchyGrants", elem.getHierarchyGrants());
        this.populateGrantArrays(elem, arrays);
        ++this.indent;
        for (Map.Entry array : arrays.entrySet()) {
            if (array.getValue() instanceof List) {
                List list = (List)array.getValue();
                if (oneTag && list.size() > 0) {
                    this.out.println(">");
                    oneTag = false;
                }
                for (OLAPObject obj : list) {
                    this.foolishWrite(obj);
                }
                continue;
            }
            if (!(array.getValue() instanceof OLAPObject)) continue;
            if (oneTag) {
                this.out.println(">");
                oneTag = false;
            }
            this.foolishWrite((OLAPObject)((Object)array.getValue()));
        }
        --this.indent;
        if (oneTag) {
            this.out.println("/>");
        } else {
            this.indentLine();
            this.out.println("</CubeGrant>");
        }
    }

    public void writeDimensionGrant(MondrianModel.DimensionGrant elem) {
        boolean oneTag = true;
        LinkedHashMap<String, Object> atts = new LinkedHashMap<String, Object>();
        if (this.idMap != null) {
            String id = Integer.toString(this.idMap.size());
            if (this.idMap.put(elem, id) != null) {
                throw new IllegalStateException("Duplicate OLAPObject found: " + (Object)((Object)elem));
            }
            atts.put("id", id);
        }
        atts.put("dimension", elem.getDimension());
        this.populateGrantAttributes(elem, atts);
        this.writeStartTag("DimensionGrant", atts);
        LinkedHashMap<String, Object> arrays = new LinkedHashMap<String, Object>();
        this.populateGrantArrays(elem, arrays);
        ++this.indent;
        for (Map.Entry array : arrays.entrySet()) {
            if (array.getValue() instanceof List) {
                List list = (List)array.getValue();
                if (oneTag && list.size() > 0) {
                    this.out.println(">");
                    oneTag = false;
                }
                for (OLAPObject obj : list) {
                    this.foolishWrite(obj);
                }
                continue;
            }
            if (!(array.getValue() instanceof OLAPObject)) continue;
            if (oneTag) {
                this.out.println(">");
                oneTag = false;
            }
            this.foolishWrite((OLAPObject)((Object)array.getValue()));
        }
        --this.indent;
        if (oneTag) {
            this.out.println("/>");
        } else {
            this.indentLine();
            this.out.println("</DimensionGrant>");
        }
    }

    public void writeHierarchyGrant(MondrianModel.HierarchyGrant elem) {
        boolean oneTag = true;
        LinkedHashMap<String, Object> atts = new LinkedHashMap<String, Object>();
        if (this.idMap != null) {
            String id = Integer.toString(this.idMap.size());
            if (this.idMap.put(elem, id) != null) {
                throw new IllegalStateException("Duplicate OLAPObject found: " + (Object)((Object)elem));
            }
            atts.put("id", id);
        }
        atts.put("hierarchy", elem.getHierarchy());
        atts.put("topLevel", elem.getTopLevel());
        atts.put("bottomLevel", elem.getBottomLevel());
        atts.put("rollupPolicy", elem.getRollupPolicy());
        this.populateGrantAttributes(elem, atts);
        this.writeStartTag("HierarchyGrant", atts);
        LinkedHashMap<String, Object> arrays = new LinkedHashMap<String, Object>();
        arrays.put("memberGrants", elem.getMemberGrants());
        this.populateGrantArrays(elem, arrays);
        ++this.indent;
        for (Map.Entry array : arrays.entrySet()) {
            if (array.getValue() instanceof List) {
                List list = (List)array.getValue();
                if (oneTag && list.size() > 0) {
                    this.out.println(">");
                    oneTag = false;
                }
                for (OLAPObject obj : list) {
                    this.foolishWrite(obj);
                }
                continue;
            }
            if (!(array.getValue() instanceof OLAPObject)) continue;
            if (oneTag) {
                this.out.println(">");
                oneTag = false;
            }
            this.foolishWrite((OLAPObject)((Object)array.getValue()));
        }
        --this.indent;
        if (oneTag) {
            this.out.println("/>");
        } else {
            this.indentLine();
            this.out.println("</HierarchyGrant>");
        }
    }

    public void writeMemberGrant(MondrianModel.MemberGrant elem) {
        boolean oneTag = true;
        LinkedHashMap<String, Object> atts = new LinkedHashMap<String, Object>();
        if (this.idMap != null) {
            String id = Integer.toString(this.idMap.size());
            if (this.idMap.put(elem, id) != null) {
                throw new IllegalStateException("Duplicate OLAPObject found: " + (Object)((Object)elem));
            }
            atts.put("id", id);
        }
        atts.put("member", elem.getMember());
        atts.put("access", elem.getAccess());
        this.writeStartTag("MemberGrant", atts);
        LinkedHashMap arrays = new LinkedHashMap();
        ++this.indent;
        for (Map.Entry array : arrays.entrySet()) {
            if (array.getValue() instanceof List) {
                List list = (List)array.getValue();
                if (oneTag && list.size() > 0) {
                    this.out.println(">");
                    oneTag = false;
                }
                for (OLAPObject obj : list) {
                    this.foolishWrite(obj);
                }
                continue;
            }
            if (!(array.getValue() instanceof OLAPObject)) continue;
            if (oneTag) {
                this.out.println(">");
                oneTag = false;
            }
            this.foolishWrite((OLAPObject)((Object)array.getValue()));
        }
        --this.indent;
        if (oneTag) {
            this.out.println("/>");
        } else {
            this.indentLine();
            this.out.println("</MemberGrant>");
        }
    }

    public void writeUnion(MondrianModel.Union elem) {
        boolean oneTag = true;
        LinkedHashMap<String, Object> atts = new LinkedHashMap<String, Object>();
        if (this.idMap != null) {
            String id = Integer.toString(this.idMap.size());
            if (this.idMap.put(elem, id) != null) {
                throw new IllegalStateException("Duplicate OLAPObject found: " + (Object)((Object)elem));
            }
            atts.put("id", id);
        }
        this.writeStartTag("Union", atts);
        LinkedHashMap<String, List<MondrianModel.RoleUsage>> arrays = new LinkedHashMap<String, List<MondrianModel.RoleUsage>>();
        arrays.put("roleUsages", elem.getRoleUsages());
        ++this.indent;
        for (Map.Entry array : arrays.entrySet()) {
            if (array.getValue() instanceof List) {
                List list = (List)array.getValue();
                if (oneTag && list.size() > 0) {
                    this.out.println(">");
                    oneTag = false;
                }
                for (OLAPObject obj : list) {
                    this.foolishWrite(obj);
                }
                continue;
            }
            if (!(array.getValue() instanceof OLAPObject)) continue;
            if (oneTag) {
                this.out.println(">");
                oneTag = false;
            }
            this.foolishWrite((OLAPObject)((Object)array.getValue()));
        }
        --this.indent;
        if (oneTag) {
            this.out.println("/>");
        } else {
            this.indentLine();
            this.out.println("</Union>");
        }
    }

    public void writeRoleUsage(MondrianModel.RoleUsage elem) {
        boolean oneTag = true;
        LinkedHashMap<String, Object> atts = new LinkedHashMap<String, Object>();
        if (this.idMap != null) {
            String id = Integer.toString(this.idMap.size());
            if (this.idMap.put(elem, id) != null) {
                throw new IllegalStateException("Duplicate OLAPObject found: " + (Object)((Object)elem));
            }
            atts.put("id", id);
        }
        atts.put("roleName", elem.getRoleName());
        this.writeStartTag("RoleUsage", atts);
        LinkedHashMap arrays = new LinkedHashMap();
        ++this.indent;
        for (Map.Entry array : arrays.entrySet()) {
            if (array.getValue() instanceof List) {
                List list = (List)array.getValue();
                if (oneTag && list.size() > 0) {
                    this.out.println(">");
                    oneTag = false;
                }
                for (OLAPObject obj : list) {
                    this.foolishWrite(obj);
                }
                continue;
            }
            if (!(array.getValue() instanceof OLAPObject)) continue;
            if (oneTag) {
                this.out.println(">");
                oneTag = false;
            }
            this.foolishWrite((OLAPObject)((Object)array.getValue()));
        }
        --this.indent;
        if (oneTag) {
            this.out.println("/>");
        } else {
            this.indentLine();
            this.out.println("</RoleUsage>");
        }
    }

    public void writeUserDefinedFunction(MondrianModel.UserDefinedFunction elem) {
        boolean oneTag = true;
        LinkedHashMap<String, Object> atts = new LinkedHashMap<String, Object>();
        if (this.idMap != null) {
            String id = Integer.toString(this.idMap.size());
            if (this.idMap.put(elem, id) != null) {
                throw new IllegalStateException("Duplicate OLAPObject found: " + (Object)((Object)elem));
            }
            atts.put("id", id);
        }
        atts.put("name", elem.getName());
        atts.put("className", elem.getClassName());
        this.writeStartTag("UserDefinedFunction", atts);
        LinkedHashMap arrays = new LinkedHashMap();
        ++this.indent;
        for (Map.Entry array : arrays.entrySet()) {
            if (array.getValue() instanceof List) {
                List list = (List)array.getValue();
                if (oneTag && list.size() > 0) {
                    this.out.println(">");
                    oneTag = false;
                }
                for (OLAPObject obj : list) {
                    this.foolishWrite(obj);
                }
                continue;
            }
            if (!(array.getValue() instanceof OLAPObject)) continue;
            if (oneTag) {
                this.out.println(">");
                oneTag = false;
            }
            this.foolishWrite((OLAPObject)((Object)array.getValue()));
        }
        --this.indent;
        if (oneTag) {
            this.out.println("/>");
        } else {
            this.indentLine();
            this.out.println("</UserDefinedFunction>");
        }
    }

    public void writeParameter(MondrianModel.Parameter elem) {
        boolean oneTag = true;
        LinkedHashMap<String, Object> atts = new LinkedHashMap<String, Object>();
        if (this.idMap != null) {
            String id = Integer.toString(this.idMap.size());
            if (this.idMap.put(elem, id) != null) {
                throw new IllegalStateException("Duplicate OLAPObject found: " + (Object)((Object)elem));
            }
            atts.put("id", id);
        }
        atts.put("name", elem.getName());
        atts.put("description", elem.getDescription());
        atts.put("type", elem.getType());
        atts.put("modifiable", elem.getModifiable());
        atts.put("defaultValue", elem.getDefaultValue());
        this.writeStartTag("Parameter", atts);
        LinkedHashMap arrays = new LinkedHashMap();
        ++this.indent;
        for (Map.Entry array : arrays.entrySet()) {
            if (array.getValue() instanceof List) {
                List list = (List)array.getValue();
                if (oneTag && list.size() > 0) {
                    this.out.println(">");
                    oneTag = false;
                }
                for (OLAPObject obj : list) {
                    this.foolishWrite(obj);
                }
                continue;
            }
            if (!(array.getValue() instanceof OLAPObject)) continue;
            if (oneTag) {
                this.out.println(">");
                oneTag = false;
            }
            this.foolishWrite((OLAPObject)((Object)array.getValue()));
        }
        --this.indent;
        if (oneTag) {
            this.out.println("/>");
        } else {
            this.indentLine();
            this.out.println("</Parameter>");
        }
    }
}

