/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.session;

import com.google.inject.Injector;
import io.netty.channel.Channel;
import io.netty.util.Timeout;
import io.netty.util.Timer;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.traccar.Protocol;
import org.traccar.broadcast.BroadcastInterface;
import org.traccar.broadcast.BroadcastService;
import org.traccar.config.Config;
import org.traccar.config.Keys;
import org.traccar.database.DeviceLookupService;
import org.traccar.database.NotificationManager;
import org.traccar.handler.events.MotionEventHandler;
import org.traccar.handler.events.OverspeedEventHandler;
import org.traccar.helper.model.AttributeUtil;
import org.traccar.model.BaseModel;
import org.traccar.model.Device;
import org.traccar.model.Event;
import org.traccar.model.Position;
import org.traccar.model.User;
import org.traccar.session.DeviceSession;
import org.traccar.session.DeviceState;
import org.traccar.session.Endpoint;
import org.traccar.session.cache.CacheManager;
import org.traccar.storage.Storage;
import org.traccar.storage.StorageException;
import org.traccar.storage.query.Columns;
import org.traccar.storage.query.Condition;
import org.traccar.storage.query.Request;

@Singleton
public class ConnectionManager
implements BroadcastInterface {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConnectionManager.class);
    private final long deviceTimeout;
    private final boolean updateDeviceState;
    private final Map<Long, DeviceSession> sessionsByDeviceId = new ConcurrentHashMap<Long, DeviceSession>();
    private final Map<Endpoint, Map<String, DeviceSession>> sessionsByEndpoint = new ConcurrentHashMap<Endpoint, Map<String, DeviceSession>>();
    private final Map<Long, DeviceState> deviceStates = new ConcurrentHashMap<Long, DeviceState>();
    private final Injector injector;
    private final Config config;
    private final CacheManager cacheManager;
    private final Storage storage;
    private final NotificationManager notificationManager;
    private final Timer timer;
    private final BroadcastService broadcastService;
    private final DeviceLookupService deviceLookupService;
    private final Map<Long, Set<UpdateListener>> listeners = new HashMap<Long, Set<UpdateListener>>();
    private final Map<Long, Set<Long>> userDevices = new HashMap<Long, Set<Long>>();
    private final Map<Long, Set<Long>> deviceUsers = new HashMap<Long, Set<Long>>();
    private final Map<Long, Timeout> timeouts = new ConcurrentHashMap<Long, Timeout>();

    @Inject
    public ConnectionManager(Injector injector, Config config, CacheManager cacheManager, Storage storage, NotificationManager notificationManager, Timer timer, BroadcastService broadcastService, DeviceLookupService deviceLookupService) {
        this.injector = injector;
        this.config = config;
        this.cacheManager = cacheManager;
        this.storage = storage;
        this.notificationManager = notificationManager;
        this.timer = timer;
        this.broadcastService = broadcastService;
        this.deviceLookupService = deviceLookupService;
        this.deviceTimeout = config.getLong(Keys.STATUS_TIMEOUT);
        this.updateDeviceState = config.getBoolean(Keys.STATUS_UPDATE_DEVICE_STATE);
        broadcastService.registerListener(this);
    }

    public DeviceSession getDeviceSession(long deviceId) {
        return this.sessionsByDeviceId.get(deviceId);
    }

    public DeviceSession getDeviceSession(Protocol protocol, Channel channel, SocketAddress remoteAddress, String ... uniqueIds) throws StorageException {
        Endpoint endpoint = new Endpoint(channel, remoteAddress);
        Map endpointSessions = this.sessionsByEndpoint.getOrDefault(endpoint, new ConcurrentHashMap());
        if ((uniqueIds = (String[])Arrays.stream(uniqueIds).filter(Objects::nonNull).toArray(String[]::new)).length > 0) {
            for (String uniqueId : uniqueIds) {
                DeviceSession deviceSession = (DeviceSession)endpointSessions.get(uniqueId);
                if (deviceSession == null) continue;
                return deviceSession;
            }
        } else {
            return endpointSessions.values().stream().findAny().orElse(null);
        }
        Device device = this.deviceLookupService.lookup(uniqueIds);
        if (device == null && this.config.getBoolean(Keys.DATABASE_REGISTER_UNKNOWN)) {
            device = this.addUnknownDevice(uniqueIds[0]);
        }
        if (device != null) {
            device.checkDisabled();
            DeviceSession oldSession = this.sessionsByDeviceId.remove(device.getId());
            if (oldSession != null) {
                Endpoint oldEndpoint = new Endpoint(oldSession.getChannel(), oldSession.getRemoteAddress());
                Map<String, DeviceSession> oldEndpointSessions = this.sessionsByEndpoint.get(oldEndpoint);
                if (oldEndpointSessions != null && oldEndpointSessions.size() > 1) {
                    oldEndpointSessions.remove(device.getUniqueId());
                } else {
                    this.sessionsByEndpoint.remove(oldEndpoint);
                }
            }
            DeviceSession deviceSession = new DeviceSession(device.getId(), device.getUniqueId(), protocol, channel, remoteAddress);
            endpointSessions.put(device.getUniqueId(), deviceSession);
            this.sessionsByEndpoint.put(endpoint, endpointSessions);
            this.sessionsByDeviceId.put(device.getId(), deviceSession);
            if (oldSession == null) {
                this.cacheManager.addDevice(device.getId());
            }
            return deviceSession;
        }
        LOGGER.warn("Unknown device - " + String.join((CharSequence)" ", uniqueIds) + " (" + ((InetSocketAddress)remoteAddress).getHostString() + ")");
        return null;
    }

    private Device addUnknownDevice(String uniqueId) {
        Device device = new Device();
        device.setName(uniqueId);
        device.setUniqueId(uniqueId);
        device.setCategory(this.config.getString(Keys.DATABASE_REGISTER_UNKNOWN_DEFAULT_CATEGORY));
        long defaultGroupId = this.config.getLong(Keys.DATABASE_REGISTER_UNKNOWN_DEFAULT_GROUP_ID);
        if (defaultGroupId != 0L) {
            device.setGroupId(defaultGroupId);
        }
        try {
            device.setId(this.storage.addObject(device, new Request(new Columns.Exclude("id"))));
            LOGGER.info("Automatically registered " + uniqueId);
            return device;
        }
        catch (StorageException e) {
            LOGGER.warn("Automatic registration failed", (Throwable)e);
            return null;
        }
    }

    public void deviceDisconnected(Channel channel, boolean supportsOffline) {
        Endpoint endpoint = new Endpoint(channel, channel.remoteAddress());
        Map<String, DeviceSession> endpointSessions = this.sessionsByEndpoint.remove(endpoint);
        if (endpointSessions != null) {
            for (DeviceSession deviceSession : endpointSessions.values()) {
                if (supportsOffline) {
                    this.updateDevice(deviceSession.getDeviceId(), "offline", null);
                }
                this.sessionsByDeviceId.remove(deviceSession.getDeviceId());
                this.cacheManager.removeDevice(deviceSession.getDeviceId());
            }
        }
    }

    public void deviceUnknown(long deviceId) {
        this.updateDevice(deviceId, "unknown", null);
        this.removeDeviceSession(deviceId);
    }

    private void removeDeviceSession(long deviceId) {
        DeviceSession deviceSession = this.sessionsByDeviceId.remove(deviceId);
        if (deviceSession != null) {
            this.cacheManager.removeDevice(deviceId);
            Endpoint endpoint = new Endpoint(deviceSession.getChannel(), deviceSession.getRemoteAddress());
            this.sessionsByEndpoint.computeIfPresent(endpoint, (e, sessions) -> {
                sessions.remove(deviceSession.getUniqueId());
                return sessions.isEmpty() ? null : sessions;
            });
        }
    }

    public void updateDevice(long deviceId, String status, Date time) {
        Timeout timeout;
        Device device = this.cacheManager.getObject(Device.class, deviceId);
        if (device == null) {
            try {
                device = this.storage.getObject(Device.class, new Request(new Columns.All(), new Condition.Equals("id", "id", deviceId)));
            }
            catch (StorageException e) {
                LOGGER.warn("Failed to get device", (Throwable)e);
            }
            if (device == null) {
                return;
            }
        }
        String oldStatus = device.getStatus();
        device.setStatus(status);
        if (!status.equals(oldStatus)) {
            String eventType;
            HashMap<Event, Position> events = new HashMap<Event, Position>();
            switch (status) {
                case "online": {
                    eventType = "deviceOnline";
                    break;
                }
                case "unknown": {
                    eventType = "deviceUnknown";
                    if (!this.updateDeviceState) break;
                    events.putAll(this.updateDeviceState(deviceId));
                    break;
                }
                default: {
                    eventType = "deviceOffline";
                    if (!this.updateDeviceState) break;
                    events.putAll(this.updateDeviceState(deviceId));
                }
            }
            events.put(new Event(eventType, deviceId), null);
            this.notificationManager.updateEvents(events);
        }
        if (time != null) {
            device.setLastUpdate(time);
        }
        if ((timeout = this.timeouts.remove(deviceId)) != null) {
            timeout.cancel();
        }
        if (status.equals("online")) {
            this.timeouts.put(deviceId, this.timer.newTimeout(timeout1 -> {
                if (!timeout1.isCancelled()) {
                    this.deviceUnknown(deviceId);
                }
            }, this.deviceTimeout, TimeUnit.SECONDS));
        }
        try {
            this.storage.updateObject(device, new Request(new Columns.Include("status", "lastUpdate"), new Condition.Equals("id", "id")));
        }
        catch (StorageException e) {
            LOGGER.warn("Update device status error", (Throwable)e);
        }
        this.updateDevice(true, device);
    }

    public DeviceState getDeviceState(long deviceId) {
        return this.deviceStates.computeIfAbsent(deviceId, x -> new DeviceState());
    }

    public void setDeviceState(long deviceId, DeviceState deviceState) {
        this.deviceStates.put(deviceId, deviceState);
    }

    public Map<Event, Position> updateDeviceState(long deviceId) {
        DeviceState deviceState = this.getDeviceState(deviceId);
        HashMap<Event, Position> result = new HashMap<Event, Position>();
        Map<Event, Position> event = ((MotionEventHandler)((Object)this.injector.getInstance(MotionEventHandler.class))).updateMotionState(deviceState);
        if (event != null) {
            result.putAll(event);
        }
        double speedLimit = AttributeUtil.lookup(this.cacheManager, Keys.EVENT_OVERSPEED_LIMIT, deviceId);
        event = ((OverspeedEventHandler)((Object)this.injector.getInstance(OverspeedEventHandler.class))).updateOverspeedState(deviceState, speedLimit);
        if (event != null) {
            result.putAll(event);
        }
        return result;
    }

    public synchronized void sendKeepalive() {
        for (Set<UpdateListener> userListeners : this.listeners.values()) {
            for (UpdateListener listener : userListeners) {
                listener.onKeepalive();
            }
        }
    }

    @Override
    public synchronized void updateDevice(boolean local, Device device) {
        if (local) {
            this.broadcastService.updateDevice(true, device);
        } else if ("online".equals(device.getStatus())) {
            this.timeouts.remove(device.getId());
            this.removeDeviceSession(device.getId());
        }
        Iterator iterator = this.deviceUsers.getOrDefault(device.getId(), Collections.emptySet()).iterator();
        while (iterator.hasNext()) {
            long userId = (Long)iterator.next();
            if (!this.listeners.containsKey(userId)) continue;
            for (UpdateListener listener : this.listeners.get(userId)) {
                listener.onUpdateDevice(device);
            }
        }
    }

    @Override
    public synchronized void updatePosition(boolean local, Position position) {
        if (local) {
            this.broadcastService.updatePosition(true, position);
        }
        Iterator iterator = this.deviceUsers.getOrDefault(position.getDeviceId(), Collections.emptySet()).iterator();
        while (iterator.hasNext()) {
            long userId = (Long)iterator.next();
            if (!this.listeners.containsKey(userId)) continue;
            for (UpdateListener listener : this.listeners.get(userId)) {
                listener.onUpdatePosition(position);
            }
        }
    }

    @Override
    public synchronized void updateEvent(boolean local, long userId, Event event) {
        if (local) {
            this.broadcastService.updateEvent(true, userId, event);
        }
        if (this.listeners.containsKey(userId)) {
            for (UpdateListener listener : this.listeners.get(userId)) {
                listener.onUpdateEvent(event);
            }
        }
    }

    @Override
    public synchronized void invalidatePermission(boolean local, Class<? extends BaseModel> clazz1, long id1, Class<? extends BaseModel> clazz2, long id2) {
        if (clazz1.equals(User.class) && clazz2.equals(Device.class) && this.listeners.containsKey(id1)) {
            this.userDevices.get(id1).add(id2);
            this.deviceUsers.put(id2, new HashSet<Long>(List.of(Long.valueOf(id1))));
        }
    }

    public synchronized void addListener(long userId, UpdateListener listener) throws StorageException {
        Set<UpdateListener> set = this.listeners.get(userId);
        if (set == null) {
            set = new HashSet<UpdateListener>();
            this.listeners.put(userId, set);
            List<Device> devices = this.storage.getObjects(Device.class, new Request(new Columns.Include("id"), new Condition.Permission(User.class, userId, Device.class)));
            this.userDevices.put(userId, devices.stream().map(BaseModel::getId).collect(Collectors.toSet()));
            devices.forEach(device -> this.deviceUsers.computeIfAbsent(device.getId(), id -> new HashSet()).add(userId));
        }
        set.add(listener);
    }

    public synchronized void removeListener(long userId, UpdateListener listener) {
        Set<UpdateListener> set = this.listeners.get(userId);
        set.remove(listener);
        if (set.isEmpty()) {
            this.listeners.remove(userId);
            this.userDevices.remove(userId).forEach(deviceId -> this.deviceUsers.computeIfPresent((Long)deviceId, (x, userIds) -> {
                userIds.remove(userId);
                return userIds.isEmpty() ? null : userIds;
            }));
        }
    }

    public static interface UpdateListener {
        public void onKeepalive();

        public void onUpdateDevice(Device var1);

        public void onUpdatePosition(Position var1);

        public void onUpdateEvent(Event var1);
    }
}

