/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.geocoder;

import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.ws.rs.client.Client;
import org.traccar.geocoder.Address;
import org.traccar.geocoder.AddressFormat;
import org.traccar.geocoder.JsonGeocoder;

public class OpenCageGeocoder
extends JsonGeocoder {
    private static String formatUrl(String url, String key, String language) {
        if (url == null) {
            url = "https://api.opencagedata.com/geocode/v1";
        }
        url = (String)url + "/json?q=%f,%f&no_annotations=1&key=" + key;
        if (language != null) {
            url = (String)url + "&language=" + language;
        }
        return url;
    }

    public OpenCageGeocoder(Client client, String url, String key, String language, int cacheSize, AddressFormat addressFormat) {
        super(client, OpenCageGeocoder.formatUrl(url, key, language), cacheSize, addressFormat);
    }

    @Override
    public Address parseAddress(JsonObject json) {
        JsonObject location;
        JsonArray result = json.getJsonArray("results");
        if (result != null && (location = result.getJsonObject(0).getJsonObject("components")) != null) {
            Address address = new Address();
            if (result.getJsonObject(0).containsKey((Object)"formatted")) {
                address.setFormattedAddress(result.getJsonObject(0).getString("formatted"));
            }
            if (location.containsKey((Object)"building")) {
                address.setHouse(location.getString("building"));
            }
            if (location.containsKey((Object)"house_number")) {
                address.setHouse(location.getString("house_number"));
            }
            if (location.containsKey((Object)"road")) {
                address.setStreet(location.getString("road"));
            }
            if (location.containsKey((Object)"suburb")) {
                address.setSuburb(location.getString("suburb"));
            }
            if (location.containsKey((Object)"city")) {
                address.setSettlement(location.getString("city"));
            }
            if (location.containsKey((Object)"city_district")) {
                address.setSettlement(location.getString("city_district"));
            }
            if (location.containsKey((Object)"county")) {
                address.setDistrict(location.getString("county"));
            }
            if (location.containsKey((Object)"state")) {
                address.setState(location.getString("state"));
            }
            if (location.containsKey((Object)"country_code")) {
                address.setCountry(location.getString("country_code").toUpperCase());
            }
            if (location.containsKey((Object)"postcode")) {
                address.setPostcode(location.getString("postcode"));
            }
            return address;
        }
        return null;
    }
}

