/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.handler.extension;

import de.rub.nds.tlsattacker.core.constants.ExtensionType;
import de.rub.nds.tlsattacker.core.protocol.handler.extension.ExtensionHandler;
import de.rub.nds.tlsattacker.core.protocol.message.extension.EarlyDataExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.parser.extension.EarlyDataExtensionParser;
import de.rub.nds.tlsattacker.core.protocol.parser.extension.ExtensionParser;
import de.rub.nds.tlsattacker.core.protocol.preparator.extension.EarlyDataExtensionPreparator;
import de.rub.nds.tlsattacker.core.protocol.preparator.extension.ExtensionPreparator;
import de.rub.nds.tlsattacker.core.protocol.serializer.extension.EarlyDataExtensionSerializer;
import de.rub.nds.tlsattacker.core.protocol.serializer.extension.ExtensionSerializer;
import de.rub.nds.tlsattacker.core.state.TlsContext;
import de.rub.nds.tlsattacker.transport.ConnectionEndType;

public class EarlyDataExtensionHandler
extends ExtensionHandler<EarlyDataExtensionMessage> {
    public EarlyDataExtensionHandler(TlsContext context) {
        super(context);
    }

    @Override
    public ExtensionParser getParser(byte[] message, int pointer) {
        return new EarlyDataExtensionParser(pointer, message);
    }

    @Override
    public ExtensionPreparator getPreparator(EarlyDataExtensionMessage message) {
        return new EarlyDataExtensionPreparator(this.context.getChooser(), message, this.getSerializer(message));
    }

    @Override
    public ExtensionSerializer getSerializer(EarlyDataExtensionMessage message) {
        return new EarlyDataExtensionSerializer(message);
    }

    @Override
    public void adjustTLSExtensionContext(EarlyDataExtensionMessage message) {
        if (message.getMaxEarlyDataSize() != null) {
            this.context.setMaxEarlyDataSize(((Integer)message.getMaxEarlyDataSize().getValue()).intValue());
        } else if (this.context.getChooser().getConnectionEndType() == ConnectionEndType.SERVER) {
            this.context.addNegotiatedExtension(ExtensionType.EARLY_DATA);
        }
    }
}

