/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.constants;

import com.google.common.collect.Sets;
import de.rub.nds.modifiablevariable.util.ArrayConverter;
import de.rub.nds.tlsattacker.core.certificate.CertificateKeyPair;
import de.rub.nds.tlsattacker.core.constants.CertificateKeyType;
import de.rub.nds.tlsattacker.core.constants.HashAlgorithm;
import de.rub.nds.tlsattacker.core.constants.SignatureAlgorithm;
import de.rub.nds.tlsattacker.core.exceptions.UnknownSignatureAndHashAlgorithm;
import de.rub.nds.tlsattacker.core.workflow.chooser.Chooser;
import java.security.InvalidAlgorithmParameterException;
import java.security.Signature;
import java.security.spec.MGF1ParameterSpec;
import java.security.spec.PSSParameterSpec;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public enum SignatureAndHashAlgorithm {
    ANONYMOUS_NONE(0),
    ANONYMOUS_MD5(256),
    ANONYMOUS_SHA1(512),
    ANONYMOUS_SHA224(768),
    ANONYMOUS_SHA256(1024),
    ANONYMOUS_SHA384(1280),
    ANONYMOUS_SHA512(1536),
    RSA_NONE(1),
    RSA_MD5(257),
    RSA_SHA1(513),
    RSA_SHA224(769),
    RSA_SHA256(1025),
    RSA_SHA384(1281),
    RSA_SHA512(1537),
    DSA_NONE(2),
    DSA_MD5(258),
    DSA_SHA1(514),
    DSA_SHA224(770),
    DSA_SHA256(1026),
    DSA_SHA384(1282),
    DSA_SHA512(1538),
    ECDSA_NONE(3),
    ECDSA_MD5(259),
    ECDSA_SHA1(515),
    ECDSA_SHA224(771),
    ECDSA_SHA256(1027),
    ECDSA_SHA384(1283),
    ECDSA_SHA512(1539),
    ED25519(2055),
    ED448(2056),
    RSA_PSS_RSAE_SHA256(2052),
    RSA_PSS_RSAE_SHA384(2053),
    RSA_PSS_RSAE_SHA512(2054),
    RSA_PSS_PSS_SHA256(2057),
    RSA_PSS_PSS_SHA384(2058),
    RSA_PSS_PSS_SHA512(2059),
    GOSTR34102001_GOSTR3411(60909),
    GOSTR34102012_256_GOSTR34112012_256(61166),
    GOSTR34102012_512_GOSTR34112012_512(61423);

    private static final Logger LOGGER;
    private int value;
    private static final Map<Integer, SignatureAndHashAlgorithm> MAP;

    public static List<? extends SignatureAndHashAlgorithm> getImplemented() {
        LinkedList<SignatureAndHashAlgorithm> algoList = new LinkedList<SignatureAndHashAlgorithm>();
        algoList.add(DSA_MD5);
        algoList.add(DSA_SHA1);
        algoList.add(DSA_SHA224);
        algoList.add(DSA_SHA256);
        algoList.add(DSA_SHA384);
        algoList.add(DSA_SHA512);
        algoList.add(RSA_MD5);
        algoList.add(RSA_SHA1);
        algoList.add(RSA_SHA224);
        algoList.add(RSA_SHA256);
        algoList.add(RSA_SHA384);
        algoList.add(RSA_SHA512);
        algoList.add(ECDSA_MD5);
        algoList.add(ECDSA_SHA1);
        algoList.add(ECDSA_SHA224);
        algoList.add(ECDSA_SHA256);
        algoList.add(ECDSA_SHA384);
        algoList.add(ECDSA_SHA512);
        algoList.add(GOSTR34102001_GOSTR3411);
        algoList.add(GOSTR34102012_256_GOSTR34112012_256);
        algoList.add(GOSTR34102012_512_GOSTR34112012_512);
        return algoList;
    }

    public static List<SignatureAndHashAlgorithm> getTls13SignatureAndHashAlgorithms() {
        LinkedList<SignatureAndHashAlgorithm> algos = new LinkedList<SignatureAndHashAlgorithm>();
        algos.add(RSA_SHA256);
        algos.add(RSA_SHA384);
        algos.add(RSA_SHA512);
        algos.add(ECDSA_SHA256);
        algos.add(ECDSA_SHA384);
        algos.add(ECDSA_SHA512);
        algos.add(RSA_PSS_PSS_SHA256);
        algos.add(RSA_PSS_PSS_SHA384);
        algos.add(RSA_PSS_PSS_SHA512);
        algos.add(RSA_PSS_RSAE_SHA256);
        algos.add(RSA_PSS_RSAE_SHA384);
        algos.add(RSA_PSS_RSAE_SHA512);
        return algos;
    }

    private SignatureAndHashAlgorithm(int value) {
        this.value = value;
    }

    private static int valueToInt(byte[] value) {
        if (value.length >= 2) {
            return (value[0] & 0xFF) << 8 | value[1] & 0xFF;
        }
        if (value.length == 1) {
            return value[0];
        }
        return 0;
    }

    public static List<SignatureAndHashAlgorithm> getSignatureAndHashAlgorithms(byte[] values) {
        LinkedList<SignatureAndHashAlgorithm> sigHashAlgoList = new LinkedList<SignatureAndHashAlgorithm>();
        if (values.length % 2 != 0) {
            throw new UnknownSignatureAndHashAlgorithm("ByteArray is not divisible by 2!");
        }
        for (int pointer = 0; pointer < values.length; pointer += 2) {
            byte[] sigHashAlgo = new byte[]{values[pointer], values[pointer + 1]};
            sigHashAlgoList.add(SignatureAndHashAlgorithm.getSignatureAndHashAlgorithm(sigHashAlgo));
        }
        return sigHashAlgoList;
    }

    public static SignatureAndHashAlgorithm getSignatureAndHashAlgorithm(byte[] value) {
        return SignatureAndHashAlgorithm.getSignatureAndHashAlgorithm(SignatureAndHashAlgorithm.valueToInt(value));
    }

    public static SignatureAndHashAlgorithm getSignatureAndHashAlgorithm(int value) {
        SignatureAndHashAlgorithm sigHashAlgo = MAP.get(value);
        return sigHashAlgo;
    }

    public static SignatureAndHashAlgorithm getSignatureAndHashAlgorithm(SignatureAlgorithm signatureAlgo, HashAlgorithm hashAlgo) {
        for (SignatureAndHashAlgorithm algo : SignatureAndHashAlgorithm.values()) {
            if (algo.getHashAlgorithm() != hashAlgo || algo.getSignatureAlgorithm() != signatureAlgo) continue;
            return algo;
        }
        throw new UnsupportedOperationException("Requested SignatureHashAlgorithm is not supported. Requested Sign:" + (Object)((Object)signatureAlgo) + " Hash:" + (Object)((Object)hashAlgo));
    }

    public byte[] getByteValue() {
        return ArrayConverter.intToBytes((int)this.value, (int)2);
    }

    public int getValue() {
        return this.value;
    }

    public SignatureAlgorithm getSignatureAlgorithm() {
        Enum bestMatch = null;
        for (SignatureAlgorithm algo : SignatureAlgorithm.values()) {
            if (!this.name().contains(algo.name()) || bestMatch != null && bestMatch.name().length() >= algo.name().length()) continue;
            bestMatch = algo;
        }
        if (bestMatch != null) {
            return bestMatch;
        }
        return SignatureAlgorithm.ANONYMOUS;
    }

    public HashAlgorithm getHashAlgorithm() {
        Enum bestMatch = null;
        for (HashAlgorithm algo : HashAlgorithm.values()) {
            if (!this.name().contains(algo.name()) || bestMatch != null && bestMatch.name().length() >= algo.name().length()) continue;
            bestMatch = algo;
        }
        if (bestMatch != null) {
            return bestMatch;
        }
        return HashAlgorithm.NONE;
    }

    public String getJavaName() {
        if (this.toString().contains("RSA_PSS")) {
            return this.getHashAlgorithm().getJavaName().replaceAll("-", "") + "withRSA/PSS";
        }
        String hashAlgorithmName = this.getHashAlgorithm().getJavaName();
        if (!hashAlgorithmName.contains("GOST")) {
            hashAlgorithmName = hashAlgorithmName.replace("-", "");
        }
        String signatureAlgorithmName = this.getSignatureAlgorithm().getJavaName();
        return hashAlgorithmName + "with" + signatureAlgorithmName;
    }

    public void setupSignature(Signature signature) throws InvalidAlgorithmParameterException {
        if (this.getSignatureAlgorithm().toString().startsWith("RSA_PSS")) {
            String hashName = this.getHashAlgorithm().getJavaName();
            int saltLength = 0;
            switch (this.getHashAlgorithm()) {
                case SHA1: {
                    saltLength = 20;
                    break;
                }
                case MD5: {
                    saltLength = 16;
                    break;
                }
                case SHA256: 
                case GOSTR3411: 
                case GOSTR34112012_256: {
                    saltLength = 32;
                    break;
                }
                case SHA224: {
                    saltLength = 28;
                    break;
                }
                case SHA384: {
                    saltLength = 48;
                    break;
                }
                case GOSTR34112012_512: 
                case SHA512: {
                    saltLength = 64;
                    break;
                }
            }
            signature.setParameter(new PSSParameterSpec(hashName, "MGF1", new MGF1ParameterSpec(hashName), saltLength, 1));
        }
    }

    public static SignatureAndHashAlgorithm forCertificateKeyPair(CertificateKeyPair keyPair, Chooser chooser) {
        Sets.SetView intersection = Sets.intersection((Set)Sets.newHashSet(chooser.getClientSupportedSignatureAndHashAlgorithms()), (Set)Sets.newHashSet(chooser.getServerSupportedSignatureAndHashAlgorithms()));
        ArrayList algorithms = new ArrayList(intersection);
        ArrayList<SignatureAndHashAlgorithm> clientPreferredHash = new ArrayList<SignatureAndHashAlgorithm>(algorithms);
        clientPreferredHash.removeIf(i -> i.getHashAlgorithm() != chooser.getConfig().getPreferredHashAlgorithm());
        algorithms.addAll(0, clientPreferredHash);
        if (chooser.getSelectedProtocolVersion().isTLS13()) {
            algorithms.removeIf(i -> i.toString().contains("RSA_SHA"));
        }
        SignatureAndHashAlgorithm sigHashAlgo = null;
        CertificateKeyType certPublicKeyType = keyPair.getCertPublicKeyType();
        boolean found = false;
        for (SignatureAndHashAlgorithm i2 : algorithms) {
            SignatureAlgorithm sig = i2.getSignatureAlgorithm();
            switch (certPublicKeyType) {
                case ECDSA: {
                    if (sig != SignatureAlgorithm.ECDSA) break;
                    found = true;
                    sigHashAlgo = i2;
                    break;
                }
                case RSA: {
                    if (!sig.toString().contains("RSA")) break;
                    found = true;
                    sigHashAlgo = i2;
                    break;
                }
                case DSS: {
                    if (sig != SignatureAlgorithm.DSA) break;
                    found = true;
                    sigHashAlgo = i2;
                    break;
                }
                case GOST01: {
                    if (sig != SignatureAlgorithm.GOSTR34102001) break;
                    found = true;
                    sigHashAlgo = GOSTR34102001_GOSTR3411;
                    break;
                }
                case GOST12: {
                    if (sig != SignatureAlgorithm.GOSTR34102012_256 && sig != SignatureAlgorithm.GOSTR34102012_512) break;
                    found = true;
                    sigHashAlgo = keyPair.getGostCurve().is512bit2012() ? GOSTR34102012_512_GOSTR34112012_512 : GOSTR34102012_256_GOSTR34112012_256;
                }
            }
            if (!found) continue;
            break;
        }
        if (sigHashAlgo == null) {
            LOGGER.warn("Could not auto select SignatureAndHashAlgorithm, setting default value");
            sigHashAlgo = RSA_SHA256;
        }
        return sigHashAlgo;
    }

    static {
        LOGGER = LogManager.getLogger();
        MAP = new HashMap<Integer, SignatureAndHashAlgorithm>();
        for (SignatureAndHashAlgorithm c : SignatureAndHashAlgorithm.values()) {
            MAP.put(c.value, c);
        }
    }
}

