/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layoutmgr.inline;

import org.apache.fop.area.LinkResolver;
import org.apache.fop.area.PageViewport;
import org.apache.fop.area.Trait;
import org.apache.fop.area.inline.InlineArea;
import org.apache.fop.datatypes.URISpecification;
import org.apache.fop.fo.flow.BasicLink;
import org.apache.fop.layoutmgr.LayoutManager;
import org.apache.fop.layoutmgr.inline.InlineLayoutManager;

public class BasicLinkLayoutManager
extends InlineLayoutManager {
    private BasicLink fobj;

    public BasicLinkLayoutManager(BasicLink node) {
        super(node);
        this.fobj = node;
    }

    protected InlineArea createArea(boolean bInlineParent) {
        InlineArea area = super.createArea(bInlineParent);
        this.setupBasicLinkArea(this.parentLM, area);
        return area;
    }

    private void setupBasicLinkArea(LayoutManager parentLM, InlineArea area) {
        if (this.fobj.getExternalDestination() != null) {
            area.addTrait(Trait.EXTERNAL_LINK, URISpecification.getURL(this.fobj.getExternalDestination()));
        } else {
            String idref = this.fobj.getInternalDestination();
            PageViewport page = this.getPSLM().getFirstPVWithID(idref);
            if (page != null) {
                area.addTrait(Trait.INTERNAL_LINK, page.getKey());
            } else {
                LinkResolver res = new LinkResolver(idref, area);
                this.getPSLM().addUnresolvedArea(idref, res);
            }
        }
    }
}

