/*
 * Decompiled with CFR 0.152.
 */
package au.com.trgtd.tr.extract.projects;

import java.io.File;
import java.net.URL;
import java.util.List;
import java.util.Vector;
import tr.extract.Extract;
import tr.extract.Param;
import tr.extract.ParamBoolean;
import tr.extract.ParamContext;
import tr.extract.ParamList;
import tr.extract.ParamTopic;
import tr.extract.ParamsDialog;
import tr.extract.prefs.ExtractPrefs;
import tr.model.Data;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExportXML
extends Extract {
    public String getID() {
        return "au.com.trgtd.tr.extract.projects.ExportXML";
    }

    public String getName() {
        return this.getString("CTL_ExportXMLAction");
    }

    public List<Param> getParams() {
        Vector<Param> params = new Vector<Param>();
        params.add((Param)new ParamTopic("topic", this.getString("param-topic"), Extract.FormatType.XML));
        params.add((Param)new ParamContext("context", this.getString("param-context"), Extract.FormatType.XML, false));
        params.add((Param)new ParamBoolean("include-done", this.getString("param-include-done")));
        params.add((Param)new ParamBoolean("include-inactive", this.getString("param-include-inactive")));
        params.add((Param)new ParamBoolean("include-doasap", this.getString("param-include-doasap")));
        params.add((Param)new ParamBoolean("include-scheduled", this.getString("param-include-scheduled")));
        params.add((Param)new ParamBoolean("include-delegated", this.getString("param-include-delegated")));
        Vector<Param.Item> dateFormatItems = new Vector<Param.Item>();
        dateFormatItems.add(new Param.Item("YYYYMMDDhhmmss", "f1"));
        dateFormatItems.add(new Param.Item("DAY DD MMM YYYY hh:mm:ss", "f2"));
        params.add((Param)new ParamList("date-format", this.getString("param-date-format"), dateFormatItems));
        Vector<Param.Item> pFieldItems = new Vector<Param.Item>();
        pFieldItems.add(new Param.Item("", "none"));
        pFieldItems.add(new Param.Item(this.getString("p-created-date"), "p-field-created"));
        pFieldItems.add(new Param.Item(this.getString("p-thought-desc"), "p-field-thought-desc"));
        pFieldItems.add(new Param.Item(this.getString("p-topic-desc"), "p-field-topic-desc"));
        pFieldItems.add(new Param.Item(this.getString("p-desc"), "p-field-desc"));
        pFieldItems.add(new Param.Item(this.getString("p-purpose"), "p-field-purpose"));
        pFieldItems.add(new Param.Item(this.getString("p-success"), "p-field-success"));
        pFieldItems.add(new Param.Item(this.getString("p-brainstorming"), "p-field-brainstorming"));
        pFieldItems.add(new Param.Item(this.getString("p-organising"), "p-field-organising"));
        pFieldItems.add(new Param.Item(this.getString("p-notes"), "p-field-notes"));
        pFieldItems.add(new Param.Item(this.getString("p-done"), "p-field-done"));
        pFieldItems.add(new Param.Item(this.getString("p-done-date"), "p-field-done-date"));
        pFieldItems.add(new Param.Item(this.getString("p-start-date"), "p-field-start-date"));
        pFieldItems.add(new Param.Item(this.getString("p-due-date"), "p-field-due-date"));
        params.add((Param)new ParamList("p-field-1", this.getString("param-p-field-1"), pFieldItems));
        params.add((Param)new ParamList("p-field-2", this.getString("param-p-field-2"), pFieldItems));
        params.add((Param)new ParamList("p-field-3", this.getString("param-p-field-3"), pFieldItems));
        params.add((Param)new ParamList("p-field-4", this.getString("param-p-field-4"), pFieldItems));
        params.add((Param)new ParamList("p-field-5", this.getString("param-p-field-5"), pFieldItems));
        params.add((Param)new ParamList("p-field-6", this.getString("param-p-field-6"), pFieldItems));
        params.add((Param)new ParamList("p-field-7", this.getString("param-p-field-7"), pFieldItems));
        params.add((Param)new ParamList("p-field-8", this.getString("param-p-field-8"), pFieldItems));
        params.add((Param)new ParamList("p-field-9", this.getString("param-p-field-9"), pFieldItems));
        params.add((Param)new ParamList("p-field-10", this.getString("param-p-field-10"), pFieldItems));
        params.add((Param)new ParamList("p-field-11", this.getString("param-p-field-11"), pFieldItems));
        params.add((Param)new ParamList("p-field-12", this.getString("param-p-field-12"), pFieldItems));
        params.add((Param)new ParamList("p-field-13", this.getString("param-p-field-13"), pFieldItems));
        Vector<Param.Item> fieldItems = new Vector<Param.Item>();
        fieldItems.add(new Param.Item("", "none"));
        fieldItems.add(new Param.Item(this.getString("desc"), "field-desc"));
        fieldItems.add(new Param.Item(this.getString("notes"), "field-notes"));
        fieldItems.add(new Param.Item(this.getString("created-date"), "field-created"));
        fieldItems.add(new Param.Item(this.getString("done"), "field-done"));
        fieldItems.add(new Param.Item(this.getString("done-date"), "field-done-date"));
        fieldItems.add(new Param.Item(this.getString("thought-desc"), "field-thought-desc"));
        fieldItems.add(new Param.Item(this.getString("topic-desc"), "field-topic-desc"));
        fieldItems.add(new Param.Item(this.getString("context-desc"), "field-context-desc"));
        fieldItems.add(new Param.Item(this.getString("status"), "field-state"));
        fieldItems.add(new Param.Item(this.getString("action-date"), "field-action-date"));
        fieldItems.add(new Param.Item(this.getString("scheduled-datetime"), "field-scheduled-datetime"));
        fieldItems.add(new Param.Item(this.getString("scheduled-duration"), "field-scheduled-duration"));
        fieldItems.add(new Param.Item(this.getString("delegated-to"), "field-delegated-to"));
        fieldItems.add(new Param.Item(this.getString("success"), "field-success"));
        fieldItems.add(new Param.Item(this.getString("start-date"), "field-start-date"));
        fieldItems.add(new Param.Item(this.getString("due-date"), "field-due-date"));
        fieldItems.add(new Param.Item(this.getString("time"), "field-time"));
        fieldItems.add(new Param.Item(this.getString("energy"), "field-energy"));
        fieldItems.add(new Param.Item(this.getString("priority"), "field-priority"));
        params.add((Param)new ParamList("field-1", this.getString("param-field-1"), fieldItems));
        params.add((Param)new ParamList("field-2", this.getString("param-field-2"), fieldItems));
        params.add((Param)new ParamList("field-3", this.getString("param-field-3"), fieldItems));
        params.add((Param)new ParamList("field-4", this.getString("param-field-4"), fieldItems));
        params.add((Param)new ParamList("field-5", this.getString("param-field-5"), fieldItems));
        params.add((Param)new ParamList("field-6", this.getString("param-field-6"), fieldItems));
        params.add((Param)new ParamList("field-7", this.getString("param-field-7"), fieldItems));
        params.add((Param)new ParamList("field-8", this.getString("param-field-8"), fieldItems));
        params.add((Param)new ParamList("field-9", this.getString("param-field-9"), fieldItems));
        params.add((Param)new ParamList("field-10", this.getString("param-field-10"), fieldItems));
        params.add((Param)new ParamList("field-11", this.getString("param-field-11"), fieldItems));
        params.add((Param)new ParamList("field-12", this.getString("param-field-12"), fieldItems));
        params.add((Param)new ParamList("field-13", this.getString("param-field-13"), fieldItems));
        params.add((Param)new ParamList("field-14", this.getString("param-field-14"), fieldItems));
        params.add((Param)new ParamList("field-15", this.getString("param-field-15"), fieldItems));
        params.add((Param)new ParamList("field-16", this.getString("param-field-16"), fieldItems));
        params.add((Param)new ParamList("field-17", this.getString("param-field-17"), fieldItems));
        params.add((Param)new ParamList("field-18", this.getString("param-field-18"), fieldItems));
        params.add((Param)new ParamList("field-19", this.getString("param-field-19"), fieldItems));
        return params;
    }

    public void process(Data data) throws Exception {
        List<Param> params = this.getParams();
        String title = this.getDialogTitleExport(this.getName());
        ParamsDialog dlg = new ParamsDialog(title, this.getID(), params);
        if (dlg.showDialog() == 2) {
            return;
        }
        File xmlfile = ExportXML.getTmpFile((String)"data.xml");
        this.extractData(data, xmlfile, Extract.FormatType.XML);
        URL xslURL = ((Object)((Object)this)).getClass().getResource("projects-xml.xsl");
        File outfile = ExportXML.getOutFile((String)("projects-" + ExportXML.getTimeStamp() + ".xml"));
        String encoding = ExtractPrefs.getEncoding();
        this.transformXSL(xmlfile, xslURL, params, outfile, encoding, true);
        this.openTextFile(outfile);
    }
}

