(function(e, a) { for(var i in a) e[i] = a[i]; }(exports, /******/ (function(modules) { // webpackBootstrap
/******/ 	// The module cache
/******/ 	var installedModules = {};
/******/
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/
/******/ 		// Check if module is in cache
/******/ 		if(installedModules[moduleId]) {
/******/ 			return installedModules[moduleId].exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = installedModules[moduleId] = {
/******/ 			i: moduleId,
/******/ 			l: false,
/******/ 			exports: {}
/******/ 		};
/******/
/******/ 		// Execute the module function
/******/ 		modules[moduleId].call(module.exports, module, module.exports, __webpack_require__);
/******/
/******/ 		// Flag the module as loaded
/******/ 		module.l = true;
/******/
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/
/******/
/******/ 	// expose the modules object (__webpack_modules__)
/******/ 	__webpack_require__.m = modules;
/******/
/******/ 	// expose the module cache
/******/ 	__webpack_require__.c = installedModules;
/******/
/******/ 	// define getter function for harmony exports
/******/ 	__webpack_require__.d = function(exports, name, getter) {
/******/ 		if(!__webpack_require__.o(exports, name)) {
/******/ 			Object.defineProperty(exports, name, { enumerable: true, get: getter });
/******/ 		}
/******/ 	};
/******/
/******/ 	// define __esModule on exports
/******/ 	__webpack_require__.r = function(exports) {
/******/ 		if(typeof Symbol !== 'undefined' && Symbol.toStringTag) {
/******/ 			Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });
/******/ 		}
/******/ 		Object.defineProperty(exports, '__esModule', { value: true });
/******/ 	};
/******/
/******/ 	// create a fake namespace object
/******/ 	// mode & 1: value is a module id, require it
/******/ 	// mode & 2: merge all properties of value into the ns
/******/ 	// mode & 4: return value when already ns object
/******/ 	// mode & 8|1: behave like require
/******/ 	__webpack_require__.t = function(value, mode) {
/******/ 		if(mode & 1) value = __webpack_require__(value);
/******/ 		if(mode & 8) return value;
/******/ 		if((mode & 4) && typeof value === 'object' && value && value.__esModule) return value;
/******/ 		var ns = Object.create(null);
/******/ 		__webpack_require__.r(ns);
/******/ 		Object.defineProperty(ns, 'default', { enumerable: true, value: value });
/******/ 		if(mode & 2 && typeof value != 'string') for(var key in value) __webpack_require__.d(ns, key, function(key) { return value[key]; }.bind(null, key));
/******/ 		return ns;
/******/ 	};
/******/
/******/ 	// getDefaultExport function for compatibility with non-harmony modules
/******/ 	__webpack_require__.n = function(module) {
/******/ 		var getter = module && module.__esModule ?
/******/ 			function getDefault() { return module['default']; } :
/******/ 			function getModuleExports() { return module; };
/******/ 		__webpack_require__.d(getter, 'a', getter);
/******/ 		return getter;
/******/ 	};
/******/
/******/ 	// Object.prototype.hasOwnProperty.call
/******/ 	__webpack_require__.o = function(object, property) { return Object.prototype.hasOwnProperty.call(object, property); };
/******/
/******/ 	// __webpack_public_path__
/******/ 	__webpack_require__.p = "";
/******/
/******/
/******/ 	// Load entry module and return exports
/******/ 	return __webpack_require__(__webpack_require__.s = "./themes/charts/themes.ts");
/******/ })
/************************************************************************/
/******/ ({

/***/ "../node_modules/chroma-js/chroma.js":
/*!*******************************************!*\
  !*** ../node_modules/chroma-js/chroma.js ***!
  \*******************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

/**
 * chroma.js - JavaScript library for color conversions
 *
 * Copyright (c) 2011-2019, Gregor Aisch
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice, this
 * list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 *
 * 3. The name Gregor Aisch may not be used to endorse or promote products
 * derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL GREGOR AISCH OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
 * OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * -------------------------------------------------------
 *
 * chroma.js includes colors from colorbrewer2.org, which are released under
 * the following license:
 *
 * Copyright (c) 2002 Cynthia Brewer, Mark Harrower,
 * and The Pennsylvania State University.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific
 * language governing permissions and limitations under the License.
 *
 * ------------------------------------------------------
 *
 * Named colors are taken from X11 Color Names.
 * http://www.w3.org/TR/css3-color/#svg-color
 *
 * @preserve
 */

(function (global, factory) {
     true ? module.exports = factory() :
    undefined;
}(this, (function () { 'use strict';

    var limit = function (x, min, max) {
        if ( min === void 0 ) min=0;
        if ( max === void 0 ) max=1;

        return x < min ? min : x > max ? max : x;
    };

    var clip_rgb = function (rgb) {
        rgb._clipped = false;
        rgb._unclipped = rgb.slice(0);
        for (var i=0; i<=3; i++) {
            if (i < 3) {
                if (rgb[i] < 0 || rgb[i] > 255) { rgb._clipped = true; }
                rgb[i] = limit(rgb[i], 0, 255);
            } else if (i === 3) {
                rgb[i] = limit(rgb[i], 0, 1);
            }
        }
        return rgb;
    };

    // ported from jQuery's $.type
    var classToType = {};
    for (var i = 0, list = ['Boolean', 'Number', 'String', 'Function', 'Array', 'Date', 'RegExp', 'Undefined', 'Null']; i < list.length; i += 1) {
        var name = list[i];

        classToType[("[object " + name + "]")] = name.toLowerCase();
    }
    var type = function(obj) {
        return classToType[Object.prototype.toString.call(obj)] || "object";
    };

    var unpack = function (args, keyOrder) {
        if ( keyOrder === void 0 ) keyOrder=null;

    	// if called with more than 3 arguments, we return the arguments
        if (args.length >= 3) { return Array.prototype.slice.call(args); }
        // with less than 3 args we check if first arg is object
        // and use the keyOrder string to extract and sort properties
    	if (type(args[0]) == 'object' && keyOrder) {
    		return keyOrder.split('')
    			.filter(function (k) { return args[0][k] !== undefined; })
    			.map(function (k) { return args[0][k]; });
    	}
    	// otherwise we just return the first argument
    	// (which we suppose is an array of args)
        return args[0];
    };

    var last = function (args) {
        if (args.length < 2) { return null; }
        var l = args.length-1;
        if (type(args[l]) == 'string') { return args[l].toLowerCase(); }
        return null;
    };

    var PI = Math.PI;

    var utils = {
    	clip_rgb: clip_rgb,
    	limit: limit,
    	type: type,
    	unpack: unpack,
    	last: last,
    	PI: PI,
    	TWOPI: PI*2,
    	PITHIRD: PI/3,
    	DEG2RAD: PI / 180,
    	RAD2DEG: 180 / PI
    };

    var input = {
    	format: {},
    	autodetect: []
    };

    var last$1 = utils.last;
    var clip_rgb$1 = utils.clip_rgb;
    var type$1 = utils.type;


    var Color = function Color() {
        var args = [], len = arguments.length;
        while ( len-- ) args[ len ] = arguments[ len ];

        var me = this;
        if (type$1(args[0]) === 'object' &&
            args[0].constructor &&
            args[0].constructor === this.constructor) {
            // the argument is already a Color instance
            return args[0];
        }

        // last argument could be the mode
        var mode = last$1(args);
        var autodetect = false;

        if (!mode) {
            autodetect = true;
            if (!input.sorted) {
                input.autodetect = input.autodetect.sort(function (a,b) { return b.p - a.p; });
                input.sorted = true;
            }
            // auto-detect format
            for (var i = 0, list = input.autodetect; i < list.length; i += 1) {
                var chk = list[i];

                mode = chk.test.apply(chk, args);
                if (mode) { break; }
            }
        }

        if (input.format[mode]) {
            var rgb = input.format[mode].apply(null, autodetect ? args : args.slice(0,-1));
            me._rgb = clip_rgb$1(rgb);
        } else {
            throw new Error('unknown format: '+args);
        }

        // add alpha channel
        if (me._rgb.length === 3) { me._rgb.push(1); }
    };

    Color.prototype.toString = function toString () {
        if (type$1(this.hex) == 'function') { return this.hex(); }
        return ("[" + (this._rgb.join(',')) + "]");
    };

    var Color_1 = Color;

    var chroma = function () {
    	var args = [], len = arguments.length;
    	while ( len-- ) args[ len ] = arguments[ len ];

    	return new (Function.prototype.bind.apply( chroma.Color, [ null ].concat( args) ));
    };

    chroma.Color = Color_1;
    chroma.version = '2.1.0';

    var chroma_1 = chroma;

    var unpack$1 = utils.unpack;
    var max = Math.max;

    var rgb2cmyk = function () {
        var args = [], len = arguments.length;
        while ( len-- ) args[ len ] = arguments[ len ];

        var ref = unpack$1(args, 'rgb');
        var r = ref[0];
        var g = ref[1];
        var b = ref[2];
        r = r / 255;
        g = g / 255;
        b = b / 255;
        var k = 1 - max(r,max(g,b));
        var f = k < 1 ? 1 / (1-k) : 0;
        var c = (1-r-k) * f;
        var m = (1-g-k) * f;
        var y = (1-b-k) * f;
        return [c,m,y,k];
    };

    var rgb2cmyk_1 = rgb2cmyk;

    var unpack$2 = utils.unpack;

    var cmyk2rgb = function () {
        var args = [], len = arguments.length;
        while ( len-- ) args[ len ] = arguments[ len ];

        args = unpack$2(args, 'cmyk');
        var c = args[0];
        var m = args[1];
        var y = args[2];
        var k = args[3];
        var alpha = args.length > 4 ? args[4] : 1;
        if (k === 1) { return [0,0,0,alpha]; }
        return [
            c >= 1 ? 0 : 255 * (1-c) * (1-k), // r
            m >= 1 ? 0 : 255 * (1-m) * (1-k), // g
            y >= 1 ? 0 : 255 * (1-y) * (1-k), // b
            alpha
        ];
    };

    var cmyk2rgb_1 = cmyk2rgb;

    var unpack$3 = utils.unpack;
    var type$2 = utils.type;



    Color_1.prototype.cmyk = function() {
        return rgb2cmyk_1(this._rgb);
    };

    chroma_1.cmyk = function () {
        var args = [], len = arguments.length;
        while ( len-- ) args[ len ] = arguments[ len ];

        return new (Function.prototype.bind.apply( Color_1, [ null ].concat( args, ['cmyk']) ));
    };

    input.format.cmyk = cmyk2rgb_1;

    input.autodetect.push({
        p: 2,
        test: function () {
            var args = [], len = arguments.length;
            while ( len-- ) args[ len ] = arguments[ len ];

            args = unpack$3(args, 'cmyk');
            if (type$2(args) === 'array' && args.length === 4) {
                return 'cmyk';
            }
        }
    });

    var unpack$4 = utils.unpack;
    var last$2 = utils.last;
    var rnd = function (a) { return Math.round(a*100)/100; };

    /*
     * supported arguments:
     * - hsl2css(h,s,l)
     * - hsl2css(h,s,l,a)
     * - hsl2css([h,s,l], mode)
     * - hsl2css([h,s,l,a], mode)
     * - hsl2css({h,s,l,a}, mode)
     */
    var hsl2css = function () {
        var args = [], len = arguments.length;
        while ( len-- ) args[ len ] = arguments[ len ];

        var hsla = unpack$4(args, 'hsla');
        var mode = last$2(args) || 'lsa';
        hsla[0] = rnd(hsla[0] || 0);
        hsla[1] = rnd(hsla[1]*100) + '%';
        hsla[2] = rnd(hsla[2]*100) + '%';
        if (mode === 'hsla' || (hsla.length > 3 && hsla[3]<1)) {
            hsla[3] = hsla.length > 3 ? hsla[3] : 1;
            mode = 'hsla';
        } else {
            hsla.length = 3;
        }
        return (mode + "(" + (hsla.join(',')) + ")");
    };

    var hsl2css_1 = hsl2css;

    var unpack$5 = utils.unpack;

    /*
     * supported arguments:
     * - rgb2hsl(r,g,b)
     * - rgb2hsl(r,g,b,a)
     * - rgb2hsl([r,g,b])
     * - rgb2hsl([r,g,b,a])
     * - rgb2hsl({r,g,b,a})
     */
    var rgb2hsl = function () {
        var args = [], len = arguments.length;
        while ( len-- ) args[ len ] = arguments[ len ];

        args = unpack$5(args, 'rgba');
        var r = args[0];
        var g = args[1];
        var b = args[2];

        r /= 255;
        g /= 255;
        b /= 255;

        var min = Math.min(r, g, b);
        var max = Math.max(r, g, b);

        var l = (max + min) / 2;
        var s, h;

        if (max === min){
            s = 0;
            h = Number.NaN;
        } else {
            s = l < 0.5 ? (max - min) / (max + min) : (max - min) / (2 - max - min);
        }

        if (r == max) { h = (g - b) / (max - min); }
        else if (g == max) { h = 2 + (b - r) / (max - min); }
        else if (b == max) { h = 4 + (r - g) / (max - min); }

        h *= 60;
        if (h < 0) { h += 360; }
        if (args.length>3 && args[3]!==undefined) { return [h,s,l,args[3]]; }
        return [h,s,l];
    };

    var rgb2hsl_1 = rgb2hsl;

    var unpack$6 = utils.unpack;
    var last$3 = utils.last;


    var round = Math.round;

    /*
     * supported arguments:
     * - rgb2css(r,g,b)
     * - rgb2css(r,g,b,a)
     * - rgb2css([r,g,b], mode)
     * - rgb2css([r,g,b,a], mode)
     * - rgb2css({r,g,b,a}, mode)
     */
    var rgb2css = function () {
        var args = [], len = arguments.length;
        while ( len-- ) args[ len ] = arguments[ len ];

        var rgba = unpack$6(args, 'rgba');
        var mode = last$3(args) || 'rgb';
        if (mode.substr(0,3) == 'hsl') {
            return hsl2css_1(rgb2hsl_1(rgba), mode);
        }
        rgba[0] = round(rgba[0]);
        rgba[1] = round(rgba[1]);
        rgba[2] = round(rgba[2]);
        if (mode === 'rgba' || (rgba.length > 3 && rgba[3]<1)) {
            rgba[3] = rgba.length > 3 ? rgba[3] : 1;
            mode = 'rgba';
        }
        return (mode + "(" + (rgba.slice(0,mode==='rgb'?3:4).join(',')) + ")");
    };

    var rgb2css_1 = rgb2css;

    var unpack$7 = utils.unpack;
    var round$1 = Math.round;

    var hsl2rgb = function () {
        var assign;

        var args = [], len = arguments.length;
        while ( len-- ) args[ len ] = arguments[ len ];
        args = unpack$7(args, 'hsl');
        var h = args[0];
        var s = args[1];
        var l = args[2];
        var r,g,b;
        if (s === 0) {
            r = g = b = l*255;
        } else {
            var t3 = [0,0,0];
            var c = [0,0,0];
            var t2 = l < 0.5 ? l * (1+s) : l+s-l*s;
            var t1 = 2 * l - t2;
            var h_ = h / 360;
            t3[0] = h_ + 1/3;
            t3[1] = h_;
            t3[2] = h_ - 1/3;
            for (var i=0; i<3; i++) {
                if (t3[i] < 0) { t3[i] += 1; }
                if (t3[i] > 1) { t3[i] -= 1; }
                if (6 * t3[i] < 1)
                    { c[i] = t1 + (t2 - t1) * 6 * t3[i]; }
                else if (2 * t3[i] < 1)
                    { c[i] = t2; }
                else if (3 * t3[i] < 2)
                    { c[i] = t1 + (t2 - t1) * ((2 / 3) - t3[i]) * 6; }
                else
                    { c[i] = t1; }
            }
            (assign = [round$1(c[0]*255),round$1(c[1]*255),round$1(c[2]*255)], r = assign[0], g = assign[1], b = assign[2]);
        }
        if (args.length > 3) {
            // keep alpha channel
            return [r,g,b,args[3]];
        }
        return [r,g,b,1];
    };

    var hsl2rgb_1 = hsl2rgb;

    var RE_RGB = /^rgb\(\s*(-?\d+),\s*(-?\d+)\s*,\s*(-?\d+)\s*\)$/;
    var RE_RGBA = /^rgba\(\s*(-?\d+),\s*(-?\d+)\s*,\s*(-?\d+)\s*,\s*([01]|[01]?\.\d+)\)$/;
    var RE_RGB_PCT = /^rgb\(\s*(-?\d+(?:\.\d+)?)%,\s*(-?\d+(?:\.\d+)?)%\s*,\s*(-?\d+(?:\.\d+)?)%\s*\)$/;
    var RE_RGBA_PCT = /^rgba\(\s*(-?\d+(?:\.\d+)?)%,\s*(-?\d+(?:\.\d+)?)%\s*,\s*(-?\d+(?:\.\d+)?)%\s*,\s*([01]|[01]?\.\d+)\)$/;
    var RE_HSL = /^hsl\(\s*(-?\d+(?:\.\d+)?),\s*(-?\d+(?:\.\d+)?)%\s*,\s*(-?\d+(?:\.\d+)?)%\s*\)$/;
    var RE_HSLA = /^hsla\(\s*(-?\d+(?:\.\d+)?),\s*(-?\d+(?:\.\d+)?)%\s*,\s*(-?\d+(?:\.\d+)?)%\s*,\s*([01]|[01]?\.\d+)\)$/;

    var round$2 = Math.round;

    var css2rgb = function (css) {
        css = css.toLowerCase().trim();
        var m;

        if (input.format.named) {
            try {
                return input.format.named(css);
            } catch (e) {
                // eslint-disable-next-line
            }
        }

        // rgb(250,20,0)
        if ((m = css.match(RE_RGB))) {
            var rgb = m.slice(1,4);
            for (var i=0; i<3; i++) {
                rgb[i] = +rgb[i];
            }
            rgb[3] = 1;  // default alpha
            return rgb;
        }

        // rgba(250,20,0,0.4)
        if ((m = css.match(RE_RGBA))) {
            var rgb$1 = m.slice(1,5);
            for (var i$1=0; i$1<4; i$1++) {
                rgb$1[i$1] = +rgb$1[i$1];
            }
            return rgb$1;
        }

        // rgb(100%,0%,0%)
        if ((m = css.match(RE_RGB_PCT))) {
            var rgb$2 = m.slice(1,4);
            for (var i$2=0; i$2<3; i$2++) {
                rgb$2[i$2] = round$2(rgb$2[i$2] * 2.55);
            }
            rgb$2[3] = 1;  // default alpha
            return rgb$2;
        }

        // rgba(100%,0%,0%,0.4)
        if ((m = css.match(RE_RGBA_PCT))) {
            var rgb$3 = m.slice(1,5);
            for (var i$3=0; i$3<3; i$3++) {
                rgb$3[i$3] = round$2(rgb$3[i$3] * 2.55);
            }
            rgb$3[3] = +rgb$3[3];
            return rgb$3;
        }

        // hsl(0,100%,50%)
        if ((m = css.match(RE_HSL))) {
            var hsl = m.slice(1,4);
            hsl[1] *= 0.01;
            hsl[2] *= 0.01;
            var rgb$4 = hsl2rgb_1(hsl);
            rgb$4[3] = 1;
            return rgb$4;
        }

        // hsla(0,100%,50%,0.5)
        if ((m = css.match(RE_HSLA))) {
            var hsl$1 = m.slice(1,4);
            hsl$1[1] *= 0.01;
            hsl$1[2] *= 0.01;
            var rgb$5 = hsl2rgb_1(hsl$1);
            rgb$5[3] = +m[4];  // default alpha = 1
            return rgb$5;
        }
    };

    css2rgb.test = function (s) {
        return RE_RGB.test(s) ||
            RE_RGBA.test(s) ||
            RE_RGB_PCT.test(s) ||
            RE_RGBA_PCT.test(s) ||
            RE_HSL.test(s) ||
            RE_HSLA.test(s);
    };

    var css2rgb_1 = css2rgb;

    var type$3 = utils.type;




    Color_1.prototype.css = function(mode) {
        return rgb2css_1(this._rgb, mode);
    };

    chroma_1.css = function () {
        var args = [], len = arguments.length;
        while ( len-- ) args[ len ] = arguments[ len ];

        return new (Function.prototype.bind.apply( Color_1, [ null ].concat( args, ['css']) ));
    };

    input.format.css = css2rgb_1;

    input.autodetect.push({
        p: 5,
        test: function (h) {
            var rest = [], len = arguments.length - 1;
            while ( len-- > 0 ) rest[ len ] = arguments[ len + 1 ];

            if (!rest.length && type$3(h) === 'string' && css2rgb_1.test(h)) {
                return 'css';
            }
        }
    });

    var unpack$8 = utils.unpack;

    input.format.gl = function () {
        var args = [], len = arguments.length;
        while ( len-- ) args[ len ] = arguments[ len ];

        var rgb = unpack$8(args, 'rgba');
        rgb[0] *= 255;
        rgb[1] *= 255;
        rgb[2] *= 255;
        return rgb;
    };

    chroma_1.gl = function () {
        var args = [], len = arguments.length;
        while ( len-- ) args[ len ] = arguments[ len ];

        return new (Function.prototype.bind.apply( Color_1, [ null ].concat( args, ['gl']) ));
    };

    Color_1.prototype.gl = function() {
        var rgb = this._rgb;
        return [rgb[0]/255, rgb[1]/255, rgb[2]/255, rgb[3]];
    };

    var unpack$9 = utils.unpack;

    var rgb2hcg = function () {
        var args = [], len = arguments.length;
        while ( len-- ) args[ len ] = arguments[ len ];

        var ref = unpack$9(args, 'rgb');
        var r = ref[0];
        var g = ref[1];
        var b = ref[2];
        var min = Math.min(r, g, b);
        var max = Math.max(r, g, b);
        var delta = max - min;
        var c = delta * 100 / 255;
        var _g = min / (255 - delta) * 100;
        var h;
        if (delta === 0) {
            h = Number.NaN;
        } else {
            if (r === max) { h = (g - b) / delta; }
            if (g === max) { h = 2+(b - r) / delta; }
            if (b === max) { h = 4+(r - g) / delta; }
            h *= 60;
            if (h < 0) { h += 360; }
        }
        return [h, c, _g];
    };

    var rgb2hcg_1 = rgb2hcg;

    var unpack$a = utils.unpack;
    var floor = Math.floor;

    /*
     * this is basically just HSV with some minor tweaks
     *
     * hue.. [0..360]
     * chroma .. [0..1]
     * grayness .. [0..1]
     */

    var hcg2rgb = function () {
        var assign, assign$1, assign$2, assign$3, assign$4, assign$5;

        var args = [], len = arguments.length;
        while ( len-- ) args[ len ] = arguments[ len ];
        args = unpack$a(args, 'hcg');
        var h = args[0];
        var c = args[1];
        var _g = args[2];
        var r,g,b;
        _g = _g * 255;
        var _c = c * 255;
        if (c === 0) {
            r = g = b = _g;
        } else {
            if (h === 360) { h = 0; }
            if (h > 360) { h -= 360; }
            if (h < 0) { h += 360; }
            h /= 60;
            var i = floor(h);
            var f = h - i;
            var p = _g * (1 - c);
            var q = p + _c * (1 - f);
            var t = p + _c * f;
            var v = p + _c;
            switch (i) {
                case 0: (assign = [v, t, p], r = assign[0], g = assign[1], b = assign[2]); break
                case 1: (assign$1 = [q, v, p], r = assign$1[0], g = assign$1[1], b = assign$1[2]); break
                case 2: (assign$2 = [p, v, t], r = assign$2[0], g = assign$2[1], b = assign$2[2]); break
                case 3: (assign$3 = [p, q, v], r = assign$3[0], g = assign$3[1], b = assign$3[2]); break
                case 4: (assign$4 = [t, p, v], r = assign$4[0], g = assign$4[1], b = assign$4[2]); break
                case 5: (assign$5 = [v, p, q], r = assign$5[0], g = assign$5[1], b = assign$5[2]); break
            }
        }
        return [r, g, b, args.length > 3 ? args[3] : 1];
    };

    var hcg2rgb_1 = hcg2rgb;

    var unpack$b = utils.unpack;
    var type$4 = utils.type;






    Color_1.prototype.hcg = function() {
        return rgb2hcg_1(this._rgb);
    };

    chroma_1.hcg = function () {
        var args = [], len = arguments.length;
        while ( len-- ) args[ len ] = arguments[ len ];

        return new (Function.prototype.bind.apply( Color_1, [ null ].concat( args, ['hcg']) ));
    };

    input.format.hcg = hcg2rgb_1;

    input.autodetect.push({
        p: 1,
        test: function () {
            var args = [], len = arguments.length;
            while ( len-- ) args[ len ] = arguments[ len ];

            args = unpack$b(args, 'hcg');
            if (type$4(args) === 'array' && args.length === 3) {
                return 'hcg';
            }
        }
    });

    var unpack$c = utils.unpack;
    var last$4 = utils.last;
    var round$3 = Math.round;

    var rgb2hex = function () {
        var args = [], len = arguments.length;
        while ( len-- ) args[ len ] = arguments[ len ];

        var ref = unpack$c(args, 'rgba');
        var r = ref[0];
        var g = ref[1];
        var b = ref[2];
        var a = ref[3];
        var mode = last$4(args) || 'auto';
        if (a === undefined) { a = 1; }
        if (mode === 'auto') {
            mode = a < 1 ? 'rgba' : 'rgb';
        }
        r = round$3(r);
        g = round$3(g);
        b = round$3(b);
        var u = r << 16 | g << 8 | b;
        var str = "000000" + u.toString(16); //#.toUpperCase();
        str = str.substr(str.length - 6);
        var hxa = '0' + round$3(a * 255).toString(16);
        hxa = hxa.substr(hxa.length - 2);
        switch (mode.toLowerCase()) {
            case 'rgba': return ("#" + str + hxa);
            case 'argb': return ("#" + hxa + str);
            default: return ("#" + str);
        }
    };

    var rgb2hex_1 = rgb2hex;

    var RE_HEX = /^#?([A-Fa-f0-9]{6}|[A-Fa-f0-9]{3})$/;
    var RE_HEXA = /^#?([A-Fa-f0-9]{8}|[A-Fa-f0-9]{4})$/;

    var hex2rgb = function (hex) {
        if (hex.match(RE_HEX)) {
            // remove optional leading #
            if (hex.length === 4 || hex.length === 7) {
                hex = hex.substr(1);
            }
            // expand short-notation to full six-digit
            if (hex.length === 3) {
                hex = hex.split('');
                hex = hex[0]+hex[0]+hex[1]+hex[1]+hex[2]+hex[2];
            }
            var u = parseInt(hex, 16);
            var r = u >> 16;
            var g = u >> 8 & 0xFF;
            var b = u & 0xFF;
            return [r,g,b,1];
        }

        // match rgba hex format, eg #FF000077
        if (hex.match(RE_HEXA)) {
            if (hex.length === 5 || hex.length === 9) {
                // remove optional leading #
                hex = hex.substr(1);
            }
            // expand short-notation to full eight-digit
            if (hex.length === 4) {
                hex = hex.split('');
                hex = hex[0]+hex[0]+hex[1]+hex[1]+hex[2]+hex[2]+hex[3]+hex[3];
            }
            var u$1 = parseInt(hex, 16);
            var r$1 = u$1 >> 24 & 0xFF;
            var g$1 = u$1 >> 16 & 0xFF;
            var b$1 = u$1 >> 8 & 0xFF;
            var a = Math.round((u$1 & 0xFF) / 0xFF * 100) / 100;
            return [r$1,g$1,b$1,a];
        }

        // we used to check for css colors here
        // if _input.css? and rgb = _input.css hex
        //     return rgb

        throw new Error(("unknown hex color: " + hex));
    };

    var hex2rgb_1 = hex2rgb;

    var type$5 = utils.type;




    Color_1.prototype.hex = function(mode) {
        return rgb2hex_1(this._rgb, mode);
    };

    chroma_1.hex = function () {
        var args = [], len = arguments.length;
        while ( len-- ) args[ len ] = arguments[ len ];

        return new (Function.prototype.bind.apply( Color_1, [ null ].concat( args, ['hex']) ));
    };

    input.format.hex = hex2rgb_1;
    input.autodetect.push({
        p: 4,
        test: function (h) {
            var rest = [], len = arguments.length - 1;
            while ( len-- > 0 ) rest[ len ] = arguments[ len + 1 ];

            if (!rest.length && type$5(h) === 'string' && [3,4,5,6,7,8,9].indexOf(h.length) >= 0) {
                return 'hex';
            }
        }
    });

    var unpack$d = utils.unpack;
    var TWOPI = utils.TWOPI;
    var min = Math.min;
    var sqrt = Math.sqrt;
    var acos = Math.acos;

    var rgb2hsi = function () {
        var args = [], len = arguments.length;
        while ( len-- ) args[ len ] = arguments[ len ];

        /*
        borrowed from here:
        http://hummer.stanford.edu/museinfo/doc/examples/humdrum/keyscape2/rgb2hsi.cpp
        */
        var ref = unpack$d(args, 'rgb');
        var r = ref[0];
        var g = ref[1];
        var b = ref[2];
        r /= 255;
        g /= 255;
        b /= 255;
        var h;
        var min_ = min(r,g,b);
        var i = (r+g+b) / 3;
        var s = i > 0 ? 1 - min_/i : 0;
        if (s === 0) {
            h = NaN;
        } else {
            h = ((r-g)+(r-b)) / 2;
            h /= sqrt((r-g)*(r-g) + (r-b)*(g-b));
            h = acos(h);
            if (b > g) {
                h = TWOPI - h;
            }
            h /= TWOPI;
        }
        return [h*360,s,i];
    };

    var rgb2hsi_1 = rgb2hsi;

    var unpack$e = utils.unpack;
    var limit$1 = utils.limit;
    var TWOPI$1 = utils.TWOPI;
    var PITHIRD = utils.PITHIRD;
    var cos = Math.cos;

    /*
     * hue [0..360]
     * saturation [0..1]
     * intensity [0..1]
     */
    var hsi2rgb = function () {
        var args = [], len = arguments.length;
        while ( len-- ) args[ len ] = arguments[ len ];

        /*
        borrowed from here:
        http://hummer.stanford.edu/museinfo/doc/examples/humdrum/keyscape2/hsi2rgb.cpp
        */
        args = unpack$e(args, 'hsi');
        var h = args[0];
        var s = args[1];
        var i = args[2];
        var r,g,b;

        if (isNaN(h)) { h = 0; }
        if (isNaN(s)) { s = 0; }
        // normalize hue
        if (h > 360) { h -= 360; }
        if (h < 0) { h += 360; }
        h /= 360;
        if (h < 1/3) {
            b = (1-s)/3;
            r = (1+s*cos(TWOPI$1*h)/cos(PITHIRD-TWOPI$1*h))/3;
            g = 1 - (b+r);
        } else if (h < 2/3) {
            h -= 1/3;
            r = (1-s)/3;
            g = (1+s*cos(TWOPI$1*h)/cos(PITHIRD-TWOPI$1*h))/3;
            b = 1 - (r+g);
        } else {
            h -= 2/3;
            g = (1-s)/3;
            b = (1+s*cos(TWOPI$1*h)/cos(PITHIRD-TWOPI$1*h))/3;
            r = 1 - (g+b);
        }
        r = limit$1(i*r*3);
        g = limit$1(i*g*3);
        b = limit$1(i*b*3);
        return [r*255, g*255, b*255, args.length > 3 ? args[3] : 1];
    };

    var hsi2rgb_1 = hsi2rgb;

    var unpack$f = utils.unpack;
    var type$6 = utils.type;






    Color_1.prototype.hsi = function() {
        return rgb2hsi_1(this._rgb);
    };

    chroma_1.hsi = function () {
        var args = [], len = arguments.length;
        while ( len-- ) args[ len ] = arguments[ len ];

        return new (Function.prototype.bind.apply( Color_1, [ null ].concat( args, ['hsi']) ));
    };

    input.format.hsi = hsi2rgb_1;

    input.autodetect.push({
        p: 2,
        test: function () {
            var args = [], len = arguments.length;
            while ( len-- ) args[ len ] = arguments[ len ];

            args = unpack$f(args, 'hsi');
            if (type$6(args) === 'array' && args.length === 3) {
                return 'hsi';
            }
        }
    });

    var unpack$g = utils.unpack;
    var type$7 = utils.type;






    Color_1.prototype.hsl = function() {
        return rgb2hsl_1(this._rgb);
    };

    chroma_1.hsl = function () {
        var args = [], len = arguments.length;
        while ( len-- ) args[ len ] = arguments[ len ];

        return new (Function.prototype.bind.apply( Color_1, [ null ].concat( args, ['hsl']) ));
    };

    input.format.hsl = hsl2rgb_1;

    input.autodetect.push({
        p: 2,
        test: function () {
            var args = [], len = arguments.length;
            while ( len-- ) args[ len ] = arguments[ len ];

            args = unpack$g(args, 'hsl');
            if (type$7(args) === 'array' && args.length === 3) {
                return 'hsl';
            }
        }
    });

    var unpack$h = utils.unpack;
    var min$1 = Math.min;
    var max$1 = Math.max;

    /*
     * supported arguments:
     * - rgb2hsv(r,g,b)
     * - rgb2hsv([r,g,b])
     * - rgb2hsv({r,g,b})
     */
    var rgb2hsl$1 = function () {
        var args = [], len = arguments.length;
        while ( len-- ) args[ len ] = arguments[ len ];

        args = unpack$h(args, 'rgb');
        var r = args[0];
        var g = args[1];
        var b = args[2];
        var min_ = min$1(r, g, b);
        var max_ = max$1(r, g, b);
        var delta = max_ - min_;
        var h,s,v;
        v = max_ / 255.0;
        if (max_ === 0) {
            h = Number.NaN;
            s = 0;
        } else {
            s = delta / max_;
            if (r === max_) { h = (g - b) / delta; }
            if (g === max_) { h = 2+(b - r) / delta; }
            if (b === max_) { h = 4+(r - g) / delta; }
            h *= 60;
            if (h < 0) { h += 360; }
        }
        return [h, s, v]
    };

    var rgb2hsv = rgb2hsl$1;

    var unpack$i = utils.unpack;
    var floor$1 = Math.floor;

    var hsv2rgb = function () {
        var assign, assign$1, assign$2, assign$3, assign$4, assign$5;

        var args = [], len = arguments.length;
        while ( len-- ) args[ len ] = arguments[ len ];
        args = unpack$i(args, 'hsv');
        var h = args[0];
        var s = args[1];
        var v = args[2];
        var r,g,b;
        v *= 255;
        if (s === 0) {
            r = g = b = v;
        } else {
            if (h === 360) { h = 0; }
            if (h > 360) { h -= 360; }
            if (h < 0) { h += 360; }
            h /= 60;

            var i = floor$1(h);
            var f = h - i;
            var p = v * (1 - s);
            var q = v * (1 - s * f);
            var t = v * (1 - s * (1 - f));

            switch (i) {
                case 0: (assign = [v, t, p], r = assign[0], g = assign[1], b = assign[2]); break
                case 1: (assign$1 = [q, v, p], r = assign$1[0], g = assign$1[1], b = assign$1[2]); break
                case 2: (assign$2 = [p, v, t], r = assign$2[0], g = assign$2[1], b = assign$2[2]); break
                case 3: (assign$3 = [p, q, v], r = assign$3[0], g = assign$3[1], b = assign$3[2]); break
                case 4: (assign$4 = [t, p, v], r = assign$4[0], g = assign$4[1], b = assign$4[2]); break
                case 5: (assign$5 = [v, p, q], r = assign$5[0], g = assign$5[1], b = assign$5[2]); break
            }
        }
        return [r,g,b,args.length > 3?args[3]:1];
    };

    var hsv2rgb_1 = hsv2rgb;

    var unpack$j = utils.unpack;
    var type$8 = utils.type;






    Color_1.prototype.hsv = function() {
        return rgb2hsv(this._rgb);
    };

    chroma_1.hsv = function () {
        var args = [], len = arguments.length;
        while ( len-- ) args[ len ] = arguments[ len ];

        return new (Function.prototype.bind.apply( Color_1, [ null ].concat( args, ['hsv']) ));
    };

    input.format.hsv = hsv2rgb_1;

    input.autodetect.push({
        p: 2,
        test: function () {
            var args = [], len = arguments.length;
            while ( len-- ) args[ len ] = arguments[ len ];

            args = unpack$j(args, 'hsv');
            if (type$8(args) === 'array' && args.length === 3) {
                return 'hsv';
            }
        }
    });

    var labConstants = {
        // Corresponds roughly to RGB brighter/darker
        Kn: 18,

        // D65 standard referent
        Xn: 0.950470,
        Yn: 1,
        Zn: 1.088830,

        t0: 0.137931034,  // 4 / 29
        t1: 0.206896552,  // 6 / 29
        t2: 0.12841855,   // 3 * t1 * t1
        t3: 0.008856452,  // t1 * t1 * t1
    };

    var unpack$k = utils.unpack;
    var pow = Math.pow;

    var rgb2lab = function () {
        var args = [], len = arguments.length;
        while ( len-- ) args[ len ] = arguments[ len ];

        var ref = unpack$k(args, 'rgb');
        var r = ref[0];
        var g = ref[1];
        var b = ref[2];
        var ref$1 = rgb2xyz(r,g,b);
        var x = ref$1[0];
        var y = ref$1[1];
        var z = ref$1[2];
        var l = 116 * y - 16;
        return [l < 0 ? 0 : l, 500 * (x - y), 200 * (y - z)];
    };

    var rgb_xyz = function (r) {
        if ((r /= 255) <= 0.04045) { return r / 12.92; }
        return pow((r + 0.055) / 1.055, 2.4);
    };

    var xyz_lab = function (t) {
        if (t > labConstants.t3) { return pow(t, 1 / 3); }
        return t / labConstants.t2 + labConstants.t0;
    };

    var rgb2xyz = function (r,g,b) {
        r = rgb_xyz(r);
        g = rgb_xyz(g);
        b = rgb_xyz(b);
        var x = xyz_lab((0.4124564 * r + 0.3575761 * g + 0.1804375 * b) / labConstants.Xn);
        var y = xyz_lab((0.2126729 * r + 0.7151522 * g + 0.0721750 * b) / labConstants.Yn);
        var z = xyz_lab((0.0193339 * r + 0.1191920 * g + 0.9503041 * b) / labConstants.Zn);
        return [x,y,z];
    };

    var rgb2lab_1 = rgb2lab;

    var unpack$l = utils.unpack;
    var pow$1 = Math.pow;

    /*
     * L* [0..100]
     * a [-100..100]
     * b [-100..100]
     */
    var lab2rgb = function () {
        var args = [], len = arguments.length;
        while ( len-- ) args[ len ] = arguments[ len ];

        args = unpack$l(args, 'lab');
        var l = args[0];
        var a = args[1];
        var b = args[2];
        var x,y,z, r,g,b_;

        y = (l + 16) / 116;
        x = isNaN(a) ? y : y + a / 500;
        z = isNaN(b) ? y : y - b / 200;

        y = labConstants.Yn * lab_xyz(y);
        x = labConstants.Xn * lab_xyz(x);
        z = labConstants.Zn * lab_xyz(z);

        r = xyz_rgb(3.2404542 * x - 1.5371385 * y - 0.4985314 * z);  // D65 -> sRGB
        g = xyz_rgb(-0.9692660 * x + 1.8760108 * y + 0.0415560 * z);
        b_ = xyz_rgb(0.0556434 * x - 0.2040259 * y + 1.0572252 * z);

        return [r,g,b_,args.length > 3 ? args[3] : 1];
    };

    var xyz_rgb = function (r) {
        return 255 * (r <= 0.00304 ? 12.92 * r : 1.055 * pow$1(r, 1 / 2.4) - 0.055)
    };

    var lab_xyz = function (t) {
        return t > labConstants.t1 ? t * t * t : labConstants.t2 * (t - labConstants.t0)
    };

    var lab2rgb_1 = lab2rgb;

    var unpack$m = utils.unpack;
    var type$9 = utils.type;






    Color_1.prototype.lab = function() {
        return rgb2lab_1(this._rgb);
    };

    chroma_1.lab = function () {
        var args = [], len = arguments.length;
        while ( len-- ) args[ len ] = arguments[ len ];

        return new (Function.prototype.bind.apply( Color_1, [ null ].concat( args, ['lab']) ));
    };

    input.format.lab = lab2rgb_1;

    input.autodetect.push({
        p: 2,
        test: function () {
            var args = [], len = arguments.length;
            while ( len-- ) args[ len ] = arguments[ len ];

            args = unpack$m(args, 'lab');
            if (type$9(args) === 'array' && args.length === 3) {
                return 'lab';
            }
        }
    });

    var unpack$n = utils.unpack;
    var RAD2DEG = utils.RAD2DEG;
    var sqrt$1 = Math.sqrt;
    var atan2 = Math.atan2;
    var round$4 = Math.round;

    var lab2lch = function () {
        var args = [], len = arguments.length;
        while ( len-- ) args[ len ] = arguments[ len ];

        var ref = unpack$n(args, 'lab');
        var l = ref[0];
        var a = ref[1];
        var b = ref[2];
        var c = sqrt$1(a * a + b * b);
        var h = (atan2(b, a) * RAD2DEG + 360) % 360;
        if (round$4(c*10000) === 0) { h = Number.NaN; }
        return [l, c, h];
    };

    var lab2lch_1 = lab2lch;

    var unpack$o = utils.unpack;



    var rgb2lch = function () {
        var args = [], len = arguments.length;
        while ( len-- ) args[ len ] = arguments[ len ];

        var ref = unpack$o(args, 'rgb');
        var r = ref[0];
        var g = ref[1];
        var b = ref[2];
        var ref$1 = rgb2lab_1(r,g,b);
        var l = ref$1[0];
        var a = ref$1[1];
        var b_ = ref$1[2];
        return lab2lch_1(l,a,b_);
    };

    var rgb2lch_1 = rgb2lch;

    var unpack$p = utils.unpack;
    var DEG2RAD = utils.DEG2RAD;
    var sin = Math.sin;
    var cos$1 = Math.cos;

    var lch2lab = function () {
        var args = [], len = arguments.length;
        while ( len-- ) args[ len ] = arguments[ len ];

        /*
        Convert from a qualitative parameter h and a quantitative parameter l to a 24-bit pixel.
        These formulas were invented by David Dalrymple to obtain maximum contrast without going
        out of gamut if the parameters are in the range 0-1.

        A saturation multiplier was added by Gregor Aisch
        */
        var ref = unpack$p(args, 'lch');
        var l = ref[0];
        var c = ref[1];
        var h = ref[2];
        if (isNaN(h)) { h = 0; }
        h = h * DEG2RAD;
        return [l, cos$1(h) * c, sin(h) * c]
    };

    var lch2lab_1 = lch2lab;

    var unpack$q = utils.unpack;



    var lch2rgb = function () {
        var args = [], len = arguments.length;
        while ( len-- ) args[ len ] = arguments[ len ];

        args = unpack$q(args, 'lch');
        var l = args[0];
        var c = args[1];
        var h = args[2];
        var ref = lch2lab_1 (l,c,h);
        var L = ref[0];
        var a = ref[1];
        var b_ = ref[2];
        var ref$1 = lab2rgb_1 (L,a,b_);
        var r = ref$1[0];
        var g = ref$1[1];
        var b = ref$1[2];
        return [r, g, b, args.length > 3 ? args[3] : 1];
    };

    var lch2rgb_1 = lch2rgb;

    var unpack$r = utils.unpack;


    var hcl2rgb = function () {
        var args = [], len = arguments.length;
        while ( len-- ) args[ len ] = arguments[ len ];

        var hcl = unpack$r(args, 'hcl').reverse();
        return lch2rgb_1.apply(void 0, hcl);
    };

    var hcl2rgb_1 = hcl2rgb;

    var unpack$s = utils.unpack;
    var type$a = utils.type;






    Color_1.prototype.lch = function() { return rgb2lch_1(this._rgb); };
    Color_1.prototype.hcl = function() { return rgb2lch_1(this._rgb).reverse(); };

    chroma_1.lch = function () {
        var args = [], len = arguments.length;
        while ( len-- ) args[ len ] = arguments[ len ];

        return new (Function.prototype.bind.apply( Color_1, [ null ].concat( args, ['lch']) ));
    };
    chroma_1.hcl = function () {
        var args = [], len = arguments.length;
        while ( len-- ) args[ len ] = arguments[ len ];

        return new (Function.prototype.bind.apply( Color_1, [ null ].concat( args, ['hcl']) ));
    };

    input.format.lch = lch2rgb_1;
    input.format.hcl = hcl2rgb_1;

    ['lch','hcl'].forEach(function (m) { return input.autodetect.push({
        p: 2,
        test: function () {
            var args = [], len = arguments.length;
            while ( len-- ) args[ len ] = arguments[ len ];

            args = unpack$s(args, m);
            if (type$a(args) === 'array' && args.length === 3) {
                return m;
            }
        }
    }); });

    /**
    	X11 color names

    	http://www.w3.org/TR/css3-color/#svg-color
    */

    var w3cx11 = {
        aliceblue: '#f0f8ff',
        antiquewhite: '#faebd7',
        aqua: '#00ffff',
        aquamarine: '#7fffd4',
        azure: '#f0ffff',
        beige: '#f5f5dc',
        bisque: '#ffe4c4',
        black: '#000000',
        blanchedalmond: '#ffebcd',
        blue: '#0000ff',
        blueviolet: '#8a2be2',
        brown: '#a52a2a',
        burlywood: '#deb887',
        cadetblue: '#5f9ea0',
        chartreuse: '#7fff00',
        chocolate: '#d2691e',
        coral: '#ff7f50',
        cornflower: '#6495ed',
        cornflowerblue: '#6495ed',
        cornsilk: '#fff8dc',
        crimson: '#dc143c',
        cyan: '#00ffff',
        darkblue: '#00008b',
        darkcyan: '#008b8b',
        darkgoldenrod: '#b8860b',
        darkgray: '#a9a9a9',
        darkgreen: '#006400',
        darkgrey: '#a9a9a9',
        darkkhaki: '#bdb76b',
        darkmagenta: '#8b008b',
        darkolivegreen: '#556b2f',
        darkorange: '#ff8c00',
        darkorchid: '#9932cc',
        darkred: '#8b0000',
        darksalmon: '#e9967a',
        darkseagreen: '#8fbc8f',
        darkslateblue: '#483d8b',
        darkslategray: '#2f4f4f',
        darkslategrey: '#2f4f4f',
        darkturquoise: '#00ced1',
        darkviolet: '#9400d3',
        deeppink: '#ff1493',
        deepskyblue: '#00bfff',
        dimgray: '#696969',
        dimgrey: '#696969',
        dodgerblue: '#1e90ff',
        firebrick: '#b22222',
        floralwhite: '#fffaf0',
        forestgreen: '#228b22',
        fuchsia: '#ff00ff',
        gainsboro: '#dcdcdc',
        ghostwhite: '#f8f8ff',
        gold: '#ffd700',
        goldenrod: '#daa520',
        gray: '#808080',
        green: '#008000',
        greenyellow: '#adff2f',
        grey: '#808080',
        honeydew: '#f0fff0',
        hotpink: '#ff69b4',
        indianred: '#cd5c5c',
        indigo: '#4b0082',
        ivory: '#fffff0',
        khaki: '#f0e68c',
        laserlemon: '#ffff54',
        lavender: '#e6e6fa',
        lavenderblush: '#fff0f5',
        lawngreen: '#7cfc00',
        lemonchiffon: '#fffacd',
        lightblue: '#add8e6',
        lightcoral: '#f08080',
        lightcyan: '#e0ffff',
        lightgoldenrod: '#fafad2',
        lightgoldenrodyellow: '#fafad2',
        lightgray: '#d3d3d3',
        lightgreen: '#90ee90',
        lightgrey: '#d3d3d3',
        lightpink: '#ffb6c1',
        lightsalmon: '#ffa07a',
        lightseagreen: '#20b2aa',
        lightskyblue: '#87cefa',
        lightslategray: '#778899',
        lightslategrey: '#778899',
        lightsteelblue: '#b0c4de',
        lightyellow: '#ffffe0',
        lime: '#00ff00',
        limegreen: '#32cd32',
        linen: '#faf0e6',
        magenta: '#ff00ff',
        maroon: '#800000',
        maroon2: '#7f0000',
        maroon3: '#b03060',
        mediumaquamarine: '#66cdaa',
        mediumblue: '#0000cd',
        mediumorchid: '#ba55d3',
        mediumpurple: '#9370db',
        mediumseagreen: '#3cb371',
        mediumslateblue: '#7b68ee',
        mediumspringgreen: '#00fa9a',
        mediumturquoise: '#48d1cc',
        mediumvioletred: '#c71585',
        midnightblue: '#191970',
        mintcream: '#f5fffa',
        mistyrose: '#ffe4e1',
        moccasin: '#ffe4b5',
        navajowhite: '#ffdead',
        navy: '#000080',
        oldlace: '#fdf5e6',
        olive: '#808000',
        olivedrab: '#6b8e23',
        orange: '#ffa500',
        orangered: '#ff4500',
        orchid: '#da70d6',
        palegoldenrod: '#eee8aa',
        palegreen: '#98fb98',
        paleturquoise: '#afeeee',
        palevioletred: '#db7093',
        papayawhip: '#ffefd5',
        peachpuff: '#ffdab9',
        peru: '#cd853f',
        pink: '#ffc0cb',
        plum: '#dda0dd',
        powderblue: '#b0e0e6',
        purple: '#800080',
        purple2: '#7f007f',
        purple3: '#a020f0',
        rebeccapurple: '#663399',
        red: '#ff0000',
        rosybrown: '#bc8f8f',
        royalblue: '#4169e1',
        saddlebrown: '#8b4513',
        salmon: '#fa8072',
        sandybrown: '#f4a460',
        seagreen: '#2e8b57',
        seashell: '#fff5ee',
        sienna: '#a0522d',
        silver: '#c0c0c0',
        skyblue: '#87ceeb',
        slateblue: '#6a5acd',
        slategray: '#708090',
        slategrey: '#708090',
        snow: '#fffafa',
        springgreen: '#00ff7f',
        steelblue: '#4682b4',
        tan: '#d2b48c',
        teal: '#008080',
        thistle: '#d8bfd8',
        tomato: '#ff6347',
        turquoise: '#40e0d0',
        violet: '#ee82ee',
        wheat: '#f5deb3',
        white: '#ffffff',
        whitesmoke: '#f5f5f5',
        yellow: '#ffff00',
        yellowgreen: '#9acd32'
    };

    var w3cx11_1 = w3cx11;

    var type$b = utils.type;





    Color_1.prototype.name = function() {
        var hex = rgb2hex_1(this._rgb, 'rgb');
        for (var i = 0, list = Object.keys(w3cx11_1); i < list.length; i += 1) {
            var n = list[i];

            if (w3cx11_1[n] === hex) { return n.toLowerCase(); }
        }
        return hex;
    };

    input.format.named = function (name) {
        name = name.toLowerCase();
        if (w3cx11_1[name]) { return hex2rgb_1(w3cx11_1[name]); }
        throw new Error('unknown color name: '+name);
    };

    input.autodetect.push({
        p: 5,
        test: function (h) {
            var rest = [], len = arguments.length - 1;
            while ( len-- > 0 ) rest[ len ] = arguments[ len + 1 ];

            if (!rest.length && type$b(h) === 'string' && w3cx11_1[h.toLowerCase()]) {
                return 'named';
            }
        }
    });

    var unpack$t = utils.unpack;

    var rgb2num = function () {
        var args = [], len = arguments.length;
        while ( len-- ) args[ len ] = arguments[ len ];

        var ref = unpack$t(args, 'rgb');
        var r = ref[0];
        var g = ref[1];
        var b = ref[2];
        return (r << 16) + (g << 8) + b;
    };

    var rgb2num_1 = rgb2num;

    var type$c = utils.type;

    var num2rgb = function (num) {
        if (type$c(num) == "number" && num >= 0 && num <= 0xFFFFFF) {
            var r = num >> 16;
            var g = (num >> 8) & 0xFF;
            var b = num & 0xFF;
            return [r,g,b,1];
        }
        throw new Error("unknown num color: "+num);
    };

    var num2rgb_1 = num2rgb;

    var type$d = utils.type;



    Color_1.prototype.num = function() {
        return rgb2num_1(this._rgb);
    };

    chroma_1.num = function () {
        var args = [], len = arguments.length;
        while ( len-- ) args[ len ] = arguments[ len ];

        return new (Function.prototype.bind.apply( Color_1, [ null ].concat( args, ['num']) ));
    };

    input.format.num = num2rgb_1;

    input.autodetect.push({
        p: 5,
        test: function () {
            var args = [], len = arguments.length;
            while ( len-- ) args[ len ] = arguments[ len ];

            if (args.length === 1 && type$d(args[0]) === 'number' && args[0] >= 0 && args[0] <= 0xFFFFFF) {
                return 'num';
            }
        }
    });

    var unpack$u = utils.unpack;
    var type$e = utils.type;
    var round$5 = Math.round;

    Color_1.prototype.rgb = function(rnd) {
        if ( rnd === void 0 ) rnd=true;

        if (rnd === false) { return this._rgb.slice(0,3); }
        return this._rgb.slice(0,3).map(round$5);
    };

    Color_1.prototype.rgba = function(rnd) {
        if ( rnd === void 0 ) rnd=true;

        return this._rgb.slice(0,4).map(function (v,i) {
            return i<3 ? (rnd === false ? v : round$5(v)) : v;
        });
    };

    chroma_1.rgb = function () {
        var args = [], len = arguments.length;
        while ( len-- ) args[ len ] = arguments[ len ];

        return new (Function.prototype.bind.apply( Color_1, [ null ].concat( args, ['rgb']) ));
    };

    input.format.rgb = function () {
        var args = [], len = arguments.length;
        while ( len-- ) args[ len ] = arguments[ len ];

        var rgba = unpack$u(args, 'rgba');
        if (rgba[3] === undefined) { rgba[3] = 1; }
        return rgba;
    };

    input.autodetect.push({
        p: 3,
        test: function () {
            var args = [], len = arguments.length;
            while ( len-- ) args[ len ] = arguments[ len ];

            args = unpack$u(args, 'rgba');
            if (type$e(args) === 'array' && (args.length === 3 ||
                args.length === 4 && type$e(args[3]) == 'number' && args[3] >= 0 && args[3] <= 1)) {
                return 'rgb';
            }
        }
    });

    /*
     * Based on implementation by Neil Bartlett
     * https://github.com/neilbartlett/color-temperature
     */

    var log = Math.log;

    var temperature2rgb = function (kelvin) {
        var temp = kelvin / 100;
        var r,g,b;
        if (temp < 66) {
            r = 255;
            g = -155.25485562709179 - 0.44596950469579133 * (g = temp-2) + 104.49216199393888 * log(g);
            b = temp < 20 ? 0 : -254.76935184120902 + 0.8274096064007395 * (b = temp-10) + 115.67994401066147 * log(b);
        } else {
            r = 351.97690566805693 + 0.114206453784165 * (r = temp-55) - 40.25366309332127 * log(r);
            g = 325.4494125711974 + 0.07943456536662342 * (g = temp-50) - 28.0852963507957 * log(g);
            b = 255;
        }
        return [r,g,b,1];
    };

    var temperature2rgb_1 = temperature2rgb;

    /*
     * Based on implementation by Neil Bartlett
     * https://github.com/neilbartlett/color-temperature
     **/


    var unpack$v = utils.unpack;
    var round$6 = Math.round;

    var rgb2temperature = function () {
        var args = [], len = arguments.length;
        while ( len-- ) args[ len ] = arguments[ len ];

        var rgb = unpack$v(args, 'rgb');
        var r = rgb[0], b = rgb[2];
        var minTemp = 1000;
        var maxTemp = 40000;
        var eps = 0.4;
        var temp;
        while (maxTemp - minTemp > eps) {
            temp = (maxTemp + minTemp) * 0.5;
            var rgb$1 = temperature2rgb_1(temp);
            if ((rgb$1[2] / rgb$1[0]) >= (b / r)) {
                maxTemp = temp;
            } else {
                minTemp = temp;
            }
        }
        return round$6(temp);
    };

    var rgb2temperature_1 = rgb2temperature;

    Color_1.prototype.temp =
    Color_1.prototype.kelvin =
    Color_1.prototype.temperature = function() {
        return rgb2temperature_1(this._rgb);
    };

    chroma_1.temp =
    chroma_1.kelvin =
    chroma_1.temperature = function () {
        var args = [], len = arguments.length;
        while ( len-- ) args[ len ] = arguments[ len ];

        return new (Function.prototype.bind.apply( Color_1, [ null ].concat( args, ['temp']) ));
    };

    input.format.temp =
    input.format.kelvin =
    input.format.temperature = temperature2rgb_1;

    var type$f = utils.type;

    Color_1.prototype.alpha = function(a, mutate) {
        if ( mutate === void 0 ) mutate=false;

        if (a !== undefined && type$f(a) === 'number') {
            if (mutate) {
                this._rgb[3] = a;
                return this;
            }
            return new Color_1([this._rgb[0], this._rgb[1], this._rgb[2], a], 'rgb');
        }
        return this._rgb[3];
    };

    Color_1.prototype.clipped = function() {
        return this._rgb._clipped || false;
    };

    Color_1.prototype.darken = function(amount) {
    	if ( amount === void 0 ) amount=1;

    	var me = this;
    	var lab = me.lab();
    	lab[0] -= labConstants.Kn * amount;
    	return new Color_1(lab, 'lab').alpha(me.alpha(), true);
    };

    Color_1.prototype.brighten = function(amount) {
    	if ( amount === void 0 ) amount=1;

    	return this.darken(-amount);
    };

    Color_1.prototype.darker = Color_1.prototype.darken;
    Color_1.prototype.brighter = Color_1.prototype.brighten;

    Color_1.prototype.get = function(mc) {
        var ref = mc.split('.');
        var mode = ref[0];
        var channel = ref[1];
        var src = this[mode]();
        if (channel) {
            var i = mode.indexOf(channel);
            if (i > -1) { return src[i]; }
            throw new Error(("unknown channel " + channel + " in mode " + mode));
        } else {
            return src;
        }
    };

    var type$g = utils.type;
    var pow$2 = Math.pow;

    var EPS = 1e-7;
    var MAX_ITER = 20;

    Color_1.prototype.luminance = function(lum) {
        if (lum !== undefined && type$g(lum) === 'number') {
            if (lum === 0) {
                // return pure black
                return new Color_1([0,0,0,this._rgb[3]], 'rgb');
            }
            if (lum === 1) {
                // return pure white
                return new Color_1([255,255,255,this._rgb[3]], 'rgb');
            }
            // compute new color using...
            var cur_lum = this.luminance();
            var mode = 'rgb';
            var max_iter = MAX_ITER;

            var test = function (low, high) {
                var mid = low.interpolate(high, 0.5, mode);
                var lm = mid.luminance();
                if (Math.abs(lum - lm) < EPS || !max_iter--) {
                    // close enough
                    return mid;
                }
                return lm > lum ? test(low, mid) : test(mid, high);
            };

            var rgb = (cur_lum > lum ? test(new Color_1([0,0,0]), this) : test(this, new Color_1([255,255,255]))).rgb();
            return new Color_1(rgb.concat( [this._rgb[3]]));
        }
        return rgb2luminance.apply(void 0, (this._rgb).slice(0,3));
    };


    var rgb2luminance = function (r,g,b) {
        // relative luminance
        // see http://www.w3.org/TR/2008/REC-WCAG20-20081211/#relativeluminancedef
        r = luminance_x(r);
        g = luminance_x(g);
        b = luminance_x(b);
        return 0.2126 * r + 0.7152 * g + 0.0722 * b;
    };

    var luminance_x = function (x) {
        x /= 255;
        return x <= 0.03928 ? x/12.92 : pow$2((x+0.055)/1.055, 2.4);
    };

    var interpolator = {};

    var type$h = utils.type;


    var mix = function (col1, col2, f) {
        if ( f === void 0 ) f=0.5;
        var rest = [], len = arguments.length - 3;
        while ( len-- > 0 ) rest[ len ] = arguments[ len + 3 ];

        var mode = rest[0] || 'lrgb';
        if (!interpolator[mode] && !rest.length) {
            // fall back to the first supported mode
            mode = Object.keys(interpolator)[0];
        }
        if (!interpolator[mode]) {
            throw new Error(("interpolation mode " + mode + " is not defined"));
        }
        if (type$h(col1) !== 'object') { col1 = new Color_1(col1); }
        if (type$h(col2) !== 'object') { col2 = new Color_1(col2); }
        return interpolator[mode](col1, col2, f)
            .alpha(col1.alpha() + f * (col2.alpha() - col1.alpha()));
    };

    Color_1.prototype.mix =
    Color_1.prototype.interpolate = function(col2, f) {
    	if ( f === void 0 ) f=0.5;
    	var rest = [], len = arguments.length - 2;
    	while ( len-- > 0 ) rest[ len ] = arguments[ len + 2 ];

    	return mix.apply(void 0, [ this, col2, f ].concat( rest ));
    };

    Color_1.prototype.premultiply = function(mutate) {
    	if ( mutate === void 0 ) mutate=false;

    	var rgb = this._rgb;
    	var a = rgb[3];
    	if (mutate) {
    		this._rgb = [rgb[0]*a, rgb[1]*a, rgb[2]*a, a];
    		return this;
    	} else {
    		return new Color_1([rgb[0]*a, rgb[1]*a, rgb[2]*a, a], 'rgb');
    	}
    };

    Color_1.prototype.saturate = function(amount) {
    	if ( amount === void 0 ) amount=1;

    	var me = this;
    	var lch = me.lch();
    	lch[1] += labConstants.Kn * amount;
    	if (lch[1] < 0) { lch[1] = 0; }
    	return new Color_1(lch, 'lch').alpha(me.alpha(), true);
    };

    Color_1.prototype.desaturate = function(amount) {
    	if ( amount === void 0 ) amount=1;

    	return this.saturate(-amount);
    };

    var type$i = utils.type;

    Color_1.prototype.set = function(mc, value, mutate) {
        if ( mutate === void 0 ) mutate=false;

        var ref = mc.split('.');
        var mode = ref[0];
        var channel = ref[1];
        var src = this[mode]();
        if (channel) {
            var i = mode.indexOf(channel);
            if (i > -1) {
                if (type$i(value) == 'string') {
                    switch(value.charAt(0)) {
                        case '+': src[i] += +value; break;
                        case '-': src[i] += +value; break;
                        case '*': src[i] *= +(value.substr(1)); break;
                        case '/': src[i] /= +(value.substr(1)); break;
                        default: src[i] = +value;
                    }
                } else if (type$i(value) === 'number') {
                    src[i] = value;
                } else {
                    throw new Error("unsupported value for Color.set");
                }
                var out = new Color_1(src, mode);
                if (mutate) {
                    this._rgb = out._rgb;
                    return this;
                }
                return out;
            }
            throw new Error(("unknown channel " + channel + " in mode " + mode));
        } else {
            return src;
        }
    };

    var rgb$1 = function (col1, col2, f) {
        var xyz0 = col1._rgb;
        var xyz1 = col2._rgb;
        return new Color_1(
            xyz0[0] + f * (xyz1[0]-xyz0[0]),
            xyz0[1] + f * (xyz1[1]-xyz0[1]),
            xyz0[2] + f * (xyz1[2]-xyz0[2]),
            'rgb'
        )
    };

    // register interpolator
    interpolator.rgb = rgb$1;

    var sqrt$2 = Math.sqrt;
    var pow$3 = Math.pow;

    var lrgb = function (col1, col2, f) {
        var ref = col1._rgb;
        var x1 = ref[0];
        var y1 = ref[1];
        var z1 = ref[2];
        var ref$1 = col2._rgb;
        var x2 = ref$1[0];
        var y2 = ref$1[1];
        var z2 = ref$1[2];
        return new Color_1(
            sqrt$2(pow$3(x1,2) * (1-f) + pow$3(x2,2) * f),
            sqrt$2(pow$3(y1,2) * (1-f) + pow$3(y2,2) * f),
            sqrt$2(pow$3(z1,2) * (1-f) + pow$3(z2,2) * f),
            'rgb'
        )
    };

    // register interpolator
    interpolator.lrgb = lrgb;

    var lab$1 = function (col1, col2, f) {
        var xyz0 = col1.lab();
        var xyz1 = col2.lab();
        return new Color_1(
            xyz0[0] + f * (xyz1[0]-xyz0[0]),
            xyz0[1] + f * (xyz1[1]-xyz0[1]),
            xyz0[2] + f * (xyz1[2]-xyz0[2]),
            'lab'
        )
    };

    // register interpolator
    interpolator.lab = lab$1;

    var _hsx = function (col1, col2, f, m) {
        var assign, assign$1;

        var xyz0, xyz1;
        if (m === 'hsl') {
            xyz0 = col1.hsl();
            xyz1 = col2.hsl();
        } else if (m === 'hsv') {
            xyz0 = col1.hsv();
            xyz1 = col2.hsv();
        } else if (m === 'hcg') {
            xyz0 = col1.hcg();
            xyz1 = col2.hcg();
        } else if (m === 'hsi') {
            xyz0 = col1.hsi();
            xyz1 = col2.hsi();
        } else if (m === 'lch' || m === 'hcl') {
            m = 'hcl';
            xyz0 = col1.hcl();
            xyz1 = col2.hcl();
        }

        var hue0, hue1, sat0, sat1, lbv0, lbv1;
        if (m.substr(0, 1) === 'h') {
            (assign = xyz0, hue0 = assign[0], sat0 = assign[1], lbv0 = assign[2]);
            (assign$1 = xyz1, hue1 = assign$1[0], sat1 = assign$1[1], lbv1 = assign$1[2]);
        }

        var sat, hue, lbv, dh;

        if (!isNaN(hue0) && !isNaN(hue1)) {
            // both colors have hue
            if (hue1 > hue0 && hue1 - hue0 > 180) {
                dh = hue1-(hue0+360);
            } else if (hue1 < hue0 && hue0 - hue1 > 180) {
                dh = hue1+360-hue0;
            } else{
                dh = hue1 - hue0;
            }
            hue = hue0 + f * dh;
        } else if (!isNaN(hue0)) {
            hue = hue0;
            if ((lbv1 == 1 || lbv1 == 0) && m != 'hsv') { sat = sat0; }
        } else if (!isNaN(hue1)) {
            hue = hue1;
            if ((lbv0 == 1 || lbv0 == 0) && m != 'hsv') { sat = sat1; }
        } else {
            hue = Number.NaN;
        }

        if (sat === undefined) { sat = sat0 + f * (sat1 - sat0); }
        lbv = lbv0 + f * (lbv1-lbv0);
        return new Color_1([hue, sat, lbv], m);
    };

    var lch$1 = function (col1, col2, f) {
    	return _hsx(col1, col2, f, 'lch');
    };

    // register interpolator
    interpolator.lch = lch$1;
    interpolator.hcl = lch$1;

    var num$1 = function (col1, col2, f) {
        var c1 = col1.num();
        var c2 = col2.num();
        return new Color_1(c1 + f * (c2-c1), 'num')
    };

    // register interpolator
    interpolator.num = num$1;

    var hcg$1 = function (col1, col2, f) {
    	return _hsx(col1, col2, f, 'hcg');
    };

    // register interpolator
    interpolator.hcg = hcg$1;

    var hsi$1 = function (col1, col2, f) {
    	return _hsx(col1, col2, f, 'hsi');
    };

    // register interpolator
    interpolator.hsi = hsi$1;

    var hsl$1 = function (col1, col2, f) {
    	return _hsx(col1, col2, f, 'hsl');
    };

    // register interpolator
    interpolator.hsl = hsl$1;

    var hsv$1 = function (col1, col2, f) {
    	return _hsx(col1, col2, f, 'hsv');
    };

    // register interpolator
    interpolator.hsv = hsv$1;

    var clip_rgb$2 = utils.clip_rgb;
    var pow$4 = Math.pow;
    var sqrt$3 = Math.sqrt;
    var PI$1 = Math.PI;
    var cos$2 = Math.cos;
    var sin$1 = Math.sin;
    var atan2$1 = Math.atan2;

    var average = function (colors, mode, weights) {
        if ( mode === void 0 ) mode='lrgb';
        if ( weights === void 0 ) weights=null;

        var l = colors.length;
        if (!weights) { weights = Array.from(new Array(l)).map(function () { return 1; }); }
        // normalize weights
        var k = l / weights.reduce(function(a, b) { return a + b; });
        weights.forEach(function (w,i) { weights[i] *= k; });
        // convert colors to Color objects
        colors = colors.map(function (c) { return new Color_1(c); });
        if (mode === 'lrgb') {
            return _average_lrgb(colors, weights)
        }
        var first = colors.shift();
        var xyz = first.get(mode);
        var cnt = [];
        var dx = 0;
        var dy = 0;
        // initial color
        for (var i=0; i<xyz.length; i++) {
            xyz[i] = (xyz[i] || 0) * weights[0];
            cnt.push(isNaN(xyz[i]) ? 0 : weights[0]);
            if (mode.charAt(i) === 'h' && !isNaN(xyz[i])) {
                var A = xyz[i] / 180 * PI$1;
                dx += cos$2(A) * weights[0];
                dy += sin$1(A) * weights[0];
            }
        }

        var alpha = first.alpha() * weights[0];
        colors.forEach(function (c,ci) {
            var xyz2 = c.get(mode);
            alpha += c.alpha() * weights[ci+1];
            for (var i=0; i<xyz.length; i++) {
                if (!isNaN(xyz2[i])) {
                    cnt[i] += weights[ci+1];
                    if (mode.charAt(i) === 'h') {
                        var A = xyz2[i] / 180 * PI$1;
                        dx += cos$2(A) * weights[ci+1];
                        dy += sin$1(A) * weights[ci+1];
                    } else {
                        xyz[i] += xyz2[i] * weights[ci+1];
                    }
                }
            }
        });

        for (var i$1=0; i$1<xyz.length; i$1++) {
            if (mode.charAt(i$1) === 'h') {
                var A$1 = atan2$1(dy / cnt[i$1], dx / cnt[i$1]) / PI$1 * 180;
                while (A$1 < 0) { A$1 += 360; }
                while (A$1 >= 360) { A$1 -= 360; }
                xyz[i$1] = A$1;
            } else {
                xyz[i$1] = xyz[i$1]/cnt[i$1];
            }
        }
        alpha /= l;
        return (new Color_1(xyz, mode)).alpha(alpha > 0.99999 ? 1 : alpha, true);
    };


    var _average_lrgb = function (colors, weights) {
        var l = colors.length;
        var xyz = [0,0,0,0];
        for (var i=0; i < colors.length; i++) {
            var col = colors[i];
            var f = weights[i] / l;
            var rgb = col._rgb;
            xyz[0] += pow$4(rgb[0],2) * f;
            xyz[1] += pow$4(rgb[1],2) * f;
            xyz[2] += pow$4(rgb[2],2) * f;
            xyz[3] += rgb[3] * f;
        }
        xyz[0] = sqrt$3(xyz[0]);
        xyz[1] = sqrt$3(xyz[1]);
        xyz[2] = sqrt$3(xyz[2]);
        if (xyz[3] > 0.9999999) { xyz[3] = 1; }
        return new Color_1(clip_rgb$2(xyz));
    };

    // minimal multi-purpose interface

    // @requires utils color analyze


    var type$j = utils.type;

    var pow$5 = Math.pow;

    var scale = function(colors) {

        // constructor
        var _mode = 'rgb';
        var _nacol = chroma_1('#ccc');
        var _spread = 0;
        // const _fixed = false;
        var _domain = [0, 1];
        var _pos = [];
        var _padding = [0,0];
        var _classes = false;
        var _colors = [];
        var _out = false;
        var _min = 0;
        var _max = 1;
        var _correctLightness = false;
        var _colorCache = {};
        var _useCache = true;
        var _gamma = 1;

        // private methods

        var setColors = function(colors) {
            colors = colors || ['#fff', '#000'];
            if (colors && type$j(colors) === 'string' && chroma_1.brewer &&
                chroma_1.brewer[colors.toLowerCase()]) {
                colors = chroma_1.brewer[colors.toLowerCase()];
            }
            if (type$j(colors) === 'array') {
                // handle single color
                if (colors.length === 1) {
                    colors = [colors[0], colors[0]];
                }
                // make a copy of the colors
                colors = colors.slice(0);
                // convert to chroma classes
                for (var c=0; c<colors.length; c++) {
                    colors[c] = chroma_1(colors[c]);
                }
                // auto-fill color position
                _pos.length = 0;
                for (var c$1=0; c$1<colors.length; c$1++) {
                    _pos.push(c$1/(colors.length-1));
                }
            }
            resetCache();
            return _colors = colors;
        };

        var getClass = function(value) {
            if (_classes != null) {
                var n = _classes.length-1;
                var i = 0;
                while (i < n && value >= _classes[i]) {
                    i++;
                }
                return i-1;
            }
            return 0;
        };

        var tMapLightness = function (t) { return t; };
        var tMapDomain = function (t) { return t; };

        // const classifyValue = function(value) {
        //     let val = value;
        //     if (_classes.length > 2) {
        //         const n = _classes.length-1;
        //         const i = getClass(value);
        //         const minc = _classes[0] + ((_classes[1]-_classes[0]) * (0 + (_spread * 0.5)));  // center of 1st class
        //         const maxc = _classes[n-1] + ((_classes[n]-_classes[n-1]) * (1 - (_spread * 0.5)));  // center of last class
        //         val = _min + ((((_classes[i] + ((_classes[i+1] - _classes[i]) * 0.5)) - minc) / (maxc-minc)) * (_max - _min));
        //     }
        //     return val;
        // };

        var getColor = function(val, bypassMap) {
            var col, t;
            if (bypassMap == null) { bypassMap = false; }
            if (isNaN(val) || (val === null)) { return _nacol; }
            if (!bypassMap) {
                if (_classes && (_classes.length > 2)) {
                    // find the class
                    var c = getClass(val);
                    t = c / (_classes.length-2);
                } else if (_max !== _min) {
                    // just interpolate between min/max
                    t = (val - _min) / (_max - _min);
                } else {
                    t = 1;
                }
            } else {
                t = val;
            }

            // domain map
            t = tMapDomain(t);

            if (!bypassMap) {
                t = tMapLightness(t);  // lightness correction
            }

            if (_gamma !== 1) { t = pow$5(t, _gamma); }

            t = _padding[0] + (t * (1 - _padding[0] - _padding[1]));

            t = Math.min(1, Math.max(0, t));

            var k = Math.floor(t * 10000);

            if (_useCache && _colorCache[k]) {
                col = _colorCache[k];
            } else {
                if (type$j(_colors) === 'array') {
                    //for i in [0.._pos.length-1]
                    for (var i=0; i<_pos.length; i++) {
                        var p = _pos[i];
                        if (t <= p) {
                            col = _colors[i];
                            break;
                        }
                        if ((t >= p) && (i === (_pos.length-1))) {
                            col = _colors[i];
                            break;
                        }
                        if (t > p && t < _pos[i+1]) {
                            t = (t-p)/(_pos[i+1]-p);
                            col = chroma_1.interpolate(_colors[i], _colors[i+1], t, _mode);
                            break;
                        }
                    }
                } else if (type$j(_colors) === 'function') {
                    col = _colors(t);
                }
                if (_useCache) { _colorCache[k] = col; }
            }
            return col;
        };

        var resetCache = function () { return _colorCache = {}; };

        setColors(colors);

        // public interface

        var f = function(v) {
            var c = chroma_1(getColor(v));
            if (_out && c[_out]) { return c[_out](); } else { return c; }
        };

        f.classes = function(classes) {
            if (classes != null) {
                if (type$j(classes) === 'array') {
                    _classes = classes;
                    _domain = [classes[0], classes[classes.length-1]];
                } else {
                    var d = chroma_1.analyze(_domain);
                    if (classes === 0) {
                        _classes = [d.min, d.max];
                    } else {
                        _classes = chroma_1.limits(d, 'e', classes);
                    }
                }
                return f;
            }
            return _classes;
        };


        f.domain = function(domain) {
            if (!arguments.length) {
                return _domain;
            }
            _min = domain[0];
            _max = domain[domain.length-1];
            _pos = [];
            var k = _colors.length;
            if ((domain.length === k) && (_min !== _max)) {
                // update positions
                for (var i = 0, list = Array.from(domain); i < list.length; i += 1) {
                    var d = list[i];

                  _pos.push((d-_min) / (_max-_min));
                }
            } else {
                for (var c=0; c<k; c++) {
                    _pos.push(c/(k-1));
                }
                if (domain.length > 2) {
                    // set domain map
                    var tOut = domain.map(function (d,i) { return i/(domain.length-1); });
                    var tBreaks = domain.map(function (d) { return (d - _min) / (_max - _min); });
                    if (!tBreaks.every(function (val, i) { return tOut[i] === val; })) {
                        tMapDomain = function (t) {
                            if (t <= 0 || t >= 1) { return t; }
                            var i = 0;
                            while (t >= tBreaks[i+1]) { i++; }
                            var f = (t - tBreaks[i]) / (tBreaks[i+1] - tBreaks[i]);
                            var out = tOut[i] + f * (tOut[i+1] - tOut[i]);
                            return out;
                        };
                    }

                }
            }
            _domain = [_min, _max];
            return f;
        };

        f.mode = function(_m) {
            if (!arguments.length) {
                return _mode;
            }
            _mode = _m;
            resetCache();
            return f;
        };

        f.range = function(colors, _pos) {
            setColors(colors, _pos);
            return f;
        };

        f.out = function(_o) {
            _out = _o;
            return f;
        };

        f.spread = function(val) {
            if (!arguments.length) {
                return _spread;
            }
            _spread = val;
            return f;
        };

        f.correctLightness = function(v) {
            if (v == null) { v = true; }
            _correctLightness = v;
            resetCache();
            if (_correctLightness) {
                tMapLightness = function(t) {
                    var L0 = getColor(0, true).lab()[0];
                    var L1 = getColor(1, true).lab()[0];
                    var pol = L0 > L1;
                    var L_actual = getColor(t, true).lab()[0];
                    var L_ideal = L0 + ((L1 - L0) * t);
                    var L_diff = L_actual - L_ideal;
                    var t0 = 0;
                    var t1 = 1;
                    var max_iter = 20;
                    while ((Math.abs(L_diff) > 1e-2) && (max_iter-- > 0)) {
                        (function() {
                            if (pol) { L_diff *= -1; }
                            if (L_diff < 0) {
                                t0 = t;
                                t += (t1 - t) * 0.5;
                            } else {
                                t1 = t;
                                t += (t0 - t) * 0.5;
                            }
                            L_actual = getColor(t, true).lab()[0];
                            return L_diff = L_actual - L_ideal;
                        })();
                    }
                    return t;
                };
            } else {
                tMapLightness = function (t) { return t; };
            }
            return f;
        };

        f.padding = function(p) {
            if (p != null) {
                if (type$j(p) === 'number') {
                    p = [p,p];
                }
                _padding = p;
                return f;
            } else {
                return _padding;
            }
        };

        f.colors = function(numColors, out) {
            // If no arguments are given, return the original colors that were provided
            if (arguments.length < 2) { out = 'hex'; }
            var result = [];

            if (arguments.length === 0) {
                result = _colors.slice(0);

            } else if (numColors === 1) {
                result = [f(0.5)];

            } else if (numColors > 1) {
                var dm = _domain[0];
                var dd = _domain[1] - dm;
                result = __range__(0, numColors, false).map(function (i) { return f( dm + ((i/(numColors-1)) * dd) ); });

            } else { // returns all colors based on the defined classes
                colors = [];
                var samples = [];
                if (_classes && (_classes.length > 2)) {
                    for (var i = 1, end = _classes.length, asc = 1 <= end; asc ? i < end : i > end; asc ? i++ : i--) {
                        samples.push((_classes[i-1]+_classes[i])*0.5);
                    }
                } else {
                    samples = _domain;
                }
                result = samples.map(function (v) { return f(v); });
            }

            if (chroma_1[out]) {
                result = result.map(function (c) { return c[out](); });
            }
            return result;
        };

        f.cache = function(c) {
            if (c != null) {
                _useCache = c;
                return f;
            } else {
                return _useCache;
            }
        };

        f.gamma = function(g) {
            if (g != null) {
                _gamma = g;
                return f;
            } else {
                return _gamma;
            }
        };

        f.nodata = function(d) {
            if (d != null) {
                _nacol = chroma_1(d);
                return f;
            } else {
                return _nacol;
            }
        };

        return f;
    };

    function __range__(left, right, inclusive) {
      var range = [];
      var ascending = left < right;
      var end = !inclusive ? right : ascending ? right + 1 : right - 1;
      for (var i = left; ascending ? i < end : i > end; ascending ? i++ : i--) {
        range.push(i);
      }
      return range;
    }

    //
    // interpolates between a set of colors uzing a bezier spline
    //

    // @requires utils lab




    var bezier = function(colors) {
        var assign, assign$1, assign$2;

        var I, lab0, lab1, lab2;
        colors = colors.map(function (c) { return new Color_1(c); });
        if (colors.length === 2) {
            // linear interpolation
            (assign = colors.map(function (c) { return c.lab(); }), lab0 = assign[0], lab1 = assign[1]);
            I = function(t) {
                var lab = ([0, 1, 2].map(function (i) { return lab0[i] + (t * (lab1[i] - lab0[i])); }));
                return new Color_1(lab, 'lab');
            };
        } else if (colors.length === 3) {
            // quadratic bezier interpolation
            (assign$1 = colors.map(function (c) { return c.lab(); }), lab0 = assign$1[0], lab1 = assign$1[1], lab2 = assign$1[2]);
            I = function(t) {
                var lab = ([0, 1, 2].map(function (i) { return ((1-t)*(1-t) * lab0[i]) + (2 * (1-t) * t * lab1[i]) + (t * t * lab2[i]); }));
                return new Color_1(lab, 'lab');
            };
        } else if (colors.length === 4) {
            // cubic bezier interpolation
            var lab3;
            (assign$2 = colors.map(function (c) { return c.lab(); }), lab0 = assign$2[0], lab1 = assign$2[1], lab2 = assign$2[2], lab3 = assign$2[3]);
            I = function(t) {
                var lab = ([0, 1, 2].map(function (i) { return ((1-t)*(1-t)*(1-t) * lab0[i]) + (3 * (1-t) * (1-t) * t * lab1[i]) + (3 * (1-t) * t * t * lab2[i]) + (t*t*t * lab3[i]); }));
                return new Color_1(lab, 'lab');
            };
        } else if (colors.length === 5) {
            var I0 = bezier(colors.slice(0, 3));
            var I1 = bezier(colors.slice(2, 5));
            I = function(t) {
                if (t < 0.5) {
                    return I0(t*2);
                } else {
                    return I1((t-0.5)*2);
                }
            };
        }
        return I;
    };

    var bezier_1 = function (colors) {
        var f = bezier(colors);
        f.scale = function () { return scale(f); };
        return f;
    };

    /*
     * interpolates between a set of colors uzing a bezier spline
     * blend mode formulas taken from http://www.venture-ware.com/kevin/coding/lets-learn-math-photoshop-blend-modes/
     */




    var blend = function (bottom, top, mode) {
        if (!blend[mode]) {
            throw new Error('unknown blend mode ' + mode);
        }
        return blend[mode](bottom, top);
    };

    var blend_f = function (f) { return function (bottom,top) {
            var c0 = chroma_1(top).rgb();
            var c1 = chroma_1(bottom).rgb();
            return chroma_1.rgb(f(c0, c1));
        }; };

    var each = function (f) { return function (c0, c1) {
            var out = [];
            out[0] = f(c0[0], c1[0]);
            out[1] = f(c0[1], c1[1]);
            out[2] = f(c0[2], c1[2]);
            return out;
        }; };

    var normal = function (a) { return a; };
    var multiply = function (a,b) { return a * b / 255; };
    var darken$1 = function (a,b) { return a > b ? b : a; };
    var lighten = function (a,b) { return a > b ? a : b; };
    var screen = function (a,b) { return 255 * (1 - (1-a/255) * (1-b/255)); };
    var overlay = function (a,b) { return b < 128 ? 2 * a * b / 255 : 255 * (1 - 2 * (1 - a / 255 ) * ( 1 - b / 255 )); };
    var burn = function (a,b) { return 255 * (1 - (1 - b / 255) / (a/255)); };
    var dodge = function (a,b) {
        if (a === 255) { return 255; }
        a = 255 * (b / 255) / (1 - a / 255);
        return a > 255 ? 255 : a
    };

    // # add = (a,b) ->
    // #     if (a + b > 255) then 255 else a + b

    blend.normal = blend_f(each(normal));
    blend.multiply = blend_f(each(multiply));
    blend.screen = blend_f(each(screen));
    blend.overlay = blend_f(each(overlay));
    blend.darken = blend_f(each(darken$1));
    blend.lighten = blend_f(each(lighten));
    blend.dodge = blend_f(each(dodge));
    blend.burn = blend_f(each(burn));
    // blend.add = blend_f(each(add));

    var blend_1 = blend;

    // cubehelix interpolation
    // based on D.A. Green "A colour scheme for the display of astronomical intensity images"
    // http://astron-soc.in/bulletin/11June/289392011.pdf

    var type$k = utils.type;
    var clip_rgb$3 = utils.clip_rgb;
    var TWOPI$2 = utils.TWOPI;
    var pow$6 = Math.pow;
    var sin$2 = Math.sin;
    var cos$3 = Math.cos;


    var cubehelix = function(start, rotations, hue, gamma, lightness) {
        if ( start === void 0 ) start=300;
        if ( rotations === void 0 ) rotations=-1.5;
        if ( hue === void 0 ) hue=1;
        if ( gamma === void 0 ) gamma=1;
        if ( lightness === void 0 ) lightness=[0,1];

        var dh = 0, dl;
        if (type$k(lightness) === 'array') {
            dl = lightness[1] - lightness[0];
        } else {
            dl = 0;
            lightness = [lightness, lightness];
        }

        var f = function(fract) {
            var a = TWOPI$2 * (((start+120)/360) + (rotations * fract));
            var l = pow$6(lightness[0] + (dl * fract), gamma);
            var h = dh !== 0 ? hue[0] + (fract * dh) : hue;
            var amp = (h * l * (1-l)) / 2;
            var cos_a = cos$3(a);
            var sin_a = sin$2(a);
            var r = l + (amp * ((-0.14861 * cos_a) + (1.78277* sin_a)));
            var g = l + (amp * ((-0.29227 * cos_a) - (0.90649* sin_a)));
            var b = l + (amp * (+1.97294 * cos_a));
            return chroma_1(clip_rgb$3([r*255,g*255,b*255,1]));
        };

        f.start = function(s) {
            if ((s == null)) { return start; }
            start = s;
            return f;
        };

        f.rotations = function(r) {
            if ((r == null)) { return rotations; }
            rotations = r;
            return f;
        };

        f.gamma = function(g) {
            if ((g == null)) { return gamma; }
            gamma = g;
            return f;
        };

        f.hue = function(h) {
            if ((h == null)) { return hue; }
            hue = h;
            if (type$k(hue) === 'array') {
                dh = hue[1] - hue[0];
                if (dh === 0) { hue = hue[1]; }
            } else {
                dh = 0;
            }
            return f;
        };

        f.lightness = function(h) {
            if ((h == null)) { return lightness; }
            if (type$k(h) === 'array') {
                lightness = h;
                dl = h[1] - h[0];
            } else {
                lightness = [h,h];
                dl = 0;
            }
            return f;
        };

        f.scale = function () { return chroma_1.scale(f); };

        f.hue(hue);

        return f;
    };

    var digits = '0123456789abcdef';

    var floor$2 = Math.floor;
    var random = Math.random;

    var random_1 = function () {
        var code = '#';
        for (var i=0; i<6; i++) {
            code += digits.charAt(floor$2(random() * 16));
        }
        return new Color_1(code, 'hex');
    };

    var log$1 = Math.log;
    var pow$7 = Math.pow;
    var floor$3 = Math.floor;
    var abs = Math.abs;


    var analyze = function (data, key) {
        if ( key === void 0 ) key=null;

        var r = {
            min: Number.MAX_VALUE,
            max: Number.MAX_VALUE*-1,
            sum: 0,
            values: [],
            count: 0
        };
        if (type(data) === 'object') {
            data = Object.values(data);
        }
        data.forEach(function (val) {
            if (key && type(val) === 'object') { val = val[key]; }
            if (val !== undefined && val !== null && !isNaN(val)) {
                r.values.push(val);
                r.sum += val;
                if (val < r.min) { r.min = val; }
                if (val > r.max) { r.max = val; }
                r.count += 1;
            }
        });

        r.domain = [r.min, r.max];

        r.limits = function (mode, num) { return limits(r, mode, num); };

        return r;
    };


    var limits = function (data, mode, num) {
        if ( mode === void 0 ) mode='equal';
        if ( num === void 0 ) num=7;

        if (type(data) == 'array') {
            data = analyze(data);
        }
        var min = data.min;
        var max = data.max;
        var values = data.values.sort(function (a,b) { return a-b; });

        if (num === 1) { return [min,max]; }

        var limits = [];

        if (mode.substr(0,1) === 'c') { // continuous
            limits.push(min);
            limits.push(max);
        }

        if (mode.substr(0,1) === 'e') { // equal interval
            limits.push(min);
            for (var i=1; i<num; i++) {
                limits.push(min+((i/num)*(max-min)));
            }
            limits.push(max);
        }

        else if (mode.substr(0,1) === 'l') { // log scale
            if (min <= 0) {
                throw new Error('Logarithmic scales are only possible for values > 0');
            }
            var min_log = Math.LOG10E * log$1(min);
            var max_log = Math.LOG10E * log$1(max);
            limits.push(min);
            for (var i$1=1; i$1<num; i$1++) {
                limits.push(pow$7(10, min_log + ((i$1/num) * (max_log - min_log))));
            }
            limits.push(max);
        }

        else if (mode.substr(0,1) === 'q') { // quantile scale
            limits.push(min);
            for (var i$2=1; i$2<num; i$2++) {
                var p = ((values.length-1) * i$2)/num;
                var pb = floor$3(p);
                if (pb === p) {
                    limits.push(values[pb]);
                } else { // p > pb
                    var pr = p - pb;
                    limits.push((values[pb]*(1-pr)) + (values[pb+1]*pr));
                }
            }
            limits.push(max);

        }

        else if (mode.substr(0,1) === 'k') { // k-means clustering
            /*
            implementation based on
            http://code.google.com/p/figue/source/browse/trunk/figue.js#336
            simplified for 1-d input values
            */
            var cluster;
            var n = values.length;
            var assignments = new Array(n);
            var clusterSizes = new Array(num);
            var repeat = true;
            var nb_iters = 0;
            var centroids = null;

            // get seed values
            centroids = [];
            centroids.push(min);
            for (var i$3=1; i$3<num; i$3++) {
                centroids.push(min + ((i$3/num) * (max-min)));
            }
            centroids.push(max);

            while (repeat) {
                // assignment step
                for (var j=0; j<num; j++) {
                    clusterSizes[j] = 0;
                }
                for (var i$4=0; i$4<n; i$4++) {
                    var value = values[i$4];
                    var mindist = Number.MAX_VALUE;
                    var best = (void 0);
                    for (var j$1=0; j$1<num; j$1++) {
                        var dist = abs(centroids[j$1]-value);
                        if (dist < mindist) {
                            mindist = dist;
                            best = j$1;
                        }
                        clusterSizes[best]++;
                        assignments[i$4] = best;
                    }
                }

                // update centroids step
                var newCentroids = new Array(num);
                for (var j$2=0; j$2<num; j$2++) {
                    newCentroids[j$2] = null;
                }
                for (var i$5=0; i$5<n; i$5++) {
                    cluster = assignments[i$5];
                    if (newCentroids[cluster] === null) {
                        newCentroids[cluster] = values[i$5];
                    } else {
                        newCentroids[cluster] += values[i$5];
                    }
                }
                for (var j$3=0; j$3<num; j$3++) {
                    newCentroids[j$3] *= 1/clusterSizes[j$3];
                }

                // check convergence
                repeat = false;
                for (var j$4=0; j$4<num; j$4++) {
                    if (newCentroids[j$4] !== centroids[j$4]) {
                        repeat = true;
                        break;
                    }
                }

                centroids = newCentroids;
                nb_iters++;

                if (nb_iters > 200) {
                    repeat = false;
                }
            }

            // finished k-means clustering
            // the next part is borrowed from gabrielflor.it
            var kClusters = {};
            for (var j$5=0; j$5<num; j$5++) {
                kClusters[j$5] = [];
            }
            for (var i$6=0; i$6<n; i$6++) {
                cluster = assignments[i$6];
                kClusters[cluster].push(values[i$6]);
            }
            var tmpKMeansBreaks = [];
            for (var j$6=0; j$6<num; j$6++) {
                tmpKMeansBreaks.push(kClusters[j$6][0]);
                tmpKMeansBreaks.push(kClusters[j$6][kClusters[j$6].length-1]);
            }
            tmpKMeansBreaks = tmpKMeansBreaks.sort(function (a,b){ return a-b; });
            limits.push(tmpKMeansBreaks[0]);
            for (var i$7=1; i$7 < tmpKMeansBreaks.length; i$7+= 2) {
                var v = tmpKMeansBreaks[i$7];
                if (!isNaN(v) && (limits.indexOf(v) === -1)) {
                    limits.push(v);
                }
            }
        }
        return limits;
    };

    var analyze_1 = {analyze: analyze, limits: limits};

    var contrast = function (a, b) {
        // WCAG contrast ratio
        // see http://www.w3.org/TR/2008/REC-WCAG20-20081211/#contrast-ratiodef
        a = new Color_1(a);
        b = new Color_1(b);
        var l1 = a.luminance();
        var l2 = b.luminance();
        return l1 > l2 ? (l1 + 0.05) / (l2 + 0.05) : (l2 + 0.05) / (l1 + 0.05);
    };

    var sqrt$4 = Math.sqrt;
    var atan2$2 = Math.atan2;
    var abs$1 = Math.abs;
    var cos$4 = Math.cos;
    var PI$2 = Math.PI;

    var deltaE = function(a, b, L, C) {
        if ( L === void 0 ) L=1;
        if ( C === void 0 ) C=1;

        // Delta E (CMC)
        // see http://www.brucelindbloom.com/index.html?Eqn_DeltaE_CMC.html
        a = new Color_1(a);
        b = new Color_1(b);
        var ref = Array.from(a.lab());
        var L1 = ref[0];
        var a1 = ref[1];
        var b1 = ref[2];
        var ref$1 = Array.from(b.lab());
        var L2 = ref$1[0];
        var a2 = ref$1[1];
        var b2 = ref$1[2];
        var c1 = sqrt$4((a1 * a1) + (b1 * b1));
        var c2 = sqrt$4((a2 * a2) + (b2 * b2));
        var sl = L1 < 16.0 ? 0.511 : (0.040975 * L1) / (1.0 + (0.01765 * L1));
        var sc = ((0.0638 * c1) / (1.0 + (0.0131 * c1))) + 0.638;
        var h1 = c1 < 0.000001 ? 0.0 : (atan2$2(b1, a1) * 180.0) / PI$2;
        while (h1 < 0) { h1 += 360; }
        while (h1 >= 360) { h1 -= 360; }
        var t = (h1 >= 164.0) && (h1 <= 345.0) ? (0.56 + abs$1(0.2 * cos$4((PI$2 * (h1 + 168.0)) / 180.0))) : (0.36 + abs$1(0.4 * cos$4((PI$2 * (h1 + 35.0)) / 180.0)));
        var c4 = c1 * c1 * c1 * c1;
        var f = sqrt$4(c4 / (c4 + 1900.0));
        var sh = sc * (((f * t) + 1.0) - f);
        var delL = L1 - L2;
        var delC = c1 - c2;
        var delA = a1 - a2;
        var delB = b1 - b2;
        var dH2 = ((delA * delA) + (delB * delB)) - (delC * delC);
        var v1 = delL / (L * sl);
        var v2 = delC / (C * sc);
        var v3 = sh;
        return sqrt$4((v1 * v1) + (v2 * v2) + (dH2 / (v3 * v3)));
    };

    // simple Euclidean distance
    var distance = function(a, b, mode) {
        if ( mode === void 0 ) mode='lab';

        // Delta E (CIE 1976)
        // see http://www.brucelindbloom.com/index.html?Equations.html
        a = new Color_1(a);
        b = new Color_1(b);
        var l1 = a.get(mode);
        var l2 = b.get(mode);
        var sum_sq = 0;
        for (var i in l1) {
            var d = (l1[i] || 0) - (l2[i] || 0);
            sum_sq += d*d;
        }
        return Math.sqrt(sum_sq);
    };

    var valid = function () {
        var args = [], len = arguments.length;
        while ( len-- ) args[ len ] = arguments[ len ];

        try {
            new (Function.prototype.bind.apply( Color_1, [ null ].concat( args) ));
            return true;
        } catch (e) {
            return false;
        }
    };

    // some pre-defined color scales:




    var scales = {
    	cool: function cool() { return scale([chroma_1.hsl(180,1,.9), chroma_1.hsl(250,.7,.4)]) },
    	hot: function hot() { return scale(['#000','#f00','#ff0','#fff'], [0,.25,.75,1]).mode('rgb') }
    };

    /**
        ColorBrewer colors for chroma.js

        Copyright (c) 2002 Cynthia Brewer, Mark Harrower, and The
        Pennsylvania State University.

        Licensed under the Apache License, Version 2.0 (the "License");
        you may not use this file except in compliance with the License.
        You may obtain a copy of the License at
        http://www.apache.org/licenses/LICENSE-2.0

        Unless required by applicable law or agreed to in writing, software distributed
        under the License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
        CONDITIONS OF ANY KIND, either express or implied. See the License for the
        specific language governing permissions and limitations under the License.
    */

    var colorbrewer = {
        // sequential
        OrRd: ['#fff7ec', '#fee8c8', '#fdd49e', '#fdbb84', '#fc8d59', '#ef6548', '#d7301f', '#b30000', '#7f0000'],
        PuBu: ['#fff7fb', '#ece7f2', '#d0d1e6', '#a6bddb', '#74a9cf', '#3690c0', '#0570b0', '#045a8d', '#023858'],
        BuPu: ['#f7fcfd', '#e0ecf4', '#bfd3e6', '#9ebcda', '#8c96c6', '#8c6bb1', '#88419d', '#810f7c', '#4d004b'],
        Oranges: ['#fff5eb', '#fee6ce', '#fdd0a2', '#fdae6b', '#fd8d3c', '#f16913', '#d94801', '#a63603', '#7f2704'],
        BuGn: ['#f7fcfd', '#e5f5f9', '#ccece6', '#99d8c9', '#66c2a4', '#41ae76', '#238b45', '#006d2c', '#00441b'],
        YlOrBr: ['#ffffe5', '#fff7bc', '#fee391', '#fec44f', '#fe9929', '#ec7014', '#cc4c02', '#993404', '#662506'],
        YlGn: ['#ffffe5', '#f7fcb9', '#d9f0a3', '#addd8e', '#78c679', '#41ab5d', '#238443', '#006837', '#004529'],
        Reds: ['#fff5f0', '#fee0d2', '#fcbba1', '#fc9272', '#fb6a4a', '#ef3b2c', '#cb181d', '#a50f15', '#67000d'],
        RdPu: ['#fff7f3', '#fde0dd', '#fcc5c0', '#fa9fb5', '#f768a1', '#dd3497', '#ae017e', '#7a0177', '#49006a'],
        Greens: ['#f7fcf5', '#e5f5e0', '#c7e9c0', '#a1d99b', '#74c476', '#41ab5d', '#238b45', '#006d2c', '#00441b'],
        YlGnBu: ['#ffffd9', '#edf8b1', '#c7e9b4', '#7fcdbb', '#41b6c4', '#1d91c0', '#225ea8', '#253494', '#081d58'],
        Purples: ['#fcfbfd', '#efedf5', '#dadaeb', '#bcbddc', '#9e9ac8', '#807dba', '#6a51a3', '#54278f', '#3f007d'],
        GnBu: ['#f7fcf0', '#e0f3db', '#ccebc5', '#a8ddb5', '#7bccc4', '#4eb3d3', '#2b8cbe', '#0868ac', '#084081'],
        Greys: ['#ffffff', '#f0f0f0', '#d9d9d9', '#bdbdbd', '#969696', '#737373', '#525252', '#252525', '#000000'],
        YlOrRd: ['#ffffcc', '#ffeda0', '#fed976', '#feb24c', '#fd8d3c', '#fc4e2a', '#e31a1c', '#bd0026', '#800026'],
        PuRd: ['#f7f4f9', '#e7e1ef', '#d4b9da', '#c994c7', '#df65b0', '#e7298a', '#ce1256', '#980043', '#67001f'],
        Blues: ['#f7fbff', '#deebf7', '#c6dbef', '#9ecae1', '#6baed6', '#4292c6', '#2171b5', '#08519c', '#08306b'],
        PuBuGn: ['#fff7fb', '#ece2f0', '#d0d1e6', '#a6bddb', '#67a9cf', '#3690c0', '#02818a', '#016c59', '#014636'],
        Viridis: ['#440154', '#482777', '#3f4a8a', '#31678e', '#26838f', '#1f9d8a', '#6cce5a', '#b6de2b', '#fee825'],

        // diverging

        Spectral: ['#9e0142', '#d53e4f', '#f46d43', '#fdae61', '#fee08b', '#ffffbf', '#e6f598', '#abdda4', '#66c2a5', '#3288bd', '#5e4fa2'],
        RdYlGn: ['#a50026', '#d73027', '#f46d43', '#fdae61', '#fee08b', '#ffffbf', '#d9ef8b', '#a6d96a', '#66bd63', '#1a9850', '#006837'],
        RdBu: ['#67001f', '#b2182b', '#d6604d', '#f4a582', '#fddbc7', '#f7f7f7', '#d1e5f0', '#92c5de', '#4393c3', '#2166ac', '#053061'],
        PiYG: ['#8e0152', '#c51b7d', '#de77ae', '#f1b6da', '#fde0ef', '#f7f7f7', '#e6f5d0', '#b8e186', '#7fbc41', '#4d9221', '#276419'],
        PRGn: ['#40004b', '#762a83', '#9970ab', '#c2a5cf', '#e7d4e8', '#f7f7f7', '#d9f0d3', '#a6dba0', '#5aae61', '#1b7837', '#00441b'],
        RdYlBu: ['#a50026', '#d73027', '#f46d43', '#fdae61', '#fee090', '#ffffbf', '#e0f3f8', '#abd9e9', '#74add1', '#4575b4', '#313695'],
        BrBG: ['#543005', '#8c510a', '#bf812d', '#dfc27d', '#f6e8c3', '#f5f5f5', '#c7eae5', '#80cdc1', '#35978f', '#01665e', '#003c30'],
        RdGy: ['#67001f', '#b2182b', '#d6604d', '#f4a582', '#fddbc7', '#ffffff', '#e0e0e0', '#bababa', '#878787', '#4d4d4d', '#1a1a1a'],
        PuOr: ['#7f3b08', '#b35806', '#e08214', '#fdb863', '#fee0b6', '#f7f7f7', '#d8daeb', '#b2abd2', '#8073ac', '#542788', '#2d004b'],

        // qualitative

        Set2: ['#66c2a5', '#fc8d62', '#8da0cb', '#e78ac3', '#a6d854', '#ffd92f', '#e5c494', '#b3b3b3'],
        Accent: ['#7fc97f', '#beaed4', '#fdc086', '#ffff99', '#386cb0', '#f0027f', '#bf5b17', '#666666'],
        Set1: ['#e41a1c', '#377eb8', '#4daf4a', '#984ea3', '#ff7f00', '#ffff33', '#a65628', '#f781bf', '#999999'],
        Set3: ['#8dd3c7', '#ffffb3', '#bebada', '#fb8072', '#80b1d3', '#fdb462', '#b3de69', '#fccde5', '#d9d9d9', '#bc80bd', '#ccebc5', '#ffed6f'],
        Dark2: ['#1b9e77', '#d95f02', '#7570b3', '#e7298a', '#66a61e', '#e6ab02', '#a6761d', '#666666'],
        Paired: ['#a6cee3', '#1f78b4', '#b2df8a', '#33a02c', '#fb9a99', '#e31a1c', '#fdbf6f', '#ff7f00', '#cab2d6', '#6a3d9a', '#ffff99', '#b15928'],
        Pastel2: ['#b3e2cd', '#fdcdac', '#cbd5e8', '#f4cae4', '#e6f5c9', '#fff2ae', '#f1e2cc', '#cccccc'],
        Pastel1: ['#fbb4ae', '#b3cde3', '#ccebc5', '#decbe4', '#fed9a6', '#ffffcc', '#e5d8bd', '#fddaec', '#f2f2f2'],
    };

    // add lowercase aliases for case-insensitive matches
    for (var i$1 = 0, list$1 = Object.keys(colorbrewer); i$1 < list$1.length; i$1 += 1) {
        var key = list$1[i$1];

        colorbrewer[key.toLowerCase()] = colorbrewer[key];
    }

    var colorbrewer_1 = colorbrewer;

    // feel free to comment out anything to rollup
    // a smaller chroma.js built

    // io --> convert colors















    // operators --> modify existing Colors










    // interpolators










    // generators -- > create new colors
    chroma_1.average = average;
    chroma_1.bezier = bezier_1;
    chroma_1.blend = blend_1;
    chroma_1.cubehelix = cubehelix;
    chroma_1.mix = chroma_1.interpolate = mix;
    chroma_1.random = random_1;
    chroma_1.scale = scale;

    // other utility methods
    chroma_1.analyze = analyze_1.analyze;
    chroma_1.contrast = contrast;
    chroma_1.deltaE = deltaE;
    chroma_1.distance = distance;
    chroma_1.limits = analyze_1.limits;
    chroma_1.valid = valid;

    // scale
    chroma_1.scales = scales;

    // colors
    chroma_1.colors = w3cx11_1;
    chroma_1.brewer = colorbrewer_1;

    var chroma_js = chroma_1;

    return chroma_js;

})));


/***/ }),

/***/ "../node_modules/core-js/internals/a-function.js":
/*!*******************************************************!*\
  !*** ../node_modules/core-js/internals/a-function.js ***!
  \*******************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = function (it) {
  if (typeof it != 'function') {
    throw TypeError(String(it) + ' is not a function');
  } return it;
};


/***/ }),

/***/ "../node_modules/core-js/internals/an-object.js":
/*!******************************************************!*\
  !*** ../node_modules/core-js/internals/an-object.js ***!
  \******************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

var isObject = __webpack_require__(/*! ../internals/is-object */ "../node_modules/core-js/internals/is-object.js");

module.exports = function (it) {
  if (!isObject(it)) {
    throw TypeError(String(it) + ' is not an object');
  } return it;
};


/***/ }),

/***/ "../node_modules/core-js/internals/array-includes.js":
/*!***********************************************************!*\
  !*** ../node_modules/core-js/internals/array-includes.js ***!
  \***********************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

var toIndexedObject = __webpack_require__(/*! ../internals/to-indexed-object */ "../node_modules/core-js/internals/to-indexed-object.js");
var toLength = __webpack_require__(/*! ../internals/to-length */ "../node_modules/core-js/internals/to-length.js");
var toAbsoluteIndex = __webpack_require__(/*! ../internals/to-absolute-index */ "../node_modules/core-js/internals/to-absolute-index.js");

// `Array.prototype.{ indexOf, includes }` methods implementation
var createMethod = function (IS_INCLUDES) {
  return function ($this, el, fromIndex) {
    var O = toIndexedObject($this);
    var length = toLength(O.length);
    var index = toAbsoluteIndex(fromIndex, length);
    var value;
    // Array#includes uses SameValueZero equality algorithm
    // eslint-disable-next-line no-self-compare
    if (IS_INCLUDES && el != el) while (length > index) {
      value = O[index++];
      // eslint-disable-next-line no-self-compare
      if (value != value) return true;
    // Array#indexOf ignores holes, Array#includes - not
    } else for (;length > index; index++) {
      if ((IS_INCLUDES || index in O) && O[index] === el) return IS_INCLUDES || index || 0;
    } return !IS_INCLUDES && -1;
  };
};

module.exports = {
  // `Array.prototype.includes` method
  // https://tc39.github.io/ecma262/#sec-array.prototype.includes
  includes: createMethod(true),
  // `Array.prototype.indexOf` method
  // https://tc39.github.io/ecma262/#sec-array.prototype.indexof
  indexOf: createMethod(false)
};


/***/ }),

/***/ "../node_modules/core-js/internals/array-iteration.js":
/*!************************************************************!*\
  !*** ../node_modules/core-js/internals/array-iteration.js ***!
  \************************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

var bind = __webpack_require__(/*! ../internals/function-bind-context */ "../node_modules/core-js/internals/function-bind-context.js");
var IndexedObject = __webpack_require__(/*! ../internals/indexed-object */ "../node_modules/core-js/internals/indexed-object.js");
var toObject = __webpack_require__(/*! ../internals/to-object */ "../node_modules/core-js/internals/to-object.js");
var toLength = __webpack_require__(/*! ../internals/to-length */ "../node_modules/core-js/internals/to-length.js");
var arraySpeciesCreate = __webpack_require__(/*! ../internals/array-species-create */ "../node_modules/core-js/internals/array-species-create.js");

var push = [].push;

// `Array.prototype.{ forEach, map, filter, some, every, find, findIndex }` methods implementation
var createMethod = function (TYPE) {
  var IS_MAP = TYPE == 1;
  var IS_FILTER = TYPE == 2;
  var IS_SOME = TYPE == 3;
  var IS_EVERY = TYPE == 4;
  var IS_FIND_INDEX = TYPE == 6;
  var NO_HOLES = TYPE == 5 || IS_FIND_INDEX;
  return function ($this, callbackfn, that, specificCreate) {
    var O = toObject($this);
    var self = IndexedObject(O);
    var boundFunction = bind(callbackfn, that, 3);
    var length = toLength(self.length);
    var index = 0;
    var create = specificCreate || arraySpeciesCreate;
    var target = IS_MAP ? create($this, length) : IS_FILTER ? create($this, 0) : undefined;
    var value, result;
    for (;length > index; index++) if (NO_HOLES || index in self) {
      value = self[index];
      result = boundFunction(value, index, O);
      if (TYPE) {
        if (IS_MAP) target[index] = result; // map
        else if (result) switch (TYPE) {
          case 3: return true;              // some
          case 5: return value;             // find
          case 6: return index;             // findIndex
          case 2: push.call(target, value); // filter
        } else if (IS_EVERY) return false;  // every
      }
    }
    return IS_FIND_INDEX ? -1 : IS_SOME || IS_EVERY ? IS_EVERY : target;
  };
};

module.exports = {
  // `Array.prototype.forEach` method
  // https://tc39.github.io/ecma262/#sec-array.prototype.foreach
  forEach: createMethod(0),
  // `Array.prototype.map` method
  // https://tc39.github.io/ecma262/#sec-array.prototype.map
  map: createMethod(1),
  // `Array.prototype.filter` method
  // https://tc39.github.io/ecma262/#sec-array.prototype.filter
  filter: createMethod(2),
  // `Array.prototype.some` method
  // https://tc39.github.io/ecma262/#sec-array.prototype.some
  some: createMethod(3),
  // `Array.prototype.every` method
  // https://tc39.github.io/ecma262/#sec-array.prototype.every
  every: createMethod(4),
  // `Array.prototype.find` method
  // https://tc39.github.io/ecma262/#sec-array.prototype.find
  find: createMethod(5),
  // `Array.prototype.findIndex` method
  // https://tc39.github.io/ecma262/#sec-array.prototype.findIndex
  findIndex: createMethod(6)
};


/***/ }),

/***/ "../node_modules/core-js/internals/array-method-has-species-support.js":
/*!*****************************************************************************!*\
  !*** ../node_modules/core-js/internals/array-method-has-species-support.js ***!
  \*****************************************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

var fails = __webpack_require__(/*! ../internals/fails */ "../node_modules/core-js/internals/fails.js");
var wellKnownSymbol = __webpack_require__(/*! ../internals/well-known-symbol */ "../node_modules/core-js/internals/well-known-symbol.js");
var V8_VERSION = __webpack_require__(/*! ../internals/engine-v8-version */ "../node_modules/core-js/internals/engine-v8-version.js");

var SPECIES = wellKnownSymbol('species');

module.exports = function (METHOD_NAME) {
  // We can't use this feature detection in V8 since it causes
  // deoptimization and serious performance degradation
  // https://github.com/zloirock/core-js/issues/677
  return V8_VERSION >= 51 || !fails(function () {
    var array = [];
    var constructor = array.constructor = {};
    constructor[SPECIES] = function () {
      return { foo: 1 };
    };
    return array[METHOD_NAME](Boolean).foo !== 1;
  });
};


/***/ }),

/***/ "../node_modules/core-js/internals/array-method-is-strict.js":
/*!*******************************************************************!*\
  !*** ../node_modules/core-js/internals/array-method-is-strict.js ***!
  \*******************************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var fails = __webpack_require__(/*! ../internals/fails */ "../node_modules/core-js/internals/fails.js");

module.exports = function (METHOD_NAME, argument) {
  var method = [][METHOD_NAME];
  return !!method && fails(function () {
    // eslint-disable-next-line no-useless-call,no-throw-literal
    method.call(null, argument || function () { throw 1; }, 1);
  });
};


/***/ }),

/***/ "../node_modules/core-js/internals/array-method-uses-to-length.js":
/*!************************************************************************!*\
  !*** ../node_modules/core-js/internals/array-method-uses-to-length.js ***!
  \************************************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

var DESCRIPTORS = __webpack_require__(/*! ../internals/descriptors */ "../node_modules/core-js/internals/descriptors.js");
var fails = __webpack_require__(/*! ../internals/fails */ "../node_modules/core-js/internals/fails.js");
var has = __webpack_require__(/*! ../internals/has */ "../node_modules/core-js/internals/has.js");

var defineProperty = Object.defineProperty;
var cache = {};

var thrower = function (it) { throw it; };

module.exports = function (METHOD_NAME, options) {
  if (has(cache, METHOD_NAME)) return cache[METHOD_NAME];
  if (!options) options = {};
  var method = [][METHOD_NAME];
  var ACCESSORS = has(options, 'ACCESSORS') ? options.ACCESSORS : false;
  var argument0 = has(options, 0) ? options[0] : thrower;
  var argument1 = has(options, 1) ? options[1] : undefined;

  return cache[METHOD_NAME] = !!method && !fails(function () {
    if (ACCESSORS && !DESCRIPTORS) return true;
    var O = { length: -1 };

    if (ACCESSORS) defineProperty(O, 1, { enumerable: true, get: thrower });
    else O[1] = 1;

    method.call(O, argument0, argument1);
  });
};


/***/ }),

/***/ "../node_modules/core-js/internals/array-species-create.js":
/*!*****************************************************************!*\
  !*** ../node_modules/core-js/internals/array-species-create.js ***!
  \*****************************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

var isObject = __webpack_require__(/*! ../internals/is-object */ "../node_modules/core-js/internals/is-object.js");
var isArray = __webpack_require__(/*! ../internals/is-array */ "../node_modules/core-js/internals/is-array.js");
var wellKnownSymbol = __webpack_require__(/*! ../internals/well-known-symbol */ "../node_modules/core-js/internals/well-known-symbol.js");

var SPECIES = wellKnownSymbol('species');

// `ArraySpeciesCreate` abstract operation
// https://tc39.github.io/ecma262/#sec-arrayspeciescreate
module.exports = function (originalArray, length) {
  var C;
  if (isArray(originalArray)) {
    C = originalArray.constructor;
    // cross-realm fallback
    if (typeof C == 'function' && (C === Array || isArray(C.prototype))) C = undefined;
    else if (isObject(C)) {
      C = C[SPECIES];
      if (C === null) C = undefined;
    }
  } return new (C === undefined ? Array : C)(length === 0 ? 0 : length);
};


/***/ }),

/***/ "../node_modules/core-js/internals/classof-raw.js":
/*!********************************************************!*\
  !*** ../node_modules/core-js/internals/classof-raw.js ***!
  \********************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

var toString = {}.toString;

module.exports = function (it) {
  return toString.call(it).slice(8, -1);
};


/***/ }),

/***/ "../node_modules/core-js/internals/copy-constructor-properties.js":
/*!************************************************************************!*\
  !*** ../node_modules/core-js/internals/copy-constructor-properties.js ***!
  \************************************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

var has = __webpack_require__(/*! ../internals/has */ "../node_modules/core-js/internals/has.js");
var ownKeys = __webpack_require__(/*! ../internals/own-keys */ "../node_modules/core-js/internals/own-keys.js");
var getOwnPropertyDescriptorModule = __webpack_require__(/*! ../internals/object-get-own-property-descriptor */ "../node_modules/core-js/internals/object-get-own-property-descriptor.js");
var definePropertyModule = __webpack_require__(/*! ../internals/object-define-property */ "../node_modules/core-js/internals/object-define-property.js");

module.exports = function (target, source) {
  var keys = ownKeys(source);
  var defineProperty = definePropertyModule.f;
  var getOwnPropertyDescriptor = getOwnPropertyDescriptorModule.f;
  for (var i = 0; i < keys.length; i++) {
    var key = keys[i];
    if (!has(target, key)) defineProperty(target, key, getOwnPropertyDescriptor(source, key));
  }
};


/***/ }),

/***/ "../node_modules/core-js/internals/create-non-enumerable-property.js":
/*!***************************************************************************!*\
  !*** ../node_modules/core-js/internals/create-non-enumerable-property.js ***!
  \***************************************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

var DESCRIPTORS = __webpack_require__(/*! ../internals/descriptors */ "../node_modules/core-js/internals/descriptors.js");
var definePropertyModule = __webpack_require__(/*! ../internals/object-define-property */ "../node_modules/core-js/internals/object-define-property.js");
var createPropertyDescriptor = __webpack_require__(/*! ../internals/create-property-descriptor */ "../node_modules/core-js/internals/create-property-descriptor.js");

module.exports = DESCRIPTORS ? function (object, key, value) {
  return definePropertyModule.f(object, key, createPropertyDescriptor(1, value));
} : function (object, key, value) {
  object[key] = value;
  return object;
};


/***/ }),

/***/ "../node_modules/core-js/internals/create-property-descriptor.js":
/*!***********************************************************************!*\
  !*** ../node_modules/core-js/internals/create-property-descriptor.js ***!
  \***********************************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = function (bitmap, value) {
  return {
    enumerable: !(bitmap & 1),
    configurable: !(bitmap & 2),
    writable: !(bitmap & 4),
    value: value
  };
};


/***/ }),

/***/ "../node_modules/core-js/internals/create-property.js":
/*!************************************************************!*\
  !*** ../node_modules/core-js/internals/create-property.js ***!
  \************************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var toPrimitive = __webpack_require__(/*! ../internals/to-primitive */ "../node_modules/core-js/internals/to-primitive.js");
var definePropertyModule = __webpack_require__(/*! ../internals/object-define-property */ "../node_modules/core-js/internals/object-define-property.js");
var createPropertyDescriptor = __webpack_require__(/*! ../internals/create-property-descriptor */ "../node_modules/core-js/internals/create-property-descriptor.js");

module.exports = function (object, key, value) {
  var propertyKey = toPrimitive(key);
  if (propertyKey in object) definePropertyModule.f(object, propertyKey, createPropertyDescriptor(0, value));
  else object[propertyKey] = value;
};


/***/ }),

/***/ "../node_modules/core-js/internals/descriptors.js":
/*!********************************************************!*\
  !*** ../node_modules/core-js/internals/descriptors.js ***!
  \********************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

var fails = __webpack_require__(/*! ../internals/fails */ "../node_modules/core-js/internals/fails.js");

// Thank's IE8 for his funny defineProperty
module.exports = !fails(function () {
  return Object.defineProperty({}, 1, { get: function () { return 7; } })[1] != 7;
});


/***/ }),

/***/ "../node_modules/core-js/internals/document-create-element.js":
/*!********************************************************************!*\
  !*** ../node_modules/core-js/internals/document-create-element.js ***!
  \********************************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

var global = __webpack_require__(/*! ../internals/global */ "../node_modules/core-js/internals/global.js");
var isObject = __webpack_require__(/*! ../internals/is-object */ "../node_modules/core-js/internals/is-object.js");

var document = global.document;
// typeof document.createElement is 'object' in old IE
var EXISTS = isObject(document) && isObject(document.createElement);

module.exports = function (it) {
  return EXISTS ? document.createElement(it) : {};
};


/***/ }),

/***/ "../node_modules/core-js/internals/engine-user-agent.js":
/*!**************************************************************!*\
  !*** ../node_modules/core-js/internals/engine-user-agent.js ***!
  \**************************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

var getBuiltIn = __webpack_require__(/*! ../internals/get-built-in */ "../node_modules/core-js/internals/get-built-in.js");

module.exports = getBuiltIn('navigator', 'userAgent') || '';


/***/ }),

/***/ "../node_modules/core-js/internals/engine-v8-version.js":
/*!**************************************************************!*\
  !*** ../node_modules/core-js/internals/engine-v8-version.js ***!
  \**************************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

var global = __webpack_require__(/*! ../internals/global */ "../node_modules/core-js/internals/global.js");
var userAgent = __webpack_require__(/*! ../internals/engine-user-agent */ "../node_modules/core-js/internals/engine-user-agent.js");

var process = global.process;
var versions = process && process.versions;
var v8 = versions && versions.v8;
var match, version;

if (v8) {
  match = v8.split('.');
  version = match[0] + match[1];
} else if (userAgent) {
  match = userAgent.match(/Edge\/(\d+)/);
  if (!match || match[1] >= 74) {
    match = userAgent.match(/Chrome\/(\d+)/);
    if (match) version = match[1];
  }
}

module.exports = version && +version;


/***/ }),

/***/ "../node_modules/core-js/internals/enum-bug-keys.js":
/*!**********************************************************!*\
  !*** ../node_modules/core-js/internals/enum-bug-keys.js ***!
  \**********************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

// IE8- don't enum bug keys
module.exports = [
  'constructor',
  'hasOwnProperty',
  'isPrototypeOf',
  'propertyIsEnumerable',
  'toLocaleString',
  'toString',
  'valueOf'
];


/***/ }),

/***/ "../node_modules/core-js/internals/export.js":
/*!***************************************************!*\
  !*** ../node_modules/core-js/internals/export.js ***!
  \***************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

var global = __webpack_require__(/*! ../internals/global */ "../node_modules/core-js/internals/global.js");
var getOwnPropertyDescriptor = __webpack_require__(/*! ../internals/object-get-own-property-descriptor */ "../node_modules/core-js/internals/object-get-own-property-descriptor.js").f;
var createNonEnumerableProperty = __webpack_require__(/*! ../internals/create-non-enumerable-property */ "../node_modules/core-js/internals/create-non-enumerable-property.js");
var redefine = __webpack_require__(/*! ../internals/redefine */ "../node_modules/core-js/internals/redefine.js");
var setGlobal = __webpack_require__(/*! ../internals/set-global */ "../node_modules/core-js/internals/set-global.js");
var copyConstructorProperties = __webpack_require__(/*! ../internals/copy-constructor-properties */ "../node_modules/core-js/internals/copy-constructor-properties.js");
var isForced = __webpack_require__(/*! ../internals/is-forced */ "../node_modules/core-js/internals/is-forced.js");

/*
  options.target      - name of the target object
  options.global      - target is the global object
  options.stat        - export as static methods of target
  options.proto       - export as prototype methods of target
  options.real        - real prototype method for the `pure` version
  options.forced      - export even if the native feature is available
  options.bind        - bind methods to the target, required for the `pure` version
  options.wrap        - wrap constructors to preventing global pollution, required for the `pure` version
  options.unsafe      - use the simple assignment of property instead of delete + defineProperty
  options.sham        - add a flag to not completely full polyfills
  options.enumerable  - export as enumerable property
  options.noTargetGet - prevent calling a getter on target
*/
module.exports = function (options, source) {
  var TARGET = options.target;
  var GLOBAL = options.global;
  var STATIC = options.stat;
  var FORCED, target, key, targetProperty, sourceProperty, descriptor;
  if (GLOBAL) {
    target = global;
  } else if (STATIC) {
    target = global[TARGET] || setGlobal(TARGET, {});
  } else {
    target = (global[TARGET] || {}).prototype;
  }
  if (target) for (key in source) {
    sourceProperty = source[key];
    if (options.noTargetGet) {
      descriptor = getOwnPropertyDescriptor(target, key);
      targetProperty = descriptor && descriptor.value;
    } else targetProperty = target[key];
    FORCED = isForced(GLOBAL ? key : TARGET + (STATIC ? '.' : '#') + key, options.forced);
    // contained in target
    if (!FORCED && targetProperty !== undefined) {
      if (typeof sourceProperty === typeof targetProperty) continue;
      copyConstructorProperties(sourceProperty, targetProperty);
    }
    // add a flag to not completely full polyfills
    if (options.sham || (targetProperty && targetProperty.sham)) {
      createNonEnumerableProperty(sourceProperty, 'sham', true);
    }
    // extend global
    redefine(target, key, sourceProperty, options);
  }
};


/***/ }),

/***/ "../node_modules/core-js/internals/fails.js":
/*!**************************************************!*\
  !*** ../node_modules/core-js/internals/fails.js ***!
  \**************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = function (exec) {
  try {
    return !!exec();
  } catch (error) {
    return true;
  }
};


/***/ }),

/***/ "../node_modules/core-js/internals/function-bind-context.js":
/*!******************************************************************!*\
  !*** ../node_modules/core-js/internals/function-bind-context.js ***!
  \******************************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

var aFunction = __webpack_require__(/*! ../internals/a-function */ "../node_modules/core-js/internals/a-function.js");

// optional / simple context binding
module.exports = function (fn, that, length) {
  aFunction(fn);
  if (that === undefined) return fn;
  switch (length) {
    case 0: return function () {
      return fn.call(that);
    };
    case 1: return function (a) {
      return fn.call(that, a);
    };
    case 2: return function (a, b) {
      return fn.call(that, a, b);
    };
    case 3: return function (a, b, c) {
      return fn.call(that, a, b, c);
    };
  }
  return function (/* ...args */) {
    return fn.apply(that, arguments);
  };
};


/***/ }),

/***/ "../node_modules/core-js/internals/get-built-in.js":
/*!*********************************************************!*\
  !*** ../node_modules/core-js/internals/get-built-in.js ***!
  \*********************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

var path = __webpack_require__(/*! ../internals/path */ "../node_modules/core-js/internals/path.js");
var global = __webpack_require__(/*! ../internals/global */ "../node_modules/core-js/internals/global.js");

var aFunction = function (variable) {
  return typeof variable == 'function' ? variable : undefined;
};

module.exports = function (namespace, method) {
  return arguments.length < 2 ? aFunction(path[namespace]) || aFunction(global[namespace])
    : path[namespace] && path[namespace][method] || global[namespace] && global[namespace][method];
};


/***/ }),

/***/ "../node_modules/core-js/internals/global.js":
/*!***************************************************!*\
  !*** ../node_modules/core-js/internals/global.js ***!
  \***************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

/* WEBPACK VAR INJECTION */(function(global) {var check = function (it) {
  return it && it.Math == Math && it;
};

// https://github.com/zloirock/core-js/issues/86#issuecomment-115759028
module.exports =
  // eslint-disable-next-line no-undef
  check(typeof globalThis == 'object' && globalThis) ||
  check(typeof window == 'object' && window) ||
  check(typeof self == 'object' && self) ||
  check(typeof global == 'object' && global) ||
  // eslint-disable-next-line no-new-func
  Function('return this')();

/* WEBPACK VAR INJECTION */}.call(this, __webpack_require__(/*! ./../../webpack/buildin/global.js */ "../node_modules/webpack/buildin/global.js")))

/***/ }),

/***/ "../node_modules/core-js/internals/has.js":
/*!************************************************!*\
  !*** ../node_modules/core-js/internals/has.js ***!
  \************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

var hasOwnProperty = {}.hasOwnProperty;

module.exports = function (it, key) {
  return hasOwnProperty.call(it, key);
};


/***/ }),

/***/ "../node_modules/core-js/internals/hidden-keys.js":
/*!********************************************************!*\
  !*** ../node_modules/core-js/internals/hidden-keys.js ***!
  \********************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = {};


/***/ }),

/***/ "../node_modules/core-js/internals/ie8-dom-define.js":
/*!***********************************************************!*\
  !*** ../node_modules/core-js/internals/ie8-dom-define.js ***!
  \***********************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

var DESCRIPTORS = __webpack_require__(/*! ../internals/descriptors */ "../node_modules/core-js/internals/descriptors.js");
var fails = __webpack_require__(/*! ../internals/fails */ "../node_modules/core-js/internals/fails.js");
var createElement = __webpack_require__(/*! ../internals/document-create-element */ "../node_modules/core-js/internals/document-create-element.js");

// Thank's IE8 for his funny defineProperty
module.exports = !DESCRIPTORS && !fails(function () {
  return Object.defineProperty(createElement('div'), 'a', {
    get: function () { return 7; }
  }).a != 7;
});


/***/ }),

/***/ "../node_modules/core-js/internals/indexed-object.js":
/*!***********************************************************!*\
  !*** ../node_modules/core-js/internals/indexed-object.js ***!
  \***********************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

var fails = __webpack_require__(/*! ../internals/fails */ "../node_modules/core-js/internals/fails.js");
var classof = __webpack_require__(/*! ../internals/classof-raw */ "../node_modules/core-js/internals/classof-raw.js");

var split = ''.split;

// fallback for non-array-like ES3 and non-enumerable old V8 strings
module.exports = fails(function () {
  // throws an error in rhino, see https://github.com/mozilla/rhino/issues/346
  // eslint-disable-next-line no-prototype-builtins
  return !Object('z').propertyIsEnumerable(0);
}) ? function (it) {
  return classof(it) == 'String' ? split.call(it, '') : Object(it);
} : Object;


/***/ }),

/***/ "../node_modules/core-js/internals/inspect-source.js":
/*!***********************************************************!*\
  !*** ../node_modules/core-js/internals/inspect-source.js ***!
  \***********************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

var store = __webpack_require__(/*! ../internals/shared-store */ "../node_modules/core-js/internals/shared-store.js");

var functionToString = Function.toString;

// this helper broken in `3.4.1-3.4.4`, so we can't use `shared` helper
if (typeof store.inspectSource != 'function') {
  store.inspectSource = function (it) {
    return functionToString.call(it);
  };
}

module.exports = store.inspectSource;


/***/ }),

/***/ "../node_modules/core-js/internals/internal-state.js":
/*!***********************************************************!*\
  !*** ../node_modules/core-js/internals/internal-state.js ***!
  \***********************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

var NATIVE_WEAK_MAP = __webpack_require__(/*! ../internals/native-weak-map */ "../node_modules/core-js/internals/native-weak-map.js");
var global = __webpack_require__(/*! ../internals/global */ "../node_modules/core-js/internals/global.js");
var isObject = __webpack_require__(/*! ../internals/is-object */ "../node_modules/core-js/internals/is-object.js");
var createNonEnumerableProperty = __webpack_require__(/*! ../internals/create-non-enumerable-property */ "../node_modules/core-js/internals/create-non-enumerable-property.js");
var objectHas = __webpack_require__(/*! ../internals/has */ "../node_modules/core-js/internals/has.js");
var sharedKey = __webpack_require__(/*! ../internals/shared-key */ "../node_modules/core-js/internals/shared-key.js");
var hiddenKeys = __webpack_require__(/*! ../internals/hidden-keys */ "../node_modules/core-js/internals/hidden-keys.js");

var WeakMap = global.WeakMap;
var set, get, has;

var enforce = function (it) {
  return has(it) ? get(it) : set(it, {});
};

var getterFor = function (TYPE) {
  return function (it) {
    var state;
    if (!isObject(it) || (state = get(it)).type !== TYPE) {
      throw TypeError('Incompatible receiver, ' + TYPE + ' required');
    } return state;
  };
};

if (NATIVE_WEAK_MAP) {
  var store = new WeakMap();
  var wmget = store.get;
  var wmhas = store.has;
  var wmset = store.set;
  set = function (it, metadata) {
    wmset.call(store, it, metadata);
    return metadata;
  };
  get = function (it) {
    return wmget.call(store, it) || {};
  };
  has = function (it) {
    return wmhas.call(store, it);
  };
} else {
  var STATE = sharedKey('state');
  hiddenKeys[STATE] = true;
  set = function (it, metadata) {
    createNonEnumerableProperty(it, STATE, metadata);
    return metadata;
  };
  get = function (it) {
    return objectHas(it, STATE) ? it[STATE] : {};
  };
  has = function (it) {
    return objectHas(it, STATE);
  };
}

module.exports = {
  set: set,
  get: get,
  has: has,
  enforce: enforce,
  getterFor: getterFor
};


/***/ }),

/***/ "../node_modules/core-js/internals/is-array.js":
/*!*****************************************************!*\
  !*** ../node_modules/core-js/internals/is-array.js ***!
  \*****************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

var classof = __webpack_require__(/*! ../internals/classof-raw */ "../node_modules/core-js/internals/classof-raw.js");

// `IsArray` abstract operation
// https://tc39.github.io/ecma262/#sec-isarray
module.exports = Array.isArray || function isArray(arg) {
  return classof(arg) == 'Array';
};


/***/ }),

/***/ "../node_modules/core-js/internals/is-forced.js":
/*!******************************************************!*\
  !*** ../node_modules/core-js/internals/is-forced.js ***!
  \******************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

var fails = __webpack_require__(/*! ../internals/fails */ "../node_modules/core-js/internals/fails.js");

var replacement = /#|\.prototype\./;

var isForced = function (feature, detection) {
  var value = data[normalize(feature)];
  return value == POLYFILL ? true
    : value == NATIVE ? false
    : typeof detection == 'function' ? fails(detection)
    : !!detection;
};

var normalize = isForced.normalize = function (string) {
  return String(string).replace(replacement, '.').toLowerCase();
};

var data = isForced.data = {};
var NATIVE = isForced.NATIVE = 'N';
var POLYFILL = isForced.POLYFILL = 'P';

module.exports = isForced;


/***/ }),

/***/ "../node_modules/core-js/internals/is-object.js":
/*!******************************************************!*\
  !*** ../node_modules/core-js/internals/is-object.js ***!
  \******************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = function (it) {
  return typeof it === 'object' ? it !== null : typeof it === 'function';
};


/***/ }),

/***/ "../node_modules/core-js/internals/is-pure.js":
/*!****************************************************!*\
  !*** ../node_modules/core-js/internals/is-pure.js ***!
  \****************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = false;


/***/ }),

/***/ "../node_modules/core-js/internals/native-symbol.js":
/*!**********************************************************!*\
  !*** ../node_modules/core-js/internals/native-symbol.js ***!
  \**********************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

var fails = __webpack_require__(/*! ../internals/fails */ "../node_modules/core-js/internals/fails.js");

module.exports = !!Object.getOwnPropertySymbols && !fails(function () {
  // Chrome 38 Symbol has incorrect toString conversion
  // eslint-disable-next-line no-undef
  return !String(Symbol());
});


/***/ }),

/***/ "../node_modules/core-js/internals/native-weak-map.js":
/*!************************************************************!*\
  !*** ../node_modules/core-js/internals/native-weak-map.js ***!
  \************************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

var global = __webpack_require__(/*! ../internals/global */ "../node_modules/core-js/internals/global.js");
var inspectSource = __webpack_require__(/*! ../internals/inspect-source */ "../node_modules/core-js/internals/inspect-source.js");

var WeakMap = global.WeakMap;

module.exports = typeof WeakMap === 'function' && /native code/.test(inspectSource(WeakMap));


/***/ }),

/***/ "../node_modules/core-js/internals/object-define-property.js":
/*!*******************************************************************!*\
  !*** ../node_modules/core-js/internals/object-define-property.js ***!
  \*******************************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

var DESCRIPTORS = __webpack_require__(/*! ../internals/descriptors */ "../node_modules/core-js/internals/descriptors.js");
var IE8_DOM_DEFINE = __webpack_require__(/*! ../internals/ie8-dom-define */ "../node_modules/core-js/internals/ie8-dom-define.js");
var anObject = __webpack_require__(/*! ../internals/an-object */ "../node_modules/core-js/internals/an-object.js");
var toPrimitive = __webpack_require__(/*! ../internals/to-primitive */ "../node_modules/core-js/internals/to-primitive.js");

var nativeDefineProperty = Object.defineProperty;

// `Object.defineProperty` method
// https://tc39.github.io/ecma262/#sec-object.defineproperty
exports.f = DESCRIPTORS ? nativeDefineProperty : function defineProperty(O, P, Attributes) {
  anObject(O);
  P = toPrimitive(P, true);
  anObject(Attributes);
  if (IE8_DOM_DEFINE) try {
    return nativeDefineProperty(O, P, Attributes);
  } catch (error) { /* empty */ }
  if ('get' in Attributes || 'set' in Attributes) throw TypeError('Accessors not supported');
  if ('value' in Attributes) O[P] = Attributes.value;
  return O;
};


/***/ }),

/***/ "../node_modules/core-js/internals/object-get-own-property-descriptor.js":
/*!*******************************************************************************!*\
  !*** ../node_modules/core-js/internals/object-get-own-property-descriptor.js ***!
  \*******************************************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

var DESCRIPTORS = __webpack_require__(/*! ../internals/descriptors */ "../node_modules/core-js/internals/descriptors.js");
var propertyIsEnumerableModule = __webpack_require__(/*! ../internals/object-property-is-enumerable */ "../node_modules/core-js/internals/object-property-is-enumerable.js");
var createPropertyDescriptor = __webpack_require__(/*! ../internals/create-property-descriptor */ "../node_modules/core-js/internals/create-property-descriptor.js");
var toIndexedObject = __webpack_require__(/*! ../internals/to-indexed-object */ "../node_modules/core-js/internals/to-indexed-object.js");
var toPrimitive = __webpack_require__(/*! ../internals/to-primitive */ "../node_modules/core-js/internals/to-primitive.js");
var has = __webpack_require__(/*! ../internals/has */ "../node_modules/core-js/internals/has.js");
var IE8_DOM_DEFINE = __webpack_require__(/*! ../internals/ie8-dom-define */ "../node_modules/core-js/internals/ie8-dom-define.js");

var nativeGetOwnPropertyDescriptor = Object.getOwnPropertyDescriptor;

// `Object.getOwnPropertyDescriptor` method
// https://tc39.github.io/ecma262/#sec-object.getownpropertydescriptor
exports.f = DESCRIPTORS ? nativeGetOwnPropertyDescriptor : function getOwnPropertyDescriptor(O, P) {
  O = toIndexedObject(O);
  P = toPrimitive(P, true);
  if (IE8_DOM_DEFINE) try {
    return nativeGetOwnPropertyDescriptor(O, P);
  } catch (error) { /* empty */ }
  if (has(O, P)) return createPropertyDescriptor(!propertyIsEnumerableModule.f.call(O, P), O[P]);
};


/***/ }),

/***/ "../node_modules/core-js/internals/object-get-own-property-names.js":
/*!**************************************************************************!*\
  !*** ../node_modules/core-js/internals/object-get-own-property-names.js ***!
  \**************************************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

var internalObjectKeys = __webpack_require__(/*! ../internals/object-keys-internal */ "../node_modules/core-js/internals/object-keys-internal.js");
var enumBugKeys = __webpack_require__(/*! ../internals/enum-bug-keys */ "../node_modules/core-js/internals/enum-bug-keys.js");

var hiddenKeys = enumBugKeys.concat('length', 'prototype');

// `Object.getOwnPropertyNames` method
// https://tc39.github.io/ecma262/#sec-object.getownpropertynames
exports.f = Object.getOwnPropertyNames || function getOwnPropertyNames(O) {
  return internalObjectKeys(O, hiddenKeys);
};


/***/ }),

/***/ "../node_modules/core-js/internals/object-get-own-property-symbols.js":
/*!****************************************************************************!*\
  !*** ../node_modules/core-js/internals/object-get-own-property-symbols.js ***!
  \****************************************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

exports.f = Object.getOwnPropertySymbols;


/***/ }),

/***/ "../node_modules/core-js/internals/object-keys-internal.js":
/*!*****************************************************************!*\
  !*** ../node_modules/core-js/internals/object-keys-internal.js ***!
  \*****************************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

var has = __webpack_require__(/*! ../internals/has */ "../node_modules/core-js/internals/has.js");
var toIndexedObject = __webpack_require__(/*! ../internals/to-indexed-object */ "../node_modules/core-js/internals/to-indexed-object.js");
var indexOf = __webpack_require__(/*! ../internals/array-includes */ "../node_modules/core-js/internals/array-includes.js").indexOf;
var hiddenKeys = __webpack_require__(/*! ../internals/hidden-keys */ "../node_modules/core-js/internals/hidden-keys.js");

module.exports = function (object, names) {
  var O = toIndexedObject(object);
  var i = 0;
  var result = [];
  var key;
  for (key in O) !has(hiddenKeys, key) && has(O, key) && result.push(key);
  // Don't enum bug & hidden keys
  while (names.length > i) if (has(O, key = names[i++])) {
    ~indexOf(result, key) || result.push(key);
  }
  return result;
};


/***/ }),

/***/ "../node_modules/core-js/internals/object-property-is-enumerable.js":
/*!**************************************************************************!*\
  !*** ../node_modules/core-js/internals/object-property-is-enumerable.js ***!
  \**************************************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var nativePropertyIsEnumerable = {}.propertyIsEnumerable;
var getOwnPropertyDescriptor = Object.getOwnPropertyDescriptor;

// Nashorn ~ JDK8 bug
var NASHORN_BUG = getOwnPropertyDescriptor && !nativePropertyIsEnumerable.call({ 1: 2 }, 1);

// `Object.prototype.propertyIsEnumerable` method implementation
// https://tc39.github.io/ecma262/#sec-object.prototype.propertyisenumerable
exports.f = NASHORN_BUG ? function propertyIsEnumerable(V) {
  var descriptor = getOwnPropertyDescriptor(this, V);
  return !!descriptor && descriptor.enumerable;
} : nativePropertyIsEnumerable;


/***/ }),

/***/ "../node_modules/core-js/internals/own-keys.js":
/*!*****************************************************!*\
  !*** ../node_modules/core-js/internals/own-keys.js ***!
  \*****************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

var getBuiltIn = __webpack_require__(/*! ../internals/get-built-in */ "../node_modules/core-js/internals/get-built-in.js");
var getOwnPropertyNamesModule = __webpack_require__(/*! ../internals/object-get-own-property-names */ "../node_modules/core-js/internals/object-get-own-property-names.js");
var getOwnPropertySymbolsModule = __webpack_require__(/*! ../internals/object-get-own-property-symbols */ "../node_modules/core-js/internals/object-get-own-property-symbols.js");
var anObject = __webpack_require__(/*! ../internals/an-object */ "../node_modules/core-js/internals/an-object.js");

// all object keys, includes non-enumerable and symbols
module.exports = getBuiltIn('Reflect', 'ownKeys') || function ownKeys(it) {
  var keys = getOwnPropertyNamesModule.f(anObject(it));
  var getOwnPropertySymbols = getOwnPropertySymbolsModule.f;
  return getOwnPropertySymbols ? keys.concat(getOwnPropertySymbols(it)) : keys;
};


/***/ }),

/***/ "../node_modules/core-js/internals/path.js":
/*!*************************************************!*\
  !*** ../node_modules/core-js/internals/path.js ***!
  \*************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

var global = __webpack_require__(/*! ../internals/global */ "../node_modules/core-js/internals/global.js");

module.exports = global;


/***/ }),

/***/ "../node_modules/core-js/internals/redefine.js":
/*!*****************************************************!*\
  !*** ../node_modules/core-js/internals/redefine.js ***!
  \*****************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

var global = __webpack_require__(/*! ../internals/global */ "../node_modules/core-js/internals/global.js");
var createNonEnumerableProperty = __webpack_require__(/*! ../internals/create-non-enumerable-property */ "../node_modules/core-js/internals/create-non-enumerable-property.js");
var has = __webpack_require__(/*! ../internals/has */ "../node_modules/core-js/internals/has.js");
var setGlobal = __webpack_require__(/*! ../internals/set-global */ "../node_modules/core-js/internals/set-global.js");
var inspectSource = __webpack_require__(/*! ../internals/inspect-source */ "../node_modules/core-js/internals/inspect-source.js");
var InternalStateModule = __webpack_require__(/*! ../internals/internal-state */ "../node_modules/core-js/internals/internal-state.js");

var getInternalState = InternalStateModule.get;
var enforceInternalState = InternalStateModule.enforce;
var TEMPLATE = String(String).split('String');

(module.exports = function (O, key, value, options) {
  var unsafe = options ? !!options.unsafe : false;
  var simple = options ? !!options.enumerable : false;
  var noTargetGet = options ? !!options.noTargetGet : false;
  if (typeof value == 'function') {
    if (typeof key == 'string' && !has(value, 'name')) createNonEnumerableProperty(value, 'name', key);
    enforceInternalState(value).source = TEMPLATE.join(typeof key == 'string' ? key : '');
  }
  if (O === global) {
    if (simple) O[key] = value;
    else setGlobal(key, value);
    return;
  } else if (!unsafe) {
    delete O[key];
  } else if (!noTargetGet && O[key]) {
    simple = true;
  }
  if (simple) O[key] = value;
  else createNonEnumerableProperty(O, key, value);
// add fake Function#toString for correct work wrapped methods / constructors with methods like LoDash isNative
})(Function.prototype, 'toString', function toString() {
  return typeof this == 'function' && getInternalState(this).source || inspectSource(this);
});


/***/ }),

/***/ "../node_modules/core-js/internals/require-object-coercible.js":
/*!*********************************************************************!*\
  !*** ../node_modules/core-js/internals/require-object-coercible.js ***!
  \*********************************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

// `RequireObjectCoercible` abstract operation
// https://tc39.github.io/ecma262/#sec-requireobjectcoercible
module.exports = function (it) {
  if (it == undefined) throw TypeError("Can't call method on " + it);
  return it;
};


/***/ }),

/***/ "../node_modules/core-js/internals/set-global.js":
/*!*******************************************************!*\
  !*** ../node_modules/core-js/internals/set-global.js ***!
  \*******************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

var global = __webpack_require__(/*! ../internals/global */ "../node_modules/core-js/internals/global.js");
var createNonEnumerableProperty = __webpack_require__(/*! ../internals/create-non-enumerable-property */ "../node_modules/core-js/internals/create-non-enumerable-property.js");

module.exports = function (key, value) {
  try {
    createNonEnumerableProperty(global, key, value);
  } catch (error) {
    global[key] = value;
  } return value;
};


/***/ }),

/***/ "../node_modules/core-js/internals/shared-key.js":
/*!*******************************************************!*\
  !*** ../node_modules/core-js/internals/shared-key.js ***!
  \*******************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

var shared = __webpack_require__(/*! ../internals/shared */ "../node_modules/core-js/internals/shared.js");
var uid = __webpack_require__(/*! ../internals/uid */ "../node_modules/core-js/internals/uid.js");

var keys = shared('keys');

module.exports = function (key) {
  return keys[key] || (keys[key] = uid(key));
};


/***/ }),

/***/ "../node_modules/core-js/internals/shared-store.js":
/*!*********************************************************!*\
  !*** ../node_modules/core-js/internals/shared-store.js ***!
  \*********************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

var global = __webpack_require__(/*! ../internals/global */ "../node_modules/core-js/internals/global.js");
var setGlobal = __webpack_require__(/*! ../internals/set-global */ "../node_modules/core-js/internals/set-global.js");

var SHARED = '__core-js_shared__';
var store = global[SHARED] || setGlobal(SHARED, {});

module.exports = store;


/***/ }),

/***/ "../node_modules/core-js/internals/shared.js":
/*!***************************************************!*\
  !*** ../node_modules/core-js/internals/shared.js ***!
  \***************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

var IS_PURE = __webpack_require__(/*! ../internals/is-pure */ "../node_modules/core-js/internals/is-pure.js");
var store = __webpack_require__(/*! ../internals/shared-store */ "../node_modules/core-js/internals/shared-store.js");

(module.exports = function (key, value) {
  return store[key] || (store[key] = value !== undefined ? value : {});
})('versions', []).push({
  version: '3.6.5',
  mode: IS_PURE ? 'pure' : 'global',
  copyright: '© 2020 Denis Pushkarev (zloirock.ru)'
});


/***/ }),

/***/ "../node_modules/core-js/internals/to-absolute-index.js":
/*!**************************************************************!*\
  !*** ../node_modules/core-js/internals/to-absolute-index.js ***!
  \**************************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

var toInteger = __webpack_require__(/*! ../internals/to-integer */ "../node_modules/core-js/internals/to-integer.js");

var max = Math.max;
var min = Math.min;

// Helper for a popular repeating case of the spec:
// Let integer be ? ToInteger(index).
// If integer < 0, let result be max((length + integer), 0); else let result be min(integer, length).
module.exports = function (index, length) {
  var integer = toInteger(index);
  return integer < 0 ? max(integer + length, 0) : min(integer, length);
};


/***/ }),

/***/ "../node_modules/core-js/internals/to-indexed-object.js":
/*!**************************************************************!*\
  !*** ../node_modules/core-js/internals/to-indexed-object.js ***!
  \**************************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

// toObject with fallback for non-array-like ES3 strings
var IndexedObject = __webpack_require__(/*! ../internals/indexed-object */ "../node_modules/core-js/internals/indexed-object.js");
var requireObjectCoercible = __webpack_require__(/*! ../internals/require-object-coercible */ "../node_modules/core-js/internals/require-object-coercible.js");

module.exports = function (it) {
  return IndexedObject(requireObjectCoercible(it));
};


/***/ }),

/***/ "../node_modules/core-js/internals/to-integer.js":
/*!*******************************************************!*\
  !*** ../node_modules/core-js/internals/to-integer.js ***!
  \*******************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

var ceil = Math.ceil;
var floor = Math.floor;

// `ToInteger` abstract operation
// https://tc39.github.io/ecma262/#sec-tointeger
module.exports = function (argument) {
  return isNaN(argument = +argument) ? 0 : (argument > 0 ? floor : ceil)(argument);
};


/***/ }),

/***/ "../node_modules/core-js/internals/to-length.js":
/*!******************************************************!*\
  !*** ../node_modules/core-js/internals/to-length.js ***!
  \******************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

var toInteger = __webpack_require__(/*! ../internals/to-integer */ "../node_modules/core-js/internals/to-integer.js");

var min = Math.min;

// `ToLength` abstract operation
// https://tc39.github.io/ecma262/#sec-tolength
module.exports = function (argument) {
  return argument > 0 ? min(toInteger(argument), 0x1FFFFFFFFFFFFF) : 0; // 2 ** 53 - 1 == 9007199254740991
};


/***/ }),

/***/ "../node_modules/core-js/internals/to-object.js":
/*!******************************************************!*\
  !*** ../node_modules/core-js/internals/to-object.js ***!
  \******************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

var requireObjectCoercible = __webpack_require__(/*! ../internals/require-object-coercible */ "../node_modules/core-js/internals/require-object-coercible.js");

// `ToObject` abstract operation
// https://tc39.github.io/ecma262/#sec-toobject
module.exports = function (argument) {
  return Object(requireObjectCoercible(argument));
};


/***/ }),

/***/ "../node_modules/core-js/internals/to-primitive.js":
/*!*********************************************************!*\
  !*** ../node_modules/core-js/internals/to-primitive.js ***!
  \*********************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

var isObject = __webpack_require__(/*! ../internals/is-object */ "../node_modules/core-js/internals/is-object.js");

// `ToPrimitive` abstract operation
// https://tc39.github.io/ecma262/#sec-toprimitive
// instead of the ES6 spec version, we didn't implement @@toPrimitive case
// and the second argument - flag - preferred type is a string
module.exports = function (input, PREFERRED_STRING) {
  if (!isObject(input)) return input;
  var fn, val;
  if (PREFERRED_STRING && typeof (fn = input.toString) == 'function' && !isObject(val = fn.call(input))) return val;
  if (typeof (fn = input.valueOf) == 'function' && !isObject(val = fn.call(input))) return val;
  if (!PREFERRED_STRING && typeof (fn = input.toString) == 'function' && !isObject(val = fn.call(input))) return val;
  throw TypeError("Can't convert object to primitive value");
};


/***/ }),

/***/ "../node_modules/core-js/internals/uid.js":
/*!************************************************!*\
  !*** ../node_modules/core-js/internals/uid.js ***!
  \************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

var id = 0;
var postfix = Math.random();

module.exports = function (key) {
  return 'Symbol(' + String(key === undefined ? '' : key) + ')_' + (++id + postfix).toString(36);
};


/***/ }),

/***/ "../node_modules/core-js/internals/use-symbol-as-uid.js":
/*!**************************************************************!*\
  !*** ../node_modules/core-js/internals/use-symbol-as-uid.js ***!
  \**************************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

var NATIVE_SYMBOL = __webpack_require__(/*! ../internals/native-symbol */ "../node_modules/core-js/internals/native-symbol.js");

module.exports = NATIVE_SYMBOL
  // eslint-disable-next-line no-undef
  && !Symbol.sham
  // eslint-disable-next-line no-undef
  && typeof Symbol.iterator == 'symbol';


/***/ }),

/***/ "../node_modules/core-js/internals/well-known-symbol.js":
/*!**************************************************************!*\
  !*** ../node_modules/core-js/internals/well-known-symbol.js ***!
  \**************************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

var global = __webpack_require__(/*! ../internals/global */ "../node_modules/core-js/internals/global.js");
var shared = __webpack_require__(/*! ../internals/shared */ "../node_modules/core-js/internals/shared.js");
var has = __webpack_require__(/*! ../internals/has */ "../node_modules/core-js/internals/has.js");
var uid = __webpack_require__(/*! ../internals/uid */ "../node_modules/core-js/internals/uid.js");
var NATIVE_SYMBOL = __webpack_require__(/*! ../internals/native-symbol */ "../node_modules/core-js/internals/native-symbol.js");
var USE_SYMBOL_AS_UID = __webpack_require__(/*! ../internals/use-symbol-as-uid */ "../node_modules/core-js/internals/use-symbol-as-uid.js");

var WellKnownSymbolsStore = shared('wks');
var Symbol = global.Symbol;
var createWellKnownSymbol = USE_SYMBOL_AS_UID ? Symbol : Symbol && Symbol.withoutSetter || uid;

module.exports = function (name) {
  if (!has(WellKnownSymbolsStore, name)) {
    if (NATIVE_SYMBOL && has(Symbol, name)) WellKnownSymbolsStore[name] = Symbol[name];
    else WellKnownSymbolsStore[name] = createWellKnownSymbol('Symbol.' + name);
  } return WellKnownSymbolsStore[name];
};


/***/ }),

/***/ "../node_modules/core-js/modules/es.array.concat.js":
/*!**********************************************************!*\
  !*** ../node_modules/core-js/modules/es.array.concat.js ***!
  \**********************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var $ = __webpack_require__(/*! ../internals/export */ "../node_modules/core-js/internals/export.js");
var fails = __webpack_require__(/*! ../internals/fails */ "../node_modules/core-js/internals/fails.js");
var isArray = __webpack_require__(/*! ../internals/is-array */ "../node_modules/core-js/internals/is-array.js");
var isObject = __webpack_require__(/*! ../internals/is-object */ "../node_modules/core-js/internals/is-object.js");
var toObject = __webpack_require__(/*! ../internals/to-object */ "../node_modules/core-js/internals/to-object.js");
var toLength = __webpack_require__(/*! ../internals/to-length */ "../node_modules/core-js/internals/to-length.js");
var createProperty = __webpack_require__(/*! ../internals/create-property */ "../node_modules/core-js/internals/create-property.js");
var arraySpeciesCreate = __webpack_require__(/*! ../internals/array-species-create */ "../node_modules/core-js/internals/array-species-create.js");
var arrayMethodHasSpeciesSupport = __webpack_require__(/*! ../internals/array-method-has-species-support */ "../node_modules/core-js/internals/array-method-has-species-support.js");
var wellKnownSymbol = __webpack_require__(/*! ../internals/well-known-symbol */ "../node_modules/core-js/internals/well-known-symbol.js");
var V8_VERSION = __webpack_require__(/*! ../internals/engine-v8-version */ "../node_modules/core-js/internals/engine-v8-version.js");

var IS_CONCAT_SPREADABLE = wellKnownSymbol('isConcatSpreadable');
var MAX_SAFE_INTEGER = 0x1FFFFFFFFFFFFF;
var MAXIMUM_ALLOWED_INDEX_EXCEEDED = 'Maximum allowed index exceeded';

// We can't use this feature detection in V8 since it causes
// deoptimization and serious performance degradation
// https://github.com/zloirock/core-js/issues/679
var IS_CONCAT_SPREADABLE_SUPPORT = V8_VERSION >= 51 || !fails(function () {
  var array = [];
  array[IS_CONCAT_SPREADABLE] = false;
  return array.concat()[0] !== array;
});

var SPECIES_SUPPORT = arrayMethodHasSpeciesSupport('concat');

var isConcatSpreadable = function (O) {
  if (!isObject(O)) return false;
  var spreadable = O[IS_CONCAT_SPREADABLE];
  return spreadable !== undefined ? !!spreadable : isArray(O);
};

var FORCED = !IS_CONCAT_SPREADABLE_SUPPORT || !SPECIES_SUPPORT;

// `Array.prototype.concat` method
// https://tc39.github.io/ecma262/#sec-array.prototype.concat
// with adding support of @@isConcatSpreadable and @@species
$({ target: 'Array', proto: true, forced: FORCED }, {
  concat: function concat(arg) { // eslint-disable-line no-unused-vars
    var O = toObject(this);
    var A = arraySpeciesCreate(O, 0);
    var n = 0;
    var i, k, length, len, E;
    for (i = -1, length = arguments.length; i < length; i++) {
      E = i === -1 ? O : arguments[i];
      if (isConcatSpreadable(E)) {
        len = toLength(E.length);
        if (n + len > MAX_SAFE_INTEGER) throw TypeError(MAXIMUM_ALLOWED_INDEX_EXCEEDED);
        for (k = 0; k < len; k++, n++) if (k in E) createProperty(A, n, E[k]);
      } else {
        if (n >= MAX_SAFE_INTEGER) throw TypeError(MAXIMUM_ALLOWED_INDEX_EXCEEDED);
        createProperty(A, n++, E);
      }
    }
    A.length = n;
    return A;
  }
});


/***/ }),

/***/ "../node_modules/core-js/modules/es.array.filter.js":
/*!**********************************************************!*\
  !*** ../node_modules/core-js/modules/es.array.filter.js ***!
  \**********************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var $ = __webpack_require__(/*! ../internals/export */ "../node_modules/core-js/internals/export.js");
var $filter = __webpack_require__(/*! ../internals/array-iteration */ "../node_modules/core-js/internals/array-iteration.js").filter;
var arrayMethodHasSpeciesSupport = __webpack_require__(/*! ../internals/array-method-has-species-support */ "../node_modules/core-js/internals/array-method-has-species-support.js");
var arrayMethodUsesToLength = __webpack_require__(/*! ../internals/array-method-uses-to-length */ "../node_modules/core-js/internals/array-method-uses-to-length.js");

var HAS_SPECIES_SUPPORT = arrayMethodHasSpeciesSupport('filter');
// Edge 14- issue
var USES_TO_LENGTH = arrayMethodUsesToLength('filter');

// `Array.prototype.filter` method
// https://tc39.github.io/ecma262/#sec-array.prototype.filter
// with adding support of @@species
$({ target: 'Array', proto: true, forced: !HAS_SPECIES_SUPPORT || !USES_TO_LENGTH }, {
  filter: function filter(callbackfn /* , thisArg */) {
    return $filter(this, callbackfn, arguments.length > 1 ? arguments[1] : undefined);
  }
});


/***/ }),

/***/ "../node_modules/core-js/modules/es.array.map.js":
/*!*******************************************************!*\
  !*** ../node_modules/core-js/modules/es.array.map.js ***!
  \*******************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var $ = __webpack_require__(/*! ../internals/export */ "../node_modules/core-js/internals/export.js");
var $map = __webpack_require__(/*! ../internals/array-iteration */ "../node_modules/core-js/internals/array-iteration.js").map;
var arrayMethodHasSpeciesSupport = __webpack_require__(/*! ../internals/array-method-has-species-support */ "../node_modules/core-js/internals/array-method-has-species-support.js");
var arrayMethodUsesToLength = __webpack_require__(/*! ../internals/array-method-uses-to-length */ "../node_modules/core-js/internals/array-method-uses-to-length.js");

var HAS_SPECIES_SUPPORT = arrayMethodHasSpeciesSupport('map');
// FF49- issue
var USES_TO_LENGTH = arrayMethodUsesToLength('map');

// `Array.prototype.map` method
// https://tc39.github.io/ecma262/#sec-array.prototype.map
// with adding support of @@species
$({ target: 'Array', proto: true, forced: !HAS_SPECIES_SUPPORT || !USES_TO_LENGTH }, {
  map: function map(callbackfn /* , thisArg */) {
    return $map(this, callbackfn, arguments.length > 1 ? arguments[1] : undefined);
  }
});


/***/ }),

/***/ "../node_modules/core-js/modules/es.array.reverse.js":
/*!***********************************************************!*\
  !*** ../node_modules/core-js/modules/es.array.reverse.js ***!
  \***********************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var $ = __webpack_require__(/*! ../internals/export */ "../node_modules/core-js/internals/export.js");
var isArray = __webpack_require__(/*! ../internals/is-array */ "../node_modules/core-js/internals/is-array.js");

var nativeReverse = [].reverse;
var test = [1, 2];

// `Array.prototype.reverse` method
// https://tc39.github.io/ecma262/#sec-array.prototype.reverse
// fix for Safari 12.0 bug
// https://bugs.webkit.org/show_bug.cgi?id=188794
$({ target: 'Array', proto: true, forced: String(test) === String(test.reverse()) }, {
  reverse: function reverse() {
    // eslint-disable-next-line no-self-assign
    if (isArray(this)) this.length = this.length;
    return nativeReverse.call(this);
  }
});


/***/ }),

/***/ "../node_modules/core-js/modules/es.array.slice.js":
/*!*********************************************************!*\
  !*** ../node_modules/core-js/modules/es.array.slice.js ***!
  \*********************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var $ = __webpack_require__(/*! ../internals/export */ "../node_modules/core-js/internals/export.js");
var isObject = __webpack_require__(/*! ../internals/is-object */ "../node_modules/core-js/internals/is-object.js");
var isArray = __webpack_require__(/*! ../internals/is-array */ "../node_modules/core-js/internals/is-array.js");
var toAbsoluteIndex = __webpack_require__(/*! ../internals/to-absolute-index */ "../node_modules/core-js/internals/to-absolute-index.js");
var toLength = __webpack_require__(/*! ../internals/to-length */ "../node_modules/core-js/internals/to-length.js");
var toIndexedObject = __webpack_require__(/*! ../internals/to-indexed-object */ "../node_modules/core-js/internals/to-indexed-object.js");
var createProperty = __webpack_require__(/*! ../internals/create-property */ "../node_modules/core-js/internals/create-property.js");
var wellKnownSymbol = __webpack_require__(/*! ../internals/well-known-symbol */ "../node_modules/core-js/internals/well-known-symbol.js");
var arrayMethodHasSpeciesSupport = __webpack_require__(/*! ../internals/array-method-has-species-support */ "../node_modules/core-js/internals/array-method-has-species-support.js");
var arrayMethodUsesToLength = __webpack_require__(/*! ../internals/array-method-uses-to-length */ "../node_modules/core-js/internals/array-method-uses-to-length.js");

var HAS_SPECIES_SUPPORT = arrayMethodHasSpeciesSupport('slice');
var USES_TO_LENGTH = arrayMethodUsesToLength('slice', { ACCESSORS: true, 0: 0, 1: 2 });

var SPECIES = wellKnownSymbol('species');
var nativeSlice = [].slice;
var max = Math.max;

// `Array.prototype.slice` method
// https://tc39.github.io/ecma262/#sec-array.prototype.slice
// fallback for not array-like ES3 strings and DOM objects
$({ target: 'Array', proto: true, forced: !HAS_SPECIES_SUPPORT || !USES_TO_LENGTH }, {
  slice: function slice(start, end) {
    var O = toIndexedObject(this);
    var length = toLength(O.length);
    var k = toAbsoluteIndex(start, length);
    var fin = toAbsoluteIndex(end === undefined ? length : end, length);
    // inline `ArraySpeciesCreate` for usage native `Array#slice` where it's possible
    var Constructor, result, n;
    if (isArray(O)) {
      Constructor = O.constructor;
      // cross-realm fallback
      if (typeof Constructor == 'function' && (Constructor === Array || isArray(Constructor.prototype))) {
        Constructor = undefined;
      } else if (isObject(Constructor)) {
        Constructor = Constructor[SPECIES];
        if (Constructor === null) Constructor = undefined;
      }
      if (Constructor === Array || Constructor === undefined) {
        return nativeSlice.call(O, k, fin);
      }
    }
    result = new (Constructor === undefined ? Array : Constructor)(max(fin - k, 0));
    for (n = 0; k < fin; k++, n++) if (k in O) createProperty(result, n, O[k]);
    result.length = n;
    return result;
  }
});


/***/ }),

/***/ "../node_modules/core-js/modules/es.array.sort.js":
/*!********************************************************!*\
  !*** ../node_modules/core-js/modules/es.array.sort.js ***!
  \********************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var $ = __webpack_require__(/*! ../internals/export */ "../node_modules/core-js/internals/export.js");
var aFunction = __webpack_require__(/*! ../internals/a-function */ "../node_modules/core-js/internals/a-function.js");
var toObject = __webpack_require__(/*! ../internals/to-object */ "../node_modules/core-js/internals/to-object.js");
var fails = __webpack_require__(/*! ../internals/fails */ "../node_modules/core-js/internals/fails.js");
var arrayMethodIsStrict = __webpack_require__(/*! ../internals/array-method-is-strict */ "../node_modules/core-js/internals/array-method-is-strict.js");

var test = [];
var nativeSort = test.sort;

// IE8-
var FAILS_ON_UNDEFINED = fails(function () {
  test.sort(undefined);
});
// V8 bug
var FAILS_ON_NULL = fails(function () {
  test.sort(null);
});
// Old WebKit
var STRICT_METHOD = arrayMethodIsStrict('sort');

var FORCED = FAILS_ON_UNDEFINED || !FAILS_ON_NULL || !STRICT_METHOD;

// `Array.prototype.sort` method
// https://tc39.github.io/ecma262/#sec-array.prototype.sort
$({ target: 'Array', proto: true, forced: FORCED }, {
  sort: function sort(comparefn) {
    return comparefn === undefined
      ? nativeSort.call(toObject(this))
      : nativeSort.call(toObject(this), aFunction(comparefn));
  }
});


/***/ }),

/***/ "../node_modules/sass-vars-to-js-loader/index.js!./global_styling/variables/_colors.scss":
/*!**************************************************************************************!*\
  !*** ../node_modules/sass-vars-to-js-loader!./global_styling/variables/_colors.scss ***!
  \**************************************************************************************/
/*! exports provided: ouiColorGhost, ouiColorInk, ouiColorPrimary, ouiColorSecondary, ouiColorAccent, ouiColorSuccess, ouiColorWarning, ouiColorDanger, ouiColorEmptyShade, ouiColorLightestShade, ouiColorLightShade, ouiColorMediumShade, ouiColorDarkShade, ouiColorDarkestShade, ouiColorFullShade, ouiPageBackgroundColor, ouiColorHighlight, ouiTextColor, ouiTitleColor, ouiTextSubduedColor, ouiColorDisabled, ouiColorPrimaryText, ouiColorSecondaryText, ouiColorAccentText, ouiColorWarningText, ouiColorDangerText, ouiColorDisabledText, ouiColorSuccessText, ouiLinkColor, ouiPaletteColorBlind, ouiPaletteColorBlindKeys, ouiColorVis0, ouiColorVis1, ouiColorVis2, ouiColorVis3, ouiColorVis4, ouiColorVis5, ouiColorVis6, ouiColorVis7, ouiColorVis8, ouiColorVis9, ouiColorVis0BehindText, ouiColorVis1BehindText, ouiColorVis2BehindText, ouiColorVis3BehindText, ouiColorVis4BehindText, ouiColorVis5BehindText, ouiColorVis6BehindText, ouiColorVis7BehindText, ouiColorVis8BehindText, ouiColorVis9BehindText, ouiColorChartLines, ouiColorChartBand, ouiCodeBlockBackgroundColor, ouiCodeBlockColor, ouiCodeBlockSelectedBackgroundColor, ouiCodeBlockCommentColor, ouiCodeBlockSelectorTagColor, ouiCodeBlockStringColor, ouiCodeBlockTagColor, ouiCodeBlockNameColor, ouiCodeBlockNumberColor, ouiCodeBlockKeywordColor, ouiCodeBlockFunctionTitleColor, ouiCodeBlockTypeColor, ouiCodeBlockAttributeColor, ouiCodeBlockSymbolColor, ouiCodeBlockParamsColor, ouiCodeBlockMetaColor, ouiCodeBlockTitleColor, ouiCodeBlockSectionColor, ouiCodeBlockAdditionColor, ouiCodeBlockDeletionColor, ouiCodeBlockSelectorClassColor, ouiCodeBlockSelectorIdColor, euiColorGhost, euiColorInk, euiColorPrimary, euiColorSecondary, euiColorAccent, euiColorSuccess, euiColorWarning, euiColorDanger, euiColorEmptyShade, euiColorLightestShade, euiColorLightShade, euiColorMediumShade, euiColorDarkShade, euiColorDarkestShade, euiColorFullShade, euiPageBackgroundColor, euiColorHighlight, euiTextColor, euiTitleColor, euiTextSubduedColor, euiColorDisabled, euiColorPrimaryText, euiColorSecondaryText, euiColorAccentText, euiColorWarningText, euiColorDangerText, euiColorDisabledText, euiColorSuccessText, euiLinkColor, euiPaletteColorBlind, euiPaletteColorBlindKeys, euiColorVis0, euiColorVis1, euiColorVis2, euiColorVis3, euiColorVis4, euiColorVis5, euiColorVis6, euiColorVis7, euiColorVis8, euiColorVis9, euiColorVis0BehindText, euiColorVis1BehindText, euiColorVis2BehindText, euiColorVis3BehindText, euiColorVis4BehindText, euiColorVis5BehindText, euiColorVis6BehindText, euiColorVis7BehindText, euiColorVis8BehindText, euiColorVis9BehindText, euiColorChartLines, euiColorChartBand, euiCodeBlockBackgroundColor, euiCodeBlockColor, euiCodeBlockSelectedBackgroundColor, euiCodeBlockCommentColor, euiCodeBlockSelectorTagColor, euiCodeBlockStringColor, euiCodeBlockTagColor, euiCodeBlockNameColor, euiCodeBlockNumberColor, euiCodeBlockKeywordColor, euiCodeBlockFunctionTitleColor, euiCodeBlockTypeColor, euiCodeBlockAttributeColor, euiCodeBlockSymbolColor, euiCodeBlockParamsColor, euiCodeBlockMetaColor, euiCodeBlockTitleColor, euiCodeBlockSectionColor, euiCodeBlockAdditionColor, euiCodeBlockDeletionColor, euiCodeBlockSelectorClassColor, euiCodeBlockSelectorIdColor, default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ouiColorGhost", function() { return ouiColorGhost; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ouiColorInk", function() { return ouiColorInk; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ouiColorPrimary", function() { return ouiColorPrimary; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ouiColorSecondary", function() { return ouiColorSecondary; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ouiColorAccent", function() { return ouiColorAccent; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ouiColorSuccess", function() { return ouiColorSuccess; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ouiColorWarning", function() { return ouiColorWarning; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ouiColorDanger", function() { return ouiColorDanger; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ouiColorEmptyShade", function() { return ouiColorEmptyShade; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ouiColorLightestShade", function() { return ouiColorLightestShade; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ouiColorLightShade", function() { return ouiColorLightShade; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ouiColorMediumShade", function() { return ouiColorMediumShade; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ouiColorDarkShade", function() { return ouiColorDarkShade; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ouiColorDarkestShade", function() { return ouiColorDarkestShade; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ouiColorFullShade", function() { return ouiColorFullShade; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ouiPageBackgroundColor", function() { return ouiPageBackgroundColor; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ouiColorHighlight", function() { return ouiColorHighlight; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ouiTextColor", function() { return ouiTextColor; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ouiTitleColor", function() { return ouiTitleColor; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ouiTextSubduedColor", function() { return ouiTextSubduedColor; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ouiColorDisabled", function() { return ouiColorDisabled; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ouiColorPrimaryText", function() { return ouiColorPrimaryText; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ouiColorSecondaryText", function() { return ouiColorSecondaryText; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ouiColorAccentText", function() { return ouiColorAccentText; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ouiColorWarningText", function() { return ouiColorWarningText; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ouiColorDangerText", function() { return ouiColorDangerText; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ouiColorDisabledText", function() { return ouiColorDisabledText; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ouiColorSuccessText", function() { return ouiColorSuccessText; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ouiLinkColor", function() { return ouiLinkColor; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ouiPaletteColorBlind", function() { return ouiPaletteColorBlind; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ouiPaletteColorBlindKeys", function() { return ouiPaletteColorBlindKeys; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ouiColorVis0", function() { return ouiColorVis0; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ouiColorVis1", function() { return ouiColorVis1; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ouiColorVis2", function() { return ouiColorVis2; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ouiColorVis3", function() { return ouiColorVis3; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ouiColorVis4", function() { return ouiColorVis4; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ouiColorVis5", function() { return ouiColorVis5; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ouiColorVis6", function() { return ouiColorVis6; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ouiColorVis7", function() { return ouiColorVis7; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ouiColorVis8", function() { return ouiColorVis8; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ouiColorVis9", function() { return ouiColorVis9; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ouiColorVis0BehindText", function() { return ouiColorVis0BehindText; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ouiColorVis1BehindText", function() { return ouiColorVis1BehindText; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ouiColorVis2BehindText", function() { return ouiColorVis2BehindText; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ouiColorVis3BehindText", function() { return ouiColorVis3BehindText; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ouiColorVis4BehindText", function() { return ouiColorVis4BehindText; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ouiColorVis5BehindText", function() { return ouiColorVis5BehindText; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ouiColorVis6BehindText", function() { return ouiColorVis6BehindText; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ouiColorVis7BehindText", function() { return ouiColorVis7BehindText; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ouiColorVis8BehindText", function() { return ouiColorVis8BehindText; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ouiColorVis9BehindText", function() { return ouiColorVis9BehindText; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ouiColorChartLines", function() { return ouiColorChartLines; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ouiColorChartBand", function() { return ouiColorChartBand; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ouiCodeBlockBackgroundColor", function() { return ouiCodeBlockBackgroundColor; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ouiCodeBlockColor", function() { return ouiCodeBlockColor; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ouiCodeBlockSelectedBackgroundColor", function() { return ouiCodeBlockSelectedBackgroundColor; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ouiCodeBlockCommentColor", function() { return ouiCodeBlockCommentColor; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ouiCodeBlockSelectorTagColor", function() { return ouiCodeBlockSelectorTagColor; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ouiCodeBlockStringColor", function() { return ouiCodeBlockStringColor; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ouiCodeBlockTagColor", function() { return ouiCodeBlockTagColor; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ouiCodeBlockNameColor", function() { return ouiCodeBlockNameColor; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ouiCodeBlockNumberColor", function() { return ouiCodeBlockNumberColor; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ouiCodeBlockKeywordColor", function() { return ouiCodeBlockKeywordColor; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ouiCodeBlockFunctionTitleColor", function() { return ouiCodeBlockFunctionTitleColor; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ouiCodeBlockTypeColor", function() { return ouiCodeBlockTypeColor; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ouiCodeBlockAttributeColor", function() { return ouiCodeBlockAttributeColor; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ouiCodeBlockSymbolColor", function() { return ouiCodeBlockSymbolColor; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ouiCodeBlockParamsColor", function() { return ouiCodeBlockParamsColor; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ouiCodeBlockMetaColor", function() { return ouiCodeBlockMetaColor; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ouiCodeBlockTitleColor", function() { return ouiCodeBlockTitleColor; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ouiCodeBlockSectionColor", function() { return ouiCodeBlockSectionColor; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ouiCodeBlockAdditionColor", function() { return ouiCodeBlockAdditionColor; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ouiCodeBlockDeletionColor", function() { return ouiCodeBlockDeletionColor; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ouiCodeBlockSelectorClassColor", function() { return ouiCodeBlockSelectorClassColor; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ouiCodeBlockSelectorIdColor", function() { return ouiCodeBlockSelectorIdColor; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "euiColorGhost", function() { return euiColorGhost; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "euiColorInk", function() { return euiColorInk; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "euiColorPrimary", function() { return euiColorPrimary; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "euiColorSecondary", function() { return euiColorSecondary; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "euiColorAccent", function() { return euiColorAccent; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "euiColorSuccess", function() { return euiColorSuccess; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "euiColorWarning", function() { return euiColorWarning; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "euiColorDanger", function() { return euiColorDanger; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "euiColorEmptyShade", function() { return euiColorEmptyShade; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "euiColorLightestShade", function() { return euiColorLightestShade; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "euiColorLightShade", function() { return euiColorLightShade; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "euiColorMediumShade", function() { return euiColorMediumShade; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "euiColorDarkShade", function() { return euiColorDarkShade; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "euiColorDarkestShade", function() { return euiColorDarkestShade; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "euiColorFullShade", function() { return euiColorFullShade; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "euiPageBackgroundColor", function() { return euiPageBackgroundColor; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "euiColorHighlight", function() { return euiColorHighlight; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "euiTextColor", function() { return euiTextColor; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "euiTitleColor", function() { return euiTitleColor; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "euiTextSubduedColor", function() { return euiTextSubduedColor; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "euiColorDisabled", function() { return euiColorDisabled; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "euiColorPrimaryText", function() { return euiColorPrimaryText; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "euiColorSecondaryText", function() { return euiColorSecondaryText; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "euiColorAccentText", function() { return euiColorAccentText; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "euiColorWarningText", function() { return euiColorWarningText; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "euiColorDangerText", function() { return euiColorDangerText; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "euiColorDisabledText", function() { return euiColorDisabledText; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "euiColorSuccessText", function() { return euiColorSuccessText; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "euiLinkColor", function() { return euiLinkColor; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "euiPaletteColorBlind", function() { return euiPaletteColorBlind; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "euiPaletteColorBlindKeys", function() { return euiPaletteColorBlindKeys; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "euiColorVis0", function() { return euiColorVis0; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "euiColorVis1", function() { return euiColorVis1; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "euiColorVis2", function() { return euiColorVis2; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "euiColorVis3", function() { return euiColorVis3; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "euiColorVis4", function() { return euiColorVis4; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "euiColorVis5", function() { return euiColorVis5; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "euiColorVis6", function() { return euiColorVis6; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "euiColorVis7", function() { return euiColorVis7; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "euiColorVis8", function() { return euiColorVis8; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "euiColorVis9", function() { return euiColorVis9; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "euiColorVis0BehindText", function() { return euiColorVis0BehindText; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "euiColorVis1BehindText", function() { return euiColorVis1BehindText; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "euiColorVis2BehindText", function() { return euiColorVis2BehindText; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "euiColorVis3BehindText", function() { return euiColorVis3BehindText; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "euiColorVis4BehindText", function() { return euiColorVis4BehindText; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "euiColorVis5BehindText", function() { return euiColorVis5BehindText; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "euiColorVis6BehindText", function() { return euiColorVis6BehindText; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "euiColorVis7BehindText", function() { return euiColorVis7BehindText; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "euiColorVis8BehindText", function() { return euiColorVis8BehindText; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "euiColorVis9BehindText", function() { return euiColorVis9BehindText; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "euiColorChartLines", function() { return euiColorChartLines; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "euiColorChartBand", function() { return euiColorChartBand; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "euiCodeBlockBackgroundColor", function() { return euiCodeBlockBackgroundColor; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "euiCodeBlockColor", function() { return euiCodeBlockColor; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "euiCodeBlockSelectedBackgroundColor", function() { return euiCodeBlockSelectedBackgroundColor; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "euiCodeBlockCommentColor", function() { return euiCodeBlockCommentColor; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "euiCodeBlockSelectorTagColor", function() { return euiCodeBlockSelectorTagColor; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "euiCodeBlockStringColor", function() { return euiCodeBlockStringColor; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "euiCodeBlockTagColor", function() { return euiCodeBlockTagColor; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "euiCodeBlockNameColor", function() { return euiCodeBlockNameColor; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "euiCodeBlockNumberColor", function() { return euiCodeBlockNumberColor; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "euiCodeBlockKeywordColor", function() { return euiCodeBlockKeywordColor; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "euiCodeBlockFunctionTitleColor", function() { return euiCodeBlockFunctionTitleColor; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "euiCodeBlockTypeColor", function() { return euiCodeBlockTypeColor; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "euiCodeBlockAttributeColor", function() { return euiCodeBlockAttributeColor; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "euiCodeBlockSymbolColor", function() { return euiCodeBlockSymbolColor; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "euiCodeBlockParamsColor", function() { return euiCodeBlockParamsColor; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "euiCodeBlockMetaColor", function() { return euiCodeBlockMetaColor; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "euiCodeBlockTitleColor", function() { return euiCodeBlockTitleColor; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "euiCodeBlockSectionColor", function() { return euiCodeBlockSectionColor; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "euiCodeBlockAdditionColor", function() { return euiCodeBlockAdditionColor; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "euiCodeBlockDeletionColor", function() { return euiCodeBlockDeletionColor; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "euiCodeBlockSelectorClassColor", function() { return euiCodeBlockSelectorClassColor; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "euiCodeBlockSelectorIdColor", function() { return euiCodeBlockSelectorIdColor; });
var ouiColorGhost = {"r":255,"g":255,"b":255,"a":1,"rgba":"rgba(255, 255, 255, 1)"}
var ouiColorInk = {"r":0,"g":0,"b":0,"a":1,"rgba":"rgba(0, 0, 0, 1)"}
var ouiColorPrimary = {"r":0,"g":107,"b":180,"a":1,"rgba":"rgba(0, 107, 180, 1)"}
var ouiColorSecondary = {"r":1,"g":125,"b":115,"a":1,"rgba":"rgba(1, 125, 115, 1)"}
var ouiColorAccent = {"r":221,"g":10,"b":115,"a":1,"rgba":"rgba(221, 10, 115, 1)"}
var ouiColorSuccess = {"r":1,"g":125,"b":115,"a":1,"rgba":"rgba(1, 125, 115, 1)"}
var ouiColorWarning = {"r":245,"g":167,"b":0,"a":1,"rgba":"rgba(245, 167, 0, 1)"}
var ouiColorDanger = {"r":189,"g":39,"b":30,"a":1,"rgba":"rgba(189, 39, 30, 1)"}
var ouiColorEmptyShade = {"r":255,"g":255,"b":255,"a":1,"rgba":"rgba(255, 255, 255, 1)"}
var ouiColorLightestShade = {"r":245,"g":247,"b":250,"a":1,"rgba":"rgba(245, 247, 250, 1)"}
var ouiColorLightShade = {"r":211,"g":218,"b":230,"a":1,"rgba":"rgba(211, 218, 230, 1)"}
var ouiColorMediumShade = {"r":152,"g":162,"b":179,"a":1,"rgba":"rgba(152, 162, 179, 1)"}
var ouiColorDarkShade = {"r":105,"g":112,"b":125,"a":1,"rgba":"rgba(105, 112, 125, 1)"}
var ouiColorDarkestShade = {"r":52,"g":55,"b":65,"a":1,"rgba":"rgba(52, 55, 65, 1)"}
var ouiColorFullShade = {"r":0,"g":0,"b":0,"a":1,"rgba":"rgba(0, 0, 0, 1)"}
var ouiPageBackgroundColor = {"r":250,"g":251,"b":253,"a":1,"rgba":"rgba(250, 251, 253, 1)"}
var ouiColorHighlight = {"r":255,"g":252,"b":221,"a":1,"rgba":"rgba(255, 252, 221, 1)"}
var ouiTextColor = {"r":52,"g":55,"b":65,"a":1,"rgba":"rgba(52, 55, 65, 1)"}
var ouiTitleColor = {"r":26,"g":28,"b":33,"a":1,"rgba":"rgba(26, 28, 33, 1)"}
var ouiTextSubduedColor = {"r":106,"g":113,"b":125,"a":1,"rgba":"rgba(106, 113, 125, 1)"}
var ouiColorDisabled = {"r":194,"g":195,"b":198,"a":1,"rgba":"rgba(194, 195, 198, 1)"}
var ouiColorPrimaryText = {"r":0,"g":107,"b":180,"a":1,"rgba":"rgba(0, 107, 180, 1)"}
var ouiColorSecondaryText = {"r":1,"g":125,"b":115,"a":1,"rgba":"rgba(1, 125, 115, 1)"}
var ouiColorAccentText = {"r":221,"g":10,"b":115,"a":1,"rgba":"rgba(221, 10, 115, 1)"}
var ouiColorWarningText = {"r":155,"g":105,"b":0,"a":1,"rgba":"rgba(155, 105, 0, 1)"}
var ouiColorDangerText = {"r":189,"g":39,"b":30,"a":1,"rgba":"rgba(189, 39, 30, 1)"}
var ouiColorDisabledText = {"r":175,"g":176,"b":179,"a":1,"rgba":"rgba(175, 176, 179, 1)"}
var ouiColorSuccessText = {"r":1,"g":125,"b":115,"a":1,"rgba":"rgba(1, 125, 115, 1)"}
var ouiLinkColor = {"r":0,"g":107,"b":180,"a":1,"rgba":"rgba(0, 107, 180, 1)"}
var ouiPaletteColorBlind = {"ouiColorVis0":{"graphic":{"r":84,"g":179,"b":153,"a":1,"rgba":"rgba(84, 179, 153, 1)"},"behindText":{"r":109,"g":204,"b":177,"a":1,"rgba":"rgba(109, 204, 177, 1)"}},"ouiColorVis1":{"graphic":{"r":96,"g":146,"b":192,"a":1,"rgba":"rgba(96, 146, 192, 1)"},"behindText":{"r":121,"g":170,"b":217,"a":1,"rgba":"rgba(121, 170, 217, 1)"}},"ouiColorVis2":{"graphic":{"r":211,"g":96,"b":134,"a":1,"rgba":"rgba(211, 96, 134, 1)"},"behindText":{"r":238,"g":120,"b":157,"a":1,"rgba":"rgba(238, 120, 157, 1)"}},"ouiColorVis3":{"graphic":{"r":145,"g":112,"b":184,"a":1,"rgba":"rgba(145, 112, 184, 1)"},"behindText":{"r":169,"g":135,"b":209,"a":1,"rgba":"rgba(169, 135, 209, 1)"}},"ouiColorVis4":{"graphic":{"r":202,"g":142,"b":174,"a":1,"rgba":"rgba(202, 142, 174, 1)"},"behindText":{"r":228,"g":166,"b":199,"a":1,"rgba":"rgba(228, 166, 199, 1)"}},"ouiColorVis5":{"graphic":{"r":214,"g":191,"b":87,"a":1,"rgba":"rgba(214, 191, 87, 1)"},"behindText":{"r":241,"g":216,"b":111,"a":1,"rgba":"rgba(241, 216, 111, 1)"}},"ouiColorVis6":{"graphic":{"r":185,"g":168,"b":136,"a":1,"rgba":"rgba(185, 168, 136, 1)"},"behindText":{"r":210,"g":192,"b":160,"a":1,"rgba":"rgba(210, 192, 160, 1)"}},"ouiColorVis7":{"graphic":{"r":218,"g":139,"b":69,"a":1,"rgba":"rgba(218, 139, 69, 1)"},"behindText":{"r":245,"g":163,"b":92,"a":1,"rgba":"rgba(245, 163, 92, 1)"}},"ouiColorVis8":{"graphic":{"r":170,"g":101,"b":86,"a":1,"rgba":"rgba(170, 101, 86, 1)"},"behindText":{"r":196,"g":124,"b":108,"a":1,"rgba":"rgba(196, 124, 108, 1)"}},"ouiColorVis9":{"graphic":{"r":231,"g":102,"b":76,"a":1,"rgba":"rgba(231, 102, 76, 1)"},"behindText":{"r":255,"g":126,"b":98,"a":1,"rgba":"rgba(255, 126, 98, 1)"}}}
var ouiPaletteColorBlindKeys = ["ouiColorVis0","ouiColorVis1","ouiColorVis2","ouiColorVis3","ouiColorVis4","ouiColorVis5","ouiColorVis6","ouiColorVis7","ouiColorVis8","ouiColorVis9"]
var ouiColorVis0 = {"r":84,"g":179,"b":153,"a":1,"rgba":"rgba(84, 179, 153, 1)"}
var ouiColorVis1 = {"r":96,"g":146,"b":192,"a":1,"rgba":"rgba(96, 146, 192, 1)"}
var ouiColorVis2 = {"r":211,"g":96,"b":134,"a":1,"rgba":"rgba(211, 96, 134, 1)"}
var ouiColorVis3 = {"r":145,"g":112,"b":184,"a":1,"rgba":"rgba(145, 112, 184, 1)"}
var ouiColorVis4 = {"r":202,"g":142,"b":174,"a":1,"rgba":"rgba(202, 142, 174, 1)"}
var ouiColorVis5 = {"r":214,"g":191,"b":87,"a":1,"rgba":"rgba(214, 191, 87, 1)"}
var ouiColorVis6 = {"r":185,"g":168,"b":136,"a":1,"rgba":"rgba(185, 168, 136, 1)"}
var ouiColorVis7 = {"r":218,"g":139,"b":69,"a":1,"rgba":"rgba(218, 139, 69, 1)"}
var ouiColorVis8 = {"r":170,"g":101,"b":86,"a":1,"rgba":"rgba(170, 101, 86, 1)"}
var ouiColorVis9 = {"r":231,"g":102,"b":76,"a":1,"rgba":"rgba(231, 102, 76, 1)"}
var ouiColorVis0BehindText = {"r":109,"g":204,"b":177,"a":1,"rgba":"rgba(109, 204, 177, 1)"}
var ouiColorVis1BehindText = {"r":121,"g":170,"b":217,"a":1,"rgba":"rgba(121, 170, 217, 1)"}
var ouiColorVis2BehindText = {"r":238,"g":120,"b":157,"a":1,"rgba":"rgba(238, 120, 157, 1)"}
var ouiColorVis3BehindText = {"r":169,"g":135,"b":209,"a":1,"rgba":"rgba(169, 135, 209, 1)"}
var ouiColorVis4BehindText = {"r":228,"g":166,"b":199,"a":1,"rgba":"rgba(228, 166, 199, 1)"}
var ouiColorVis5BehindText = {"r":241,"g":216,"b":111,"a":1,"rgba":"rgba(241, 216, 111, 1)"}
var ouiColorVis6BehindText = {"r":210,"g":192,"b":160,"a":1,"rgba":"rgba(210, 192, 160, 1)"}
var ouiColorVis7BehindText = {"r":245,"g":163,"b":92,"a":1,"rgba":"rgba(245, 163, 92, 1)"}
var ouiColorVis8BehindText = {"r":196,"g":124,"b":108,"a":1,"rgba":"rgba(196, 124, 108, 1)"}
var ouiColorVis9BehindText = {"r":255,"g":126,"b":98,"a":1,"rgba":"rgba(255, 126, 98, 1)"}
var ouiColorChartLines = {"r":238,"g":240,"b":243,"a":1,"rgba":"rgba(238, 240, 243, 1)"}
var ouiColorChartBand = {"r":245,"g":247,"b":250,"a":1,"rgba":"rgba(245, 247, 250, 1)"}
var ouiCodeBlockBackgroundColor = {"r":245,"g":247,"b":250,"a":1,"rgba":"rgba(245, 247, 250, 1)"}
var ouiCodeBlockColor = {"r":52,"g":55,"b":65,"a":1,"rgba":"rgba(52, 55, 65, 1)"}
var ouiCodeBlockSelectedBackgroundColor = "inherit"
var ouiCodeBlockCommentColor = {"r":106,"g":113,"b":125,"a":1,"rgba":"rgba(106, 113, 125, 1)"}
var ouiCodeBlockSelectorTagColor = "inherit"
var ouiCodeBlockStringColor = {"r":172,"g":78,"b":109,"a":1,"rgba":"rgba(172, 78, 109, 1)"}
var ouiCodeBlockTagColor = {"r":74,"g":113,"b":148,"a":1,"rgba":"rgba(74, 113, 148, 1)"}
var ouiCodeBlockNameColor = {"r":74,"g":113,"b":148,"a":1,"rgba":"rgba(74, 113, 148, 1)"}
var ouiCodeBlockNumberColor = {"r":59,"g":125,"b":106,"a":1,"rgba":"rgba(59, 125, 106, 1)"}
var ouiCodeBlockKeywordColor = {"r":124,"g":96,"b":158,"a":1,"rgba":"rgba(124, 96, 158, 1)"}
var ouiCodeBlockFunctionTitleColor = "inherit"
var ouiCodeBlockTypeColor = {"r":74,"g":113,"b":148,"a":1,"rgba":"rgba(74, 113, 148, 1)"}
var ouiCodeBlockAttributeColor = "inherit"
var ouiCodeBlockSymbolColor = {"r":179,"g":79,"b":59,"a":1,"rgba":"rgba(179, 79, 59, 1)"}
var ouiCodeBlockParamsColor = "inherit"
var ouiCodeBlockMetaColor = {"r":106,"g":113,"b":125,"a":1,"rgba":"rgba(106, 113, 125, 1)"}
var ouiCodeBlockTitleColor = {"r":153,"g":97,"b":48,"a":1,"rgba":"rgba(153, 97, 48, 1)"}
var ouiCodeBlockSectionColor = {"r":179,"g":79,"b":59,"a":1,"rgba":"rgba(179, 79, 59, 1)"}
var ouiCodeBlockAdditionColor = {"r":59,"g":125,"b":106,"a":1,"rgba":"rgba(59, 125, 106, 1)"}
var ouiCodeBlockDeletionColor = {"r":189,"g":39,"b":30,"a":1,"rgba":"rgba(189, 39, 30, 1)"}
var ouiCodeBlockSelectorClassColor = "inherit"
var ouiCodeBlockSelectorIdColor = "inherit"
var euiColorGhost = {"r":255,"g":255,"b":255,"a":1,"rgba":"rgba(255, 255, 255, 1)"}
var euiColorInk = {"r":0,"g":0,"b":0,"a":1,"rgba":"rgba(0, 0, 0, 1)"}
var euiColorPrimary = {"r":0,"g":107,"b":180,"a":1,"rgba":"rgba(0, 107, 180, 1)"}
var euiColorSecondary = {"r":1,"g":125,"b":115,"a":1,"rgba":"rgba(1, 125, 115, 1)"}
var euiColorAccent = {"r":221,"g":10,"b":115,"a":1,"rgba":"rgba(221, 10, 115, 1)"}
var euiColorSuccess = {"r":1,"g":125,"b":115,"a":1,"rgba":"rgba(1, 125, 115, 1)"}
var euiColorWarning = {"r":245,"g":167,"b":0,"a":1,"rgba":"rgba(245, 167, 0, 1)"}
var euiColorDanger = {"r":189,"g":39,"b":30,"a":1,"rgba":"rgba(189, 39, 30, 1)"}
var euiColorEmptyShade = {"r":255,"g":255,"b":255,"a":1,"rgba":"rgba(255, 255, 255, 1)"}
var euiColorLightestShade = {"r":245,"g":247,"b":250,"a":1,"rgba":"rgba(245, 247, 250, 1)"}
var euiColorLightShade = {"r":211,"g":218,"b":230,"a":1,"rgba":"rgba(211, 218, 230, 1)"}
var euiColorMediumShade = {"r":152,"g":162,"b":179,"a":1,"rgba":"rgba(152, 162, 179, 1)"}
var euiColorDarkShade = {"r":105,"g":112,"b":125,"a":1,"rgba":"rgba(105, 112, 125, 1)"}
var euiColorDarkestShade = {"r":52,"g":55,"b":65,"a":1,"rgba":"rgba(52, 55, 65, 1)"}
var euiColorFullShade = {"r":0,"g":0,"b":0,"a":1,"rgba":"rgba(0, 0, 0, 1)"}
var euiPageBackgroundColor = {"r":250,"g":251,"b":253,"a":1,"rgba":"rgba(250, 251, 253, 1)"}
var euiColorHighlight = {"r":255,"g":252,"b":221,"a":1,"rgba":"rgba(255, 252, 221, 1)"}
var euiTextColor = {"r":52,"g":55,"b":65,"a":1,"rgba":"rgba(52, 55, 65, 1)"}
var euiTitleColor = {"r":26,"g":28,"b":33,"a":1,"rgba":"rgba(26, 28, 33, 1)"}
var euiTextSubduedColor = {"r":106,"g":113,"b":125,"a":1,"rgba":"rgba(106, 113, 125, 1)"}
var euiColorDisabled = {"r":194,"g":195,"b":198,"a":1,"rgba":"rgba(194, 195, 198, 1)"}
var euiColorPrimaryText = {"r":0,"g":107,"b":180,"a":1,"rgba":"rgba(0, 107, 180, 1)"}
var euiColorSecondaryText = {"r":1,"g":125,"b":115,"a":1,"rgba":"rgba(1, 125, 115, 1)"}
var euiColorAccentText = {"r":221,"g":10,"b":115,"a":1,"rgba":"rgba(221, 10, 115, 1)"}
var euiColorWarningText = {"r":155,"g":105,"b":0,"a":1,"rgba":"rgba(155, 105, 0, 1)"}
var euiColorDangerText = {"r":189,"g":39,"b":30,"a":1,"rgba":"rgba(189, 39, 30, 1)"}
var euiColorDisabledText = {"r":175,"g":176,"b":179,"a":1,"rgba":"rgba(175, 176, 179, 1)"}
var euiColorSuccessText = {"r":1,"g":125,"b":115,"a":1,"rgba":"rgba(1, 125, 115, 1)"}
var euiLinkColor = {"r":0,"g":107,"b":180,"a":1,"rgba":"rgba(0, 107, 180, 1)"}
var euiPaletteColorBlind = {"euiColorVis0":{"graphic":{"r":84,"g":179,"b":153,"a":1,"rgba":"rgba(84, 179, 153, 1)"},"behindText":{"r":109,"g":204,"b":177,"a":1,"rgba":"rgba(109, 204, 177, 1)"}},"euiColorVis1":{"graphic":{"r":96,"g":146,"b":192,"a":1,"rgba":"rgba(96, 146, 192, 1)"},"behindText":{"r":121,"g":170,"b":217,"a":1,"rgba":"rgba(121, 170, 217, 1)"}},"euiColorVis2":{"graphic":{"r":211,"g":96,"b":134,"a":1,"rgba":"rgba(211, 96, 134, 1)"},"behindText":{"r":238,"g":120,"b":157,"a":1,"rgba":"rgba(238, 120, 157, 1)"}},"euiColorVis3":{"graphic":{"r":145,"g":112,"b":184,"a":1,"rgba":"rgba(145, 112, 184, 1)"},"behindText":{"r":169,"g":135,"b":209,"a":1,"rgba":"rgba(169, 135, 209, 1)"}},"euiColorVis4":{"graphic":{"r":202,"g":142,"b":174,"a":1,"rgba":"rgba(202, 142, 174, 1)"},"behindText":{"r":228,"g":166,"b":199,"a":1,"rgba":"rgba(228, 166, 199, 1)"}},"euiColorVis5":{"graphic":{"r":214,"g":191,"b":87,"a":1,"rgba":"rgba(214, 191, 87, 1)"},"behindText":{"r":241,"g":216,"b":111,"a":1,"rgba":"rgba(241, 216, 111, 1)"}},"euiColorVis6":{"graphic":{"r":185,"g":168,"b":136,"a":1,"rgba":"rgba(185, 168, 136, 1)"},"behindText":{"r":210,"g":192,"b":160,"a":1,"rgba":"rgba(210, 192, 160, 1)"}},"euiColorVis7":{"graphic":{"r":218,"g":139,"b":69,"a":1,"rgba":"rgba(218, 139, 69, 1)"},"behindText":{"r":245,"g":163,"b":92,"a":1,"rgba":"rgba(245, 163, 92, 1)"}},"euiColorVis8":{"graphic":{"r":170,"g":101,"b":86,"a":1,"rgba":"rgba(170, 101, 86, 1)"},"behindText":{"r":196,"g":124,"b":108,"a":1,"rgba":"rgba(196, 124, 108, 1)"}},"euiColorVis9":{"graphic":{"r":231,"g":102,"b":76,"a":1,"rgba":"rgba(231, 102, 76, 1)"},"behindText":{"r":255,"g":126,"b":98,"a":1,"rgba":"rgba(255, 126, 98, 1)"}}}
var euiPaletteColorBlindKeys = ["euiColorVis0","euiColorVis1","euiColorVis2","euiColorVis3","euiColorVis4","euiColorVis5","euiColorVis6","euiColorVis7","euiColorVis8","euiColorVis9"]
var euiColorVis0 = {"r":84,"g":179,"b":153,"a":1,"rgba":"rgba(84, 179, 153, 1)"}
var euiColorVis1 = {"r":96,"g":146,"b":192,"a":1,"rgba":"rgba(96, 146, 192, 1)"}
var euiColorVis2 = {"r":211,"g":96,"b":134,"a":1,"rgba":"rgba(211, 96, 134, 1)"}
var euiColorVis3 = {"r":145,"g":112,"b":184,"a":1,"rgba":"rgba(145, 112, 184, 1)"}
var euiColorVis4 = {"r":202,"g":142,"b":174,"a":1,"rgba":"rgba(202, 142, 174, 1)"}
var euiColorVis5 = {"r":214,"g":191,"b":87,"a":1,"rgba":"rgba(214, 191, 87, 1)"}
var euiColorVis6 = {"r":185,"g":168,"b":136,"a":1,"rgba":"rgba(185, 168, 136, 1)"}
var euiColorVis7 = {"r":218,"g":139,"b":69,"a":1,"rgba":"rgba(218, 139, 69, 1)"}
var euiColorVis8 = {"r":170,"g":101,"b":86,"a":1,"rgba":"rgba(170, 101, 86, 1)"}
var euiColorVis9 = {"r":231,"g":102,"b":76,"a":1,"rgba":"rgba(231, 102, 76, 1)"}
var euiColorVis0BehindText = {"r":109,"g":204,"b":177,"a":1,"rgba":"rgba(109, 204, 177, 1)"}
var euiColorVis1BehindText = {"r":121,"g":170,"b":217,"a":1,"rgba":"rgba(121, 170, 217, 1)"}
var euiColorVis2BehindText = {"r":238,"g":120,"b":157,"a":1,"rgba":"rgba(238, 120, 157, 1)"}
var euiColorVis3BehindText = {"r":169,"g":135,"b":209,"a":1,"rgba":"rgba(169, 135, 209, 1)"}
var euiColorVis4BehindText = {"r":228,"g":166,"b":199,"a":1,"rgba":"rgba(228, 166, 199, 1)"}
var euiColorVis5BehindText = {"r":241,"g":216,"b":111,"a":1,"rgba":"rgba(241, 216, 111, 1)"}
var euiColorVis6BehindText = {"r":210,"g":192,"b":160,"a":1,"rgba":"rgba(210, 192, 160, 1)"}
var euiColorVis7BehindText = {"r":245,"g":163,"b":92,"a":1,"rgba":"rgba(245, 163, 92, 1)"}
var euiColorVis8BehindText = {"r":196,"g":124,"b":108,"a":1,"rgba":"rgba(196, 124, 108, 1)"}
var euiColorVis9BehindText = {"r":255,"g":126,"b":98,"a":1,"rgba":"rgba(255, 126, 98, 1)"}
var euiColorChartLines = {"r":238,"g":240,"b":243,"a":1,"rgba":"rgba(238, 240, 243, 1)"}
var euiColorChartBand = {"r":245,"g":247,"b":250,"a":1,"rgba":"rgba(245, 247, 250, 1)"}
var euiCodeBlockBackgroundColor = {"r":245,"g":247,"b":250,"a":1,"rgba":"rgba(245, 247, 250, 1)"}
var euiCodeBlockColor = {"r":52,"g":55,"b":65,"a":1,"rgba":"rgba(52, 55, 65, 1)"}
var euiCodeBlockSelectedBackgroundColor = "inherit"
var euiCodeBlockCommentColor = {"r":106,"g":113,"b":125,"a":1,"rgba":"rgba(106, 113, 125, 1)"}
var euiCodeBlockSelectorTagColor = "inherit"
var euiCodeBlockStringColor = {"r":172,"g":78,"b":109,"a":1,"rgba":"rgba(172, 78, 109, 1)"}
var euiCodeBlockTagColor = {"r":74,"g":113,"b":148,"a":1,"rgba":"rgba(74, 113, 148, 1)"}
var euiCodeBlockNameColor = {"r":74,"g":113,"b":148,"a":1,"rgba":"rgba(74, 113, 148, 1)"}
var euiCodeBlockNumberColor = {"r":59,"g":125,"b":106,"a":1,"rgba":"rgba(59, 125, 106, 1)"}
var euiCodeBlockKeywordColor = {"r":124,"g":96,"b":158,"a":1,"rgba":"rgba(124, 96, 158, 1)"}
var euiCodeBlockFunctionTitleColor = "inherit"
var euiCodeBlockTypeColor = {"r":74,"g":113,"b":148,"a":1,"rgba":"rgba(74, 113, 148, 1)"}
var euiCodeBlockAttributeColor = "inherit"
var euiCodeBlockSymbolColor = {"r":179,"g":79,"b":59,"a":1,"rgba":"rgba(179, 79, 59, 1)"}
var euiCodeBlockParamsColor = "inherit"
var euiCodeBlockMetaColor = {"r":106,"g":113,"b":125,"a":1,"rgba":"rgba(106, 113, 125, 1)"}
var euiCodeBlockTitleColor = {"r":153,"g":97,"b":48,"a":1,"rgba":"rgba(153, 97, 48, 1)"}
var euiCodeBlockSectionColor = {"r":179,"g":79,"b":59,"a":1,"rgba":"rgba(179, 79, 59, 1)"}
var euiCodeBlockAdditionColor = {"r":59,"g":125,"b":106,"a":1,"rgba":"rgba(59, 125, 106, 1)"}
var euiCodeBlockDeletionColor = {"r":189,"g":39,"b":30,"a":1,"rgba":"rgba(189, 39, 30, 1)"}
var euiCodeBlockSelectorClassColor = "inherit"
var euiCodeBlockSelectorIdColor = "inherit"
/* harmony default export */ __webpack_exports__["default"] = ({"ouiColorGhost":{"r":255,"g":255,"b":255,"a":1,"rgba":"rgba(255, 255, 255, 1)"},"ouiColorInk":{"r":0,"g":0,"b":0,"a":1,"rgba":"rgba(0, 0, 0, 1)"},"ouiColorPrimary":{"r":0,"g":107,"b":180,"a":1,"rgba":"rgba(0, 107, 180, 1)"},"ouiColorSecondary":{"r":1,"g":125,"b":115,"a":1,"rgba":"rgba(1, 125, 115, 1)"},"ouiColorAccent":{"r":221,"g":10,"b":115,"a":1,"rgba":"rgba(221, 10, 115, 1)"},"ouiColorSuccess":{"r":1,"g":125,"b":115,"a":1,"rgba":"rgba(1, 125, 115, 1)"},"ouiColorWarning":{"r":245,"g":167,"b":0,"a":1,"rgba":"rgba(245, 167, 0, 1)"},"ouiColorDanger":{"r":189,"g":39,"b":30,"a":1,"rgba":"rgba(189, 39, 30, 1)"},"ouiColorEmptyShade":{"r":255,"g":255,"b":255,"a":1,"rgba":"rgba(255, 255, 255, 1)"},"ouiColorLightestShade":{"r":245,"g":247,"b":250,"a":1,"rgba":"rgba(245, 247, 250, 1)"},"ouiColorLightShade":{"r":211,"g":218,"b":230,"a":1,"rgba":"rgba(211, 218, 230, 1)"},"ouiColorMediumShade":{"r":152,"g":162,"b":179,"a":1,"rgba":"rgba(152, 162, 179, 1)"},"ouiColorDarkShade":{"r":105,"g":112,"b":125,"a":1,"rgba":"rgba(105, 112, 125, 1)"},"ouiColorDarkestShade":{"r":52,"g":55,"b":65,"a":1,"rgba":"rgba(52, 55, 65, 1)"},"ouiColorFullShade":{"r":0,"g":0,"b":0,"a":1,"rgba":"rgba(0, 0, 0, 1)"},"ouiPageBackgroundColor":{"r":250,"g":251,"b":253,"a":1,"rgba":"rgba(250, 251, 253, 1)"},"ouiColorHighlight":{"r":255,"g":252,"b":221,"a":1,"rgba":"rgba(255, 252, 221, 1)"},"ouiTextColor":{"r":52,"g":55,"b":65,"a":1,"rgba":"rgba(52, 55, 65, 1)"},"ouiTitleColor":{"r":26,"g":28,"b":33,"a":1,"rgba":"rgba(26, 28, 33, 1)"},"ouiTextSubduedColor":{"r":106,"g":113,"b":125,"a":1,"rgba":"rgba(106, 113, 125, 1)"},"ouiColorDisabled":{"r":194,"g":195,"b":198,"a":1,"rgba":"rgba(194, 195, 198, 1)"},"ouiColorPrimaryText":{"r":0,"g":107,"b":180,"a":1,"rgba":"rgba(0, 107, 180, 1)"},"ouiColorSecondaryText":{"r":1,"g":125,"b":115,"a":1,"rgba":"rgba(1, 125, 115, 1)"},"ouiColorAccentText":{"r":221,"g":10,"b":115,"a":1,"rgba":"rgba(221, 10, 115, 1)"},"ouiColorWarningText":{"r":155,"g":105,"b":0,"a":1,"rgba":"rgba(155, 105, 0, 1)"},"ouiColorDangerText":{"r":189,"g":39,"b":30,"a":1,"rgba":"rgba(189, 39, 30, 1)"},"ouiColorDisabledText":{"r":175,"g":176,"b":179,"a":1,"rgba":"rgba(175, 176, 179, 1)"},"ouiColorSuccessText":{"r":1,"g":125,"b":115,"a":1,"rgba":"rgba(1, 125, 115, 1)"},"ouiLinkColor":{"r":0,"g":107,"b":180,"a":1,"rgba":"rgba(0, 107, 180, 1)"},"ouiPaletteColorBlind":{"ouiColorVis0":{"graphic":{"r":84,"g":179,"b":153,"a":1,"rgba":"rgba(84, 179, 153, 1)"},"behindText":{"r":109,"g":204,"b":177,"a":1,"rgba":"rgba(109, 204, 177, 1)"}},"ouiColorVis1":{"graphic":{"r":96,"g":146,"b":192,"a":1,"rgba":"rgba(96, 146, 192, 1)"},"behindText":{"r":121,"g":170,"b":217,"a":1,"rgba":"rgba(121, 170, 217, 1)"}},"ouiColorVis2":{"graphic":{"r":211,"g":96,"b":134,"a":1,"rgba":"rgba(211, 96, 134, 1)"},"behindText":{"r":238,"g":120,"b":157,"a":1,"rgba":"rgba(238, 120, 157, 1)"}},"ouiColorVis3":{"graphic":{"r":145,"g":112,"b":184,"a":1,"rgba":"rgba(145, 112, 184, 1)"},"behindText":{"r":169,"g":135,"b":209,"a":1,"rgba":"rgba(169, 135, 209, 1)"}},"ouiColorVis4":{"graphic":{"r":202,"g":142,"b":174,"a":1,"rgba":"rgba(202, 142, 174, 1)"},"behindText":{"r":228,"g":166,"b":199,"a":1,"rgba":"rgba(228, 166, 199, 1)"}},"ouiColorVis5":{"graphic":{"r":214,"g":191,"b":87,"a":1,"rgba":"rgba(214, 191, 87, 1)"},"behindText":{"r":241,"g":216,"b":111,"a":1,"rgba":"rgba(241, 216, 111, 1)"}},"ouiColorVis6":{"graphic":{"r":185,"g":168,"b":136,"a":1,"rgba":"rgba(185, 168, 136, 1)"},"behindText":{"r":210,"g":192,"b":160,"a":1,"rgba":"rgba(210, 192, 160, 1)"}},"ouiColorVis7":{"graphic":{"r":218,"g":139,"b":69,"a":1,"rgba":"rgba(218, 139, 69, 1)"},"behindText":{"r":245,"g":163,"b":92,"a":1,"rgba":"rgba(245, 163, 92, 1)"}},"ouiColorVis8":{"graphic":{"r":170,"g":101,"b":86,"a":1,"rgba":"rgba(170, 101, 86, 1)"},"behindText":{"r":196,"g":124,"b":108,"a":1,"rgba":"rgba(196, 124, 108, 1)"}},"ouiColorVis9":{"graphic":{"r":231,"g":102,"b":76,"a":1,"rgba":"rgba(231, 102, 76, 1)"},"behindText":{"r":255,"g":126,"b":98,"a":1,"rgba":"rgba(255, 126, 98, 1)"}}},"ouiPaletteColorBlindKeys":["ouiColorVis0","ouiColorVis1","ouiColorVis2","ouiColorVis3","ouiColorVis4","ouiColorVis5","ouiColorVis6","ouiColorVis7","ouiColorVis8","ouiColorVis9"],"ouiColorVis0":{"r":84,"g":179,"b":153,"a":1,"rgba":"rgba(84, 179, 153, 1)"},"ouiColorVis1":{"r":96,"g":146,"b":192,"a":1,"rgba":"rgba(96, 146, 192, 1)"},"ouiColorVis2":{"r":211,"g":96,"b":134,"a":1,"rgba":"rgba(211, 96, 134, 1)"},"ouiColorVis3":{"r":145,"g":112,"b":184,"a":1,"rgba":"rgba(145, 112, 184, 1)"},"ouiColorVis4":{"r":202,"g":142,"b":174,"a":1,"rgba":"rgba(202, 142, 174, 1)"},"ouiColorVis5":{"r":214,"g":191,"b":87,"a":1,"rgba":"rgba(214, 191, 87, 1)"},"ouiColorVis6":{"r":185,"g":168,"b":136,"a":1,"rgba":"rgba(185, 168, 136, 1)"},"ouiColorVis7":{"r":218,"g":139,"b":69,"a":1,"rgba":"rgba(218, 139, 69, 1)"},"ouiColorVis8":{"r":170,"g":101,"b":86,"a":1,"rgba":"rgba(170, 101, 86, 1)"},"ouiColorVis9":{"r":231,"g":102,"b":76,"a":1,"rgba":"rgba(231, 102, 76, 1)"},"ouiColorVis0BehindText":{"r":109,"g":204,"b":177,"a":1,"rgba":"rgba(109, 204, 177, 1)"},"ouiColorVis1BehindText":{"r":121,"g":170,"b":217,"a":1,"rgba":"rgba(121, 170, 217, 1)"},"ouiColorVis2BehindText":{"r":238,"g":120,"b":157,"a":1,"rgba":"rgba(238, 120, 157, 1)"},"ouiColorVis3BehindText":{"r":169,"g":135,"b":209,"a":1,"rgba":"rgba(169, 135, 209, 1)"},"ouiColorVis4BehindText":{"r":228,"g":166,"b":199,"a":1,"rgba":"rgba(228, 166, 199, 1)"},"ouiColorVis5BehindText":{"r":241,"g":216,"b":111,"a":1,"rgba":"rgba(241, 216, 111, 1)"},"ouiColorVis6BehindText":{"r":210,"g":192,"b":160,"a":1,"rgba":"rgba(210, 192, 160, 1)"},"ouiColorVis7BehindText":{"r":245,"g":163,"b":92,"a":1,"rgba":"rgba(245, 163, 92, 1)"},"ouiColorVis8BehindText":{"r":196,"g":124,"b":108,"a":1,"rgba":"rgba(196, 124, 108, 1)"},"ouiColorVis9BehindText":{"r":255,"g":126,"b":98,"a":1,"rgba":"rgba(255, 126, 98, 1)"},"ouiColorChartLines":{"r":238,"g":240,"b":243,"a":1,"rgba":"rgba(238, 240, 243, 1)"},"ouiColorChartBand":{"r":245,"g":247,"b":250,"a":1,"rgba":"rgba(245, 247, 250, 1)"},"ouiCodeBlockBackgroundColor":{"r":245,"g":247,"b":250,"a":1,"rgba":"rgba(245, 247, 250, 1)"},"ouiCodeBlockColor":{"r":52,"g":55,"b":65,"a":1,"rgba":"rgba(52, 55, 65, 1)"},"ouiCodeBlockSelectedBackgroundColor":"inherit","ouiCodeBlockCommentColor":{"r":106,"g":113,"b":125,"a":1,"rgba":"rgba(106, 113, 125, 1)"},"ouiCodeBlockSelectorTagColor":"inherit","ouiCodeBlockStringColor":{"r":172,"g":78,"b":109,"a":1,"rgba":"rgba(172, 78, 109, 1)"},"ouiCodeBlockTagColor":{"r":74,"g":113,"b":148,"a":1,"rgba":"rgba(74, 113, 148, 1)"},"ouiCodeBlockNameColor":{"r":74,"g":113,"b":148,"a":1,"rgba":"rgba(74, 113, 148, 1)"},"ouiCodeBlockNumberColor":{"r":59,"g":125,"b":106,"a":1,"rgba":"rgba(59, 125, 106, 1)"},"ouiCodeBlockKeywordColor":{"r":124,"g":96,"b":158,"a":1,"rgba":"rgba(124, 96, 158, 1)"},"ouiCodeBlockFunctionTitleColor":"inherit","ouiCodeBlockTypeColor":{"r":74,"g":113,"b":148,"a":1,"rgba":"rgba(74, 113, 148, 1)"},"ouiCodeBlockAttributeColor":"inherit","ouiCodeBlockSymbolColor":{"r":179,"g":79,"b":59,"a":1,"rgba":"rgba(179, 79, 59, 1)"},"ouiCodeBlockParamsColor":"inherit","ouiCodeBlockMetaColor":{"r":106,"g":113,"b":125,"a":1,"rgba":"rgba(106, 113, 125, 1)"},"ouiCodeBlockTitleColor":{"r":153,"g":97,"b":48,"a":1,"rgba":"rgba(153, 97, 48, 1)"},"ouiCodeBlockSectionColor":{"r":179,"g":79,"b":59,"a":1,"rgba":"rgba(179, 79, 59, 1)"},"ouiCodeBlockAdditionColor":{"r":59,"g":125,"b":106,"a":1,"rgba":"rgba(59, 125, 106, 1)"},"ouiCodeBlockDeletionColor":{"r":189,"g":39,"b":30,"a":1,"rgba":"rgba(189, 39, 30, 1)"},"ouiCodeBlockSelectorClassColor":"inherit","ouiCodeBlockSelectorIdColor":"inherit","euiColorGhost":{"r":255,"g":255,"b":255,"a":1,"rgba":"rgba(255, 255, 255, 1)"},"euiColorInk":{"r":0,"g":0,"b":0,"a":1,"rgba":"rgba(0, 0, 0, 1)"},"euiColorPrimary":{"r":0,"g":107,"b":180,"a":1,"rgba":"rgba(0, 107, 180, 1)"},"euiColorSecondary":{"r":1,"g":125,"b":115,"a":1,"rgba":"rgba(1, 125, 115, 1)"},"euiColorAccent":{"r":221,"g":10,"b":115,"a":1,"rgba":"rgba(221, 10, 115, 1)"},"euiColorSuccess":{"r":1,"g":125,"b":115,"a":1,"rgba":"rgba(1, 125, 115, 1)"},"euiColorWarning":{"r":245,"g":167,"b":0,"a":1,"rgba":"rgba(245, 167, 0, 1)"},"euiColorDanger":{"r":189,"g":39,"b":30,"a":1,"rgba":"rgba(189, 39, 30, 1)"},"euiColorEmptyShade":{"r":255,"g":255,"b":255,"a":1,"rgba":"rgba(255, 255, 255, 1)"},"euiColorLightestShade":{"r":245,"g":247,"b":250,"a":1,"rgba":"rgba(245, 247, 250, 1)"},"euiColorLightShade":{"r":211,"g":218,"b":230,"a":1,"rgba":"rgba(211, 218, 230, 1)"},"euiColorMediumShade":{"r":152,"g":162,"b":179,"a":1,"rgba":"rgba(152, 162, 179, 1)"},"euiColorDarkShade":{"r":105,"g":112,"b":125,"a":1,"rgba":"rgba(105, 112, 125, 1)"},"euiColorDarkestShade":{"r":52,"g":55,"b":65,"a":1,"rgba":"rgba(52, 55, 65, 1)"},"euiColorFullShade":{"r":0,"g":0,"b":0,"a":1,"rgba":"rgba(0, 0, 0, 1)"},"euiPageBackgroundColor":{"r":250,"g":251,"b":253,"a":1,"rgba":"rgba(250, 251, 253, 1)"},"euiColorHighlight":{"r":255,"g":252,"b":221,"a":1,"rgba":"rgba(255, 252, 221, 1)"},"euiTextColor":{"r":52,"g":55,"b":65,"a":1,"rgba":"rgba(52, 55, 65, 1)"},"euiTitleColor":{"r":26,"g":28,"b":33,"a":1,"rgba":"rgba(26, 28, 33, 1)"},"euiTextSubduedColor":{"r":106,"g":113,"b":125,"a":1,"rgba":"rgba(106, 113, 125, 1)"},"euiColorDisabled":{"r":194,"g":195,"b":198,"a":1,"rgba":"rgba(194, 195, 198, 1)"},"euiColorPrimaryText":{"r":0,"g":107,"b":180,"a":1,"rgba":"rgba(0, 107, 180, 1)"},"euiColorSecondaryText":{"r":1,"g":125,"b":115,"a":1,"rgba":"rgba(1, 125, 115, 1)"},"euiColorAccentText":{"r":221,"g":10,"b":115,"a":1,"rgba":"rgba(221, 10, 115, 1)"},"euiColorWarningText":{"r":155,"g":105,"b":0,"a":1,"rgba":"rgba(155, 105, 0, 1)"},"euiColorDangerText":{"r":189,"g":39,"b":30,"a":1,"rgba":"rgba(189, 39, 30, 1)"},"euiColorDisabledText":{"r":175,"g":176,"b":179,"a":1,"rgba":"rgba(175, 176, 179, 1)"},"euiColorSuccessText":{"r":1,"g":125,"b":115,"a":1,"rgba":"rgba(1, 125, 115, 1)"},"euiLinkColor":{"r":0,"g":107,"b":180,"a":1,"rgba":"rgba(0, 107, 180, 1)"},"euiPaletteColorBlind":{"euiColorVis0":{"graphic":{"r":84,"g":179,"b":153,"a":1,"rgba":"rgba(84, 179, 153, 1)"},"behindText":{"r":109,"g":204,"b":177,"a":1,"rgba":"rgba(109, 204, 177, 1)"}},"euiColorVis1":{"graphic":{"r":96,"g":146,"b":192,"a":1,"rgba":"rgba(96, 146, 192, 1)"},"behindText":{"r":121,"g":170,"b":217,"a":1,"rgba":"rgba(121, 170, 217, 1)"}},"euiColorVis2":{"graphic":{"r":211,"g":96,"b":134,"a":1,"rgba":"rgba(211, 96, 134, 1)"},"behindText":{"r":238,"g":120,"b":157,"a":1,"rgba":"rgba(238, 120, 157, 1)"}},"euiColorVis3":{"graphic":{"r":145,"g":112,"b":184,"a":1,"rgba":"rgba(145, 112, 184, 1)"},"behindText":{"r":169,"g":135,"b":209,"a":1,"rgba":"rgba(169, 135, 209, 1)"}},"euiColorVis4":{"graphic":{"r":202,"g":142,"b":174,"a":1,"rgba":"rgba(202, 142, 174, 1)"},"behindText":{"r":228,"g":166,"b":199,"a":1,"rgba":"rgba(228, 166, 199, 1)"}},"euiColorVis5":{"graphic":{"r":214,"g":191,"b":87,"a":1,"rgba":"rgba(214, 191, 87, 1)"},"behindText":{"r":241,"g":216,"b":111,"a":1,"rgba":"rgba(241, 216, 111, 1)"}},"euiColorVis6":{"graphic":{"r":185,"g":168,"b":136,"a":1,"rgba":"rgba(185, 168, 136, 1)"},"behindText":{"r":210,"g":192,"b":160,"a":1,"rgba":"rgba(210, 192, 160, 1)"}},"euiColorVis7":{"graphic":{"r":218,"g":139,"b":69,"a":1,"rgba":"rgba(218, 139, 69, 1)"},"behindText":{"r":245,"g":163,"b":92,"a":1,"rgba":"rgba(245, 163, 92, 1)"}},"euiColorVis8":{"graphic":{"r":170,"g":101,"b":86,"a":1,"rgba":"rgba(170, 101, 86, 1)"},"behindText":{"r":196,"g":124,"b":108,"a":1,"rgba":"rgba(196, 124, 108, 1)"}},"euiColorVis9":{"graphic":{"r":231,"g":102,"b":76,"a":1,"rgba":"rgba(231, 102, 76, 1)"},"behindText":{"r":255,"g":126,"b":98,"a":1,"rgba":"rgba(255, 126, 98, 1)"}}},"euiPaletteColorBlindKeys":["euiColorVis0","euiColorVis1","euiColorVis2","euiColorVis3","euiColorVis4","euiColorVis5","euiColorVis6","euiColorVis7","euiColorVis8","euiColorVis9"],"euiColorVis0":{"r":84,"g":179,"b":153,"a":1,"rgba":"rgba(84, 179, 153, 1)"},"euiColorVis1":{"r":96,"g":146,"b":192,"a":1,"rgba":"rgba(96, 146, 192, 1)"},"euiColorVis2":{"r":211,"g":96,"b":134,"a":1,"rgba":"rgba(211, 96, 134, 1)"},"euiColorVis3":{"r":145,"g":112,"b":184,"a":1,"rgba":"rgba(145, 112, 184, 1)"},"euiColorVis4":{"r":202,"g":142,"b":174,"a":1,"rgba":"rgba(202, 142, 174, 1)"},"euiColorVis5":{"r":214,"g":191,"b":87,"a":1,"rgba":"rgba(214, 191, 87, 1)"},"euiColorVis6":{"r":185,"g":168,"b":136,"a":1,"rgba":"rgba(185, 168, 136, 1)"},"euiColorVis7":{"r":218,"g":139,"b":69,"a":1,"rgba":"rgba(218, 139, 69, 1)"},"euiColorVis8":{"r":170,"g":101,"b":86,"a":1,"rgba":"rgba(170, 101, 86, 1)"},"euiColorVis9":{"r":231,"g":102,"b":76,"a":1,"rgba":"rgba(231, 102, 76, 1)"},"euiColorVis0BehindText":{"r":109,"g":204,"b":177,"a":1,"rgba":"rgba(109, 204, 177, 1)"},"euiColorVis1BehindText":{"r":121,"g":170,"b":217,"a":1,"rgba":"rgba(121, 170, 217, 1)"},"euiColorVis2BehindText":{"r":238,"g":120,"b":157,"a":1,"rgba":"rgba(238, 120, 157, 1)"},"euiColorVis3BehindText":{"r":169,"g":135,"b":209,"a":1,"rgba":"rgba(169, 135, 209, 1)"},"euiColorVis4BehindText":{"r":228,"g":166,"b":199,"a":1,"rgba":"rgba(228, 166, 199, 1)"},"euiColorVis5BehindText":{"r":241,"g":216,"b":111,"a":1,"rgba":"rgba(241, 216, 111, 1)"},"euiColorVis6BehindText":{"r":210,"g":192,"b":160,"a":1,"rgba":"rgba(210, 192, 160, 1)"},"euiColorVis7BehindText":{"r":245,"g":163,"b":92,"a":1,"rgba":"rgba(245, 163, 92, 1)"},"euiColorVis8BehindText":{"r":196,"g":124,"b":108,"a":1,"rgba":"rgba(196, 124, 108, 1)"},"euiColorVis9BehindText":{"r":255,"g":126,"b":98,"a":1,"rgba":"rgba(255, 126, 98, 1)"},"euiColorChartLines":{"r":238,"g":240,"b":243,"a":1,"rgba":"rgba(238, 240, 243, 1)"},"euiColorChartBand":{"r":245,"g":247,"b":250,"a":1,"rgba":"rgba(245, 247, 250, 1)"},"euiCodeBlockBackgroundColor":{"r":245,"g":247,"b":250,"a":1,"rgba":"rgba(245, 247, 250, 1)"},"euiCodeBlockColor":{"r":52,"g":55,"b":65,"a":1,"rgba":"rgba(52, 55, 65, 1)"},"euiCodeBlockSelectedBackgroundColor":"inherit","euiCodeBlockCommentColor":{"r":106,"g":113,"b":125,"a":1,"rgba":"rgba(106, 113, 125, 1)"},"euiCodeBlockSelectorTagColor":"inherit","euiCodeBlockStringColor":{"r":172,"g":78,"b":109,"a":1,"rgba":"rgba(172, 78, 109, 1)"},"euiCodeBlockTagColor":{"r":74,"g":113,"b":148,"a":1,"rgba":"rgba(74, 113, 148, 1)"},"euiCodeBlockNameColor":{"r":74,"g":113,"b":148,"a":1,"rgba":"rgba(74, 113, 148, 1)"},"euiCodeBlockNumberColor":{"r":59,"g":125,"b":106,"a":1,"rgba":"rgba(59, 125, 106, 1)"},"euiCodeBlockKeywordColor":{"r":124,"g":96,"b":158,"a":1,"rgba":"rgba(124, 96, 158, 1)"},"euiCodeBlockFunctionTitleColor":"inherit","euiCodeBlockTypeColor":{"r":74,"g":113,"b":148,"a":1,"rgba":"rgba(74, 113, 148, 1)"},"euiCodeBlockAttributeColor":"inherit","euiCodeBlockSymbolColor":{"r":179,"g":79,"b":59,"a":1,"rgba":"rgba(179, 79, 59, 1)"},"euiCodeBlockParamsColor":"inherit","euiCodeBlockMetaColor":{"r":106,"g":113,"b":125,"a":1,"rgba":"rgba(106, 113, 125, 1)"},"euiCodeBlockTitleColor":{"r":153,"g":97,"b":48,"a":1,"rgba":"rgba(153, 97, 48, 1)"},"euiCodeBlockSectionColor":{"r":179,"g":79,"b":59,"a":1,"rgba":"rgba(179, 79, 59, 1)"},"euiCodeBlockAdditionColor":{"r":59,"g":125,"b":106,"a":1,"rgba":"rgba(59, 125, 106, 1)"},"euiCodeBlockDeletionColor":{"r":189,"g":39,"b":30,"a":1,"rgba":"rgba(189, 39, 30, 1)"},"euiCodeBlockSelectorClassColor":"inherit","euiCodeBlockSelectorIdColor":"inherit"});


/***/ }),

/***/ "../node_modules/sass-vars-to-js-loader/index.js!./themes/oui/oui_colors_dark.scss":
/*!********************************************************************************!*\
  !*** ../node_modules/sass-vars-to-js-loader!./themes/oui/oui_colors_dark.scss ***!
  \********************************************************************************/
/*! exports provided: ouiColorGhost, ouiColorInk, ouiColorPrimary, ouiColorSecondary, ouiColorAccent, ouiColorSuccess, ouiColorWarning, ouiColorDanger, ouiColorEmptyShade, ouiColorLightestShade, ouiColorLightShade, ouiColorMediumShade, ouiColorDarkShade, ouiColorDarkestShade, ouiColorFullShade, ouiPageBackgroundColor, ouiColorHighlight, ouiTextColor, ouiTitleColor, ouiTextSubduedColor, ouiColorDisabled, ouiColorPrimaryText, ouiColorSecondaryText, ouiColorAccentText, ouiColorWarningText, ouiColorDangerText, ouiColorDisabledText, ouiColorSuccessText, ouiLinkColor, ouiColorChartLines, ouiColorChartBand, ouiShadowColor, ouiShadowColorLarge, euiColorGhost, euiColorInk, euiColorPrimary, euiColorSecondary, euiColorAccent, euiColorSuccess, euiColorWarning, euiColorDanger, euiColorEmptyShade, euiColorLightestShade, euiColorLightShade, euiColorMediumShade, euiColorDarkShade, euiColorDarkestShade, euiColorFullShade, euiPageBackgroundColor, euiColorHighlight, euiTextColor, euiTitleColor, euiTextSubduedColor, euiColorDisabled, euiColorPrimaryText, euiColorSecondaryText, euiColorAccentText, euiColorWarningText, euiColorDangerText, euiColorDisabledText, euiColorSuccessText, euiLinkColor, euiColorChartLines, euiColorChartBand, euiShadowColor, euiShadowColorLarge, default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ouiColorGhost", function() { return ouiColorGhost; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ouiColorInk", function() { return ouiColorInk; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ouiColorPrimary", function() { return ouiColorPrimary; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ouiColorSecondary", function() { return ouiColorSecondary; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ouiColorAccent", function() { return ouiColorAccent; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ouiColorSuccess", function() { return ouiColorSuccess; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ouiColorWarning", function() { return ouiColorWarning; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ouiColorDanger", function() { return ouiColorDanger; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ouiColorEmptyShade", function() { return ouiColorEmptyShade; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ouiColorLightestShade", function() { return ouiColorLightestShade; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ouiColorLightShade", function() { return ouiColorLightShade; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ouiColorMediumShade", function() { return ouiColorMediumShade; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ouiColorDarkShade", function() { return ouiColorDarkShade; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ouiColorDarkestShade", function() { return ouiColorDarkestShade; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ouiColorFullShade", function() { return ouiColorFullShade; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ouiPageBackgroundColor", function() { return ouiPageBackgroundColor; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ouiColorHighlight", function() { return ouiColorHighlight; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ouiTextColor", function() { return ouiTextColor; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ouiTitleColor", function() { return ouiTitleColor; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ouiTextSubduedColor", function() { return ouiTextSubduedColor; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ouiColorDisabled", function() { return ouiColorDisabled; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ouiColorPrimaryText", function() { return ouiColorPrimaryText; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ouiColorSecondaryText", function() { return ouiColorSecondaryText; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ouiColorAccentText", function() { return ouiColorAccentText; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ouiColorWarningText", function() { return ouiColorWarningText; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ouiColorDangerText", function() { return ouiColorDangerText; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ouiColorDisabledText", function() { return ouiColorDisabledText; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ouiColorSuccessText", function() { return ouiColorSuccessText; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ouiLinkColor", function() { return ouiLinkColor; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ouiColorChartLines", function() { return ouiColorChartLines; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ouiColorChartBand", function() { return ouiColorChartBand; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ouiShadowColor", function() { return ouiShadowColor; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ouiShadowColorLarge", function() { return ouiShadowColorLarge; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "euiColorGhost", function() { return euiColorGhost; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "euiColorInk", function() { return euiColorInk; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "euiColorPrimary", function() { return euiColorPrimary; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "euiColorSecondary", function() { return euiColorSecondary; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "euiColorAccent", function() { return euiColorAccent; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "euiColorSuccess", function() { return euiColorSuccess; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "euiColorWarning", function() { return euiColorWarning; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "euiColorDanger", function() { return euiColorDanger; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "euiColorEmptyShade", function() { return euiColorEmptyShade; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "euiColorLightestShade", function() { return euiColorLightestShade; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "euiColorLightShade", function() { return euiColorLightShade; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "euiColorMediumShade", function() { return euiColorMediumShade; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "euiColorDarkShade", function() { return euiColorDarkShade; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "euiColorDarkestShade", function() { return euiColorDarkestShade; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "euiColorFullShade", function() { return euiColorFullShade; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "euiPageBackgroundColor", function() { return euiPageBackgroundColor; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "euiColorHighlight", function() { return euiColorHighlight; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "euiTextColor", function() { return euiTextColor; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "euiTitleColor", function() { return euiTitleColor; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "euiTextSubduedColor", function() { return euiTextSubduedColor; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "euiColorDisabled", function() { return euiColorDisabled; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "euiColorPrimaryText", function() { return euiColorPrimaryText; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "euiColorSecondaryText", function() { return euiColorSecondaryText; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "euiColorAccentText", function() { return euiColorAccentText; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "euiColorWarningText", function() { return euiColorWarningText; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "euiColorDangerText", function() { return euiColorDangerText; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "euiColorDisabledText", function() { return euiColorDisabledText; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "euiColorSuccessText", function() { return euiColorSuccessText; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "euiLinkColor", function() { return euiLinkColor; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "euiColorChartLines", function() { return euiColorChartLines; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "euiColorChartBand", function() { return euiColorChartBand; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "euiShadowColor", function() { return euiShadowColor; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "euiShadowColorLarge", function() { return euiShadowColorLarge; });
var ouiColorGhost = {"r":255,"g":255,"b":255,"a":1,"rgba":"rgba(255, 255, 255, 1)"}
var ouiColorInk = {"r":0,"g":0,"b":0,"a":1,"rgba":"rgba(0, 0, 0, 1)"}
var ouiColorPrimary = {"r":27,"g":169,"b":245,"a":1,"rgba":"rgba(27, 169, 245, 1)"}
var ouiColorSecondary = {"r":125,"g":226,"b":209,"a":1,"rgba":"rgba(125, 226, 209, 1)"}
var ouiColorAccent = {"r":249,"g":144,"b":192,"a":1,"rgba":"rgba(249, 144, 192, 1)"}
var ouiColorSuccess = {"r":125,"g":226,"b":209,"a":1,"rgba":"rgba(125, 226, 209, 1)"}
var ouiColorWarning = {"r":255,"g":206,"b":122,"a":1,"rgba":"rgba(255, 206, 122, 1)"}
var ouiColorDanger = {"r":255,"g":102,"b":102,"a":1,"rgba":"rgba(255, 102, 102, 1)"}
var ouiColorEmptyShade = {"r":29,"g":30,"b":36,"a":1,"rgba":"rgba(29, 30, 36, 1)"}
var ouiColorLightestShade = {"r":37,"g":38,"b":46,"a":1,"rgba":"rgba(37, 38, 46, 1)"}
var ouiColorLightShade = {"r":52,"g":55,"b":65,"a":1,"rgba":"rgba(52, 55, 65, 1)"}
var ouiColorMediumShade = {"r":83,"g":89,"b":102,"a":1,"rgba":"rgba(83, 89, 102, 1)"}
var ouiColorDarkShade = {"r":152,"g":162,"b":179,"a":1,"rgba":"rgba(152, 162, 179, 1)"}
var ouiColorDarkestShade = {"r":212,"g":218,"b":229,"a":1,"rgba":"rgba(212, 218, 229, 1)"}
var ouiColorFullShade = {"r":255,"g":255,"b":255,"a":1,"rgba":"rgba(255, 255, 255, 1)"}
var ouiPageBackgroundColor = {"r":20,"g":21,"b":25,"a":1,"rgba":"rgba(20, 21, 25, 1)"}
var ouiColorHighlight = {"r":46,"g":45,"b":37,"a":1,"rgba":"rgba(46, 45, 37, 1)"}
var ouiTextColor = {"r":223,"g":229,"b":239,"a":1,"rgba":"rgba(223, 229, 239, 1)"}
var ouiTitleColor = {"r":223,"g":229,"b":239,"a":1,"rgba":"rgba(223, 229, 239, 1)"}
var ouiTextSubduedColor = {"r":122,"g":127,"b":137,"a":1,"rgba":"rgba(122, 127, 137, 1)"}
var ouiColorDisabled = {"r":67,"g":69,"b":72,"a":1,"rgba":"rgba(67, 69, 72, 1)"}
var ouiColorPrimaryText = {"r":27,"g":169,"b":245,"a":1,"rgba":"rgba(27, 169, 245, 1)"}
var ouiColorSecondaryText = {"r":125,"g":226,"b":209,"a":1,"rgba":"rgba(125, 226, 209, 1)"}
var ouiColorAccentText = {"r":249,"g":144,"b":192,"a":1,"rgba":"rgba(249, 144, 192, 1)"}
var ouiColorWarningText = {"r":255,"g":206,"b":122,"a":1,"rgba":"rgba(255, 206, 122, 1)"}
var ouiColorDangerText = {"r":255,"g":102,"b":102,"a":1,"rgba":"rgba(255, 102, 102, 1)"}
var ouiColorDisabledText = {"r":76,"g":78,"b":81,"a":1,"rgba":"rgba(76, 78, 81, 1)"}
var ouiColorSuccessText = {"r":125,"g":226,"b":209,"a":1,"rgba":"rgba(125, 226, 209, 1)"}
var ouiLinkColor = {"r":27,"g":169,"b":245,"a":1,"rgba":"rgba(27, 169, 245, 1)"}
var ouiColorChartLines = {"r":52,"g":55,"b":65,"a":1,"rgba":"rgba(52, 55, 65, 1)"}
var ouiColorChartBand = {"r":42,"g":43,"b":51,"a":1,"rgba":"rgba(42, 43, 51, 1)"}
var ouiShadowColor = {"r":0,"g":0,"b":0,"a":1,"rgba":"rgba(0, 0, 0, 1)"}
var ouiShadowColorLarge = {"r":0,"g":0,"b":0,"a":1,"rgba":"rgba(0, 0, 0, 1)"}
var euiColorGhost = {"r":255,"g":255,"b":255,"a":1,"rgba":"rgba(255, 255, 255, 1)"}
var euiColorInk = {"r":0,"g":0,"b":0,"a":1,"rgba":"rgba(0, 0, 0, 1)"}
var euiColorPrimary = {"r":27,"g":169,"b":245,"a":1,"rgba":"rgba(27, 169, 245, 1)"}
var euiColorSecondary = {"r":125,"g":226,"b":209,"a":1,"rgba":"rgba(125, 226, 209, 1)"}
var euiColorAccent = {"r":249,"g":144,"b":192,"a":1,"rgba":"rgba(249, 144, 192, 1)"}
var euiColorSuccess = {"r":125,"g":226,"b":209,"a":1,"rgba":"rgba(125, 226, 209, 1)"}
var euiColorWarning = {"r":255,"g":206,"b":122,"a":1,"rgba":"rgba(255, 206, 122, 1)"}
var euiColorDanger = {"r":255,"g":102,"b":102,"a":1,"rgba":"rgba(255, 102, 102, 1)"}
var euiColorEmptyShade = {"r":29,"g":30,"b":36,"a":1,"rgba":"rgba(29, 30, 36, 1)"}
var euiColorLightestShade = {"r":37,"g":38,"b":46,"a":1,"rgba":"rgba(37, 38, 46, 1)"}
var euiColorLightShade = {"r":52,"g":55,"b":65,"a":1,"rgba":"rgba(52, 55, 65, 1)"}
var euiColorMediumShade = {"r":83,"g":89,"b":102,"a":1,"rgba":"rgba(83, 89, 102, 1)"}
var euiColorDarkShade = {"r":152,"g":162,"b":179,"a":1,"rgba":"rgba(152, 162, 179, 1)"}
var euiColorDarkestShade = {"r":212,"g":218,"b":229,"a":1,"rgba":"rgba(212, 218, 229, 1)"}
var euiColorFullShade = {"r":255,"g":255,"b":255,"a":1,"rgba":"rgba(255, 255, 255, 1)"}
var euiPageBackgroundColor = {"r":20,"g":21,"b":25,"a":1,"rgba":"rgba(20, 21, 25, 1)"}
var euiColorHighlight = {"r":46,"g":45,"b":37,"a":1,"rgba":"rgba(46, 45, 37, 1)"}
var euiTextColor = {"r":223,"g":229,"b":239,"a":1,"rgba":"rgba(223, 229, 239, 1)"}
var euiTitleColor = {"r":223,"g":229,"b":239,"a":1,"rgba":"rgba(223, 229, 239, 1)"}
var euiTextSubduedColor = {"r":122,"g":127,"b":137,"a":1,"rgba":"rgba(122, 127, 137, 1)"}
var euiColorDisabled = {"r":67,"g":69,"b":72,"a":1,"rgba":"rgba(67, 69, 72, 1)"}
var euiColorPrimaryText = {"r":27,"g":169,"b":245,"a":1,"rgba":"rgba(27, 169, 245, 1)"}
var euiColorSecondaryText = {"r":125,"g":226,"b":209,"a":1,"rgba":"rgba(125, 226, 209, 1)"}
var euiColorAccentText = {"r":249,"g":144,"b":192,"a":1,"rgba":"rgba(249, 144, 192, 1)"}
var euiColorWarningText = {"r":255,"g":206,"b":122,"a":1,"rgba":"rgba(255, 206, 122, 1)"}
var euiColorDangerText = {"r":255,"g":102,"b":102,"a":1,"rgba":"rgba(255, 102, 102, 1)"}
var euiColorDisabledText = {"r":76,"g":78,"b":81,"a":1,"rgba":"rgba(76, 78, 81, 1)"}
var euiColorSuccessText = {"r":125,"g":226,"b":209,"a":1,"rgba":"rgba(125, 226, 209, 1)"}
var euiLinkColor = {"r":27,"g":169,"b":245,"a":1,"rgba":"rgba(27, 169, 245, 1)"}
var euiColorChartLines = {"r":52,"g":55,"b":65,"a":1,"rgba":"rgba(52, 55, 65, 1)"}
var euiColorChartBand = {"r":42,"g":43,"b":51,"a":1,"rgba":"rgba(42, 43, 51, 1)"}
var euiShadowColor = {"r":0,"g":0,"b":0,"a":1,"rgba":"rgba(0, 0, 0, 1)"}
var euiShadowColorLarge = {"r":0,"g":0,"b":0,"a":1,"rgba":"rgba(0, 0, 0, 1)"}
/* harmony default export */ __webpack_exports__["default"] = ({"ouiColorGhost":{"r":255,"g":255,"b":255,"a":1,"rgba":"rgba(255, 255, 255, 1)"},"ouiColorInk":{"r":0,"g":0,"b":0,"a":1,"rgba":"rgba(0, 0, 0, 1)"},"ouiColorPrimary":{"r":27,"g":169,"b":245,"a":1,"rgba":"rgba(27, 169, 245, 1)"},"ouiColorSecondary":{"r":125,"g":226,"b":209,"a":1,"rgba":"rgba(125, 226, 209, 1)"},"ouiColorAccent":{"r":249,"g":144,"b":192,"a":1,"rgba":"rgba(249, 144, 192, 1)"},"ouiColorSuccess":{"r":125,"g":226,"b":209,"a":1,"rgba":"rgba(125, 226, 209, 1)"},"ouiColorWarning":{"r":255,"g":206,"b":122,"a":1,"rgba":"rgba(255, 206, 122, 1)"},"ouiColorDanger":{"r":255,"g":102,"b":102,"a":1,"rgba":"rgba(255, 102, 102, 1)"},"ouiColorEmptyShade":{"r":29,"g":30,"b":36,"a":1,"rgba":"rgba(29, 30, 36, 1)"},"ouiColorLightestShade":{"r":37,"g":38,"b":46,"a":1,"rgba":"rgba(37, 38, 46, 1)"},"ouiColorLightShade":{"r":52,"g":55,"b":65,"a":1,"rgba":"rgba(52, 55, 65, 1)"},"ouiColorMediumShade":{"r":83,"g":89,"b":102,"a":1,"rgba":"rgba(83, 89, 102, 1)"},"ouiColorDarkShade":{"r":152,"g":162,"b":179,"a":1,"rgba":"rgba(152, 162, 179, 1)"},"ouiColorDarkestShade":{"r":212,"g":218,"b":229,"a":1,"rgba":"rgba(212, 218, 229, 1)"},"ouiColorFullShade":{"r":255,"g":255,"b":255,"a":1,"rgba":"rgba(255, 255, 255, 1)"},"ouiPageBackgroundColor":{"r":20,"g":21,"b":25,"a":1,"rgba":"rgba(20, 21, 25, 1)"},"ouiColorHighlight":{"r":46,"g":45,"b":37,"a":1,"rgba":"rgba(46, 45, 37, 1)"},"ouiTextColor":{"r":223,"g":229,"b":239,"a":1,"rgba":"rgba(223, 229, 239, 1)"},"ouiTitleColor":{"r":223,"g":229,"b":239,"a":1,"rgba":"rgba(223, 229, 239, 1)"},"ouiTextSubduedColor":{"r":122,"g":127,"b":137,"a":1,"rgba":"rgba(122, 127, 137, 1)"},"ouiColorDisabled":{"r":67,"g":69,"b":72,"a":1,"rgba":"rgba(67, 69, 72, 1)"},"ouiColorPrimaryText":{"r":27,"g":169,"b":245,"a":1,"rgba":"rgba(27, 169, 245, 1)"},"ouiColorSecondaryText":{"r":125,"g":226,"b":209,"a":1,"rgba":"rgba(125, 226, 209, 1)"},"ouiColorAccentText":{"r":249,"g":144,"b":192,"a":1,"rgba":"rgba(249, 144, 192, 1)"},"ouiColorWarningText":{"r":255,"g":206,"b":122,"a":1,"rgba":"rgba(255, 206, 122, 1)"},"ouiColorDangerText":{"r":255,"g":102,"b":102,"a":1,"rgba":"rgba(255, 102, 102, 1)"},"ouiColorDisabledText":{"r":76,"g":78,"b":81,"a":1,"rgba":"rgba(76, 78, 81, 1)"},"ouiColorSuccessText":{"r":125,"g":226,"b":209,"a":1,"rgba":"rgba(125, 226, 209, 1)"},"ouiLinkColor":{"r":27,"g":169,"b":245,"a":1,"rgba":"rgba(27, 169, 245, 1)"},"ouiColorChartLines":{"r":52,"g":55,"b":65,"a":1,"rgba":"rgba(52, 55, 65, 1)"},"ouiColorChartBand":{"r":42,"g":43,"b":51,"a":1,"rgba":"rgba(42, 43, 51, 1)"},"ouiShadowColor":{"r":0,"g":0,"b":0,"a":1,"rgba":"rgba(0, 0, 0, 1)"},"ouiShadowColorLarge":{"r":0,"g":0,"b":0,"a":1,"rgba":"rgba(0, 0, 0, 1)"},"euiColorGhost":{"r":255,"g":255,"b":255,"a":1,"rgba":"rgba(255, 255, 255, 1)"},"euiColorInk":{"r":0,"g":0,"b":0,"a":1,"rgba":"rgba(0, 0, 0, 1)"},"euiColorPrimary":{"r":27,"g":169,"b":245,"a":1,"rgba":"rgba(27, 169, 245, 1)"},"euiColorSecondary":{"r":125,"g":226,"b":209,"a":1,"rgba":"rgba(125, 226, 209, 1)"},"euiColorAccent":{"r":249,"g":144,"b":192,"a":1,"rgba":"rgba(249, 144, 192, 1)"},"euiColorSuccess":{"r":125,"g":226,"b":209,"a":1,"rgba":"rgba(125, 226, 209, 1)"},"euiColorWarning":{"r":255,"g":206,"b":122,"a":1,"rgba":"rgba(255, 206, 122, 1)"},"euiColorDanger":{"r":255,"g":102,"b":102,"a":1,"rgba":"rgba(255, 102, 102, 1)"},"euiColorEmptyShade":{"r":29,"g":30,"b":36,"a":1,"rgba":"rgba(29, 30, 36, 1)"},"euiColorLightestShade":{"r":37,"g":38,"b":46,"a":1,"rgba":"rgba(37, 38, 46, 1)"},"euiColorLightShade":{"r":52,"g":55,"b":65,"a":1,"rgba":"rgba(52, 55, 65, 1)"},"euiColorMediumShade":{"r":83,"g":89,"b":102,"a":1,"rgba":"rgba(83, 89, 102, 1)"},"euiColorDarkShade":{"r":152,"g":162,"b":179,"a":1,"rgba":"rgba(152, 162, 179, 1)"},"euiColorDarkestShade":{"r":212,"g":218,"b":229,"a":1,"rgba":"rgba(212, 218, 229, 1)"},"euiColorFullShade":{"r":255,"g":255,"b":255,"a":1,"rgba":"rgba(255, 255, 255, 1)"},"euiPageBackgroundColor":{"r":20,"g":21,"b":25,"a":1,"rgba":"rgba(20, 21, 25, 1)"},"euiColorHighlight":{"r":46,"g":45,"b":37,"a":1,"rgba":"rgba(46, 45, 37, 1)"},"euiTextColor":{"r":223,"g":229,"b":239,"a":1,"rgba":"rgba(223, 229, 239, 1)"},"euiTitleColor":{"r":223,"g":229,"b":239,"a":1,"rgba":"rgba(223, 229, 239, 1)"},"euiTextSubduedColor":{"r":122,"g":127,"b":137,"a":1,"rgba":"rgba(122, 127, 137, 1)"},"euiColorDisabled":{"r":67,"g":69,"b":72,"a":1,"rgba":"rgba(67, 69, 72, 1)"},"euiColorPrimaryText":{"r":27,"g":169,"b":245,"a":1,"rgba":"rgba(27, 169, 245, 1)"},"euiColorSecondaryText":{"r":125,"g":226,"b":209,"a":1,"rgba":"rgba(125, 226, 209, 1)"},"euiColorAccentText":{"r":249,"g":144,"b":192,"a":1,"rgba":"rgba(249, 144, 192, 1)"},"euiColorWarningText":{"r":255,"g":206,"b":122,"a":1,"rgba":"rgba(255, 206, 122, 1)"},"euiColorDangerText":{"r":255,"g":102,"b":102,"a":1,"rgba":"rgba(255, 102, 102, 1)"},"euiColorDisabledText":{"r":76,"g":78,"b":81,"a":1,"rgba":"rgba(76, 78, 81, 1)"},"euiColorSuccessText":{"r":125,"g":226,"b":209,"a":1,"rgba":"rgba(125, 226, 209, 1)"},"euiLinkColor":{"r":27,"g":169,"b":245,"a":1,"rgba":"rgba(27, 169, 245, 1)"},"euiColorChartLines":{"r":52,"g":55,"b":65,"a":1,"rgba":"rgba(52, 55, 65, 1)"},"euiColorChartBand":{"r":42,"g":43,"b":51,"a":1,"rgba":"rgba(42, 43, 51, 1)"},"euiShadowColor":{"r":0,"g":0,"b":0,"a":1,"rgba":"rgba(0, 0, 0, 1)"},"euiShadowColorLarge":{"r":0,"g":0,"b":0,"a":1,"rgba":"rgba(0, 0, 0, 1)"}});


/***/ }),

/***/ "../node_modules/webpack/buildin/global.js":
/*!*************************************************!*\
  !*** ../node_modules/webpack/buildin/global.js ***!
  \*************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

var g;

// This works in non-strict mode
g = (function() {
	return this;
})();

try {
	// This works if eval is allowed (see CSP)
	g = g || new Function("return this")();
} catch (e) {
	// This works if the window reference is available
	if (typeof window === "object") g = window;
}

// g can still be undefined, but nothing to do about it...
// We return undefined, instead of nothing here, so it's
// easier to handle this case. if(!global) { ...}

module.exports = g;


/***/ }),

/***/ "./services/color/color_palette.ts":
/*!*****************************************!*\
  !*** ./services/color/color_palette.ts ***!
  \*****************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


__webpack_require__(/*! core-js/modules/es.array.concat */ "../node_modules/core-js/modules/es.array.concat.js");

__webpack_require__(/*! core-js/modules/es.array.filter */ "../node_modules/core-js/modules/es.array.filter.js");

__webpack_require__(/*! core-js/modules/es.array.reverse */ "../node_modules/core-js/modules/es.array.reverse.js");

__webpack_require__(/*! core-js/modules/es.array.slice */ "../node_modules/core-js/modules/es.array.slice.js");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.colorPalette = colorPalette;
exports.MID_COLOR_STOP = void 0;

var _chromaJs = _interopRequireDefault(__webpack_require__(/*! chroma-js */ "../node_modules/chroma-js/chroma.js"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/*
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
var MID_COLOR_STOP = '#EBEFF5';
/**
 * This function takes an array of colors and returns an array of interpolated
 * colors based on the number of steps/len needed for use in UI elements such as charts.
 * Derived from https://github.com/gka/palettes (Unlicensed)
 */

exports.MID_COLOR_STOP = MID_COLOR_STOP;

function colorPalette(
/**
 * The main color code or array of codes
 */
colors) {
  var len = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 10;
  var diverging = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;
  var categorical = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : false;
  var hexStart = colors.slice();
  var hexEnd = [];
  var even = len % 2 === 0;
  var numColorsLeft = diverging ? Math.ceil(len / 2) + (even ? 1 : 0) : len;
  var numColorsRight = diverging ? Math.ceil(len / 2) + (even ? 1 : 0) : 0; // If only a single color is provided prepend the mid-point color

  if (hexStart.length === 1) {
    hexStart.unshift(MID_COLOR_STOP);
  } // If diverging, split the start array and duplicate the mid color


  if (diverging) {
    // If there's no midpoint, create one
    if (hexStart.length < 3) {
      hexStart[2] = hexStart[1];
      hexStart[1] = MID_COLOR_STOP;
    }

    var numColorsHalf = Math.ceil(hexStart.length / 2);
    var colorsLeft = hexStart.filter(function (item, index) {
      if (index < numColorsHalf) {
        return true; // keep it
      }
    });
    var colorsRight = hexStart.reverse().filter(function (item, index) {
      if (index < numColorsHalf) {
        return true; // keep it
      }
    }).reverse();
    hexStart = colorsLeft;
    hexEnd = colorsRight;
  }

  function createSteps(colors, steps) {
    if (!colors.length) {
      return colors;
    }

    if (!categorical) {
      return _chromaJs.default.bezier(colors).scale().correctLightness().colors(steps);
    } else {
      return _chromaJs.default.scale(colors).colors(steps);
    }
  }

  var stepsLeft = createSteps(hexStart, numColorsLeft);
  var stepsRight = createSteps(hexEnd, numColorsRight);
  return (even && diverging ? stepsLeft.slice(0, stepsLeft.length - 1) : stepsLeft).concat(stepsRight.slice(1));
}

/***/ }),

/***/ "./services/color/oui_palettes.ts":
/*!****************************************!*\
  !*** ./services/color/oui_palettes.ts ***!
  \****************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


__webpack_require__(/*! core-js/modules/es.array.concat */ "../node_modules/core-js/modules/es.array.concat.js");

__webpack_require__(/*! core-js/modules/es.array.map */ "../node_modules/core-js/modules/es.array.map.js");

__webpack_require__(/*! core-js/modules/es.array.reverse */ "../node_modules/core-js/modules/es.array.reverse.js");

__webpack_require__(/*! core-js/modules/es.array.slice */ "../node_modules/core-js/modules/es.array.slice.js");

__webpack_require__(/*! core-js/modules/es.array.sort */ "../node_modules/core-js/modules/es.array.sort.js");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.euiPaletteGray = exports.euiPaletteWarm = exports.euiPaletteCool = exports.euiPalettePositive = exports.euiPaletteNegative = exports.euiPaletteComplimentary = exports.euiPaletteForTemperature = exports.euiPaletteForStatus = exports.euiPaletteForDarkBackground = exports.euiPaletteForLightBackground = exports.euiPaletteColorBlindBehindText = exports.euiPaletteColorBlind = exports.ouiPaletteGray = exports.ouiPaletteWarm = exports.ouiPaletteCool = exports.ouiPalettePositive = exports.ouiPaletteNegative = exports.ouiPaletteComplimentary = exports.ouiPaletteForTemperature = exports.ouiPaletteForStatus = exports.ouiPaletteForDarkBackground = exports.ouiPaletteForLightBackground = exports.ouiPaletteColorBlindBehindText = exports.ouiPaletteColorBlind = void 0;

var _chromaJs = _interopRequireDefault(__webpack_require__(/*! chroma-js */ "../node_modules/chroma-js/chroma.js"));

var _color_palette = __webpack_require__(/*! ./color_palette */ "./services/color/color_palette.ts");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableSpread(); }

function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _iterableToArray(iter) { if (typeof Symbol !== "undefined" && Symbol.iterator in Object(iter)) return Array.from(iter); }

function _arrayWithoutHoles(arr) { if (Array.isArray(arr)) return _arrayLikeToArray(arr); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

var flatten = function flatten(arr) {
  var _ref;

  return (_ref = []).concat.apply(_ref, _toConsumableArray(arr));
};

var ouiPalette = function ouiPalette(colors, steps) {
  var diverge = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;
  var categorical = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : true;

  // This function also trims the first color so white/black is never a color
  if (!diverge && steps > 1) {
    var palette = (0, _color_palette.colorPalette)(colors, steps + 1);
    palette.shift();
    return palette;
  }

  return (0, _color_palette.colorPalette)(colors, steps, diverge, categorical);
};

var ouiPaletteColorBlind = function ouiPaletteColorBlind() {
  var _ref2 = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {},
      _ref2$rotations = _ref2.rotations,
      rotations = _ref2$rotations === void 0 ? 1 : _ref2$rotations,
      _ref2$order = _ref2.order,
      order = _ref2$order === void 0 ? 'append' : _ref2$order,
      _ref2$direction = _ref2.direction,
      direction = _ref2$direction === void 0 ? 'lighter' : _ref2$direction,
      _ref2$sortBy = _ref2.sortBy,
      sortBy = _ref2$sortBy === void 0 ? 'default' : _ref2$sortBy,
      _ref2$sortShift = _ref2.sortShift,
      sortShift = _ref2$sortShift === void 0 ? '-100' : _ref2$sortShift;

  var colors = [];
  var base = ['#54B399', // 0 green
  '#6092C0', // 1 blue
  '#D36086', // 2 dark pink
  '#9170B8', // 3 purple
  '#CA8EAE', // 4 light pink
  '#D6BF57', // 5 yellow
  '#B9A888', // 6 tan
  '#DA8B45', // 7 orange
  '#AA6556', // 8 brown
  '#E7664C' // 9 red
  ];

  if (sortBy === 'natural') {
    // Sort the colors based on the color wheel, but shifting the values based on sortShift
    base = _toConsumableArray(base).sort(function (a, b) {
      return (0, _chromaJs.default)(a).set('hsl.h', sortShift).hsl()[0] - (0, _chromaJs.default)(b).set('hsl.h', sortShift).hsl()[0];
    });
  }

  if (rotations > 1) {
    var palettes = base.map(function (color) {
      // Create the darkest and lightest versions of each color using black and white
      var palette = (0, _color_palette.colorPalette)(['black', color, 'white'], 5, false, true); // Then removing the extremes

      palette.pop();
      palette.shift();

      switch (direction) {
        case 'lighter':
          return (0, _color_palette.colorPalette)([palette[1], palette[2]], rotations, false, true);

        case 'darker':
          return (0, _color_palette.colorPalette)([palette[1], palette[0]], rotations, false, true);

        case 'both':
          return (0, _color_palette.colorPalette)(palette, rotations, false, true);
      }
    });

    if (order === 'group') {
      colors = flatten(palettes);
    } else {
      var _loop = function _loop(i) {
        var _colors;

        var rotation = palettes.map(function (palette) {
          return palette[i];
        });

        (_colors = colors).push.apply(_colors, _toConsumableArray(rotation));
      };

      for (var i = 0; i < rotations; i++) {
        _loop(i);
      }
    }
  } else {
    colors = base;
  }

  return colors;
};
/**
 * Color blind palette with text is meant for use when text is applied on top of the color.
 * It increases the brightness of the color to give the text more contrast.
 */


exports.ouiPaletteColorBlind = ouiPaletteColorBlind;

var ouiPaletteColorBlindBehindText = function ouiPaletteColorBlindBehindText() {
  var paletteProps = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
  var originalPalette = ouiPaletteColorBlind(paletteProps);
  var newPalette = originalPalette.map(function (color) {
    return (0, _chromaJs.default)(color).brighten(0.5).hex();
  });
  return newPalette;
};

exports.ouiPaletteColorBlindBehindText = ouiPaletteColorBlindBehindText;

var ouiPaletteForLightBackground = function ouiPaletteForLightBackground() {
  return ['#006BB4', '#017D73', '#F5A700', '#BD271E', '#DD0A73'];
};

exports.ouiPaletteForLightBackground = ouiPaletteForLightBackground;

var ouiPaletteForDarkBackground = function ouiPaletteForDarkBackground() {
  return ['#1BA9F5', '#7DE2D1', '#F990C0', '#F66', '#FFCE7A'];
};

exports.ouiPaletteForDarkBackground = ouiPaletteForDarkBackground;
var positiveColor = '#209280';
var negativeColor = '#CC5642';
var lightNegativeColor = ouiPaletteColorBlind()[9];
var coolArray = [ouiPaletteColorBlind()[1], '#6092C0'];
var warmArray = [ouiPaletteColorBlind()[7], ouiPaletteColorBlind()[9]];

var ouiPaletteForStatus = function ouiPaletteForStatus(steps) {
  if (steps === 1) {
    return [positiveColor];
  }

  if (steps <= 3) {
    return ouiPalette([positiveColor, ouiPaletteColorBlind()[5], negativeColor], steps, true);
  }

  return ouiPalette([positiveColor, ouiPaletteColorBlind()[0], ouiPaletteColorBlind()[5], lightNegativeColor, negativeColor], steps, true);
};

exports.ouiPaletteForStatus = ouiPaletteForStatus;

var ouiPaletteForTemperature = function ouiPaletteForTemperature(steps) {
  var cools = (0, _color_palette.colorPalette)([].concat(_toConsumableArray(coolArray.slice().reverse()), ['#EBEFF5']), 3);
  var warms = (0, _color_palette.colorPalette)(['#F4F3DB'].concat(warmArray), 3);

  if (steps === 1) {
    return [cools[0]];
  } else if (steps <= 3) {
    return ouiPalette([cools[0], lightNegativeColor], steps, true);
  }

  return ouiPalette([].concat(_toConsumableArray(cools), _toConsumableArray(warms)), steps, true);
};

exports.ouiPaletteForTemperature = ouiPaletteForTemperature;

var ouiPaletteComplimentary = function ouiPaletteComplimentary(steps) {
  if (steps === 1) {
    return [ouiPaletteColorBlind()[1]];
  }

  return ouiPalette([ouiPaletteColorBlind()[1], ouiPaletteColorBlind()[7]], steps, true);
};

exports.ouiPaletteComplimentary = ouiPaletteComplimentary;

var ouiPaletteNegative = function ouiPaletteNegative(steps) {
  if (steps === 1) {
    return [lightNegativeColor];
  }

  return ouiPalette(['white', negativeColor], steps);
};

exports.ouiPaletteNegative = ouiPaletteNegative;

var ouiPalettePositive = function ouiPalettePositive(steps) {
  if (steps === 1) {
    return [ouiPaletteColorBlind()[0]];
  }

  return ouiPalette(['white', positiveColor], steps);
};

exports.ouiPalettePositive = ouiPalettePositive;

var ouiPaletteCool = function ouiPaletteCool(steps) {
  if (steps === 1) {
    return [coolArray[1]];
  }

  return ouiPalette(['white'].concat(coolArray), steps);
};

exports.ouiPaletteCool = ouiPaletteCool;

var ouiPaletteWarm = function ouiPaletteWarm(steps) {
  if (steps === 1) {
    return [lightNegativeColor];
  }

  return ouiPalette(['#FBFBDC'].concat(warmArray), steps);
};

exports.ouiPaletteWarm = ouiPaletteWarm;

var ouiPaletteGray = function ouiPaletteGray(steps) {
  if (steps === 1) {
    return ['#98a2b3'];
  }

  return ouiPalette(['white', '#d3dae6', '#98a2b3', '#69707d', '#343741'], steps, false);
};
/* OUI -> EUI Aliases */


exports.ouiPaletteGray = ouiPaletteGray;
var euiPaletteColorBlind = ouiPaletteColorBlind;
exports.euiPaletteColorBlind = euiPaletteColorBlind;
var euiPaletteColorBlindBehindText = ouiPaletteColorBlindBehindText;
exports.euiPaletteColorBlindBehindText = euiPaletteColorBlindBehindText;
var euiPaletteForLightBackground = ouiPaletteForLightBackground;
exports.euiPaletteForLightBackground = euiPaletteForLightBackground;
var euiPaletteForDarkBackground = ouiPaletteForDarkBackground;
exports.euiPaletteForDarkBackground = euiPaletteForDarkBackground;
var euiPaletteForStatus = ouiPaletteForStatus;
exports.euiPaletteForStatus = euiPaletteForStatus;
var euiPaletteForTemperature = ouiPaletteForTemperature;
exports.euiPaletteForTemperature = euiPaletteForTemperature;
var euiPaletteComplimentary = ouiPaletteComplimentary;
exports.euiPaletteComplimentary = euiPaletteComplimentary;
var euiPaletteNegative = ouiPaletteNegative;
exports.euiPaletteNegative = euiPaletteNegative;
var euiPalettePositive = ouiPalettePositive;
exports.euiPalettePositive = euiPalettePositive;
var euiPaletteCool = ouiPaletteCool;
exports.euiPaletteCool = euiPaletteCool;
var euiPaletteWarm = ouiPaletteWarm;
exports.euiPaletteWarm = euiPaletteWarm;
var euiPaletteGray = ouiPaletteGray;
/* End of Aliases */

exports.euiPaletteGray = euiPaletteGray;

/***/ }),

/***/ "./services/color/visualization_colors.ts":
/*!************************************************!*\
  !*** ./services/color/visualization_colors.ts ***!
  \************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DEFAULT_VISUALIZATION_COLOR = exports.VISUALIZATION_COLORS = void 0;

var _oui_palettes = __webpack_require__(/*! ../../services/color/oui_palettes */ "./services/color/oui_palettes.ts");

/*
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
// Array of color-blind safe colors to use in visualizations or other
// spots that need a large range of varied, qualitative colors.
var VISUALIZATION_COLORS = (0, _oui_palettes.ouiPaletteColorBlind)();
exports.VISUALIZATION_COLORS = VISUALIZATION_COLORS;
var DEFAULT_VISUALIZATION_COLOR = VISUALIZATION_COLORS[1];
exports.DEFAULT_VISUALIZATION_COLOR = DEFAULT_VISUALIZATION_COLOR;

/***/ }),

/***/ "./themes/charts/themes.ts":
/*!*********************************!*\
  !*** ./themes/charts/themes.ts ***!
  \*********************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EUI_SPARKLINE_THEME_PARTIAL = exports.EUI_CHARTS_THEME_DARK = exports.EUI_CHARTS_THEME_LIGHT = exports.OUI_SPARKLINE_THEME_PARTIAL = exports.OUI_CHARTS_THEME_DARK = exports.OUI_CHARTS_THEME_LIGHT = void 0;

var _oui_palettes = __webpack_require__(/*! ../../services/color/oui_palettes */ "./services/color/oui_palettes.ts");

var _visualization_colors = __webpack_require__(/*! ../../services/color/visualization_colors */ "./services/color/visualization_colors.ts");

var _colors = _interopRequireDefault(__webpack_require__(/*! !sass-vars-to-js-loader!../../global_styling/variables/_colors.scss */ "../node_modules/sass-vars-to-js-loader/index.js!./global_styling/variables/_colors.scss"));

var _oui_colors_dark = _interopRequireDefault(__webpack_require__(/*! !sass-vars-to-js-loader!../../themes/oui/oui_colors_dark.scss */ "../node_modules/sass-vars-to-js-loader/index.js!./themes/oui/oui_colors_dark.scss"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/*
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
// @ts-ignore typescript doesn't understand the webpack loader
// @ts-ignore typescript doesn't understand the webpack loader
var fontFamily = "'Inter UI', -apple-system, BlinkMacSystemFont,\n  'Segoe UI', Helvetica, Arial, sans-serif, 'Apple Color Emoji', 'Segoe UI Emoji', 'Segoe UI Symbol'";

function createTheme(colors) {
  return {
    lineAnnotation: {
      line: {
        strokeWidth: 1,
        stroke: colors.ouiColorDarkShade.rgba,
        opacity: 1
      },
      details: {
        fontSize: 10,
        fontFamily: fontFamily,
        fill: colors.ouiColorDarkShade.rgba,
        padding: 0
      }
    },
    partition: {
      fontFamily: fontFamily,
      minFontSize: 8,
      maxFontSize: 16,
      fillLabel: {
        textInvertible: false,
        valueFont: {
          fontWeight: 700
        }
      },
      linkLabel: {
        maxCount: 5,
        fontSize: 11,
        textColor: colors.ouiColorDarkestShade.rgba
      },
      outerSizeRatio: 1,
      circlePadding: 4,
      sectorLineStroke: colors.ouiColorEmptyShade.rgba,
      sectorLineWidth: 1.5
    },
    theme: {
      background: {
        color: colors.ouiColorEmptyShade.rgba
      },
      chartMargins: {
        left: 0,
        right: 0,
        top: 0,
        bottom: 0
      },
      lineSeriesStyle: {
        line: {
          strokeWidth: 2
        },
        point: {
          fill: colors.ouiColorEmptyShade.rgba,
          strokeWidth: 2,
          radius: 3
        }
      },
      areaSeriesStyle: {
        area: {
          opacity: 0.3
        },
        line: {
          strokeWidth: 2
        },
        point: {
          visible: false,
          fill: colors.ouiColorEmptyShade.rgba,
          strokeWidth: 2,
          radius: 3
        }
      },
      barSeriesStyle: {
        displayValue: {
          fontSize: 8,
          fontFamily: fontFamily,
          fill: colors.ouiColorDarkShade.rgba
        }
      },
      scales: {
        barsPadding: 0.25,
        histogramPadding: 0.05
      },
      axes: {
        axisTitle: {
          fontSize: 12,
          fontFamily: fontFamily,
          fill: colors.ouiColorDarkestShade.rgba,
          padding: {
            inner: 10,
            outer: 0
          }
        },
        axisLine: {
          stroke: colors.ouiColorChartLines.rgba
        },
        tickLabel: {
          fontSize: 10,
          fontFamily: fontFamily,
          fill: colors.ouiColorDarkShade.rgba,
          padding: {
            outer: 8,
            inner: 10
          }
        },
        tickLine: {
          visible: false,
          stroke: colors.ouiColorChartLines.rgba,
          strokeWidth: 1
        },
        gridLine: {
          horizontal: {
            visible: true,
            stroke: colors.ouiColorChartLines.rgba,
            strokeWidth: 1,
            opacity: 1,
            dash: [0, 0]
          },
          vertical: {
            visible: true,
            stroke: colors.ouiColorChartLines.rgba,
            strokeWidth: 1,
            opacity: 1,
            dash: [4, 4]
          }
        }
      },
      colors: {
        vizColors: (0, _oui_palettes.ouiPaletteColorBlind)({
          sortBy: 'natural'
        }),
        defaultVizColor: _visualization_colors.DEFAULT_VISUALIZATION_COLOR
      },
      crosshair: {
        band: {
          fill: colors.ouiColorChartBand.rgba
        },
        line: {
          stroke: colors.ouiColorDarkShade.rgba,
          strokeWidth: 1,
          dash: [4, 4]
        },
        crossLine: {
          stroke: colors.ouiColorDarkShade.rgba,
          strokeWidth: 1,
          dash: [4, 4]
        }
      }
    }
  };
}

var OUI_CHARTS_THEME_LIGHT = createTheme(_colors.default);
exports.OUI_CHARTS_THEME_LIGHT = OUI_CHARTS_THEME_LIGHT;
var OUI_CHARTS_THEME_DARK = createTheme(_oui_colors_dark.default);
exports.OUI_CHARTS_THEME_DARK = OUI_CHARTS_THEME_DARK;
var OUI_SPARKLINE_THEME_PARTIAL = {
  lineSeriesStyle: {
    point: {
      visible: false,
      strokeWidth: 1,
      radius: 1
    }
  },
  areaSeriesStyle: {
    point: {
      visible: false,
      strokeWidth: 1,
      radius: 1
    }
  }
};
/* OUI -> EUI Aliases */

exports.OUI_SPARKLINE_THEME_PARTIAL = OUI_SPARKLINE_THEME_PARTIAL;
var EUI_CHARTS_THEME_LIGHT = OUI_CHARTS_THEME_LIGHT;
exports.EUI_CHARTS_THEME_LIGHT = EUI_CHARTS_THEME_LIGHT;
var EUI_CHARTS_THEME_DARK = OUI_CHARTS_THEME_DARK;
exports.EUI_CHARTS_THEME_DARK = EUI_CHARTS_THEME_DARK;
var EUI_SPARKLINE_THEME_PARTIAL = OUI_SPARKLINE_THEME_PARTIAL;
/* End of Aliases */

exports.EUI_SPARKLINE_THEME_PARTIAL = EUI_SPARKLINE_THEME_PARTIAL;

/***/ })

/******/ })));
//# sourceMappingURL=eui_charts_theme.js.map