/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking.api;

import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.bugtracking.api.Issue;
import org.netbeans.modules.bugtracking.api.Repository;
import org.netbeans.modules.bugtracking.ui.search.QuickSearchComboBar;
import org.netbeans.modules.bugtracking.ui.search.QuickSearchPanel;
import org.openide.filesystems.FileObject;
import org.openide.util.HelpCtx;

public final class IssueQuickSearch {
    private final QuickSearchPanel panel;

    private IssueQuickSearch(FileObject context, RepositoryFilter filter) {
        this.panel = new QuickSearchPanel(context, filter);
    }

    public static IssueQuickSearch create() {
        return new IssueQuickSearch(null, RepositoryFilter.ALL);
    }

    public static IssueQuickSearch create(FileObject context) {
        return new IssueQuickSearch(context, RepositoryFilter.ALL);
    }

    public static IssueQuickSearch create(FileObject context, RepositoryFilter filter) {
        return new IssueQuickSearch(context, filter);
    }

    public static Issue selectIssue(String message, Repository repository, JPanel caller, HelpCtx helpCtx) {
        return QuickSearchComboBar.selectIssue(message, repository, caller, helpCtx);
    }

    public void setRepository(Repository repository) {
        this.panel.setRepository(repository);
    }

    public JComponent getComponent() {
        return this.panel;
    }

    public Issue getIssue() {
        return this.panel.getIssue();
    }

    public void setChangeListener(ChangeListener listener) {
        this.panel.setChangeListener(listener);
    }

    public void setIssue(Issue issue) {
        this.panel.setIssue(issue.getImpl());
    }

    public Repository getSelectedRepository() {
        return this.panel.getSelectedRepository();
    }

    public void setEnabled(boolean enabled) {
        this.panel.setEnabled(enabled);
    }

    public static enum RepositoryFilter {
        ATTACH_FILE,
        ALL;

    }
}

