/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javaee.wildfly.config;

import javax.enterprise.deploy.spi.exceptions.DeploymentManagerCreationException;
import org.netbeans.modules.j2ee.deployment.common.api.ConfigurationException;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.plugins.spi.config.ModuleConfiguration;
import org.netbeans.modules.j2ee.deployment.plugins.spi.config.ModuleConfigurationFactory2;
import org.netbeans.modules.javaee.wildfly.WildflyDeploymentFactory;
import org.netbeans.modules.javaee.wildfly.WildflyDeploymentManager;
import org.netbeans.modules.javaee.wildfly.config.CarDeploymentConfiguration;
import org.netbeans.modules.javaee.wildfly.config.EarDeploymentConfiguration;
import org.netbeans.modules.javaee.wildfly.config.EjbDeploymentConfiguration;
import org.netbeans.modules.javaee.wildfly.config.WarDeploymentConfiguration;
import org.netbeans.modules.javaee.wildfly.ide.ui.WildflyPluginUtils;

public class WildlfyModuleConfigurationFactory
implements ModuleConfigurationFactory2 {
    public ModuleConfiguration create(J2eeModule j2eeModule) throws ConfigurationException {
        if (J2eeModule.Type.WAR.equals(j2eeModule.getType())) {
            return new WarDeploymentConfiguration(j2eeModule);
        }
        if (J2eeModule.Type.EJB.equals(j2eeModule.getType())) {
            return new EjbDeploymentConfiguration(j2eeModule);
        }
        if (J2eeModule.Type.CAR.equals(j2eeModule.getType())) {
            return new CarDeploymentConfiguration(j2eeModule);
        }
        if (J2eeModule.Type.EAR.equals(j2eeModule.getType())) {
            return new EarDeploymentConfiguration(j2eeModule);
        }
        throw new ConfigurationException("Not supported module: " + j2eeModule.getType());
    }

    public ModuleConfiguration create(J2eeModule j2eeModule, String instanceUrl) throws ConfigurationException {
        if (!instanceUrl.startsWith("wildfly-deployer:")) {
            return this.create(j2eeModule);
        }
        try {
            WildflyDeploymentManager dm = (WildflyDeploymentManager)WildflyDeploymentFactory.getInstance().getDisconnectedDeploymentManager(instanceUrl);
            WildflyPluginUtils.Version version = dm.getServerVersion();
            if (J2eeModule.Type.WAR.equals(j2eeModule.getType())) {
                return new WarDeploymentConfiguration(j2eeModule, version, dm.isWildfly());
            }
            if (J2eeModule.Type.EJB.equals(j2eeModule.getType())) {
                return new EjbDeploymentConfiguration(j2eeModule, version, dm.isWildfly());
            }
            if (J2eeModule.Type.EAR.equals(j2eeModule.getType())) {
                return new EarDeploymentConfiguration(j2eeModule, version, dm.isWildfly());
            }
        }
        catch (DeploymentManagerCreationException ex) {
            return this.create(j2eeModule);
        }
        throw new ConfigurationException("Not supported module: " + j2eeModule.getType());
    }
}

